/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.experimental_setup;

import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;

public class ExperimentalSetupVariable {
    private String name;
    private VariableManipulation manipulation;
    private boolean isStudied;
    private double mean;
    private double stdDev;
    private String lockedAt;

    public ExperimentalSetupVariable(String name) {
        this(name, VariableManipulation.NONE, true, 0.0, 1.0);
    }

    public ExperimentalSetupVariable(String name, VariableManipulation manip, boolean isStudied) {
        this(name, manip, isStudied, 0.0, 1.0);
    }

    public ExperimentalSetupVariable(ExperimentalSetupVariable esv, double mean, double stdDev) {
        this(esv.getName(), esv.getManipulation(), esv.isStudied(), mean, stdDev);
    }

    public ExperimentalSetupVariable(String name, VariableManipulation manip, boolean isStudied, double mean, double stdDev) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        this.name = name;
        this.manipulation = manip;
        this.isStudied = isStudied;
        this.mean = mean;
        this.stdDev = stdDev;
    }

    public String getName() {
        return this.name;
    }

    public VariableManipulation getManipulation() {
        return this.manipulation;
    }

    public boolean isStudied() throws IllegalArgumentException {
        return this.isStudied;
    }

    public void setRandomized() {
        this.manipulation = VariableManipulation.RANDOMIZED;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.stdDev;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setStandardDeviation(double stdDev) {
        this.stdDev = stdDev;
    }

    public void setLocked(String lockedValue) throws IllegalArgumentException {
        this.lockedAt = lockedValue;
        this.manipulation = VariableManipulation.LOCKED;
    }

    public String getLockedAtValue() {
        if (this.manipulation == VariableManipulation.LOCKED) {
            return this.lockedAt;
        }
        return null;
    }

    public void setUnmanipulated() throws IllegalArgumentException {
        this.manipulation = VariableManipulation.NONE;
    }

    public void setStudied(boolean isStudied) throws IllegalArgumentException {
        this.isStudied = isStudied;
    }
}

