/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.experimental_setup;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import junit.framework.TestCase;

public class TestExperimentalSetup
extends TestCase {
    private ExperimentalSetup experiment;

    public TestExperimentalSetup(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Dag graph = new Dag();
        graph.addNode(new GraphNode("A"));
        graph.addNode(new GraphNode("B"));
        graph.addNode(new GraphNode("C"));
        GraphNode node = new GraphNode("Latent");
        node.setNodeType(NodeType.LATENT);
        graph.addNode(node);
        graph.addDirectedEdge(graph.getNode("A"), graph.getNode("B"));
        graph.addDirectedEdge(graph.getNode("A"), graph.getNode("C"));
        graph.addDirectedEdge(graph.getNode("Latent"), graph.getNode("A"));
        this.experiment = new ExperimentalSetup("experiment 1", graph);
    }

    public void testDefaultsSetCorrectly() {
        TestExperimentalSetup.assertTrue(this.experiment.getNumVariables() == 3);
        TestExperimentalSetup.assertTrue(this.experiment.getVariable("A").getManipulation() == VariableManipulation.NONE);
        TestExperimentalSetup.assertTrue(this.experiment.getVariable("B").getManipulation() == VariableManipulation.NONE);
        TestExperimentalSetup.assertTrue(this.experiment.getVariable("C").getManipulation() == VariableManipulation.NONE);
    }

    public void testVarNotInExperiment() {
        boolean error = false;
        try {
            this.experiment.getVariable("W").getManipulation();
        }
        catch (Exception e) {
            error = true;
        }
        TestExperimentalSetup.assertTrue(error);
    }

    public void testSetManipulator() {
        this.experiment.getVariable("A").setRandomized();
        TestExperimentalSetup.assertTrue(this.experiment.getVariable("A").getManipulation() == VariableManipulation.RANDOMIZED);
        this.experiment.getVariable("A").setUnmanipulated();
    }

    public void testSetManipulatorOnAbsentVariable() {
        boolean except = false;
        try {
            this.experiment.getVariable("W").setRandomized();
        }
        catch (IllegalArgumentException e) {
            except = true;
        }
        TestExperimentalSetup.assertTrue(except);
    }

    public void testGetVariables() {
        String[] varNames = this.experiment.getVariableNames();
        TestExperimentalSetup.assertTrue(varNames[0].equals("A"));
        TestExperimentalSetup.assertTrue(varNames[1].equals("B"));
        TestExperimentalSetup.assertTrue(varNames[2].equals("C"));
        TestExperimentalSetup.assertTrue(varNames.length == 3);
    }

    public void testIsValidVariableName() {
        TestExperimentalSetup.assertTrue(this.experiment.isValidVariableName("A"));
        TestExperimentalSetup.assertTrue(!this.experiment.isValidVariableName("foo"));
    }

    public void testSetName() {
        this.experiment.setName("Experiment foo");
        TestExperimentalSetup.assertTrue(this.experiment.getName().equals("Experiment foo"));
    }
}

