/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.experimental_setup;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import junit.framework.TestCase;

public class TestExperimentalSetupVariablesStudied
extends TestCase {
    private ExperimentalSetup studiedVariables;

    public TestExperimentalSetupVariablesStudied(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Dag graph = new Dag();
        graph.addNode(new GraphNode("education"));
        graph.addNode(new GraphNode("income"));
        graph.addNode(new GraphNode("happiness"));
        GraphNode node = new GraphNode("Latent");
        node.setNodeType(NodeType.LATENT);
        graph.addNode(node);
        graph.addDirectedEdge(graph.getNode("education"), graph.getNode("income"));
        graph.addDirectedEdge(graph.getNode("education"), graph.getNode("happiness"));
        graph.addDirectedEdge(graph.getNode("Latent"), graph.getNode("education"));
        this.studiedVariables = new ExperimentalSetup("experiment 1", graph);
    }

    public void test() {
        boolean except = false;
        TestExperimentalSetupVariablesStudied.assertTrue(this.studiedVariables.isVariableStudied("education"));
        TestExperimentalSetupVariablesStudied.assertTrue(this.studiedVariables.isVariableStudied("income"));
        TestExperimentalSetupVariablesStudied.assertTrue(this.studiedVariables.isVariableStudied("happiness"));
        this.studiedVariables.getVariable("education").setStudied(false);
        TestExperimentalSetupVariablesStudied.assertTrue(!this.studiedVariables.isVariableStudied("education"));
        TestExperimentalSetupVariablesStudied.assertTrue(this.studiedVariables.getNumVariablesStudied() == 2);
        try {
            this.studiedVariables.isVariableStudied("foo");
        }
        catch (IllegalArgumentException e) {
            except = true;
        }
        TestExperimentalSetupVariablesStudied.assertTrue(except);
        except = false;
        try {
            this.studiedVariables.getVariable("foo").setStudied(false);
        }
        catch (IllegalArgumentException e) {
            except = true;
        }
        TestExperimentalSetupVariablesStudied.assertTrue(except);
    }

    public void testNames() {
        this.studiedVariables.getVariable("education").setStudied(false);
        String[] names = this.studiedVariables.getNamesOfStudiedVariables();
        TestExperimentalSetupVariablesStudied.assertTrue(this.studiedVariables.getNumVariablesStudied() == 2);
        TestExperimentalSetupVariablesStudied.assertTrue(names.length == 2);
        TestExperimentalSetupVariablesStudied.assertTrue(names[0].equals("happiness") && names[1].equals("income") || names[1].equals("happiness") && names[0].equals("income"));
    }
}

