/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.manipulated_graph;

import edu.cmu.tetrad.graph.DirectedGraph;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.EdgeManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedEdge;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class AbstractManipulatedGraph
implements Graph {
    static final long serialVersionUID = 23L;
    private DirectedGraph graph;
    protected Map<String, VariableManipulation> variableManipulations;
    protected List<ManipulatedEdge> brokenEdges;
    protected List<ManipulatedEdge> frozenEdges;

    public AbstractManipulatedGraph(Graph graph) throws IllegalArgumentException {
        this.graph = new DirectedGraph(graph);
        this.brokenEdges = new ArrayList<ManipulatedEdge>();
        this.variableManipulations = new HashMap<String, VariableManipulation>();
        this.frozenEdges = new ArrayList<ManipulatedEdge>();
    }

    public static AbstractManipulatedGraph serializableInstance() {
        return new AbstractManipulatedGraph(new EdgeListGraph());
    }

    public ManipulatedEdge[] getBrokenEdges() {
        ManipulatedEdge[] edgeInfos = new ManipulatedEdge[this.brokenEdges.size()];
        for (int i = 0; i < this.brokenEdges.size(); ++i) {
            edgeInfos[i] = this.brokenEdges.get(i);
        }
        return edgeInfos;
    }

    public ManipulatedEdge[] getFrozenEdges() {
        ManipulatedEdge[] edgeInfos = new ManipulatedEdge[this.frozenEdges.size()];
        for (int i = 0; i < this.frozenEdges.size(); ++i) {
            edgeInfos[i] = this.frozenEdges.get(i);
        }
        return edgeInfos;
    }

    public VariableManipulation getManipulationFor(String variableName) {
        return this.variableManipulations.get(variableName);
    }

    public ManipulatedEdge[] getAllNonLatentEdges() {
        int i;
        ArrayList<Edge> nonLatentEdges = new ArrayList<Edge>();
        for (Edge edge : this.getGraph().getEdges()) {
            if (edge.getNode1().getNodeType() != NodeType.MEASURED || edge.getNode2().getNodeType() != NodeType.MEASURED) continue;
            nonLatentEdges.add(edge);
        }
        ManipulatedEdge[] edges = new ManipulatedEdge[this.brokenEdges.size() + this.frozenEdges.size() + nonLatentEdges.size()];
        for (i = 0; i < nonLatentEdges.size(); ++i) {
            edges[i] = new ManipulatedEdge((Edge)nonLatentEdges.get(i));
        }
        Iterator<ManipulatedEdge> brokens = this.brokenEdges.iterator();
        while (brokens.hasNext()) {
            edges[i] = brokens.next();
            ++i;
        }
        Iterator<ManipulatedEdge> frozens = this.frozenEdges.iterator();
        while (frozens.hasNext()) {
            edges[i] = frozens.next();
            ++i;
        }
        return edges;
    }

    public ManipulatedEdge getAnyEdge(String fromNode, String toNode) {
        ManipulatedEdge edgeInfo;
        int i;
        Edge edge = this.getGraph().getEdge(this.getGraph().getNode(fromNode), this.getGraph().getNode(toNode));
        if (edge != null) {
            return new ManipulatedEdge(edge);
        }
        ManipulatedEdge[] edges = this.getBrokenEdges();
        for (i = 0; i < edges.length; ++i) {
            edgeInfo = edges[i];
            if (!edgeInfo.getFromNode().equals(fromNode) || !edgeInfo.getToNode().equals(toNode)) continue;
            return edgeInfo;
        }
        edges = this.getFrozenEdges();
        for (i = 0; i < edges.length; ++i) {
            edgeInfo = edges[i];
            if (!edgeInfo.getFromNode().equals(fromNode) || !edgeInfo.getToNode().equals(toNode)) continue;
            return edgeInfo;
        }
        return null;
    }

    public EdgeManipulation getManipulationForEdge(String fromNode, String toNode) {
        ManipulatedEdge edgeInfo;
        int i;
        Edge edge = this.getGraph().getEdge(this.getGraph().getNode(fromNode), this.getGraph().getNode(toNode));
        if (edge != null) {
            return EdgeManipulation.NORMAL;
        }
        ManipulatedEdge[] edges = this.getFrozenEdges();
        for (i = 0; i < edges.length; ++i) {
            edgeInfo = edges[i];
            if (!edgeInfo.getFromNode().equals(fromNode) || !edgeInfo.getToNode().equals(toNode)) continue;
            return EdgeManipulation.FROZEN;
        }
        edges = this.getBrokenEdges();
        for (i = 0; i < edges.length; ++i) {
            edgeInfo = edges[i];
            if (!edgeInfo.getFromNode().equals(fromNode) || !edgeInfo.getToNode().equals(toNode)) continue;
            return EdgeManipulation.BROKEN;
        }
        return null;
    }

    protected void breakEdges(List edges) {
        ListIterator e = edges.listIterator();
        while (e.hasNext()) {
            Edge edge = (Edge)e.next();
            this.brokenEdges.add(new ManipulatedEdge(edge, EdgeManipulation.BROKEN));
            this.getGraph().removeEdge(edge);
        }
    }

    protected void freezeEdges(List edges) {
        ListIterator e = edges.listIterator();
        while (e.hasNext()) {
            Edge edge = (Edge)e.next();
            this.frozenEdges.add(new ManipulatedEdge(edge, EdgeManipulation.FROZEN));
        }
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        return this.getGraph().addBidirectedEdge(node1, node2);
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        return this.getGraph().addDirectedEdge(node1, node2);
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        return this.getGraph().addUndirectedEdge(node1, node2);
    }

    @Override
    public boolean addEdge(Edge edge) {
        return this.getGraph().addEdge(edge);
    }

    @Override
    public boolean addGraphConstraint(GraphConstraint gc) {
        return this.getGraph().addGraphConstraint(gc);
    }

    @Override
    public boolean addNode(Node node) {
        return this.getGraph().addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener e) {
        this.getGraph().addPropertyChangeListener(e);
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public boolean existsDirectedCycle() {
        return this.getGraph().existsDirectedCycle();
    }

    @Override
    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean existsUndirectedPathFromTo(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsSemiDirectedPathFromTo(Node node1, Set<Node> nodes) {
        return this.getGraph().existsSemiDirectedPathFromTo(node1, nodes);
    }

    @Override
    public boolean existsInducingPath(Node node1, Node node2, Set<Node> observedNodes, Set<Node> conditioningNodes) {
        return this.getGraph().existsInducingPath(node1, node2, observedNodes, conditioningNodes);
    }

    @Override
    public boolean existsTrek(Node node1, Node node2) {
        return this.getGraph().existsTrek(node1, node2);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getGraph()).equals(o);
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.getGraph().fullyConnect(endpoint);
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        this.getGraph().reorientAllWith(endpoint);
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getAncestors(List<Node> nodes) {
        return this.getGraph().getAncestors(nodes);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getConnectivity() {
        return this.getGraph().getConnectivity();
    }

    @Override
    public List<Node> getDescendants(List<Node> nodes) {
        return this.getGraph().getDescendants(nodes);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public List<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public Endpoint[][] getEndpointMatrix() {
        return this.getGraph().getEndpointMatrix();
    }

    @Override
    public List<GraphConstraint> getGraphConstraints() {
        return this.getGraph().getGraphConstraints();
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public boolean isAdjacentTo(Node node1, Node node2) {
        return this.getGraph().isAdjacentTo(node1, node2);
    }

    @Override
    public boolean isAncestorOf(Node node1, Node node2) {
        return this.getGraph().isAncestorOf(node1, node2);
    }

    @Override
    public boolean possibleAncestor(Node node1, Node node2) {
        return this.getGraph().possibleAncestor(node1, node2);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isProperAncestorOf(Node node1, Node node2) {
        return this.getGraph().isProperAncestorOf(node1, node2);
    }

    @Override
    public boolean isProperDescendentOf(Node node1, Node node2) {
        return this.getGraph().isProperDescendentOf(node1, node2);
    }

    @Override
    public boolean isDescendentOf(Node node1, Node node2) {
        return this.getGraph().isDescendentOf(node1, node2);
    }

    @Override
    public boolean defNonDescendent(Node node1, Node node2) {
        return this.getGraph().defNonDescendent(node1, node2);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean isDConnectedTo(Node node1, Node node2, List<Node> z) {
        return this.getGraph().isDConnectedTo(node1, node2, z);
    }

    @Override
    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return this.getGraph().isDSeparatedFrom(node1, node2, z);
    }

    @Override
    public boolean possDConnectedTo(Node node1, Node node2, List<Node> z) {
        return this.getGraph().possDConnectedTo(node1, node2, z);
    }

    @Override
    public boolean isDirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isDirectedFromTo(node1, node2);
    }

    @Override
    public boolean isUndirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isUndirectedFromTo(node1, node2);
    }

    @Override
    public boolean defVisible(Edge edge) {
        return this.getGraph().defVisible(edge);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint n) {
        return this.getGraph().getNodesInTo(node, n);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.getGraph().removeEdge(edge);
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.getGraph().removeEdge(node1, node2);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.getGraph().removeEdges(node1, node2);
    }

    @Override
    public boolean removeEdges(List<Edge> edges) {
        return this.getGraph().removeEdges(edges);
    }

    @Override
    public boolean removeNode(Node node) {
        return this.getGraph().removeNode(node);
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) {
        return this.getGraph().setEndpoint(from, to, endPoint);
    }

    @Override
    public boolean isGraphConstraintsChecked() {
        return this.getGraph().isGraphConstraintsChecked();
    }

    @Override
    public void setGraphConstraintsChecked(boolean checked) {
        this.getGraph().setGraphConstraintsChecked(checked);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public String toString() {
        return ((Object)this.getGraph()).toString();
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        return this.getGraph().addNondirectedEdge(node1, node2);
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        return this.getGraph().addPartiallyOrientedEdge(node1, node2);
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return this.getGraph().getAmbiguousTriples();
    }

    @Override
    public Set<Triple> getUnderLines() {
        return this.getGraph().getUnderLines();
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return this.getGraph().getDottedUnderlines();
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.getGraph().isAmbiguousTriple(x, y, z);
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isUnderlineTriple(x, y, z);
    }

    @Override
    public boolean isDottedUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().addAmbiguousTriple(x, y, z);
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addUnderlineTriple(x, y, z);
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().removeAmbiguousTriple(x, y, z);
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeUnderlineTriple(x, y, z);
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.getGraph().setAmbiguousTriples(triples);
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setUnderLineTriples(triples);
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setDottedUnderLineTriples(triples);
    }

    @Override
    public List<Node> getTierOrdering() {
        return this.getGraph().getTierOrdering();
    }

    private Graph getGraph() {
        return this.graph;
    }
}

