/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.manipulated_graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.EdgeManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.GuessedManipulatedGraph;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedEdge;
import junit.framework.TestCase;

public class TestGuessedManipulatedGraph
extends TestCase {
    Graph correctGraph;
    ExperimentalSetup experiment;
    GuessedManipulatedGraph guess;

    public TestGuessedManipulatedGraph(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.correctGraph = this.makeModel("Education", "Income", "Happiness");
        this.experiment = new ExperimentalSetup("experiment 1", this.correctGraph);
        this.guess = new GuessedManipulatedGraph(this.correctGraph);
    }

    public void testRandomizedType() {
        this.guess.setVariableRandomized("Education");
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Education") == VariableManipulation.RANDOMIZED);
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Income") == VariableManipulation.NONE);
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Happiness") == VariableManipulation.NONE);
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Latent") == VariableManipulation.NONE);
        TestGuessedManipulatedGraph.assertNull((Object)this.guess.getManipulationFor("foo"));
        ManipulatedEdge[] brokenEdges = this.guess.getBrokenEdges();
        TestGuessedManipulatedGraph.assertTrue(brokenEdges.length == 0);
        this.guess.setVariableNotManipulated("Education");
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Education") == VariableManipulation.NONE);
    }

    public void testLockedType() {
        this.guess.setVariableLocked("Education");
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Education") == VariableManipulation.LOCKED);
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Income") == VariableManipulation.NONE);
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Happiness") == VariableManipulation.NONE);
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Latent") == VariableManipulation.NONE);
        TestGuessedManipulatedGraph.assertNull((Object)this.guess.getManipulationFor("foo"));
        ManipulatedEdge[] brokenEdges = this.guess.getBrokenEdges();
        TestGuessedManipulatedGraph.assertTrue(brokenEdges.length == 0);
        this.guess.setVariableNotManipulated("Education");
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationFor("Education") == VariableManipulation.NONE);
    }

    public void testGetAllEdges() {
        ManipulatedEdge[] edges = this.guess.getAllNonLatentEdges();
        for (int i = 0; i < edges.length; ++i) {
            System.out.println(this.getClass() + " " + edges[i]);
        }
        TestGuessedManipulatedGraph.assertTrue(edges.length == 2);
    }

    public void testEdgeType() {
        this.guess.setEdgeBroken("Education", "Income");
        TestGuessedManipulatedGraph.assertTrue(this.guess.getManipulationForEdge("Education", "Income") == EdgeManipulation.BROKEN);
    }

    private Graph makeModel(String a, String b, String c) {
        Dag m1 = new Dag();
        m1.addNode(new GraphNode(a));
        m1.addNode(new GraphNode(b));
        m1.addNode(new GraphNode(c));
        GraphNode tn = new GraphNode("Latent");
        tn.setNodeType(NodeType.LATENT);
        m1.addNode(tn);
        m1.addDirectedEdge(m1.getNode(a), m1.getNode(b));
        m1.addDirectedEdge(m1.getNode(a), m1.getNode(c));
        m1.addDirectedEdge(m1.getNode("Latent"), m1.getNode(a));
        return m1;
    }
}

