/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.population;

import edu.cmu.tetrad.graph.DirectedGraph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.util.List;

public class CorrectManipulatedGraphSemIm {
    public static SemIm createIm(SemIm correctSemIm, ExperimentalSetup experiment) {
        ManipulatedGraph mGraph;
        SemGraph tempGraph = new SemGraph(correctSemIm.getSemPm().getGraph());
        List<Node> errorNodes = correctSemIm.getSemPm().getErrorNodes();
        if (errorNodes != null) {
            tempGraph.removeNodes(errorNodes);
        }
        if ((mGraph = new ManipulatedGraph(new DirectedGraph(tempGraph), experiment)) == null) {
            throw new NullPointerException("Graph was null");
        }
        SemPm pm = new SemPm(mGraph);
        SemIm im = new SemIm(pm);
        for (Parameter p1 : im.getSemPm().getParameters()) {
            Node nodeA = correctSemIm.getSemPm().getGraph().getNode(p1.getNodeA().getName());
            Node nodeB = correctSemIm.getSemPm().getGraph().getNode(p1.getNodeB().getName());
            for (Parameter p2 : correctSemIm.getSemPm().getParameters()) {
                if (p2.getNodeA() != nodeA || p2.getNodeB() != nodeB || p2.getType() != p1.getType()) continue;
                im.setParamValue(p1, correctSemIm.getParamValue(p2));
            }
        }
        List<Node> nodes = im.getVariableNodes();
        for (Node ob : nodes) {
            Node node = ob;
            if (experiment.getVariable(node.getName()).getManipulation() == VariableManipulation.RANDOMIZED) {
                double stdDev = experiment.getVariable(node.getName()).getStandardDeviation();
                im.setMean(node, experiment.getVariable(node.getName()).getMean());
                im.setErrVar(node, stdDev * stdDev);
                continue;
            }
            im.setMean(node, correctSemIm.getMean(node));
        }
        return im;
    }

    public static void setVariableLocked(SemIm manipulatedSemIm, ExperimentalSetup experiment, String variableName) {
        System.out.println("CorrectManipulatedGraphSemIm not locking");
    }

    public static void setVariableRandomized(SemIm manipulatedSemIm, String variableName) {
        SemGraph graph = manipulatedSemIm.getSemPm().getGraph();
        Node var = graph.getNode(variableName);
        List<Node> parents = graph.getParents(graph.getNode(variableName));
        for (Node parent : parents) {
            manipulatedSemIm.setParamValue(parent, var, 0.0);
        }
    }
}

