/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.sample;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.DataSetProbs;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariablesStudied;
import edu.cmu.tetrad.manip.population.CorrectManipulatedGraphBayesIm;
import edu.cmu.tetrad.manip.sample.Sample;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class BayesSample
implements Sample {
    private static int VALUE_NOT_VIEWED = -1;
    private DataSetProbs dataSetProbs;
    private MlBayesIm correctManipulatedGraphIM;

    public BayesSample(BayesIm correctIm, ExperimentalSetup experiment, int sampleSize, long sampleSeed) {
        this.correctManipulatedGraphIM = CorrectManipulatedGraphBayesIm.createIm(correctIm, experiment);
        DataSet dataSet = this.correctManipulatedGraphIM.simulateData(sampleSize, sampleSeed, false);
        this.dataSetProbs = new DataSetProbs(dataSet);
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSetProbs.getDataSet();
    }

    private int getVariableIndexInData(String varName) throws IllegalArgumentException {
        int index = 0;
        for (String name : this.getDataSet().getVariableNames()) {
            if (name.equals(varName)) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("That varName does not appear in the data");
    }

    private int getVariableValueIndexInData(String varName, String varValue, BayesIm IM) {
        return IM.getBayesPm().getCategoryIndex(IM.getBayesPm().getDag().getNode(varName), varValue);
    }

    public double getHistogramProbabilityOfVarValue(Properties nameValuePairs) {
        return this.getHistogramProbability(nameValuePairs, this.correctManipulatedGraphIM);
    }

    private double getHistogramProbability(Properties nameValuePairs, BayesIm IM) {
        int[] indexCombination = new int[this.getDataSet().getNumColumns()];
        for (int i = 0; i < indexCombination.length; ++i) {
            indexCombination[i] = VALUE_NOT_VIEWED;
        }
        Enumeration<?> varNames = nameValuePairs.propertyNames();
        while (varNames.hasMoreElements()) {
            String varName = (String)varNames.nextElement();
            String varValue = nameValuePairs.getProperty(varName);
            indexCombination[this.getVariableIndexInData((String)varName)] = this.getVariableValueIndexInData(varName, varValue, IM);
        }
        Proposition proposition = BayesSample.createProposition(this.dataSetProbs.getDataSet(), indexCombination);
        return this.dataSetProbs.getProb(proposition);
    }

    public int getNumSampleCases() {
        return this.dataSetProbs.getDataSet().getNumRows();
    }

    public String[] getSampleCaseColumnNames(VariablesStudied studiedVariables) {
        String[] varNames = new String[this.dataSetProbs.getDataSet().getVariableNames().size()];
        int i = 0;
        Iterator<String> it = this.dataSetProbs.getDataSet().getVariableNames().iterator();
        while (it.hasNext()) {
            varNames[i] = it.next();
            ++i;
        }
        String[] names = new String[studiedVariables.getNumVariablesStudied() + 1];
        names[0] = "#";
        int j = 1;
        for (i = 0; i < this.dataSetProbs.getDataSet().getNumColumns(); ++i) {
            if (!studiedVariables.isVariableStudied(varNames[i])) continue;
            names[j++] = varNames[i];
        }
        return names;
    }

    public String[] getSampleCase(int row, VariablesStudied studiedVariables) {
        String[] varNames = new String[this.dataSetProbs.getDataSet().getVariableNames().size()];
        int i = 0;
        Iterator<String> it = this.dataSetProbs.getDataSet().getVariableNames().iterator();
        while (it.hasNext()) {
            varNames[i] = it.next();
            ++i;
        }
        DataSet dataSet = this.dataSetProbs.getDataSet();
        String[] sampleCase = new String[studiedVariables.getNumVariablesStudied() + 1];
        sampleCase[0] = new Integer(row + 1).toString();
        int j = 1;
        for (i = 0; i < dataSet.getNumColumns(); ++i) {
            if (!studiedVariables.isVariableStudied(varNames[i])) continue;
            sampleCase[j++] = dataSet.getObject(row, i).toString();
        }
        return sampleCase;
    }

    public int getNumSampleCaseFrequencies(VariablesStudied studiedVariables) {
        int numSampleCases = 1;
        String[] varNames = new String[this.dataSetProbs.getDataSet().getVariableNames().size()];
        int i = 0;
        Iterator<String> it = this.dataSetProbs.getDataSet().getVariableNames().iterator();
        while (it.hasNext()) {
            varNames[i] = it.next();
            ++i;
        }
        if (studiedVariables.getNumVariablesStudied() == 0) {
            return 0;
        }
        for (i = 0; i < varNames.length; ++i) {
            if (!studiedVariables.isVariableStudied(varNames[i])) continue;
            Node node = this.correctManipulatedGraphIM.getNode(varNames[i]);
            int numValues = this.correctManipulatedGraphIM.getBayesPm().getNumCategories(node);
            numSampleCases *= numValues;
        }
        return numSampleCases;
    }

    public String[] getSampleFrequenciesColumnNames(VariablesStudied studiedVariables) {
        String[] columns = new String[studiedVariables.getNumVariablesStudied() + 1];
        String[] names = studiedVariables.getNamesOfStudiedVariables();
        System.arraycopy(names, 0, columns, 0, names.length);
        columns[columns.length - 1] = "%";
        return columns;
    }

    public String[] getSampleCaseFrequencyCombination(int row, VariablesStudied studiedVariables) {
        this.dataSetProbs.getDataSet();
        String[] stringCombination = new String[studiedVariables.getNumVariablesStudied()];
        int[] indexCombination = BayesSample.sampleFrequenciesIndexFunction(this.correctManipulatedGraphIM, studiedVariables, this.dataSetProbs.getDataSet(), row);
        int j = 0;
        for (int i = 0; i < indexCombination.length; ++i) {
            if (indexCombination[i] == VALUE_NOT_VIEWED) continue;
            String varName = this.dataSetProbs.getDataSet().getVariable(i).getName();
            Node node = this.correctManipulatedGraphIM.getNode(varName);
            stringCombination[j++] = this.correctManipulatedGraphIM.getBayesPm().getCategory(node, indexCombination[i]);
        }
        return stringCombination;
    }

    public double getSampleCaseFrequency(int row, VariablesStudied studiedVariables) {
        int[] indexCombination = BayesSample.sampleFrequenciesIndexFunction(this.correctManipulatedGraphIM, studiedVariables, this.dataSetProbs.getDataSet(), row);
        Proposition proposition = BayesSample.createProposition(this.dataSetProbs.getDataSet(), indexCombination);
        return this.dataSetProbs.getProb(proposition);
    }

    private static int[] sampleFrequenciesIndexFunction(BayesIm IM, VariablesStudied studiedVariables, DataSet data, int row) {
        int productPreviousNumValues = 1;
        if (data.getNumColumns() == 0) {
            return null;
        }
        int[] combination = new int[data.getNumColumns()];
        for (int varIndex = data.getNumColumns() - 1; varIndex >= 0; --varIndex) {
            Node node = IM.getNode(data.getVariable(varIndex).getName());
            if (studiedVariables.isVariableStudied(node.getName())) {
                int value;
                int currentNumValues = IM.getBayesPm().getNumCategories(node);
                combination[varIndex] = value = row / productPreviousNumValues % currentNumValues;
                productPreviousNumValues *= currentNumValues;
                continue;
            }
            combination[varIndex] = VALUE_NOT_VIEWED;
        }
        return combination;
    }

    private static Proposition createProposition(VariableSource varSource, int[] combination) {
        Proposition proposition = Proposition.tautology(varSource);
        for (int nodeIndex = 0; nodeIndex < combination.length; ++nodeIndex) {
            int value = combination[nodeIndex];
            if (value == VALUE_NOT_VIEWED) {
                proposition.setVariable(nodeIndex, true);
                continue;
            }
            proposition.setVariable(nodeIndex, false);
            proposition.setCategory(nodeIndex, value);
        }
        return proposition;
    }
}

