/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.sample;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariablesStudied;
import edu.cmu.tetrad.manip.population.CorrectManipulatedGraphSemIm;
import edu.cmu.tetrad.manip.sample.Sample;
import edu.cmu.tetrad.sem.SemIm;
import java.util.Collections;

public class SemSample
implements Sample {
    private DataSet data;

    public SemSample(SemIm correctSemIm, ExperimentalSetup experiment, int sampleSize, long sampleSeed) {
        SemIm correctManipulatedGraphIM = CorrectManipulatedGraphSemIm.createIm(correctSemIm, experiment);
        this.data = correctManipulatedGraphIM.simulateData(sampleSize, false, sampleSeed);
    }

    @Override
    public DataSet getDataSet() {
        return this.data;
    }

    public String getColumnName(int col, VariablesStudied studiedVariables) {
        if (col == 0) {
            return "";
        }
        return studiedVariables.getNamesOfStudiedVariables()[col - 1];
    }

    public int getRowCount() {
        return this.data.getNumRows();
    }

    public int getColumnCount(VariablesStudied studiedVariables) {
        return studiedVariables.getNumVariablesStudied() + 1;
    }

    public Object getValueAt(int row, int column, VariablesStudied studiedVariables) {
        if (column == 0) {
            return new Integer(row + 1);
        }
        if (column > 0) {
            return this.data.getObject(row, column - 1);
        }
        throw new IllegalArgumentException("SemSample: Invalid column value = " + column);
    }

    public Object getValueAtRowGivenColumnName(int row, String varName) {
        return this.data.getDouble(row, this.data.getColumn(this.data.getVariable(varName)));
    }

    public DataSet getDataSetGivenConstraints() {
        return new ColtDataSet(0, Collections.EMPTY_LIST);
    }
}

