/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.network;

import edu.cmu.tetrad.network.CorrelationParams;
import edu.cmu.tetrad.network.CorrelationProle;
import edu.cmu.tetrad.network.ProleControl;
import java.net.Socket;

public class Prole {
    private final int numCores;
    private Socket socket;
    private ProleControl controller;

    public Prole(int numCores, String hostname) {
        this.numCores = numCores;
        boolean connected = false;
        while (!connected) {
            try {
                this.socket = new Socket(hostname, 10803);
                connected = true;
            }
            catch (Exception e) {
                try {
                    System.out.println("[Prole]: Failed to connect . . . trying again in 10 seconds.");
                    Thread.sleep(10000L);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        this.controller = new ProleControl(this.socket, this);
        this.controller.run();
    }

    public void handle(CorrelationParams params) {
        this.controller.relax();
        int tasksPerThread = params.evalTrials / this.numCores;
        int leftOverTasks = params.evalTrials % this.numCores;
        System.out.println("[Prole]: Ready to perform evaluation step.");
        System.out.println("[Prole]: tasksPerThread: " + tasksPerThread);
        System.out.println("[Prole]: leftOverTasks: " + leftOverTasks);
        int[] pair = this.calculatePair(0, params);
        System.out.println("Starting with: <" + pair[0] + ", " + pair[1] + ">");
        CorrelationProle cp = new CorrelationProle(pair, 10, params);
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
        cp.getNextPair();
    }

    public int[] calculatePair(int index, CorrelationParams params) {
        int i;
        int numVars = params.col;
        int temp = index;
        for (i = 0; i < numVars && (temp -= numVars - 1 - i) >= 0; ++i) {
        }
        int[] result = new int[]{i, i + (numVars - i) + temp};
        return result;
    }

    public int timeEstimationInMilli() {
        return 100;
    }

    public static void main(String[] args) {
        Prole p = new Prole(2, "127.0.0.1");
    }
}

