/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.bayes.MeanInterpolator;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.regression.RegressionOld;
import edu.cmu.tetrad.regression.RegressionResult;

public final class RegressionInterpolator
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        int j;
        ColtDataSet d1 = new ColtDataSet((ColtDataSet)dataSet);
        DataSet d2 = new ColtDataSet((ColtDataSet)dataSet);
        d2 = new MeanInterpolator().filter(d2);
        int numVars = d2.getNumColumns();
        int numCases = d2.getNumRows();
        double[][] columns = new double[numVars][numCases];
        String[] names = new String[numVars];
        for (int i = 0; i < numCases; ++i) {
            for (int j2 = 0; j2 < numVars; ++j2) {
                columns[j2][i] = d2.getDouble(i, j2);
            }
        }
        for (j = 0; j < numVars; ++j) {
            names[j] = d2.getVariable(j).getName();
        }
        while ((j = this.columnWithMaxMissing(d1)) != -1) {
            int i;
            System.out.println(j);
            double[] target = columns[j];
            String targetName = names[j];
            double[][] regressors = new double[numVars - 1][numCases];
            String[] regressorNames = new String[numVars - 1];
            int k = -1;
            for (int m = 0; m < numVars; ++m) {
                if (m == j) continue;
                regressors[++k] = columns[m];
                regressorNames[k] = names[m];
            }
            RegressionOld regression = new RegressionOld();
            regression.setRegressors(regressors);
            regression.setRegressorNames(regressorNames);
            RegressionResult result = regression.regress(target, targetName);
            for (i = 0; i < numCases; ++i) {
                if (!Double.isNaN(d1.getDouble(i, j))) continue;
                k = -1;
                double[] values = new double[numVars - 1];
                for (int m = 0; m < numVars; ++m) {
                    if (m == j) continue;
                    values[++k] = d2.getDouble(i, m);
                }
                double predicted = result.getPredictedValue(values);
                d1.setDouble(i, j, predicted);
            }
            for (i = 0; i < numCases; ++i) {
                d2.setDouble(i, j, d1.getDouble(i, j));
            }
        }
        return d1;
    }

    private int columnWithMaxMissing(DataSet d1) {
        int max = -1;
        int maxCol = -1;
        for (int j = 0; j < d1.getNumColumns(); ++j) {
            int n = 0;
            for (int i = 0; i < d1.getNumRows(); ++i) {
                if (!Double.isNaN(d1.getDouble(i, j))) continue;
                ++n;
            }
            if (n <= 0 || n <= max) continue;
            max = n;
            maxCol = j;
        }
        return maxCol;
    }
}

