/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.search.ExploreFastIca;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.SemLearningMethod;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.util.List;

public class CheatSearch
implements SemLearningMethod {
    @Override
    public String getName() {
        return "true DAG";
    }

    @Override
    public GraphWithParameters run(DataSet dataSet, boolean estimateCoefficients, ExploreFastIca.PwpPlusGeneratingParameters pwpPlusParms) {
        GraphWithParameters estimatedTrueGraph = null;
        if (estimateCoefficients) {
            try {
                SemPm semPmTrueDag = new SemPm(pwpPlusParms.generatingPwp.getGraph());
                SemEstimator estimatorTrueDag = new SemEstimator(dataSet, semPmTrueDag);
                estimatorTrueDag.estimate();
                SemIm semImTrueDag = estimatorTrueDag.getEstimatedSem();
                estimatedTrueGraph = new GraphWithParameters(semImTrueDag, pwpPlusParms.generatingPwp.getGraph());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Skip this pattern");
            }
        } else {
            estimatedTrueGraph = new GraphWithParameters(pwpPlusParms.generatingPwp.getGraph());
        }
        return estimatedTrueGraph;
    }

    public GraphWithParameters run(DataSet dataSet, boolean estimateCoefficients, List<Edge> edgesToEvaluateCoeffs, ExploreFastIca.PwpPlusGeneratingParameters standardPwpPlusParms) {
        return this.run(dataSet, estimateCoefficients, standardPwpPlusParms);
    }
}

