/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.FasDci;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.ResolveSepsets;
import edu.cmu.tetrad.search.SepsetMapDci;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DciR {
    private Set<Graph> output = new HashSet<Graph>();
    private List<IndependenceTest> independenceTests = new ArrayList<IndependenceTest>();
    private List<Node> variables = new ArrayList<Node>();
    private List<Set<Node>> marginalVars = new ArrayList<Set<Node>>();
    private List<SepsetMapDci> sepsetMaps = new ArrayList<SepsetMapDci>();
    private int depth = -1;
    private Set<Triple> allTriples;
    private Set<Triple> definiteNoncolliders = new HashSet<Triple>();
    private Set<Triple> definiteColliders = new HashSet<Triple>();
    private boolean changeFlag = true;
    private List<Graph> discrimGraphs = new ArrayList<Graph>();
    private List<Graph> currentDiscrimGraphs = new ArrayList<Graph>();
    private List<Graph> finalGraphs = new ArrayList<Graph>();
    private Map<List<Node>, Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>> necessaryTreks;
    private List<Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>> currentNecessaryTreks = new ArrayList<Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>>();
    private Graph currentGraph;
    private Graph oldGraph;
    private Set<Triple> currentPossibleColliders = new HashSet<Triple>();
    private long elapsedTime;
    private String method;

    public DciR(List<IndependenceTest> tests, String method) {
        HashSet<Node> variables = new HashSet<Node>();
        for (IndependenceTest test : tests) {
            if (test == null) {
                throw new NullPointerException();
            }
            this.independenceTests.add(test);
            this.marginalVars.add(new HashSet<Node>(test.getVariables()));
            variables.addAll(test.getVariables());
        }
        this.variables.addAll(variables);
        this.method = method;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public List<Graph> search() {
        this.elapsedTime = System.currentTimeMillis();
        EdgeListGraph graph = new EdgeListGraph(this.variables);
        graph.fullyConnect(Endpoint.CIRCLE);
        for (IndependenceTest independenceTest : this.independenceTests) {
            FasDci adj = new FasDci(new EdgeListGraph(graph), independenceTest);
            adj.setDepth(this.depth);
            this.sepsetMaps.add(adj.search());
        }
        SepsetMapDci resolvedSepset = ResolveSepsets.ResolveSepsets(this.sepsetMaps, this.independenceTests, this.method, new SepsetMapDci(), new SepsetMapDci());
        this.sepsetMaps.clear();
        this.sepsetMaps.add(resolvedSepset);
        this.removeNonadjacencies(graph, this.sepsetMaps);
        this.orientColliders(graph);
        this.propagateInitialOrientations(graph);
        System.out.println(graph);
        this.getTriplesDefiniteColliders(graph);
        this.ensureMinimalSpanningTreks(graph);
        System.out.println("Paths ensuring Treks: \n" + this.necessaryTreks);
        Map<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>> possibleSkeletons = this.findPossibleSkeletons(graph);
        Iterator<Set<Edge>> itr = possibleSkeletons.keySet().iterator();
        while (itr.hasNext()) {
            Set<Edge> edgesToRemove = itr.next();
            Set<Map<Triple, List<Set<Edge>>>> colliderSets = possibleSkeletons.get(edgesToRemove);
            EdgeListGraph newGraph = new EdgeListGraph(graph);
            newGraph.removeEdges(new ArrayList<Edge>(edgesToRemove));
            this.oldGraph = newGraph;
            if (colliderSets.isEmpty()) {
                this.allColliderCombinations(newGraph, edgesToRemove, new HashSet<Triple>(), possibleSkeletons.size());
            } else {
                for (Map<Triple, List<Set<Edge>>> colliderSet : colliderSets) {
                    for (Graph newNewGraph : this.generateSkeletons(newGraph, colliderSet)) {
                        this.allColliderCombinations(newNewGraph, edgesToRemove, colliderSet.keySet(), possibleSkeletons.size());
                    }
                }
            }
            System.out.println("Current Size: " + this.output.size());
            itr.remove();
        }
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        return new ArrayList<Graph>(this.output);
    }

    private void removeNonadjacencies(Graph graph, List<SepsetMapDci> sepsetMaps) {
        int[] combination;
        List<Node> nodes = graph.getNodes();
        ChoiceGenerator cg = new ChoiceGenerator(nodes.size(), 2);
        block0: while ((combination = cg.next()) != null) {
            Node x = nodes.get(combination[0]);
            Node y = nodes.get(combination[1]);
            for (SepsetMapDci sepset : sepsetMaps) {
                if (sepset.get(x, y) == null) continue;
                graph.removeEdge(x, y);
                continue block0;
            }
        }
    }

    private void orientColliders(Graph graph) {
        for (int k = 0; k < this.marginalVars.size(); ++k) {
            Set<Node> marginalSet = this.marginalVars.get(k);
            SepsetMapDci sepset = this.sepsetMaps.get(0);
            for (Node b : marginalSet) {
                int[] combination;
                ArrayList<Node> adjacentNodes = new ArrayList<Node>();
                for (Node node : graph.getAdjacentNodes(b)) {
                    if (!marginalSet.contains(node)) continue;
                    adjacentNodes.add(node);
                }
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node a = (Node)adjacentNodes.get(combination[0]);
                    if (sepset.get(a, c = (Node)adjacentNodes.get(combination[1])) == null) continue;
                    if (!sepset.get(a, c).contains(b)) {
                        if (!this.isArrowpointAllowed(graph, a, b) || !this.isArrowpointAllowed(graph, c, b)) continue;
                        graph.setEndpoint(a, b, Endpoint.ARROW);
                        graph.setEndpoint(c, b, Endpoint.ARROW);
                        continue;
                    }
                    this.definiteNoncolliders.add(new Triple(a, b, c));
                }
            }
        }
    }

    private void propagateInitialOrientations(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.initialDoubleTriangle(graph);
            this.initialAwayFromColliderAncestorCycle(graph);
            this.initialDiscrimPaths(graph);
        }
        this.changeFlag = true;
    }

    private void initialDoubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C)) continue;
                        boolean checkABC = false;
                        boolean checkADC = false;
                        for (Set<Node> marginalSet : this.marginalVars) {
                            if (marginalSet.contains(A) && marginalSet.contains(B) && marginalSet.contains(C)) {
                                checkABC = true;
                            }
                            if (!marginalSet.contains(A) || !marginalSet.contains(D) || !marginalSet.contains(C)) continue;
                            checkABC = true;
                        }
                        if (!checkABC || !checkADC || !this.isArrowpointAllowed(graph, D, B)) continue;
                        graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private boolean isArrowpointAllowed(Graph graph, Node x, Node y) {
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW && graph.getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return true;
    }

    private void initialAwayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                boolean checkABC = false;
                for (Set<Node> marginalSet : this.marginalVars) {
                    if (!marginalSet.contains(A) || !marginalSet.contains(B) || !marginalSet.contains(C)) continue;
                    checkABC = true;
                    break;
                }
                if (checkABC) {
                    this.awayFromCollider(graph, A, B, C);
                    this.awayFromCollider(graph, C, B, A);
                }
                this.awayFromAncestor(graph, A, B, C);
                this.awayFromAncestor(graph, C, B, A);
                this.awayFromCycle(graph, A, B, C);
                this.awayFromCycle(graph, C, B, A);
            }
        }
    }

    private void awayFromCollider(Graph graph, Node a, Node b, Node c) {
        Endpoint BC = graph.getEndpoint(b, c);
        Endpoint CB = graph.getEndpoint(c, b);
        if (!graph.isAdjacentTo(a, c) && graph.getEndpoint(a, b) == Endpoint.ARROW) {
            if ((CB == Endpoint.CIRCLE || CB == Endpoint.TAIL) && BC == Endpoint.CIRCLE) {
                if (!this.isArrowpointAllowed(graph, b, c)) {
                    return;
                }
                graph.setEndpoint(b, c, Endpoint.ARROW);
                this.changeFlag = true;
            }
            if ((BC == Endpoint.CIRCLE || BC == Endpoint.ARROW) && CB == Endpoint.CIRCLE) {
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.changeFlag = true;
            }
        }
    }

    private void awayFromAncestor(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowpointAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            this.changeFlag = true;
        }
    }

    private void awayFromCycle(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.ARROW && graph.getEndpoint(c, a) == Endpoint.CIRCLE && graph.isDirectedFromTo(a, b) && graph.isDirectedFromTo(b, c)) {
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
        }
    }

    private void initialDiscrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    boolean checkABC = false;
                    for (Set<Node> marginalSet : this.marginalVars) {
                        if (!marginalSet.contains(a) || !marginalSet.contains(b) || !marginalSet.contains(c)) continue;
                        checkABC = true;
                    }
                    if (!checkABC) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(graph, a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFind(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                boolean checkABCL = false;
                for (Set<Node> marginalSet : this.marginalVars) {
                    if (!marginalSet.contains(a) || !marginalSet.contains(b) || !marginalSet.contains(c) || !marginalSet.contains(l)) continue;
                    checkABCL = true;
                }
                if (!checkABCL) continue;
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientation(graph, l, a, b, c);
                    return;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
    }

    private void doDdpOrientation(Graph graph, Node l, Node a, Node b, Node c) {
        HashSet<Node> sepset = new HashSet<Node>();
        for (SepsetMapDci msepset : this.sepsetMaps) {
            List<Node> condSet = msepset.get(l, c);
            if (condSet == null) continue;
            sepset.addAll(condSet);
        }
        if (sepset.contains(b)) {
            graph.setEndpoint(c, b, Endpoint.TAIL);
            this.changeFlag = true;
        } else {
            if (!this.isArrowpointAllowed(graph, a, b)) {
                return;
            }
            if (!this.isArrowpointAllowed(graph, c, b)) {
                return;
            }
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
            this.changeFlag = true;
        }
    }

    private Map<List<Node>, Set<Node>> minimalSpanningTreks(Graph graph, Set<Node> marginalNodes) {
        int size = marginalNodes.size();
        HashMap allPaths = new HashMap();
        for (int k = 2; k <= size; ++k) {
            allPaths.put(k, new HashMap());
        }
        for (NodePair nodePair : this.allNodePairs(new ArrayList<Node>(marginalNodes))) {
            int k;
            if (graph.isAdjacentTo(nodePair.getFirst(), nodePair.getSecond())) {
                HashSet<Node> otherNodes = new HashSet<Node>(marginalNodes);
                ArrayList<Node> adjacency = new ArrayList<Node>();
                adjacency.add(nodePair.getFirst());
                adjacency.add(nodePair.getSecond());
                otherNodes.removeAll(adjacency);
                ((Map)allPaths.get(2)).put(adjacency, otherNodes);
                continue;
            }
            HashMap newPaths = new HashMap();
            for (int k2 = 2; k2 <= size; ++k2) {
                newPaths.put(k2, new HashMap());
            }
            for (List<Node> trek : GraphUtils.treks(graph, nodePair.getFirst(), nodePair.getSecond())) {
                boolean inMarginal = true;
                for (Node node : trek) {
                    if (marginalNodes.contains(node)) continue;
                    inMarginal = false;
                    break;
                }
                if (!inMarginal) continue;
                HashSet<Node> otherNodes = new HashSet<Node>(marginalNodes);
                otherNodes.removeAll(trek);
                ((Map)newPaths.get(trek.size())).put(trek, otherNodes);
            }
            ArrayList<List> remove = new ArrayList<List>();
            for (k = 2; k < size; ++k) {
                Map trekMap = (Map)newPaths.get(k);
                for (int l = k + 1; l <= size; ++l) {
                    Map trekMapNext = (Map)newPaths.get(l);
                    for (List trek : trekMap.keySet()) {
                        for (List trekNext : trekMapNext.keySet()) {
                            if (!((Set)trekMap.get(trek)).containsAll((Collection)trekMapNext.get(trekNext)) || !this.isSubtrek(trekNext, trek)) continue;
                            remove.add(trekNext);
                        }
                    }
                    for (List nodes : remove) {
                        trekMapNext.remove(nodes);
                    }
                    remove.clear();
                }
            }
            for (k = 2; k <= size; ++k) {
                ((Map)allPaths.get(k)).putAll((Map)newPaths.get(k));
            }
        }
        HashMap<List<Node>, Set<Node>> minimalSpanningTreks = new HashMap<List<Node>, Set<Node>>();
        for (int k = 2; k < size; ++k) {
            Map smaller = (Map)allPaths.get(k);
            Map larger = (Map)allPaths.get(k + 1);
            for (List subpath : smaller.keySet()) {
                boolean isSubpath = false;
                for (List path : larger.keySet()) {
                    if (!this.isSubpath(path, subpath)) continue;
                    isSubpath = true;
                    break;
                }
                if (isSubpath) continue;
                minimalSpanningTreks.put(subpath, (Set<Node>)smaller.get(subpath));
            }
            if (larger.isEmpty()) break;
            if (k != size - 1) continue;
            minimalSpanningTreks.putAll(larger);
        }
        if (size == 2) {
            minimalSpanningTreks.putAll((Map)allPaths.get(2));
        }
        return minimalSpanningTreks;
    }

    public boolean isSubtrek(List<Node> trek, List<Node> subtrek) {
        int l = 0;
        for (int k = 0; k < subtrek.size(); ++k) {
            while (!((Object)subtrek.get(k)).equals(trek.get(l))) {
                if (++l < trek.size()) continue;
                return false;
            }
            if (l >= trek.size()) {
                return false;
            }
            ++l;
        }
        return true;
    }

    private boolean isSubpath(List<Node> path, List<Node> subpath) {
        boolean isSubpath = false;
        int subpathLast = subpath.size() - 1;
        for (int k = 0; k < path.size() - subpathLast; ++k) {
            int m;
            if (((Object)path.get(k)).equals(subpath.get(0))) {
                isSubpath = true;
                for (m = 1; m < subpath.size(); ++m) {
                    if (((Object)path.get(k + m)).equals(subpath.get(m))) continue;
                    isSubpath = false;
                    break;
                }
                if (isSubpath) break;
            }
            if (!((Object)path.get(k)).equals(subpath.get(subpathLast))) continue;
            isSubpath = true;
            for (m = subpathLast - 1; m >= 0; --m) {
                if (((Object)path.get(k + subpathLast - m)).equals(subpath.get(m))) continue;
                isSubpath = false;
                break;
            }
            if (isSubpath) break;
        }
        return isSubpath;
    }

    private Set<Triple> getAllTriples(Graph graph) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Node node : graph.getNodes()) {
            List<Node> adjNodes = graph.getAdjacentNodes(node);
            for (int i = 0; i < adjNodes.size() - 1; ++i) {
                for (int j = i + 1; j < adjNodes.size(); ++j) {
                    triples.add(new Triple(adjNodes.get(i), node, adjNodes.get(j)));
                }
            }
        }
        return triples;
    }

    private void getTriplesDefiniteColliders(Graph graph) {
        this.allTriples = this.getAllTriples(graph);
        for (Triple triple : this.allTriples) {
            if (!graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
            this.definiteColliders.add(triple);
        }
    }

    private static Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> pathsEnsuringTrek(Graph graph, List<Node> ensureTrek, Set<Node> conditioning) {
        HashMap<Set<Edge>, Map<Triple, List<Set<Edge>>>> paths = new HashMap<Set<Edge>, Map<Triple, List<Set<Edge>>>>();
        DciR.pathsEnsuringTrek(graph, ensureTrek, 1, new LinkedList<Node>(Arrays.asList(ensureTrek.get(0))), conditioning, new HashMap<Triple, NodePair>(), paths, new HashSet<Node>(Arrays.asList(ensureTrek.get(0))));
        return paths;
    }

    private static void pathsEnsuringTrek(Graph graph, List<Node> ensureTrek, int index, LinkedList<Node> path, Set<Node> conditioning, Map<Triple, NodePair> colliders, Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> paths, Set<Node> visited) {
        if (index == ensureTrek.size()) {
            HashMap newColliders = new HashMap();
            for (Triple triple : colliders.keySet()) {
                ArrayList edgeSet = new ArrayList();
                ArrayList<List<Node>> treks = new ArrayList<List<Node>>();
                treks.addAll(GraphUtils.treks(graph, triple.getY(), colliders.get(triple).getFirst()));
                treks.addAll(GraphUtils.treks(graph, triple.getY(), colliders.get(triple).getSecond()));
                for (List list : treks) {
                    HashSet<Edge> edges = new HashSet<Edge>();
                    boolean okay = true;
                    for (int k = 0; k < list.size() - 1; ++k) {
                        if (graph.getEndpoint((Node)list.get(k + 1), (Node)list.get(k)).equals(Endpoint.ARROW)) {
                            okay = false;
                            break;
                        }
                        edges.add(graph.getEdge((Node)list.get(k + 1), (Node)list.get(k)));
                    }
                    if (!okay) continue;
                    edgeSet.add(edges);
                }
                if (edgeSet.isEmpty()) {
                    return;
                }
                newColliders.put(triple, edgeSet);
            }
            HashSet<Edge> edges = new HashSet<Edge>();
            for (int k = 0; k < path.size() - 1; ++k) {
                edges.add(graph.getEdge(path.get(k), path.get(k + 1)));
            }
            paths.put(edges, newColliders);
            return;
        }
        Node node1 = path.getLast();
        Node node2 = ensureTrek.get(index);
        for (Edge edge : graph.getEdges(node1)) {
            Set<Node> currentVisited;
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (next == null || path.size() > 1 && !((Object)next).equals(node0 = path.get(path.size() - 2)) && graph.isDefCollider(node0, node1, next) && !conditioning.contains(node1) || visited.contains(next)) continue;
            path.add(next);
            visited.add(next);
            if (conditioning.contains(node1)) {
                node0 = path.get(path.size() - 3);
                if (graph.getEndpoint(node0, node1).equals(Endpoint.TAIL) || graph.getEndpoint(next, node1).equals(Endpoint.TAIL)) {
                    path.removeLast();
                    visited.remove(next);
                    continue;
                }
                if (!graph.possibleAncestor(next, node2)) {
                    path.removeLast();
                    visited.remove(next);
                    continue;
                }
                colliders.put(new Triple(node0, node1, next), new NodePair(node2, ensureTrek.get(index - 1)));
            }
            if (((Object)next).equals(node2)) {
                ++index;
                currentVisited = new HashSet<Node>();
                currentVisited.add(node2);
            } else {
                currentVisited = visited;
            }
            DciR.pathsEnsuringTrek(graph, ensureTrek, index, path, conditioning, colliders, paths, currentVisited);
            path.removeLast();
            if (next == node2) {
                --index;
            }
            visited.remove(next);
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            for (Triple triple : colliders.keySet()) {
                if (!((Object)triple.getY()).equals(node1)) continue;
                arrayList.add(triple);
            }
            for (Triple triple : arrayList) {
                colliders.remove(triple);
            }
        }
    }

    private void ensureMinimalSpanningTreks(Graph graph) {
        this.necessaryTreks = new HashMap<List<Node>, Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>>();
        for (Set<Node> marginalSet : this.marginalVars) {
            Map<List<Node>, Set<Node>> minimalSpanningTreks = this.minimalSpanningTreks(graph, marginalSet);
            for (List<Node> trek : minimalSpanningTreks.keySet()) {
                this.necessaryTreks.put(trek, DciR.pathsEnsuringTrek(graph, trek, minimalSpanningTreks.get(trek)));
            }
        }
    }

    private List<Graph> generateSkeletons(Graph graph, Map<Triple, List<Set<Edge>>> colliderSet) {
        EdgeListGraph newGraph = new EdgeListGraph(graph);
        for (Triple triple : colliderSet.keySet()) {
            newGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
            newGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
        }
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        graphs.add(newGraph);
        for (Triple triple : colliderSet.keySet()) {
            this.generateSkeletons(graphs, triple, colliderSet.get(triple));
        }
        return graphs;
    }

    private void generateSkeletons(List<Graph> graphs, Triple collider, List<Set<Edge>> paths) {
        ArrayList<Graph> newGraphs = new ArrayList<Graph>();
        for (Graph graph : graphs) {
            for (Set<Edge> edges : paths) {
                List<Node> path = this.getPathFromEdges(edges, collider.getY());
                EdgeListGraph newGraph = new EdgeListGraph(graph);
                for (int k = 0; k < path.size() - 1; ++k) {
                    Node node1 = path.get(k);
                    Node node2 = path.get(k + 1);
                    newGraph.setEndpoint(node1, node2, Endpoint.ARROW);
                    newGraph.setEndpoint(node2, node1, Endpoint.TAIL);
                }
                newGraphs.add(newGraph);
            }
        }
        graphs = newGraphs;
    }

    private List<Node> getPathFromEdges(Set<Edge> edges, Node start) {
        EdgeListGraph newGraph = new EdgeListGraph();
        for (Edge edge : edges) {
            newGraph.addNode(edge.getNode1());
            newGraph.addNode(edge.getNode2());
            newGraph.addEdge(edge);
        }
        ArrayList<Node> path = new ArrayList<Node>();
        path.add(start);
        Node next = start;
        Node last = start;
        Node current = start;
        for (int k = 1; k < newGraph.getNumNodes(); ++k) {
            List<Edge> adjEdges = newGraph.getEdges(current);
            next = adjEdges.get(0).getDistalNode(current);
            if (((Object)next).equals(last)) {
                next = adjEdges.get(1).getDistalNode(current);
            }
            path.add(next);
            last = current;
            current = next;
        }
        return path;
    }

    private Map<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>> findPossibleSkeletons(Graph graph) {
        HashSet<Edge> allEdges = new HashSet<Edge>(graph.getEdges());
        HashSet<Edge> remove = new HashSet<Edge>();
        block0: for (Edge edge : allEdges) {
            boolean necessary = false;
            for (List<Node> necessaryTrek : this.necessaryTreks.keySet()) {
                necessary = true;
                Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> possiblePaths = this.necessaryTreks.get(necessaryTrek);
                for (Set<Edge> set : possiblePaths.keySet()) {
                    if (set.contains(edge)) continue;
                    Map<Triple, List<Set<Edge>>> tripleMap = possiblePaths.get(set);
                    if (tripleMap.isEmpty()) {
                        necessary = false;
                    }
                    for (Triple triple : tripleMap.keySet()) {
                        necessary = true;
                        for (Set<Edge> ancpath : tripleMap.get(triple)) {
                            if (ancpath.contains(edge)) continue;
                            necessary = false;
                            break;
                        }
                        if (!necessary) continue;
                        break;
                    }
                    if (necessary) continue;
                    break;
                }
                if (!necessary) continue;
                remove.add(edge);
                continue block0;
            }
        }
        allEdges.removeAll(remove);
        HashMap<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>> possibleEdges = new HashMap<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>>();
        PowerSet<Edge> pset = new PowerSet<Edge>(allEdges);
        for (Set<Edge> set : pset) {
            boolean possible = true;
            HashSet colliderSets = new HashSet();
            for (List list : this.necessaryTreks.keySet()) {
                Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> possiblePaths = this.necessaryTreks.get(list);
                boolean okay = false;
                HashSet necessaryColliders = new HashSet();
                for (Set<Edge> path : possiblePaths.keySet()) {
                    boolean pathOkay = true;
                    for (Edge edge : set) {
                        if (!path.contains(edge)) continue;
                        pathOkay = false;
                        break;
                    }
                    if (!pathOkay) continue;
                    Map<Triple, List<Set<Edge>>> colliders = possiblePaths.get(path);
                    if (colliders.isEmpty()) {
                        okay = true;
                        necessaryColliders.clear();
                        break;
                    }
                    HashMap newColliders = new HashMap();
                    for (Triple triple : colliders.keySet()) {
                        ArrayList<Set<Edge>> newEdges = new ArrayList<Set<Edge>>();
                        for (Set<Edge> edges : colliders.get(triple)) {
                            pathOkay = true;
                            for (Edge edge : set) {
                                if (!path.contains(edge)) continue;
                                pathOkay = false;
                                break;
                            }
                            if (!pathOkay) continue;
                            newEdges.add(edges);
                        }
                        if (newEdges.isEmpty()) break;
                        newColliders.put(triple, newEdges);
                    }
                    if (colliders.size() != newColliders.size()) continue;
                    okay = true;
                    necessaryColliders.add(newColliders);
                }
                if (!okay) {
                    possible = false;
                    break;
                }
                if (necessaryColliders.isEmpty()) continue;
                colliderSets.addAll(necessaryColliders);
            }
            if (!possible) continue;
            possibleEdges.put(set, colliderSets);
        }
        return possibleEdges;
    }

    private void allColliderCombinations(Graph graph, Set<Edge> removedEdges, Set<Triple> newColliders, int skeletonsLeft) {
        this.currentGraph = graph;
        for (List<Node> necessaryTrek : this.necessaryTreks.keySet()) {
            Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> possiblePaths = this.necessaryTreks.get(necessaryTrek);
            HashMap newPossiblePaths = new HashMap();
            for (Set<Edge> set : possiblePaths.keySet()) {
                boolean add = true;
                for (Edge edgeRemoved : removedEdges) {
                    if (!set.contains(edgeRemoved)) continue;
                    add = false;
                    break;
                }
                if (add) {
                    for (Triple triple : newColliders) {
                        if (!set.contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) || !set.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY())) || possiblePaths.get(set).containsKey(triple)) continue;
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                Map<Triple, List<Set<Edge>>> colliderMap = possiblePaths.get(set);
                HashMap newColliderMap = new HashMap();
                for (Triple collider : colliderMap.keySet()) {
                    ArrayList<Set<Edge>> pathSet = new ArrayList<Set<Edge>>();
                    for (Set<Edge> edges : colliderMap.get(collider)) {
                        add = true;
                        for (Edge edgeRemoved : removedEdges) {
                            if (!set.contains(edgeRemoved)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        pathSet.add(edges);
                    }
                    if (pathSet.isEmpty()) {
                        add = false;
                        break;
                    }
                    newColliderMap.put(collider, pathSet);
                }
                if (!add) continue;
                newPossiblePaths.put(set, newColliderMap);
            }
            this.currentNecessaryTreks.add(newPossiblePaths);
        }
        for (Triple triple : this.allTriples) {
            if (graph.isAdjacentTo(triple.getX(), triple.getZ()) || this.definiteNoncolliders.contains(triple) || graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ()) || !graph.isAdjacentTo(triple.getX(), triple.getY()) || !graph.isAdjacentTo(triple.getY(), triple.getZ()) || graph.isUnderlineTriple(triple.getX(), triple.getY(), triple.getZ())) continue;
            this.currentPossibleColliders.add(triple);
        }
        HashSet<Triple> remove = new HashSet<Triple>();
        block8: for (Triple triple : this.currentPossibleColliders) {
            boolean necessary = false;
            for (Map map : this.currentNecessaryTreks) {
                necessary = true;
                boolean size1 = false;
                if (map.size() == 1) {
                    size1 = true;
                }
                for (Set path : map.keySet()) {
                    if (path.contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) && path.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY())) && !((Map)map.get(path)).containsKey(triple)) continue;
                    necessary = false;
                    break;
                }
                if (!necessary && size1) {
                    for (Map tripleMap : map.values()) {
                        for (List path : tripleMap.values()) {
                            if (path.size() != 1 || !((Set)path.get(0)).contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) || !((Set)path.get(0)).contains(this.oldGraph.getEdge(triple.getZ(), triple.getY()))) continue;
                            necessary = true;
                            break;
                        }
                        if (!necessary) continue;
                        break;
                    }
                }
                if (!necessary) continue;
                remove.add(triple);
                continue block8;
            }
        }
        this.currentPossibleColliders.removeAll(remove);
        this.simpleColliderIterator(skeletonsLeft);
        this.currentPossibleColliders.clear();
        this.currentNecessaryTreks.clear();
    }

    private void simpleColliderIterator(int skeletonsLeft) {
        HashSet<Set<Triple>> necessaryEdges = new HashSet<Set<Triple>>();
        PowerSet<Triple> pset = new PowerSet<Triple>(this.currentPossibleColliders);
        int psetsize = (int)Math.pow(2.0, this.currentPossibleColliders.size());
        for (Set<Triple> set : pset) {
            System.out.println("Searching Possible PAGs: " + psetsize + " (" + skeletonsLeft + " Skeletons Remaining)");
            --psetsize;
            boolean stop = false;
            for (Set set2 : necessaryEdges) {
                if (!set.containsAll(set2)) continue;
                stop = true;
                break;
            }
            if (stop) continue;
            if (this.checkCollider(set, necessaryEdges)) {
                EdgeListGraph newGraph = new EdgeListGraph(this.currentGraph);
                for (Triple triple : set) {
                    newGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
                    newGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
                }
                long l = System.currentTimeMillis();
                this.doFinalOrientation(newGraph);
                for (Graph graph : this.finalGraphs) {
                    if (this.predictsFalseDependence(graph)) continue;
                    HashSet<Triple> newColliders = new HashSet<Triple>(this.allTriples);
                    newColliders.removeAll(this.definiteColliders);
                    newColliders.removeAll(set);
                    HashSet<Triple> remove = new HashSet<Triple>();
                    for (Triple triple : newColliders) {
                        if (graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
                        remove.add(triple);
                    }
                    newColliders.removeAll(remove);
                    if (!newColliders.isEmpty()) {
                        newColliders.addAll(set);
                        if (!this.checkCollider(newColliders, necessaryEdges)) continue;
                    }
                    if (graph.existsDirectedCycle()) continue;
                    graph.setUnderLineTriples(new HashSet<Triple>());
                    this.output.add(graph);
                }
                continue;
            }
            necessaryEdges.add(set);
        }
    }

    private boolean checkCollider(Set<Triple> newSet, Set<Set<Triple>> necessaryEdges) {
        boolean possible = true;
        for (Set<Triple> set : necessaryEdges) {
            if (!newSet.containsAll(set)) continue;
            possible = false;
            break;
        }
        if (possible) {
            for (Map map : this.currentNecessaryTreks) {
                boolean okay = false;
                for (Set path : map.keySet()) {
                    boolean pathOkay = true;
                    for (Triple triple : newSet) {
                        if (path.contains(this.currentGraph.getEdge(triple.getX(), triple.getY())) && path.contains(this.currentGraph.getEdge(triple.getY(), triple.getZ())) && !((Map)map.get(path)).containsKey(triple)) {
                            pathOkay = false;
                            break;
                        }
                        for (Triple collider : ((Map)map.get(path)).keySet()) {
                            if (!this.currentGraph.isDefCollider(collider.getX(), collider.getY(), collider.getZ()) && !newSet.contains(collider)) {
                                pathOkay = false;
                                break;
                            }
                            pathOkay = false;
                            for (Set adjPath : (List)((Map)map.get(path)).get(collider)) {
                                int k;
                                boolean adjPathOkay;
                                List<Node> findPath;
                                if (adjPath.contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) && adjPath.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY()))) continue;
                                if (adjPath.contains(this.oldGraph.getEdge(triple.getX(), triple.getY()))) {
                                    findPath = this.getPathFromEdges(adjPath, collider.getY());
                                    adjPathOkay = true;
                                    for (k = 0; k < findPath.size() - 1; ++k) {
                                        if (!((Object)findPath.get(k)).equals(triple.getY()) || !((Object)findPath.get(k + 1)).equals(triple.getX())) continue;
                                        adjPathOkay = false;
                                        break;
                                    }
                                    if (!adjPathOkay) continue;
                                    pathOkay = true;
                                    continue;
                                }
                                if (adjPath.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY()))) {
                                    findPath = this.getPathFromEdges(adjPath, collider.getY());
                                    adjPathOkay = true;
                                    for (k = 0; k < findPath.size() - 1; ++k) {
                                        if (!((Object)findPath.get(k)).equals(triple.getY()) || !((Object)findPath.get(k + 1)).equals(triple.getZ())) continue;
                                        adjPathOkay = false;
                                        break;
                                    }
                                    if (!adjPathOkay) continue;
                                    pathOkay = true;
                                    continue;
                                }
                                pathOkay = true;
                            }
                            if (pathOkay) continue;
                            break;
                        }
                        if (pathOkay) continue;
                        break;
                    }
                    if (!pathOkay) continue;
                    okay = true;
                    break;
                }
                if (okay) continue;
                possible = false;
                break;
            }
        }
        return possible;
    }

    private void doFinalOrientation(Graph graph) {
        this.discrimGraphs.clear();
        this.finalGraphs.clear();
        this.currentDiscrimGraphs.add(graph);
        while (this.changeFlag) {
            this.changeFlag = false;
            this.currentDiscrimGraphs.addAll(this.discrimGraphs);
            this.discrimGraphs.clear();
            for (Graph newGraph : this.currentDiscrimGraphs) {
                this.doubleTriangle(newGraph);
                this.awayFromColliderAncestorCycle(newGraph);
                if (this.discrimPaths(newGraph)) continue;
                if (this.changeFlag) {
                    this.discrimGraphs.add(newGraph);
                    continue;
                }
                this.finalGraphs.add(newGraph);
            }
            this.currentDiscrimGraphs.clear();
        }
        this.changeFlag = true;
    }

    private void doubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C) || !this.isArrowpointAllowed(graph, D, B)) continue;
                        graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private void awayFromAncestorCycle(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            List<Node> nodes = graph.getNodes();
            for (Node B : nodes) {
                int[] combination;
                List<Node> adj = graph.getAdjacentNodes(B);
                if (adj.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node A = adj.get(combination[0]);
                    Node C = adj.get(combination[1]);
                    this.awayFromAncestor(graph, A, B, C);
                    this.awayFromAncestor(graph, C, B, A);
                    this.awayFromCycle(graph, A, B, C);
                    this.awayFromCycle(graph, C, B, A);
                }
            }
        }
        this.changeFlag = true;
    }

    private void awayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.awayFromCollider(graph, A, B, C);
                this.awayFromCollider(graph, C, B, A);
                this.awayFromAncestor(graph, A, B, C);
                this.awayFromAncestor(graph, C, B, A);
                this.awayFromCycle(graph, A, B, C);
                this.awayFromCycle(graph, C, B, A);
            }
        }
    }

    private boolean discrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    if (!this.reachablePathFindOrient(graph, a, b, c, reachable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean reachablePathFindOrient(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientationFinal(graph, l, a, b, c);
                    return true;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
        return false;
    }

    private void doDdpOrientationFinal(Graph graph, Node l, Node a, Node b, Node c) {
        this.changeFlag = true;
        ArrayList<Node> sepset = new ArrayList<Node>();
        for (SepsetMapDci msepset : this.sepsetMaps) {
            List<Node> condSet = msepset.get(l, c);
            if (condSet == null) continue;
            sepset.addAll(condSet);
        }
        EdgeListGraph newGraph1 = new EdgeListGraph(graph);
        newGraph1.setEndpoint(c, b, Endpoint.TAIL);
        this.discrimGraphs.add(newGraph1);
        if (sepset.contains(b)) {
            return;
        }
        EdgeListGraph newGraph2 = new EdgeListGraph(graph);
        if (!this.isArrowpointAllowed(graph, a, b)) {
            return;
        }
        if (!this.isArrowpointAllowed(graph, c, b)) {
            return;
        }
        newGraph2.setEndpoint(a, b, Endpoint.ARROW);
        newGraph2.setEndpoint(c, b, Endpoint.ARROW);
        this.discrimGraphs.add(newGraph2);
    }

    private boolean predictsFalseDependence(Graph graph) {
        for (int k = 0; k < this.variables.size() - 1; ++k) {
            Node x = this.variables.get(k);
            for (int m = k + 1; m < this.variables.size(); ++m) {
                Node y = this.variables.get(m);
                for (SepsetMapDci sepset : this.sepsetMaps) {
                    if (sepset.get(x, y) == null) continue;
                    for (List<Node> condSet : sepset.getSet(x, y)) {
                        if (graph.isDSeparatedFrom(x, y, condSet)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private List<NodePair> allNodePairs(List<Node> nodes) {
        ArrayList<NodePair> nodePairs = new ArrayList<NodePair>();
        for (int j = 0; j < nodes.size() - 1; ++j) {
            for (int k = j + 1; k < nodes.size(); ++k) {
                nodePairs.add(new NodePair(nodes.get(j), nodes.get(k)));
            }
        }
        return nodePairs;
    }

    private class PowerSet<E>
    implements Iterable<Set<E>> {
        Collection<E> all;

        public PowerSet(Collection<E> all) {
            this.all = all;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new PowerSetIterator(this);
        }

        class PowerSetIterator<InE>
        implements Iterator<Set<InE>> {
            PowerSet<InE> powerSet;
            List<InE> canonicalOrder = new ArrayList<InE>();
            List<InE> mask = new ArrayList<InE>();
            boolean hasNext = true;

            PowerSetIterator(PowerSet<InE> powerSet2) {
                this.powerSet = powerSet2;
                this.canonicalOrder.addAll(powerSet2.all);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean allOnes() {
                for (InE bit : this.mask) {
                    if (bit != null) continue;
                    return false;
                }
                return true;
            }

            private void increment() {
                int i;
                for (i = 0; i < this.mask.size(); ++i) {
                    InE bit = this.mask.get(i);
                    if (bit == null) {
                        this.mask.set(i, this.canonicalOrder.get(i));
                        return;
                    }
                    this.mask.set(i, null);
                }
                this.mask.add(this.canonicalOrder.get(i));
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Set<InE> next() {
                HashSet<InE> result = new HashSet<InE>();
                result.addAll(this.mask);
                result.remove(null);
                boolean bl = this.hasNext = this.mask.size() < this.powerSet.all.size() || !this.allOnes();
                if (this.hasNext) {
                    this.increment();
                }
                return result;
            }
        }
    }
}

