/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.sem.MimBuildEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;

public final class DiscreteTetradTest
implements TetradTest {
    DataSet dataSet;
    int[][][][] counts;
    int[][] values;
    int[] valueIndices;
    private double[] prob;
    private double tempProb;
    private double sig1;
    private double sig2;
    private double sig3;
    private double sig;
    private boolean[] bvalues;
    double[][] thresholds;
    int[] indices;
    int[][][][] currentCounts;
    int currentVar1;
    int currentVar2;
    double[][] currentFiBuffer;
    double[][] currentPi;
    double currentRho;
    double[] rhoGrid;
    double[][] polyCorr;
    double[][][] btCovars;
    private static final int MAX_VALUES = 50;
    private static final int RHO_GRID_SIZE = 1000;
    public boolean verbose = false;
    private static double[] GHY = new double[]{5.555035187326467, 4.773992343411219, 4.12199554749184, 3.5319728771376777, 2.979991207704598, 2.453552124512838, 1.944962949186254, 1.448934250650732, 0.961499634418369, 0.4794507070791076, 0.0, -5.555035187326467, -4.773992343411219, -4.12199554749184, -3.5319728771376777, -2.979991207704598, -2.453552124512838, -1.944962949186254, -1.448934250650732, -0.961499634418369, -0.4794507070791076};
    private static double[] GHW = new double[]{3.720365070136049E-14, 8.818611242049951E-11, 2.5712301800593137E-8, 2.1718848980566694E-6, 7.478398867310061E-5, 0.0012549820417264105, 0.011414065837434383, 0.06017964665891227, 0.19212032406699775, 0.3816690736135021, 0.47902370312017767, 3.720365070136049E-14, 8.818611242049951E-11, 2.5712301800593137E-8, 2.1718848980566694E-6, 7.478398867310061E-5, 0.0012549820417264105, 0.011414065837434383, 0.06017964665891227, 0.19212032406699775, 0.3816690736135021, 0.47902370312017767};
    int[][][][] oneFactor4Tests;
    int[][][][][] oneFactor5Tests;
    int[][][][] twoFactor4Tests;
    boolean highPrecisionIntegral = false;

    public DiscreteTetradTest(DataSet dataSet, double sig) {
        this.dataSet = dataSet;
        this.sig = sig;
        this.initialization();
    }

    @Override
    public String[] getVarNames() {
        return this.dataSet.getVariableNames().toArray(new String[0]);
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void initialization() {
        int i;
        int i2 = 0;
        while (i2 < GHY.length) {
            int n = i2;
            GHY[n] = GHY[n] * Math.sqrt(2.0);
            int n2 = i2++;
            GHW[n2] = GHW[n2] / Math.sqrt(Math.PI);
        }
        int numRows = this.dataSet.getNumRows();
        int numColumns = this.dataSet.getNumColumns();
        this.prob = new double[3];
        this.bvalues = new boolean[3];
        this.sig1 = this.sig / 3.0;
        this.sig2 = 2.0 * this.sig / 3.0;
        this.sig3 = this.sig;
        this.rhoGrid = new double[1000];
        for (int i3 = 1; i3 < 1000; ++i3) {
            this.rhoGrid[i3 - 1] = -1.0 + 0.002 * (double)i3;
        }
        this.values = new int[numColumns][];
        this.valueIndices = new int[numColumns];
        int[] tempValues = new int[50];
        boolean[] marked = new boolean[50];
        for (i = 0; i < numColumns; ++i) {
            int j;
            int vSize = 0;
            block3: for (j = 0; j < numRows; ++j) {
                int value = this.dataSet.getInt(j, i);
                for (int k = 0; k < vSize; ++k) {
                    if (tempValues[k] == value) continue block3;
                }
                if (vSize < 49) {
                    tempValues[vSize++] = value;
                    continue;
                }
                throw new RuntimeException("Maximum number of distinct values for a discrete variable exceeded!");
            }
            this.values[i] = new int[vSize];
            this.valueIndices[i] = i == 0 ? 0 : this.valueIndices[i - 1] + vSize - 1;
            for (j = 0; j < vSize; ++j) {
                marked[j] = false;
            }
            for (j = 0; j < vSize; ++j) {
                int minValue = Integer.MAX_VALUE;
                int minIndexValue = -1;
                for (int k = 0; k < vSize; ++k) {
                    if (marked[k] || tempValues[k] >= minValue) continue;
                    minValue = tempValues[k];
                    minIndexValue = k;
                }
                this.values[i][j] = minValue;
                marked[minIndexValue] = true;
            }
        }
        this.thresholds = new double[numColumns][];
        for (i = 0; i < numColumns; ++i) {
            this.thresholds[i] = new double[this.values[i].length - 1];
        }
        this.counts = new int[numColumns][numColumns][][];
        this.computeCounts(this.counts, this.dataSet);
        this.currentCounts = this.counts;
        this.polyCorr = this.getUnderlyingCorr(this.counts);
        this.oneFactor4Tests = new int[this.values.length][this.values.length][this.values.length][this.values.length];
        this.twoFactor4Tests = new int[this.values.length][this.values.length][this.values.length][this.values.length];
        this.resetCache();
    }

    public void resetCache() {
        int v4;
        int v3;
        int v2;
        int v1;
        for (v1 = 0; v1 < this.values.length; ++v1) {
            for (v2 = v1 + 1; v2 < this.values.length; ++v2) {
                for (v3 = v2 + 1; v3 < this.values.length; ++v3) {
                    for (v4 = v3 + 1; v4 < this.values.length; ++v4) {
                        this.oneFactor4Tests[v1][v2][v3][v4] = 0;
                    }
                }
            }
        }
        for (v1 = 0; v1 < this.values.length - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.values.length; ++v2) {
                for (v3 = 0; v3 < this.values.length - 1; ++v3) {
                    for (v4 = v3 + 1; v4 < this.values.length; ++v4) {
                        this.twoFactor4Tests[v1][v2][v3][v4] = 0;
                    }
                }
            }
        }
    }

    @Override
    public double getSignificance() {
        return this.sig;
    }

    @Override
    public void setSignificance(double sig) {
        this.sig = sig;
    }

    public void setHighPrecision(boolean p) {
        this.highPrecisionIntegral = p;
    }

    public boolean getHighPrecision() {
        return this.highPrecisionIntegral;
    }

    @Override
    public int tetradScore(int i, int j, int k, int l) {
        if (this.oneFactorTest(i, j, k, l)) {
            return 3;
        }
        this.twoFactorTest(i, l, j, k);
        this.prob[0] = this.tempProb;
        this.twoFactorTest(i, k, j, l);
        this.prob[1] = this.tempProb;
        this.twoFactorTest(i, j, k, l);
        this.prob[2] = this.tempProb;
        for (int c = 0; c < 3; ++c) {
            this.bvalues[c] = this.prob[c] >= this.sig;
        }
        if (this.prob[1] < this.prob[0] && this.prob[1] < this.prob[2]) {
            this.tempProb = this.prob[0];
            this.prob[0] = this.prob[1];
            this.prob[1] = this.tempProb;
        } else if (this.prob[2] < this.prob[0] && this.prob[2] < this.prob[0]) {
            this.tempProb = this.prob[0];
            this.prob[0] = this.prob[2];
            this.prob[2] = this.tempProb;
        }
        if (this.prob[2] < this.prob[1]) {
            this.tempProb = this.prob[1];
            this.prob[1] = this.prob[2];
            this.prob[2] = this.tempProb;
        }
        if (this.prob[2] <= this.sig3) {
            return 0;
        }
        if (this.prob[1] <= this.sig2) {
            return 1;
        }
        if (this.prob[0] <= this.sig1) {
            return 3;
        }
        return 3;
    }

    @Override
    public boolean tetradScore1(int v1, int v2, int v3, int v4) {
        if (this.oneFactorTest(v1, v2, v3, v4)) {
            return false;
        }
        return this.twoFactorTest(v1, v2, v3, v4);
    }

    @Override
    public boolean tetradScore3(int v1, int v2, int v3, int v4) {
        return this.oneFactorTest(v1, v2, v3, v4);
    }

    @Override
    public double tetradPValue(int v1, int v2, int v3, int v4) {
        this.twoFactorTest(v1, v2, v3, v4);
        return this.tempProb;
    }

    @Override
    public boolean tetradHolds(int i, int j, int k, int l) {
        this.twoFactorTest(i, l, j, k);
        this.prob[0] = this.tempProb;
        this.bvalues[0] = this.prob[0] >= this.sig;
        return this.bvalues[0];
    }

    private void computeCounts(int[][][][] counts, DataSet data) {
        int q;
        int k;
        int j;
        int i;
        int numRows = this.dataSet.getNumRows();
        int numColumns = this.dataSet.getNumColumns();
        for (i = 0; i < numColumns; ++i) {
            for (j = i; j < numColumns; ++j) {
                counts[i][j] = new int[this.values[i].length][this.values[j].length];
                counts[j][i] = new int[this.values[j].length][this.values[i].length];
                for (k = 0; k < this.values[i].length; ++k) {
                    for (q = 0; q < this.values[j].length; ++q) {
                        counts[j][i][q][k] = 0;
                        counts[i][j][k][q] = 0;
                    }
                }
            }
        }
        for (int r = 0; r < numRows; ++r) {
            for (int i2 = 0; i2 < numColumns; ++i2) {
                for (int j2 = i2; j2 < numColumns; ++j2) {
                    int[] nArray = counts[i2][j2][this.getValuePosition(data.getInt(r, i2), i2)];
                    int n = this.getValuePosition(data.getInt(r, j2), j2);
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (i = 0; i < numColumns - 1; ++i) {
            for (j = i + 1; j < numColumns; ++j) {
                for (k = 0; k < this.values[i].length; ++k) {
                    for (q = 0; q < this.values[j].length; ++q) {
                        counts[j][i][q][k] = counts[i][j][k][q];
                    }
                }
            }
        }
    }

    private int[][][][] computeCounts4(int i, int j, int k, int l) {
        int[][][][] newCounts = new int[this.values[i].length][this.values[j].length][this.values[k].length][this.values[l].length];
        int numRows = this.dataSet.getNumRows();
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        newCounts[v1][v2][v3][v4] = 0;
                    }
                }
            }
        }
        for (int r = 0; r < numRows; ++r) {
            int[] nArray = newCounts[this.getValuePosition(this.dataSet.getInt(r, i), i)][this.getValuePosition(this.dataSet.getInt(r, j), j)][this.getValuePosition(this.dataSet.getInt(r, k), k)];
            int n = this.getValuePosition(this.dataSet.getInt(r, l), l);
            nArray[n] = nArray[n] + 1;
        }
        return newCounts;
    }

    private int[][][][][] computeCounts5(int i, int j, int k, int l, int x) {
        int numRows = this.dataSet.getNumRows();
        int[][][][][] newCounts = new int[this.values[i].length][this.values[j].length][this.values[k].length][this.values[l].length][this.values[x].length];
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        for (int v5 = 0; v5 < this.values[this.indices[4]].length; ++v5) {
                            newCounts[v1][v2][v3][v4][v5] = 0;
                        }
                    }
                }
            }
        }
        for (int r = 0; r < numRows; ++r) {
            int[] nArray = newCounts[this.getValuePosition(this.dataSet.getInt(r, i), i)][this.getValuePosition(this.dataSet.getInt(r, j), j)][this.getValuePosition(this.dataSet.getInt(r, k), k)][this.getValuePosition(this.dataSet.getInt(r, l), l)];
            int n = this.getValuePosition(this.dataSet.getInt(r, x), x);
            nArray[n] = nArray[n] + 1;
        }
        return newCounts;
    }

    private int[][][][][][] computeCounts6(int i, int j, int k, int l, int x, int y) {
        int numRows = this.dataSet.getNumRows();
        int[][][][][][] newCounts = new int[this.values[i].length][this.values[j].length][this.values[k].length][this.values[l].length][this.values[x].length][this.values[y].length];
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        for (int v5 = 0; v5 < this.values[this.indices[4]].length; ++v5) {
                            for (int v6 = 0; v6 < this.values[this.indices[5]].length; ++v6) {
                                newCounts[v1][v2][v3][v4][v5][v6] = 0;
                            }
                        }
                    }
                }
            }
        }
        for (int r = 0; r < numRows; ++r) {
            int[] nArray = newCounts[this.getValuePosition(this.dataSet.getInt(r, i), i)][this.getValuePosition(this.dataSet.getInt(r, j), j)][this.getValuePosition(this.dataSet.getInt(r, k), k)][this.getValuePosition(this.dataSet.getInt(r, l), l)][this.getValuePosition(this.dataSet.getInt(r, x), x)];
            int n = this.getValuePosition(this.dataSet.getInt(r, y), y);
            nArray[n] = nArray[n] + 1;
        }
        return newCounts;
    }

    private int getValuePosition(int value, int varNumber) {
        for (int i = 0; i < this.values[varNumber].length; ++i) {
            if (this.values[varNumber][i] != value) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    private double[][] getUnderlyingCorr(int[][][][] nextCounts) {
        int j;
        double[][] outputCorr = new double[this.dataSet.getNumColumns()][this.dataSet.getNumColumns()];
        this.currentCounts = nextCounts;
        for (int i = 0; i < this.dataSet.getNumColumns(); ++i) {
            int c = 0;
            for (j = 0; j < this.values[i].length - 1; ++j) {
                this.thresholds[i][j] = ProbUtils.normalQuantile((double)(c += this.currentCounts[i][i][j][j]) / (double)this.dataSet.getNumRows());
            }
        }
        int[] indices = new int[2];
        for (int i = 0; i < this.dataSet.getNumColumns(); ++i) {
            outputCorr[i][i] = 1.0;
            for (j = i + 1; j < this.dataSet.getNumColumns(); ++j) {
                indices[0] = i;
                indices[1] = j;
                double d = this.estimatePolychoric(indices);
                outputCorr[j][i] = d;
                outputCorr[i][j] = d;
            }
        }
        String[] dummyNames = new String[outputCorr.length];
        for (int i = 0; i < outputCorr.length; ++i) {
            dummyNames[i] = "L" + i;
            for (int j2 = 0; j2 <= i; ++j2) {
                System.out.print((double)((int)(100.0 * outputCorr[i][j2])) / 100.0 + "\t");
            }
            System.out.println();
        }
        return outputCorr;
    }

    private double estimatePolychoric(int[] indices) {
        this.indices = indices;
        double[] start = new double[1];
        RandomUtil r = RandomUtil.getInstance();
        this.currentVar1 = indices[0];
        this.currentVar2 = indices[1];
        this.currentFiBuffer = new double[this.values[this.currentVar1].length + 1][this.values[this.currentVar2].length + 1];
        this.currentPi = new double[this.values[this.currentVar1].length][this.values[this.currentVar2].length];
        this.currentRho = start[0] = r.nextDouble() / 2.0 + 0.2;
        this.currentRho = this.gridOptimizer();
        return this.currentRho;
    }

    private void computeFiBuffer() {
        for (int i = 0; i < this.values[this.currentVar1].length + 1; ++i) {
            int j;
            this.currentFiBuffer[i][0] = 0.0;
            if (i == 0) {
                for (j = 1; j < this.values[this.currentVar2].length + 1; ++j) {
                    this.currentFiBuffer[i][j] = 0.0;
                }
                continue;
            }
            if (i < this.values[this.currentVar1].length) {
                for (j = 1; j < this.values[this.currentVar2].length + 1; ++j) {
                    this.currentFiBuffer[i][j] = j < this.values[this.currentVar2].length ? ProbUtils.biNormalCdf(this.thresholds[this.currentVar1][i - 1], this.thresholds[this.currentVar2][j - 1], this.currentRho) : ProbUtils.normalCdf(this.thresholds[this.currentVar1][i - 1]);
                }
                continue;
            }
            for (j = 1; j < this.values[this.currentVar2].length + 1; ++j) {
                this.currentFiBuffer[i][j] = j < this.values[this.currentVar2].length ? ProbUtils.normalCdf(this.thresholds[this.currentVar2][j - 1]) : 1.0;
            }
        }
    }

    protected double currentScoreFunction() {
        double score = 0.0;
        for (int i = 0; i < this.values[this.currentVar1].length; ++i) {
            for (int j = 0; j < this.values[this.currentVar2].length; ++j) {
                score -= (double)this.currentCounts[this.currentVar1][this.currentVar2][i][j] * Math.log(this.currentPi[i][j]);
            }
        }
        return score;
    }

    private void computeCurrentPi() {
        for (int i = 0; i < this.values[this.currentVar1].length; ++i) {
            for (int j = 0; j < this.values[this.currentVar2].length; ++j) {
                this.currentPi[i][j] = this.currentFiBuffer[i + 1][j + 1] - this.currentFiBuffer[i][j + 1] - this.currentFiBuffer[i + 1][j] + this.currentFiBuffer[i][j];
            }
        }
    }

    private double gridOptimizer() {
        double minValue = Double.MAX_VALUE;
        double bestRho = -1.0;
        for (int i = 0; i < this.rhoGrid.length; ++i) {
            this.currentRho = this.rhoGrid[i];
            this.computeFiBuffer();
            this.computeCurrentPi();
            double score = this.currentScoreFunction();
            if (!(score < minValue)) continue;
            minValue = score;
            bestRho = this.currentRho;
        }
        return bestRho;
    }

    private int oneFactorCached(int[] indices) {
        int[] ordered = new int[indices.length];
        System.arraycopy(indices, 0, ordered, 0, indices.length);
        for (int i = 0; i < indices.length - 1; ++i) {
            int min = ordered[i];
            int minIndex = i;
            for (int j = i + 1; j < this.indices.length; ++j) {
                if (ordered[j] >= min) continue;
                min = ordered[j];
                minIndex = j;
            }
            int temp = ordered[i];
            ordered[i] = min;
            ordered[minIndex] = temp;
        }
        if (indices.length == 4) {
            return this.oneFactor4Tests[ordered[0]][ordered[1]][ordered[2]][ordered[3]];
        }
        return 0;
    }

    private int twoFactorCached(int[] indices) {
        int temp;
        int[] ordered = new int[indices.length];
        System.arraycopy(indices, 0, ordered, 0, indices.length);
        if (ordered[1] < ordered[0]) {
            temp = ordered[1];
            ordered[1] = ordered[0];
            ordered[0] = temp;
        }
        if (ordered[3] < ordered[2]) {
            temp = ordered[3];
            ordered[3] = ordered[2];
            ordered[2] = temp;
        }
        return this.twoFactor4Tests[ordered[0]][ordered[1]][ordered[2]][ordered[3]];
    }

    private void cacheOneFactorTest(int[] indices, boolean result) {
        if (indices.length > 4) {
            return;
        }
        int[] ordered = new int[indices.length];
        System.arraycopy(indices, 0, ordered, 0, indices.length);
        for (int i = 0; i < indices.length - 1; ++i) {
            int min = ordered[i];
            int minIndex = i;
            for (int j = i + 1; j < this.indices.length; ++j) {
                if (ordered[j] >= min) continue;
                min = ordered[j];
                minIndex = j;
            }
            int temp = ordered[i];
            ordered[i] = min;
            ordered[minIndex] = temp;
        }
        int intResult = result ? 1 : -1;
        this.oneFactor4Tests[ordered[0]][ordered[1]][ordered[2]][ordered[3]] = intResult;
    }

    private void cacheTwoFactorTest(int[] indices, boolean result) {
        int temp;
        int[] ordered = new int[indices.length];
        System.arraycopy(indices, 0, ordered, 0, indices.length);
        if (ordered[1] < ordered[0]) {
            temp = ordered[1];
            ordered[1] = ordered[0];
            ordered[0] = temp;
        }
        if (ordered[3] < ordered[2]) {
            temp = ordered[3];
            ordered[3] = ordered[2];
            ordered[2] = temp;
        }
        int intResult = result ? 1 : -1;
        this.twoFactor4Tests[ordered[0]][ordered[1]][ordered[2]][ordered[3]] = intResult;
    }

    @Override
    public boolean oneFactorTest(int i, int j, int k, int l) {
        this.indices = new int[4];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        int cachedResult = this.oneFactorCached(this.indices);
        if (cachedResult != 0) {
            return cachedResult > 0;
        }
        double[][] ulCorr = new double[4][4];
        String[] vNames = new String[4];
        for (int v1 = 0; v1 < 4; ++v1) {
            ulCorr[v1][v1] = 1.0;
            for (int v2 = v1 + 1; v2 < 4; ++v2) {
                double d = this.polyCorr[this.indices[v1]][this.indices[v2]];
                ulCorr[v2][v1] = d;
                ulCorr[v1][v2] = d;
            }
            vNames[v1] = "xi" + v1;
        }
        if (MatrixUtils.determinant(ulCorr) <= 0.0) {
            return false;
        }
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(ulCorr), this.dataSet.getNumRows());
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta = new GraphNode("eta");
        eta.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta);
        for (int n = 0; n < 4; ++n) {
            GraphNode xi = new GraphNode("xi" + n);
            factorModel.addNode(xi);
            factorModel.addDirectedEdge(eta, xi);
        }
        SemPm semPm = new SemPm(factorModel);
        MimBuildEstimator est = new MimBuildEstimator(covarianceMatrix, semPm, 5, 5);
        est.estimate();
        if (est.getEstimatedSem().getPValue() > this.sig) {
            this.cacheOneFactorTest(this.indices, true);
            return true;
        }
        if (est.getEstimatedSem().getPValue() < 1.0E-10) {
            this.cacheOneFactorTest(this.indices, false);
            return false;
        }
        CovarianceMatrix covMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(est.getEstimatedSem().getImplCovarMeas().toArray()), this.dataSet.getNumRows());
        double[][] m = new CorrelationMatrix(covMatrix).getMatrix().toArray();
        int[][][][] counts4 = this.computeCounts4(i, j, k, l);
        int[] indices2 = new int[4];
        double chisq2 = 0.0;
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        if (counts4[v1][v2][v3][v4] == 0) continue;
                        indices2[0] = v1;
                        indices2[1] = v2;
                        indices2[2] = v3;
                        indices2[3] = v4;
                        double ph = this.highPrecisionIntegral ? this.piHat0(this.indices, indices2, m) : this.piHat1(this.indices, indices2, est.getEstimatedSem());
                        chisq2 += ((double)counts4[v1][v2][v3][v4] - (double)this.dataSet.getNumRows() * ph) * ((double)counts4[v1][v2][v3][v4] - (double)this.dataSet.getNumRows() * ph) / ((double)this.dataSet.getNumRows() * ph);
                    }
                }
            }
        }
        int df = this.values[this.indices[0]].length * this.values[this.indices[1]].length * this.values[this.indices[2]].length * this.values[this.indices[3]].length - 1 - (this.values[this.indices[0]].length + this.values[this.indices[1]].length + this.values[this.indices[2]].length + this.values[this.indices[3]].length);
        if (this.verbose) {
            System.out.println("(" + i + " " + j + " " + k + " " + l + " chisq2 = " + chisq2 + ", prob = " + (1.0 - ProbUtils.chisqCdf(chisq2, df)) + ")");
        }
        this.cacheOneFactorTest(this.indices, 1.0 - ProbUtils.chisqCdf(chisq2, df) > this.sig);
        return 1.0 - ProbUtils.chisqCdf(chisq2, df) > this.sig;
    }

    @Override
    public boolean oneFactorTest(int i, int j, int k, int l, int x) {
        this.indices = new int[5];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.indices[4] = x;
        int cachedResult = this.oneFactorCached(this.indices);
        if (cachedResult != 0) {
            return cachedResult > 0;
        }
        double[][] ulCorr = new double[5][5];
        String[] vNames = new String[5];
        for (int v1 = 0; v1 < 5; ++v1) {
            ulCorr[v1][v1] = 1.0;
            for (int v2 = v1 + 1; v2 < 5; ++v2) {
                double d = this.polyCorr[this.indices[v1]][this.indices[v2]];
                ulCorr[v2][v1] = d;
                ulCorr[v1][v2] = d;
            }
            vNames[v1] = "xi" + v1;
        }
        if (MatrixUtils.determinant(ulCorr) <= 0.0) {
            return false;
        }
        CovarianceMatrix CovarianceMatrix2 = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(ulCorr), this.dataSet.getNumRows());
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta = new GraphNode("eta");
        eta.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta);
        for (int n = 0; n < 5; ++n) {
            GraphNode xi = new GraphNode("xi" + n);
            factorModel.addNode(xi);
            factorModel.addDirectedEdge(eta, xi);
        }
        SemPm semPm = new SemPm(factorModel);
        MimBuildEstimator est = new MimBuildEstimator(CovarianceMatrix2, semPm, 5, 5);
        est.estimate();
        if (est.getEstimatedSem().getPValue() > this.sig) {
            this.cacheOneFactorTest(this.indices, true);
            return true;
        }
        if (est.getEstimatedSem().getPValue() < 1.0E-10) {
            this.cacheOneFactorTest(this.indices, false);
            return false;
        }
        CovarianceMatrix covMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(est.getEstimatedSem().getImplCovarMeas().toArray()), this.dataSet.getNumRows());
        double[][] m = new CorrelationMatrix(covMatrix).getMatrix().toArray();
        int[][][][][] counts5 = this.computeCounts5(i, j, k, l, x);
        double chisq = 0.0;
        int[] indices2 = new int[5];
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        for (int v5 = 0; v5 < this.values[this.indices[4]].length; ++v5) {
                            if (counts5[v1][v2][v3][v4][v5] == 0) continue;
                            indices2[0] = v1;
                            indices2[1] = v2;
                            indices2[2] = v3;
                            indices2[3] = v4;
                            indices2[4] = v5;
                            double ph = this.highPrecisionIntegral ? this.piHat0(this.indices, indices2, m) : this.piHat1(this.indices, indices2, est.getEstimatedSem());
                            chisq += ((double)counts5[v1][v2][v3][v4][v5] - (double)this.dataSet.getNumRows() * ph) * ((double)counts5[v1][v2][v3][v4][v5] - (double)this.dataSet.getNumRows() * ph) / ((double)this.dataSet.getNumRows() * ph);
                        }
                    }
                }
            }
        }
        int df = this.values[this.indices[0]].length * this.values[this.indices[1]].length * this.values[this.indices[2]].length * this.values[this.indices[3]].length * this.values[this.indices[4]].length - 1 - (this.values[this.indices[0]].length + this.values[this.indices[1]].length + this.values[this.indices[2]].length + this.values[this.indices[3]].length + this.values[this.indices[4]].length);
        if (this.verbose) {
            System.out.println("(" + i + " " + j + " " + k + " " + l + " " + x + " chisq = " + chisq + ", prob = " + (1.0 - ProbUtils.chisqCdf(chisq, df)) + ")");
        }
        this.cacheOneFactorTest(this.indices, 1.0 - ProbUtils.chisqCdf(chisq, df) > this.sig);
        return 1.0 - ProbUtils.chisqCdf(chisq, df) > this.sig;
    }

    @Override
    public boolean oneFactorTest(int i, int j, int k, int l, int x, int y) {
        this.indices = new int[6];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.indices[4] = x;
        this.indices[5] = y;
        double[][] ulCorr = new double[6][6];
        String[] vNames = new String[6];
        for (int v1 = 0; v1 < 6; ++v1) {
            ulCorr[v1][v1] = 1.0;
            for (int v2 = v1 + 1; v2 < 6; ++v2) {
                double d = this.polyCorr[this.indices[v1]][this.indices[v2]];
                ulCorr[v2][v1] = d;
                ulCorr[v1][v2] = d;
            }
            vNames[v1] = "xi" + v1;
        }
        if (MatrixUtils.determinant(ulCorr) <= 0.0) {
            return false;
        }
        CovarianceMatrix CovarianceMatrix2 = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(ulCorr), this.dataSet.getNumRows());
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta = new GraphNode("eta");
        eta.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta);
        for (int n = 0; n < 6; ++n) {
            GraphNode xi = new GraphNode("xi" + n);
            factorModel.addNode(xi);
            factorModel.addDirectedEdge(eta, xi);
        }
        SemPm semPm = new SemPm(factorModel);
        MimBuildEstimator est = new MimBuildEstimator(CovarianceMatrix2, semPm, 5, 5);
        est.estimate();
        if (est.getEstimatedSem().getPValue() > this.sig) {
            return true;
        }
        if (est.getEstimatedSem().getPValue() < 1.0E-10) {
            return false;
        }
        CorrelationMatrix correlationMatrix = new CorrelationMatrix(new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(est.getEstimatedSem().getImplCovarMeas().toArray()), this.dataSet.getNumRows()));
        double[][] m = correlationMatrix.getMatrix().toArray();
        int[][][][][][] counts6 = this.computeCounts6(i, j, k, l, x, y);
        double chisq = 0.0;
        int[] indices2 = new int[6];
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        for (int v5 = 0; v5 < this.values[this.indices[4]].length; ++v5) {
                            for (int v6 = 0; v6 < this.values[this.indices[5]].length; ++v6) {
                                if (counts6[v1][v2][v3][v4][v5][v6] == 0) continue;
                                indices2[0] = v1;
                                indices2[1] = v2;
                                indices2[2] = v3;
                                indices2[3] = v4;
                                indices2[4] = v5;
                                indices2[5] = v6;
                                double ph = this.highPrecisionIntegral ? this.piHat0(this.indices, indices2, m) : this.piHat1(this.indices, indices2, est.getEstimatedSem());
                                chisq += ((double)counts6[v1][v2][v3][v4][v5][v6] - (double)this.dataSet.getNumRows() * ph) * ((double)counts6[v1][v2][v3][v4][v5][v6] - (double)this.dataSet.getNumRows() * ph) / ((double)this.dataSet.getNumRows() * ph);
                            }
                        }
                    }
                }
            }
        }
        int df = this.values[this.indices[0]].length * this.values[this.indices[1]].length * this.values[this.indices[2]].length * this.values[this.indices[3]].length * this.values[this.indices[4]].length * this.values[this.indices[5]].length - 1 - (this.values[this.indices[0]].length + this.values[this.indices[1]].length + this.values[this.indices[2]].length + this.values[this.indices[3]].length + this.values[this.indices[4]].length + this.values[this.indices[5]].length);
        if (this.verbose) {
            System.out.println("(" + i + " " + j + " " + k + " " + l + " " + x + " chisq = " + chisq + ", prob = " + (1.0 - ProbUtils.chisqCdf(chisq, df)) + ")");
        }
        return 1.0 - ProbUtils.chisqCdf(chisq, df) > this.sig;
    }

    @Override
    public boolean twoFactorTest(int i, int j, int k, int l) {
        this.indices = new int[4];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        int cachedResult = this.twoFactorCached(this.indices);
        if (cachedResult != 0) {
            return cachedResult > 0;
        }
        double[][] ulCorr = new double[4][4];
        String[] vNames = new String[4];
        for (int v1 = 0; v1 < 4; ++v1) {
            ulCorr[v1][v1] = 1.0;
            for (int v2 = v1 + 1; v2 < 4; ++v2) {
                double d = this.polyCorr[this.indices[v1]][this.indices[v2]];
                ulCorr[v2][v1] = d;
                ulCorr[v1][v2] = d;
            }
            vNames[v1] = "xi" + v1;
        }
        if (MatrixUtils.determinant(ulCorr) <= 0.0) {
            this.tempProb = 0.0;
            return false;
        }
        CovarianceMatrix CovarianceMatrix2 = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(ulCorr), this.dataSet.getNumRows());
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta1 = new GraphNode("eta1");
        eta1.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta1);
        GraphNode eta2 = new GraphNode("eta2");
        eta2.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta2);
        for (int n = 0; n < 4; ++n) {
            GraphNode xi = new GraphNode("xi" + n);
            factorModel.addNode(xi);
            if (n < 2) {
                factorModel.addDirectedEdge(eta1, xi);
                continue;
            }
            factorModel.addDirectedEdge(eta2, xi);
        }
        factorModel.addDirectedEdge(eta1, eta2);
        SemPm semPm = new SemPm(factorModel);
        MimBuildEstimator est = new MimBuildEstimator(CovarianceMatrix2, semPm, 5, 5);
        est.estimate();
        this.tempProb = est.getEstimatedSem().getPValue();
        if (est.getEstimatedSem().getPValue() > this.sig) {
            this.cacheTwoFactorTest(this.indices, true);
            return true;
        }
        if (est.getEstimatedSem().getPValue() < 1.0E-10) {
            this.cacheTwoFactorTest(this.indices, false);
            return false;
        }
        CovarianceMatrix covMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(est.getEstimatedSem().getImplCovarMeas().toArray()), this.dataSet.getNumRows());
        double[][] m = new CorrelationMatrix(covMatrix).getMatrix().toArray();
        int[][][][] counts4 = this.computeCounts4(i, j, k, l);
        int[] indices2 = new int[4];
        double chisq2 = 0.0;
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        if (counts4[v1][v2][v3][v4] == 0) continue;
                        indices2[0] = v1;
                        indices2[1] = v2;
                        indices2[2] = v3;
                        indices2[3] = v4;
                        double ph = this.highPrecisionIntegral ? this.piHat0(this.indices, indices2, m) : this.piHat2(this.indices, indices2, est.getEstimatedSem());
                        chisq2 += ((double)counts4[v1][v2][v3][v4] - (double)this.dataSet.getNumRows() * ph) * ((double)counts4[v1][v2][v3][v4] - (double)this.dataSet.getNumRows() * ph) / ((double)this.dataSet.getNumRows() * ph);
                    }
                }
            }
        }
        int df = this.values[this.indices[0]].length * this.values[this.indices[1]].length * this.values[this.indices[2]].length * this.values[this.indices[3]].length - 1 - (this.values[this.indices[0]].length + this.values[this.indices[1]].length + this.values[this.indices[2]].length + this.values[this.indices[3]].length);
        if (this.verbose) {
            System.out.println("(" + i + " " + j + " " + k + " " + l + " chisq2 = " + chisq2 + ", prob = " + (1.0 - ProbUtils.chisqCdf(chisq2, df)) + ")");
        }
        this.cacheTwoFactorTest(this.indices, 1.0 - ProbUtils.chisqCdf(chisq2, df) > this.sig);
        this.tempProb = 1.0 - ProbUtils.chisqCdf(chisq2, df);
        return this.tempProb > this.sig;
    }

    @Override
    public boolean twoFactorTest(int i, int j, int k, int l, int x) {
        this.indices = new int[5];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.indices[4] = x;
        double[][] ulCorr = new double[5][5];
        String[] vNames = new String[5];
        for (int v1 = 0; v1 < 5; ++v1) {
            ulCorr[v1][v1] = 1.0;
            for (int v2 = v1 + 1; v2 < 5; ++v2) {
                double d = this.polyCorr[this.indices[v1]][this.indices[v2]];
                ulCorr[v2][v1] = d;
                ulCorr[v1][v2] = d;
            }
            vNames[v1] = "xi" + v1;
        }
        if (MatrixUtils.determinant(ulCorr) <= 0.0) {
            return false;
        }
        CovarianceMatrix CovarianceMatrix2 = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(ulCorr), this.dataSet.getNumRows());
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta1 = new GraphNode("eta1");
        eta1.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta1);
        GraphNode eta2 = new GraphNode("eta2");
        eta2.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta2);
        for (int n = 0; n < 5; ++n) {
            GraphNode xi = new GraphNode("xi" + n);
            factorModel.addNode(xi);
            if (n <= 2) {
                factorModel.addDirectedEdge(eta1, xi);
                continue;
            }
            factorModel.addDirectedEdge(eta2, xi);
        }
        factorModel.addDirectedEdge(eta1, eta2);
        SemPm semPm = new SemPm(factorModel);
        MimBuildEstimator est = new MimBuildEstimator(CovarianceMatrix2, semPm, 5, 5);
        est.estimate();
        if (est.getEstimatedSem().getPValue() > this.sig) {
            return true;
        }
        if (est.getEstimatedSem().getPValue() < 1.0E-10) {
            return false;
        }
        CorrelationMatrix correlationMatrix = new CorrelationMatrix(new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(est.getEstimatedSem().getImplCovarMeas().toArray()), this.dataSet.getNumRows()));
        double[][] m = correlationMatrix.getMatrix().toArray();
        int[][][][][] counts5 = this.computeCounts5(i, j, k, l, x);
        double chisq = 0.0;
        int[] indices2 = new int[5];
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        for (int v5 = 0; v5 < this.values[this.indices[4]].length; ++v5) {
                            if (counts5[v1][v2][v3][v4][v5] == 0) continue;
                            indices2[0] = v1;
                            indices2[1] = v2;
                            indices2[2] = v3;
                            indices2[3] = v4;
                            indices2[4] = v5;
                            double ph = this.highPrecisionIntegral ? this.piHat0(this.indices, indices2, m) : this.piHat2(this.indices, indices2, est.getEstimatedSem());
                            chisq += ((double)counts5[v1][v2][v3][v4][v5] - (double)this.dataSet.getNumRows() * ph) * ((double)counts5[v1][v2][v3][v4][v5] - (double)this.dataSet.getNumRows() * ph) / ((double)this.dataSet.getNumRows() * ph);
                        }
                    }
                }
            }
        }
        int df = this.values[this.indices[0]].length * this.values[this.indices[1]].length * this.values[this.indices[2]].length * this.values[this.indices[3]].length * this.values[this.indices[4]].length - 1 - (this.values[this.indices[0]].length + this.values[this.indices[1]].length + this.values[this.indices[2]].length + this.values[this.indices[3]].length + this.values[this.indices[4]].length + 1);
        if (this.verbose) {
            System.out.println("(" + i + " " + j + " " + k + " " + l + " " + x + " chisq = " + chisq + ", prob = " + (1.0 - ProbUtils.chisqCdf(chisq, df)) + ")");
        }
        return 1.0 - ProbUtils.chisqCdf(chisq, df) > this.sig;
    }

    @Override
    public boolean twoFactorTest(int i, int j, int k, int l, int x, int y) {
        this.indices = new int[6];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.indices[4] = x;
        this.indices[5] = y;
        double[][] ulCorr = new double[6][6];
        String[] vNames = new String[6];
        for (int v1 = 0; v1 < 6; ++v1) {
            ulCorr[v1][v1] = 1.0;
            for (int v2 = v1 + 1; v2 < 6; ++v2) {
                double d = this.polyCorr[this.indices[v1]][this.indices[v2]];
                ulCorr[v2][v1] = d;
                ulCorr[v1][v2] = d;
            }
            vNames[v1] = "xi" + v1;
        }
        if (MatrixUtils.determinant(ulCorr) <= 0.0) {
            return false;
        }
        CovarianceMatrix CovarianceMatrix2 = new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(ulCorr), this.dataSet.getNumRows());
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta1 = new GraphNode("eta1");
        eta1.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta1);
        GraphNode eta2 = new GraphNode("eta2");
        eta2.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta2);
        for (int n = 0; n < 6; ++n) {
            GraphNode xi = new GraphNode("xi" + n);
            factorModel.addNode(xi);
            if (n <= 2) {
                factorModel.addDirectedEdge(eta1, xi);
                continue;
            }
            factorModel.addDirectedEdge(eta2, xi);
        }
        factorModel.addDirectedEdge(eta1, eta2);
        SemPm semPm = new SemPm(factorModel);
        MimBuildEstimator est = new MimBuildEstimator(CovarianceMatrix2, semPm, 5, 5);
        est.estimate();
        if (est.getEstimatedSem().getPValue() > this.sig) {
            return true;
        }
        if (est.getEstimatedSem().getPValue() < 1.0E-10) {
            return false;
        }
        CorrelationMatrix correlationMatrix = new CorrelationMatrix(new CovarianceMatrix(DataUtils.createContinuousVariables(vNames), new DenseDoubleMatrix2D(est.getEstimatedSem().getImplCovarMeas().toArray()), this.dataSet.getNumRows()));
        double[][] m = correlationMatrix.getMatrix().toArray();
        int[][][][][][] counts6 = this.computeCounts6(i, j, k, l, x, y);
        double chisq = 0.0;
        int[] indices2 = new int[6];
        for (int v1 = 0; v1 < this.values[this.indices[0]].length; ++v1) {
            for (int v2 = 0; v2 < this.values[this.indices[1]].length; ++v2) {
                for (int v3 = 0; v3 < this.values[this.indices[2]].length; ++v3) {
                    for (int v4 = 0; v4 < this.values[this.indices[3]].length; ++v4) {
                        for (int v5 = 0; v5 < this.values[this.indices[4]].length; ++v5) {
                            for (int v6 = 0; v6 < this.values[this.indices[5]].length; ++v6) {
                                if (counts6[v1][v2][v3][v4][v5][v6] == 0) continue;
                                indices2[0] = v1;
                                indices2[1] = v2;
                                indices2[2] = v3;
                                indices2[3] = v4;
                                indices2[4] = v5;
                                indices2[5] = v6;
                                double ph = this.highPrecisionIntegral ? this.piHat0(this.indices, indices2, m) : this.piHat2(this.indices, indices2, est.getEstimatedSem());
                                chisq += ((double)counts6[v1][v2][v3][v4][v5][v6] - (double)this.dataSet.getNumRows() * ph) * ((double)counts6[v1][v2][v3][v4][v5][v6] - (double)this.dataSet.getNumRows() * ph) / ((double)this.dataSet.getNumRows() * ph);
                            }
                        }
                    }
                }
            }
        }
        int df = this.values[this.indices[0]].length * this.values[this.indices[1]].length * this.values[this.indices[2]].length * this.values[this.indices[3]].length * this.values[this.indices[4]].length * this.values[this.indices[5]].length - 1 - (this.values[this.indices[0]].length + this.values[this.indices[1]].length + this.values[this.indices[2]].length + this.values[this.indices[3]].length + this.values[this.indices[4]].length + this.values[this.indices[5]].length + 1);
        if (this.verbose) {
            System.out.println("(" + i + " " + j + " " + k + " " + l + " " + x + " chisq = " + chisq + ", prob = " + (1.0 - ProbUtils.chisqCdf(chisq, df)) + ")");
        }
        return 1.0 - ProbUtils.chisqCdf(chisq, df) > this.sig;
    }

    private double piHat0(int[] indices, int[] v, double[][] m) {
        double[] a = new double[indices.length];
        double[] b = new double[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            a[i] = v[i] == 0 ? Double.NEGATIVE_INFINITY : this.thresholds[indices[i]][v[i] - 1];
            b[i] = v[i] == this.values[indices[i]].length - 1 ? Double.POSITIVE_INFINITY : this.thresholds[indices[i]][v[i]];
        }
        double[][] mScratch = new double[m.length][m.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                mScratch[i][j] = m[i][j];
            }
        }
        return ProbUtils.multinormalProb(a, b, mScratch);
    }

    private double piHat1(int[] indices, int[] v, SemIm semIm) {
        double[] stdE = new double[indices.length];
        double[] stdU = new double[indices.length];
        double[] coeff = new double[indices.length];
        Node etaNode = semIm.getSemPm().getGraph().getNode("eta");
        double varEta = semIm.getParamValue(etaNode, etaNode);
        double stdEta = Math.sqrt(semIm.getParamValue(etaNode, etaNode));
        for (int i = 0; i < indices.length; ++i) {
            Node uNode = semIm.getSemPm().getGraph().getNode("xi" + i);
            Node uParent = null;
            Node uError = null;
            for (Node parent : semIm.getSemPm().getGraph().getParents(uNode)) {
                if (parent.getNodeType() == NodeType.LATENT) {
                    uParent = parent;
                    continue;
                }
                uError = parent;
            }
            coeff[i] = i == 0 ? 1.0 : semIm.getParamValue(uParent, uNode);
            stdE[i] = Math.sqrt(semIm.getParamValue(uError, uError));
            stdU[i] = Math.sqrt(coeff[i] * coeff[i] * varEta + semIm.getParamValue(uError, uError));
        }
        double l = 0.0;
        for (int t = 0; t < GHY.length; ++t) {
            double tValue = GHW[t];
            for (int i = 0; i < indices.length; ++i) {
                int numValues = this.values[indices[i]].length;
                if (v[i] == 0) {
                    tValue *= ProbUtils.normalCdf((this.thresholds[indices[i]][0] * stdU[i] - coeff[i] * GHY[t] * stdEta) / stdE[i]);
                    continue;
                }
                if (v[i] == numValues - 1) {
                    tValue *= 1.0 - ProbUtils.normalCdf((this.thresholds[indices[i]][numValues - 2] * stdU[i] - coeff[i] * GHY[t] * stdEta) / stdE[i]);
                    continue;
                }
                tValue *= ProbUtils.normalCdf((this.thresholds[indices[i]][v[i]] * stdU[i] - coeff[i] * GHY[t] * stdEta) / stdE[i]) - ProbUtils.normalCdf((this.thresholds[indices[i]][v[i] - 1] * stdU[i] - coeff[i] * GHY[t] * stdEta) / stdE[i]);
            }
            l += tValue;
        }
        return l;
    }

    private double piHat2(int[] indices, int[] v, SemIm semIm) {
        Node etaNode1 = semIm.getSemPm().getGraph().getNode("eta1");
        double varEta1 = semIm.getParamValue(etaNode1, etaNode1);
        double stdEta1 = Math.sqrt(semIm.getParamValue(etaNode1, etaNode1));
        Node etaNode2 = semIm.getSemPm().getGraph().getNode("eta2");
        double coeffEta = semIm.getParamValue(etaNode1, etaNode2);
        Node errorEta2 = semIm.getSemPm().getGraph().getParents(etaNode2).get(0) == etaNode1 ? semIm.getSemPm().getGraph().getParents(etaNode2).get(1) : semIm.getSemPm().getGraph().getParents(etaNode2).get(0);
        double varEta2 = coeffEta * coeffEta * varEta1 + semIm.getParamValue(errorEta2, errorEta2);
        double stdEtaError2 = Math.sqrt(semIm.getParamValue(errorEta2, errorEta2));
        double[] stdE = new double[indices.length];
        double[] varEta = new double[indices.length];
        double[] stdU = new double[indices.length];
        double[] coeff = new double[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            Node uNode = semIm.getSemPm().getGraph().getNode("xi" + i);
            Node uParent = null;
            Node uError = null;
            for (Node node : semIm.getSemPm().getGraph().getParents(uNode)) {
                Node parent = node;
                if (parent.getNodeType() == NodeType.LATENT) {
                    uParent = parent;
                    continue;
                }
                uError = parent;
            }
            coeff[i] = i == 0 || i == 2 && indices.length == 4 || i == 3 && indices.length > 4 ? 1.0 : semIm.getParamValue(uParent, uNode);
            varEta[i] = uParent == etaNode1 ? varEta1 : varEta2;
            stdE[i] = Math.sqrt(semIm.getParamValue(uError, uError));
            stdU[i] = Math.sqrt(coeff[i] * coeff[i] * varEta[i] + semIm.getParamValue(uError, uError));
        }
        double l = 0.0;
        for (int t1 = 0; t1 < GHY.length; ++t1) {
            for (int t2 = 0; t2 < GHY.length; ++t2) {
                double tValue = GHW[t1] * GHW[t2];
                double eta1 = GHY[t1] * stdEta1;
                double eta2 = eta1 * coeffEta + GHY[t2] * stdEtaError2;
                for (int i = 0; i < indices.length; ++i) {
                    double eta = indices.length == 4 ? (i < 2 ? eta1 : eta2) : (i < 3 ? eta1 : eta2);
                    int numValues = this.values[indices[i]].length;
                    if (v[i] == 0) {
                        tValue *= ProbUtils.normalCdf((this.thresholds[indices[i]][0] * stdU[i] - coeff[i] * eta) / stdE[i]);
                        continue;
                    }
                    if (v[i] == numValues - 1) {
                        tValue *= 1.0 - ProbUtils.normalCdf((this.thresholds[indices[i]][numValues - 2] * stdU[i] - coeff[i] * eta) / stdE[i]);
                        continue;
                    }
                    tValue *= ProbUtils.normalCdf((this.thresholds[indices[i]][v[i]] * stdU[i] - coeff[i] * eta) / stdE[i]) - ProbUtils.normalCdf((this.thresholds[indices[i]][v[i] - 1] * stdU[i] - coeff[i] * eta) / stdE[i]);
                }
                l += tValue;
            }
        }
        return l;
    }
}

