/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.PossibleDsepFci;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class FciOld {
    private Graph graph;
    private SepsetMap sepsetMap;
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables = new ArrayList<Node>();
    private IndependenceTest independenceTest;
    private boolean changeFlag = true;
    private int depth = -1;
    private long elapsedTime;
    private TetradLogger logger = TetradLogger.getInstance();

    public FciOld(IndependenceTest independenceTest) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public FciOld(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        HashSet<Node> remVars = new HashSet<Node>();
        for (Node node1 : this.variables) {
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Graph search() {
        long beginTime = System.currentTimeMillis();
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.independenceTest + ".");
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Node variable : this.variables) {
            nodes.add(variable);
        }
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.CIRCLE);
        Fas adj = new Fas(this.graph, this.independenceTest);
        adj.setKnowledge(this.getKnowledge());
        adj.setDepth(this.depth);
        this.graph = adj.search();
        this.sepsetMap = adj.getSepsets();
        long time1 = System.currentTimeMillis();
        this.orientColliders();
        long time2 = System.currentTimeMillis();
        this.logger.log("info", "Step C: " + (double)(time2 - time1) / 1000.0 + "s");
        long time3 = System.currentTimeMillis();
        PossibleDsepFci possibleDSep = new PossibleDsepFci(this.graph, this.independenceTest, this.getSepsetMap());
        possibleDSep.setDepth(this.getDepth());
        possibleDSep.setKnowledge(this.getKnowledge());
        this.sepsetMap = possibleDSep.search();
        long time4 = System.currentTimeMillis();
        this.logger.log("info", "Step D: " + (double)(time4 - time3) / 1000.0 + "s");
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        long time5 = System.currentTimeMillis();
        this.fciOrientbk(this.getKnowledge(), this.graph, this.variables);
        this.orientColliders();
        long time6 = System.currentTimeMillis();
        this.logger.log("info", "Step CI C: " + (double)(time6 - time5) / 1000.0 + "s");
        this.doFinalOrientation();
        long endTime = System.currentTimeMillis();
        this.elapsedTime = endTime - beginTime;
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        return this.graph;
    }

    public SepsetMap getSepsetMap() {
        return this.sepsetMap;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    private void orientColliders() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(a, c = adjacentNodes.get(combination[1])) || this.sepsetMap.get(a, c).contains(b) || !this.isArrowpointAllowed(a, b) || !this.isArrowpointAllowed(c, b)) continue;
                this.graph.setEndpoint(a, b, Endpoint.ARROW);
                this.graph.setEndpoint(c, b, Endpoint.ARROW);
                this.logger.log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(a, b, c));
            }
        }
    }

    private void doFinalOrientation() {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.doubleTriangle();
            this.awayFromColliderAncestorCycle();
            this.discrimPaths();
        }
    }

    private void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }

    private void doubleTriangle() {
        List<Node> nodes = this.graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = this.graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = this.graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !this.graph.isAdjacentTo(A, D) || !this.graph.isAdjacentTo(C, D) || !this.graph.isDefNoncollider(A, D, C) || !this.isArrowpointAllowed(D, B)) continue;
                        this.graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Double triangle", this.graph.getEdge(D, B)));
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private void awayFromColliderAncestorCycle() {
        List<Node> nodes = this.graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = this.graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.awayFromCollider(A, B, C);
                this.awayFromCollider(C, B, A);
                this.awayFromAncestor(A, B, C);
                this.awayFromAncestor(C, B, A);
                this.awayFromCycle(A, B, C);
                this.awayFromCycle(C, B, A);
            }
        }
    }

    private boolean isArrowpointAllowed(Node x, Node y) {
        if (this.graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (this.graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (this.graph.getEndpoint(y, x) == Endpoint.ARROW && this.graph.getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return !this.knowledge.isForbiddenByTiers(x.getName(), y.getName());
    }

    private void awayFromCollider(Node a, Node b, Node c) {
        Endpoint BC = this.graph.getEndpoint(b, c);
        Endpoint CB = this.graph.getEndpoint(c, b);
        if (!this.graph.isAdjacentTo(a, c) && this.graph.getEndpoint(a, b) == Endpoint.ARROW) {
            if ((CB == Endpoint.CIRCLE || CB == Endpoint.TAIL) && BC == Endpoint.CIRCLE) {
                if (!this.isArrowpointAllowed(b, c)) {
                    return;
                }
                this.graph.setEndpoint(b, c, Endpoint.ARROW);
                this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Away from collider", this.graph.getEdge(b, c)));
                this.changeFlag = true;
            }
            if ((BC == Endpoint.CIRCLE || BC == Endpoint.ARROW) && CB == Endpoint.CIRCLE) {
                this.graph.setEndpoint(c, b, Endpoint.TAIL);
                this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Away from collider", this.graph.getEdge(c, b)));
                this.changeFlag = true;
            }
        }
    }

    private void awayFromAncestor(Node a, Node b, Node c) {
        if (this.graph.isAdjacentTo(a, c) && this.graph.getEndpoint(a, c) == Endpoint.CIRCLE && this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(b, c) == Endpoint.ARROW && (this.graph.getEndpoint(b, a) == Endpoint.TAIL || this.graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.graph.setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Away from ancestor", this.graph.getEdge(a, c)));
            this.changeFlag = true;
        }
    }

    private void awayFromCycle(Node a, Node b, Node c) {
        if (this.graph.isAdjacentTo(a, c) && this.graph.getEndpoint(a, c) == Endpoint.ARROW && this.graph.getEndpoint(c, a) == Endpoint.CIRCLE && this.graph.isDirectedFromTo(a, b) && this.graph.isDirectedFromTo(b, c)) {
            this.graph.setEndpoint(c, a, Endpoint.TAIL);
            this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Away from cycle", this.graph.getEdge(c, a)));
            this.changeFlag = true;
        }
    }

    private void discrimPaths() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = this.graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(this.graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(this.graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!this.graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFind(Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(this.graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = this.graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!this.graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientation(l, a, b, c);
                    return;
                }
                if (!cParents.contains(l) || this.graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
    }

    private void doDdpOrientation(Node l, Node a, Node b, Node c) {
        List<Node> sepset = this.sepsetMap.get(l, c);
        if (sepset == null) {
            throw new IllegalArgumentException("The edge from l to c must have been removed at this point.");
        }
        if (sepset.contains(b)) {
            this.graph.setEndpoint(c, b, Endpoint.TAIL);
            this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Definite discriminating path l = " + l, this.graph.getEdge(b, c)));
            this.changeFlag = true;
        } else {
            if (!this.isArrowpointAllowed(a, b)) {
                return;
            }
            if (!this.isArrowpointAllowed(c, b)) {
                return;
            }
            this.graph.setEndpoint(a, b, Endpoint.ARROW);
            this.graph.setEndpoint(c, b, Endpoint.ARROW);
            this.logger.log("colliderOrientations", SearchLogUtils.colliderOrientedMsg("Definite discriminating path.. l = " + l, a, b, c));
            this.changeFlag = true;
        }
    }

    private boolean isDirEdgeAllowed(Node from, Node to) {
        return !this.getKnowledge().edgeRequired(to.getName(), from.getName()) && !this.getKnowledge().edgeForbidden(from.getName(), to.getName());
    }
}

