/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Ges;
import edu.cmu.tetrad.search.MbUtils;
import java.util.LinkedList;
import java.util.List;

public class GesMbFilter {
    private DataSet dataSet;
    private Ges search;

    public GesMbFilter(DataSet dataSet) {
        this.dataSet = dataSet;
        this.search = new Ges(dataSet);
        this.search.setSamplePrior(10.0);
        this.search.setStructurePrior(0.01);
    }

    public Graph filter(List<Node> variable, Node target) {
        LinkedList<Node> dataVars = new LinkedList<Node>();
        for (Node node1 : variable) {
            dataVars.add(this.dataSet.getVariable(node1.getName()));
        }
        Graph mbPattern = this.search.search(new LinkedList<Node>(dataVars));
        Node dataTarget = this.dataSet.getVariable(target.getName());
        MbUtils.trimToMbNodes(mbPattern, dataTarget, false);
        MbUtils.trimEdgesAmongParents(mbPattern, dataTarget);
        MbUtils.trimEdgesAmongParentsOfChildren(mbPattern, dataTarget);
        return mbPattern;
    }
}

