/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.util.RandomUtil;
import java.util.Scanner;

public class Hungarian {
    public static int readInput(String prompt) {
        Scanner in = new Scanner(System.in);
        System.out.print(prompt);
        return in.nextInt();
    }

    public static void printTime(double time) {
        String timeElapsed = "";
        int days = (int)Math.floor(time) / 86400;
        int hours = (int)Math.floor(time % 86400.0) / 3600;
        int minutes = (int)Math.floor(time % 3600.0 / 60.0);
        int seconds = (int)Math.round(time % 60.0);
        if (days > 0) {
            timeElapsed = Integer.toString(days) + "d:";
        }
        if (hours > 0) {
            timeElapsed = timeElapsed + Integer.toString(hours) + "h:";
        }
        if (minutes > 0) {
            timeElapsed = timeElapsed + Integer.toString(minutes) + "m:";
        }
        timeElapsed = timeElapsed + Integer.toString(seconds) + "s";
        System.out.print("\nTotal time required: " + timeElapsed + "\n\n");
    }

    public static void generateRandomArray(double[][] array, String randomMethod) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (randomMethod.equals("random")) {
                    array[i][j] = RandomUtil.getInstance().nextDouble();
                }
                if (!randomMethod.equals("gaussian")) continue;
                array[i][j] = RandomUtil.getInstance().nextNormal(0.0, 1.0) / 4.0;
                if (array[i][j] > 0.5) {
                    array[i][j] = 0.5;
                }
                if (array[i][j] < -0.5) {
                    array[i][j] = -0.5;
                }
                array[i][j] = array[i][j] + 0.5;
            }
        }
    }

    public static double findLargest(double[][] array) {
        double largest = 0.0;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (!(array[i][j] > largest)) continue;
                largest = array[i][j];
            }
        }
        return largest;
    }

    public static double[][] transpose(double[][] array) {
        double[][] transposedArray = new double[array[0].length][array.length];
        for (int i = 0; i < transposedArray.length; ++i) {
            for (int j = 0; j < transposedArray[i].length; ++j) {
                transposedArray[i][j] = array[j][i];
            }
        }
        return transposedArray;
    }

    public static double[][] copyOf(double[][] original) {
        double[][] copy = new double[original.length][original[0].length];
        for (int i = 0; i < original.length; ++i) {
            System.arraycopy(original[i], 0, copy[i], 0, original[i].length);
        }
        return copy;
    }

    public static int[][] hgAlgorithm(double[][] array, String sumType) {
        double[][] cost = Hungarian.copyOf(array);
        if (sumType.equalsIgnoreCase("max")) {
            double maxWeight = Hungarian.findLargest(cost);
            for (int i = 0; i < cost.length; ++i) {
                for (int j = 0; j < cost[i].length; ++j) {
                    cost[i][j] = maxWeight - cost[i][j];
                }
            }
        }
        double maxCost = Hungarian.findLargest(cost);
        int[][] mask = new int[cost.length][cost[0].length];
        int[] rowCover = new int[cost.length];
        int[] colCover = new int[cost[0].length];
        int[] zero_RC = new int[2];
        int step = 1;
        boolean done = false;
        while (!done) {
            switch (step) {
                case 1: {
                    step = Hungarian.hg_step1(step, cost);
                    break;
                }
                case 2: {
                    step = Hungarian.hg_step2(step, cost, mask, rowCover, colCover);
                    break;
                }
                case 3: {
                    step = Hungarian.hg_step3(step, mask, colCover);
                    break;
                }
                case 4: {
                    step = Hungarian.hg_step4(step, cost, mask, rowCover, colCover, zero_RC);
                    break;
                }
                case 5: {
                    step = Hungarian.hg_step5(step, mask, rowCover, colCover, zero_RC);
                    break;
                }
                case 6: {
                    step = Hungarian.hg_step6(step, cost, rowCover, colCover, maxCost);
                    break;
                }
                case 7: {
                    done = true;
                }
            }
        }
        int[][] assignment = new int[array.length][2];
        for (int i = 0; i < mask.length; ++i) {
            for (int j = 0; j < mask[i].length; ++j) {
                if (mask[i][j] != 1) continue;
                assignment[i][0] = i;
                assignment[i][1] = j;
            }
        }
        return assignment;
    }

    public static int hg_step1(int step, double[][] cost) {
        for (int i = 0; i < cost.length; ++i) {
            int j;
            double minval = cost[i][0];
            for (j = 0; j < cost[i].length; ++j) {
                if (!(minval > cost[i][j])) continue;
                minval = cost[i][j];
            }
            for (j = 0; j < cost[i].length; ++j) {
                cost[i][j] = cost[i][j] - minval;
            }
        }
        step = 2;
        return step;
    }

    public static int hg_step2(int step, double[][] cost, int[][] mask, int[] rowCover, int[] colCover) {
        for (int i = 0; i < cost.length; ++i) {
            for (int j = 0; j < cost[i].length; ++j) {
                if (cost[i][j] != 0.0 || colCover[j] != 0 || rowCover[i] != 0) continue;
                mask[i][j] = 1;
                colCover[j] = 1;
                rowCover[i] = 1;
            }
        }
        Hungarian.clearCovers(rowCover, colCover);
        step = 3;
        return step;
    }

    public static int hg_step3(int step, int[][] mask, int[] colCover) {
        int j;
        for (int i = 0; i < mask.length; ++i) {
            for (j = 0; j < mask[i].length; ++j) {
                if (mask[i][j] != 1) continue;
                colCover[j] = 1;
            }
        }
        int count = 0;
        for (j = 0; j < colCover.length; ++j) {
            count += colCover[j];
        }
        step = count >= mask.length ? 7 : 4;
        return step;
    }

    public static int hg_step4(int step, double[][] cost, int[][] mask, int[] rowCover, int[] colCover, int[] zero_RC) {
        int[] row_col = new int[2];
        boolean done = false;
        while (!done) {
            if ((row_col = Hungarian.findUncoveredZero(row_col, cost, rowCover, colCover))[0] == -1) {
                done = true;
                step = 6;
                continue;
            }
            mask[row_col[0]][row_col[1]] = 2;
            boolean starInRow = false;
            for (int j = 0; j < mask[row_col[0]].length; ++j) {
                if (mask[row_col[0]][j] != 1) continue;
                starInRow = true;
                row_col[1] = j;
            }
            if (starInRow) {
                rowCover[row_col[0]] = 1;
                colCover[row_col[1]] = 0;
                continue;
            }
            zero_RC[0] = row_col[0];
            zero_RC[1] = row_col[1];
            done = true;
            step = 5;
        }
        return step;
    }

    public static int[] findUncoveredZero(int[] row_col, double[][] cost, int[] rowCover, int[] colCover) {
        row_col[0] = -1;
        row_col[1] = 0;
        int i = 0;
        boolean done = false;
        while (!done) {
            for (int j = 0; j < cost[i].length; ++j) {
                if (cost[i][j] != 0.0 || rowCover[i] != 0 || colCover[j] != 0) continue;
                row_col[0] = i;
                row_col[1] = j;
                done = true;
            }
            if (++i < cost.length) continue;
            done = true;
        }
        return row_col;
    }

    public static int hg_step5(int step, int[][] mask, int[] rowCover, int[] colCover, int[] zero_RC) {
        int count = 0;
        int[][] path = new int[mask[0].length * mask.length][2];
        path[count][0] = zero_RC[0];
        path[count][1] = zero_RC[1];
        boolean done = false;
        while (!done) {
            int r = Hungarian.findStarInCol(mask, path[count][1]);
            if (r >= 0) {
                path[++count][0] = r;
                path[count][1] = path[count - 1][1];
            } else {
                done = true;
            }
            if (done) continue;
            int c = Hungarian.findPrimeInRow(mask, path[count][0]);
            path[++count][0] = path[count - 1][0];
            path[count][1] = c;
        }
        Hungarian.convertPath(mask, path, count);
        Hungarian.clearCovers(rowCover, colCover);
        Hungarian.erasePrimes(mask);
        step = 3;
        return step;
    }

    public static int findStarInCol(int[][] mask, int col) {
        int r = -1;
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i][col] != 1) continue;
            r = i;
        }
        return r;
    }

    public static int findPrimeInRow(int[][] mask, int row) {
        int c = -1;
        for (int j = 0; j < mask[row].length; ++j) {
            if (mask[row][j] != 2) continue;
            c = j;
        }
        return c;
    }

    public static void convertPath(int[][] mask, int[][] path, int count) {
        for (int i = 0; i <= count; ++i) {
            mask[path[i][0]][path[i][1]] = mask[path[i][0]][path[i][1]] == 1 ? 0 : 1;
        }
    }

    public static void erasePrimes(int[][] mask) {
        for (int i = 0; i < mask.length; ++i) {
            for (int j = 0; j < mask[i].length; ++j) {
                if (mask[i][j] != 2) continue;
                mask[i][j] = 0;
            }
        }
    }

    public static void clearCovers(int[] rowCover, int[] colCover) {
        for (int i = 0; i < rowCover.length; ++i) {
            rowCover[i] = 0;
        }
        for (int j = 0; j < colCover.length; ++j) {
            colCover[j] = 0;
        }
    }

    public static int hg_step6(int step, double[][] cost, int[] rowCover, int[] colCover, double maxCost) {
        double minval = Hungarian.findSmallest(cost, rowCover, colCover, maxCost);
        for (int i = 0; i < rowCover.length; ++i) {
            for (int j = 0; j < colCover.length; ++j) {
                if (rowCover[i] == 1) {
                    cost[i][j] = cost[i][j] + minval;
                }
                if (colCover[j] != 0) continue;
                cost[i][j] = cost[i][j] - minval;
            }
        }
        step = 4;
        return step;
    }

    public static double findSmallest(double[][] cost, int[] rowCover, int[] colCover, double maxCost) {
        double minval = maxCost;
        for (int i = 0; i < cost.length; ++i) {
            for (int j = 0; j < cost[i].length; ++j) {
                if (rowCover[i] != 0 || colCover[j] != 0 || !(minval > cost[i][j])) continue;
                minval = cost[i][j];
            }
        }
        return minval;
    }

    public static void main(String[] args) {
        String sumType = "max";
        int numOfRows = Hungarian.readInput("How many rows for the matrix? ");
        int numOfCols = Hungarian.readInput("How many columns for the matrix? ");
        double[][] array = new double[numOfRows][numOfCols];
        Hungarian.generateRandomArray(array, "random");
        if (array.length > array[0].length) {
            System.out.println("Array transposed (because rows>columns).\n");
            array = Hungarian.transpose(array);
        }
        System.out.println("\n(Printing out only 2 decimals)\n");
        System.out.println("The matrix is:");
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                System.out.printf("%.2f\t", array[i][j]);
            }
            System.out.println();
        }
        System.out.println();
        double startTime = System.nanoTime();
        int[][] assignment = new int[array.length][2];
        assignment = Hungarian.hgAlgorithm(array, sumType);
        double endTime = System.nanoTime();
        System.out.println("The winning assignment (" + sumType + " sum) is:\n");
        double sum = 0.0;
        for (int i = 0; i < assignment.length; ++i) {
            System.out.printf("array(%d,%d) = %.2f\n", assignment[i][0] + 1, assignment[i][1] + 1, array[assignment[i][0]][assignment[i][1]]);
            sum += array[assignment[i][0]][assignment[i][1]];
        }
        System.out.printf("\nThe %s is: %.2f\n", sumType, sum);
        Hungarian.printTime((endTime - startTime) / 1.0E9);
    }
}

