/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Cpc;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Icpc
implements GraphSearch {
    private IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private long elapsedTime;
    private boolean aggressivelyPreventCycles = false;
    private TetradLogger logger = TetradLogger.getInstance();
    private double alpha;
    private Graph trueGraph;
    private SemIm semIm;
    private int maxAdjacencies = 100;
    private double unfathfulThreshold = 0.1;
    private SepsetMap sepsets;
    private int maxIterations = 30;
    private Graph startingGraph;

    public Icpc(IndependenceTest test) {
        this(test, null);
    }

    public Icpc(IndependenceTest independenceTest, Graph graph) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.startingGraph = graph;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public void setSemIm(SemIm semIm) {
        this.semIm = semIm;
    }

    public int getMaxAdjacencies() {
        return this.maxAdjacencies;
    }

    public void setMaxAdjacencies(int maxAdjacencies) {
        if (maxAdjacencies < 1) {
            throw new IllegalArgumentException("Max adjacencies needs to be at least one, preferably at least 3");
        }
        this.maxAdjacencies = maxAdjacencies;
    }

    public List<Node> getSemidirectedDescendants(Graph graph, List<Node> nodes) {
        HashSet<Node> descendants = new HashSet<Node>();
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node1;
            Node node = node1 = i$.next();
            this.collectSemidirectedDescendantsVisit(graph, node, descendants);
        }
        return new LinkedList<Node>(descendants);
    }

    @Override
    public Graph search() {
        int[] choice;
        Graph graph;
        EdgeListGraph minGraph = null;
        int min = Integer.MAX_VALUE;
        ArrayList<EdgeListGraph> graphs = new ArrayList<EdgeListGraph>();
        IndependenceTest test = this.getIndependenceTest();
        if (this.startingGraph != null) {
            graph = this.startingGraph;
        } else {
            Cpc cpc = new Cpc(test);
            graph = cpc.search();
        }
        this.sepsets = new SepsetMap();
        EdgeListGraph fullGraph = new EdgeListGraph(graph.getNodes());
        fullGraph.fullyConnect(Endpoint.CIRCLE);
        List<Edge> edges = fullGraph.getEdges();
        boolean converged = false;
        boolean changed = true;
        int count = -1;
        while (changed && ++count <= this.getMaxIterations()) {
            changed = false;
            int numAdded = 0;
            int numRemoved = 0;
            ArrayList<Edge> changedEdges = new ArrayList<Edge>();
            for (Edge adjacency : edges) {
                Edge edge = graph.getEdge(adjacency.getNode1(), adjacency.getNode2());
                Node x = adjacency.getNode1();
                Node y = adjacency.getNode2();
                List<Node> sepsetX = this.pathBlockingSet(test, graph, x, y);
                List<Node> sepsetY = this.pathBlockingSet(test, graph, y, x);
                if (sepsetX != null && sepsetY != null) {
                    if (sepsetX.size() < sepsetY.size()) {
                        this.sepsets.set(x, y, sepsetX);
                    } else {
                        this.sepsets.set(x, y, sepsetY);
                    }
                } else if (sepsetX != null) {
                    this.sepsets.set(x, y, sepsetX);
                } else if (sepsetY != null) {
                    this.sepsets.set(x, y, sepsetY);
                } else {
                    this.sepsets.set(x, y, null);
                }
                if (edge == null) {
                    if (sepsetX != null || sepsetY != null || graph.getAdjacentNodes(x).size() >= this.getMaxAdjacencies() || graph.getAdjacentNodes(y).size() >= this.getMaxAdjacencies()) continue;
                    graph.addUndirectedEdge(x, y);
                    this.addChangedEdges(graph, changedEdges, graph.getEdge(x, y));
                    changed = true;
                    ++numAdded;
                    continue;
                }
                if (sepsetX == null && sepsetY == null) continue;
                this.addChangedEdges(graph, changedEdges, graph.getEdge(x, y));
                graph.removeEdge(edge);
                changed = true;
                ++numRemoved;
            }
            graph = this.orientCpc(graph, this.knowledge, this.depth);
            if (count > this.getMaxIterations() - 10 && graph.getNumEdges() < min) {
                minGraph = new EdgeListGraph(graph);
                min = graph.getNumEdges();
            }
            graphs.add(new EdgeListGraph(graph));
        }
        List<Node> nodes = graph.getNodes();
        ChoiceGenerator gen = new ChoiceGenerator(nodes.size(), 3);
        int numTriples = 0;
        while ((choice = gen.next()) != null) {
            List<Node> triple = SearchGraphUtils.asList(choice, nodes);
            Node x = triple.get(0);
            Node y = triple.get(1);
            Node z = triple.get(2);
            if (!graph.isAdjacentTo(x, y) || !graph.isAdjacentTo(y, z) || !graph.isAdjacentTo(x, z)) continue;
            ++numTriples;
        }
        this.logger.log("graph", "\nReturning this graph: " + graph);
        if (minGraph != null) {
            return minGraph;
        }
        Graph lastGraph = (Graph)graphs.get(graphs.size() - 1);
        int _min = lastGraph.getNumEdges();
        Graph _minGraph = lastGraph;
        if (_min == 0) {
            _minGraph = lastGraph;
        } else {
            for (int i = graphs.size() - 2; i >= 0; --i) {
                Graph _graph = (Graph)graphs.get(i);
                if (!((Object)lastGraph).equals(_graph)) continue;
                for (int j = i; j < graphs.size(); ++j) {
                    Graph __graph = (Graph)graphs.get(j);
                    if (__graph.getNumEdges() >= _min) continue;
                    _min = __graph.getNumEdges();
                    _minGraph = __graph;
                }
            }
        }
        return _minGraph;
    }

    private void addChangedEdges(Graph graph, List<Edge> changedEdges, Edge edge) {
        if (changedEdges.contains(edge)) {
            changedEdges.add(edge);
        }
        this.addAdjacentEdges(graph, changedEdges, edge);
    }

    private void addAdjacentEdges(Graph graph, List<Edge> changedEdges, Edge edge) {
        Edge _edge;
        Node node1 = graph.getNode(((Object)edge.getNode1()).toString());
        Node node2 = graph.getNode(((Object)edge.getNode2()).toString());
        for (Node node : graph.getAdjacentNodes(node1)) {
            _edge = graph.getEdge(node, node1);
            if (changedEdges.contains(edge) || _edge.pointsTowards(node)) continue;
            changedEdges.add(_edge);
        }
        for (Node node : graph.getAdjacentNodes(node2)) {
            _edge = graph.getEdge(node, node2);
            if (changedEdges.contains(edge) || _edge.pointsTowards(node)) continue;
            changedEdges.add(_edge);
        }
    }

    private boolean isCorrelationUnfaithful(IndependenceTest test, Graph graph, Node x, Node y, List<Node> sepsetX) {
        boolean correlationUnfaithful = false;
        if (sepsetX != null) {
            for (Node z : sepsetX) {
                double rxz;
                double ryz;
                if (!graph.isAdjacentTo(x, y) || !graph.isAdjacentTo(y, z) || !graph.isAdjacentTo(x, z)) continue;
                DataSet data = (DataSet)test.getData();
                DoubleMatrix2D _data = data.getDoubleData();
                int datax = data.getColumn(data.getVariable(x.getName()));
                int datay = data.getColumn(data.getVariable(y.getName()));
                int dataz = data.getColumn(data.getVariable(z.getName()));
                DoubleMatrix1D xData = _data.viewColumn(datax);
                DoubleMatrix1D yData = _data.viewColumn(datay);
                DoubleMatrix1D zData = _data.viewColumn(dataz);
                double rxy = StatUtils.correlation(xData.toArray(), yData.toArray());
                if (!(Math.abs(rxy - (ryz = StatUtils.correlation(yData.toArray(), zData.toArray())) * (rxz = StatUtils.correlation(xData.toArray(), zData.toArray()))) < this.getUnfathfulThreshold())) continue;
                correlationUnfaithful = true;
            }
        }
        return correlationUnfaithful;
    }

    private void printStuff(IndependenceTest test, Graph graph) {
        for (Edge edge : this.trueGraph.getEdges()) {
            Node y;
            Node _x = edge.getNode1();
            Node _y = edge.getNode2();
            Node x = graph.getNode(_x.getName());
            if (graph.isAdjacentTo(x, y = graph.getNode(_y.getName()))) continue;
            if (graph.getEdge(y, x) != null) {
                System.out.println("Bloody murder!");
            }
            System.out.println("False negative: " + edge);
            List<Node> commonAdj = this.trueGraph.getAdjacentNodes(_x);
            commonAdj.retainAll(this.trueGraph.getAdjacentNodes(_y));
            StringBuilder buf = new StringBuilder();
            for (Node adj : commonAdj) {
                Node _adj = this.trueGraph.getNode(adj.getName());
                if (graph.isDefCollider(x, adj, y)) {
                    buf.append("collider ");
                } else {
                    buf.append("noncollider ");
                }
                if (this.trueGraph.isDefCollider(_x, _adj, _y)) {
                    buf.append(" [collider] ");
                } else {
                    buf.append(" [noncollider] ");
                }
                if (!graph.isAmbiguousTriple(x, adj, y)) continue;
                buf.append(" (ambiguous) ");
            }
            List<Node> sepsetX = this.pathBlockingSet(test, graph, x, y);
            List<Node> sepsetY = this.pathBlockingSet(test, graph, y, x);
            LinkedList<Node> _sepsetX = null;
            if (sepsetX != null) {
                _sepsetX = new LinkedList<Node>();
                for (Node node : sepsetX) {
                    _sepsetX.add(this.trueGraph.getNode(node.getName()));
                }
            }
            LinkedList<Node> _sepsetY = null;
            if (sepsetY != null) {
                _sepsetY = new LinkedList<Node>();
                for (Node node : sepsetY) {
                    _sepsetY.add(this.trueGraph.getNode(node.getName()));
                }
            }
            LinkedHashSet<Node> estNodes = new LinkedHashSet<Node>();
            LinkedHashSet<Node> trueNodes = new LinkedHashSet<Node>();
            if (sepsetX != null) {
                estNodes.addAll(sepsetX);
                boolean indep1 = test.isIndependent(x, y, sepsetX);
                double p1 = test.getPValue();
                System.out.println("   est B(x, y) = " + sepsetX + " indep1 = " + indep1 + " p1 = " + p1);
                for (Node node : sepsetX) {
                    trueNodes.add(this.trueGraph.getNode(node.getName()));
                }
            }
            if (sepsetY != null) {
                estNodes.addAll(sepsetY);
                boolean indep2 = test.isIndependent(x, y, sepsetY);
                double p2 = test.getPValue();
                System.out.println("   est B(y, x) = " + sepsetY + " indep1 = " + indep2 + " p1 = " + p2);
                for (Node node : sepsetY) {
                    trueNodes.add(this.trueGraph.getNode(node.getName()));
                }
            }
            estNodes.add(x);
            estNodes.add(y);
            LinkedList<Node> estNodesList = new LinkedList<Node>(estNodes);
            Graph subGraph = graph.subgraph(estNodesList);
            System.out.println("estimated nodes: " + estNodesList);
            System.out.println("Estimated subgraph: " + subGraph);
            trueNodes.add(_x);
            trueNodes.add(_y);
            LinkedList<Node> trueNodesList = new LinkedList<Node>(trueNodes);
            Graph _subGraph = this.trueGraph.subgraph(trueNodesList);
            System.out.println("true nodes: " + trueNodesList);
            System.out.println("True subgraph: " + _subGraph);
            SemPm semPm = new SemPm(this.trueGraph);
            SemEstimator estimator = new SemEstimator((DataSet)test.getData(), semPm);
            estimator.estimate();
            SemIm estIm = estimator.getEstimatedSem();
            if (_sepsetX != null) {
                List<List<Node>> dConnectingPathsX = GraphUtils.dConnectingPaths(this.trueGraph, _x, _y, _sepsetX);
                System.out.println("D connecting paths conditioning on _sepsetX:");
                for (List<Node> path : dConnectingPathsX) {
                    System.out.println(GraphUtils.pathString(this.trueGraph, path, _sepsetX));
                }
                System.out.println("Sum of paths = " + this.sumOfPaths(dConnectingPathsX, estIm));
            }
            if (_sepsetY == null) continue;
            List<List<Node>> dConnectingPathsY = GraphUtils.dConnectingPaths(this.trueGraph, _x, _y, _sepsetY);
            System.out.println("D connecting paths conditioning on _sepsetY:");
            for (List<Node> path : dConnectingPathsY) {
                System.out.println(GraphUtils.pathString(this.trueGraph, path, _sepsetY));
            }
            System.out.println("Sum of paths = " + this.sumOfPaths(dConnectingPathsY, estIm));
        }
    }

    private double sumOfPaths(List<List<Node>> paths, SemIm semIm) {
        SemGraph semGraph = semIm.getSemPm().getGraph();
        double sum = 0.0;
        for (List<Node> path : paths) {
            double product = this.productOfCoefs(semIm, path);
            sum += product;
        }
        return sum;
    }

    private double productOfCoefs(SemIm semIm, List<Node> path) {
        SemGraph semGraph = semIm.getSemPm().getGraph();
        double product = 1.0;
        for (int i = 0; i < path.size() - 1; ++i) {
            Node y;
            Node x = semGraph.getNode(path.get(i).getName());
            double coef = semIm.getEdgeCoef(x, y = semGraph.getNode(path.get(i + 1).getName()));
            if (Double.isNaN(coef)) {
                coef = semIm.getEdgeCoef(y, x);
            }
            if (Double.isNaN(coef)) {
                coef = 0.0;
            }
            product *= coef;
        }
        return product;
    }

    private double[] coefsAlongPath(SemIm semIm, List<Node> path) {
        SemGraph semGraph = semIm.getSemPm().getGraph();
        double[] coefs = new double[path.size() - 1];
        for (int i = 0; i < path.size() - 1; ++i) {
            Node y;
            Node x = semGraph.getNode(path.get(i).getName());
            double coef = semIm.getEdgeCoef(x, y = semGraph.getNode(path.get(i + 1).getName()));
            if (Double.isNaN(coef)) {
                coef = semIm.getEdgeCoef(y, x);
            }
            if (Double.isNaN(coef)) {
                coef = 0.0;
            }
            coefs[i] = coef;
        }
        return coefs;
    }

    private List<Node> pathBlockingSet(IndependenceTest test, Graph graph, Node x, Node y) {
        int[] choice;
        List<Node> commonAdjacents = graph.getAdjacentNodes(x);
        commonAdjacents.retainAll(graph.getAdjacentNodes(y));
        DepthChoiceGenerator generator = new DepthChoiceGenerator(commonAdjacents.size(), commonAdjacents.size());
        while ((choice = generator.next()) != null) {
            List<Node> excludes = GraphUtils.asList(choice, commonAdjacents);
            List<Node> sepset = this.pathBlockingSetExcluding(graph, x, y, excludes);
            if (sepset == null || !test.isIndependent(x, y, sepset)) continue;
            return sepset;
        }
        return null;
    }

    private Graph markovBlanketGraph(Node node, Graph graph) {
        EdgeListGraph mbGraph = new EdgeListGraph();
        mbGraph.addNode(node);
        for (Node adj : graph.getAdjacentNodes(node)) {
            if (!mbGraph.containsNode(adj)) {
                mbGraph.addNode(adj);
            }
            mbGraph.addEdge(graph.getEdge(node, adj));
            for (Node parent : graph.getParents(adj)) {
                if (parent == node) continue;
                if (!mbGraph.containsNode(parent)) {
                    mbGraph.addNode(parent);
                }
                mbGraph.addEdge(graph.getEdge(adj, parent));
            }
        }
        return mbGraph;
    }

    private List<Node> pathBlockingSet2(Graph graph, Node x, Node y) {
        List<Node> commonAdjacents = graph.getAdjacentNodes(x);
        commonAdjacents.retainAll(graph.getAdjacentNodes(y));
        LinkedList<Node> excludes = new LinkedList<Node>();
        for (Node adj : commonAdjacents) {
            if (graph.isDefCollider(x, adj, y)) {
                excludes.add(adj);
                continue;
            }
            if (graph.isDefNoncollider(x, adj, y)) continue;
            return null;
        }
        return this.pathBlockingSetExcluding(graph, x, y, excludes);
    }

    private List<Node> pathBlockingSetExcluding(Graph graph, Node x, Node y, List<Node> excludes) {
        LinkedList<Node> condSet = new LinkedList<Node>();
        HashSet<Node> allExcludes = new HashSet<Node>();
        for (Node exclude : excludes) {
            List<Node> list = graph.getDescendants(Collections.singletonList(exclude));
            allExcludes.addAll(list);
        }
        for (Node b : graph.getAdjacentNodes(x)) {
            if (b == y || allExcludes.contains(b)) continue;
            condSet.add(b);
            if (this.getParents(graph, x).contains(b)) continue;
            for (Node parent : this.getParents(graph, b)) {
                if (parent == x || parent == y || condSet.contains(parent)) continue;
                condSet.add(parent);
            }
        }
        for (Node parent : this.getParents(graph, y)) {
            if (parent == x || condSet.contains(parent)) continue;
            condSet.add(parent);
        }
        return condSet;
    }

    private List<Node> getParents(Graph graph, Node node) {
        List<Node> adj = graph.getAdjacentNodes(node);
        ArrayList<Node> parents = new ArrayList<Node>();
        for (Node _node : adj) {
            Edge edge = graph.getEdge(node, _node);
            if (edge.getProximalEndpoint(node) != Endpoint.ARROW) continue;
            parents.add(_node);
        }
        return parents;
    }

    private Graph orientCpc(Graph graph, Knowledge knowledge, int depth) {
        graph = GraphUtils.undirectedGraph(graph);
        SearchGraphUtils.pcOrientbk(knowledge, graph, graph.getNodes());
        graph = this.orientUnshieldedTriples(graph, knowledge, this.getIndependenceTest(), depth);
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(true);
        meekRules.setKnowledge(knowledge);
        meekRules.orientImplied(graph);
        return graph;
    }

    private Graph orientPc(Graph graph, Knowledge knowledge, int depth) {
        graph = GraphUtils.nondirectedGraph(graph);
        SearchGraphUtils.pcOrientbk(knowledge, graph, graph.getNodes());
        SearchGraphUtils.orientCollidersUsingSepsets(this.sepsets, knowledge, graph);
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(true);
        meekRules.setKnowledge(knowledge);
        meekRules.orientImplied(graph);
        return graph;
    }

    private Graph orientUnshieldedTriples(Graph graph, Knowledge knowledge, IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        for (Node y : graph.getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                SearchGraphUtils.CpcTripleType type = SearchGraphUtils.getCpcTripleType(x, y, z, test, depth, graph);
                if (type == SearchGraphUtils.CpcTripleType.COLLIDER) {
                    if (!this.colliderAllowed(x, y, z, knowledge)) continue;
                    graph.setEndpoint(y, x, Endpoint.TAIL);
                    graph.setEndpoint(y, z, Endpoint.TAIL);
                    graph.setEndpoint(x, y, Endpoint.ARROW);
                    graph.setEndpoint(z, y, Endpoint.ARROW);
                    TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
                    continue;
                }
                if (type != SearchGraphUtils.CpcTripleType.AMBIGUOUS) continue;
                Triple triple = new Triple(x, y, z);
                graph.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
        return graph;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return Icpc.isArrowpointAllowed1(x, y, knowledge) && Icpc.isArrowpointAllowed1(z, y, knowledge);
    }

    private static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(((Object)to).toString(), ((Object)from).toString()) && !knowledge.edgeForbidden(((Object)from).toString(), ((Object)to).toString());
    }

    private int totAdjErr(Graph pattern, Graph result) {
        GraphUtils.GraphComparison comparison = GraphUtils.getGraphComparison(pattern, result);
        int value = comparison.getEdgesAdded().size() + comparison.getEdgesRemoved().size();
        return value;
    }

    private int adjFp(Graph pattern, Graph result) {
        GraphUtils.GraphComparison comparison = GraphUtils.getGraphComparison(pattern, result);
        int value = comparison.getEdgesAdded().size();
        return value;
    }

    private int adjFn(Graph pattern, Graph result) {
        GraphUtils.GraphComparison comparison = GraphUtils.getGraphComparison(pattern, result);
        int value = comparison.getEdgesRemoved().size();
        return value;
    }

    private void collectSemidirectedDescendantsVisit(Graph graph, Node node, Set<Node> descendants) {
        descendants.add(node);
        List<Node> children = graph.getChildren(node);
        if (!children.isEmpty()) {
            Iterator<Node> i$ = children.iterator();
            while (i$.hasNext()) {
                Node aChildren;
                Node child = aChildren = i$.next();
                this.doSemidirectedChildClosureVisit(graph, child, descendants);
            }
        }
    }

    private void doSemidirectedChildClosureVisit(Graph graph, Node node, Set<Node> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            for (Edge edge1 : graph.getEdges(node)) {
                Node sub = Edges.traverseUndirected(node, edge1);
                if (sub == null || !edge1.pointsTowards(sub) && !Edges.isUndirectedEdge(edge1)) continue;
                System.out.println(edge1);
                this.doSemidirectedChildClosureVisit(graph, sub, closure);
            }
        }
    }

    public double getUnfathfulThreshold() {
        return this.unfathfulThreshold;
    }

    public void setUnfathfulThreshold(double unfathfulThreshold) {
        this.unfathfulThreshold = unfathfulThreshold;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        if (maxIterations < 0) {
            throw new IllegalArgumentException("Number of graph correction iterations must be >= 0: " + maxIterations);
        }
        this.maxIterations = maxIterations;
    }
}

