/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class IndTestFisherZ
implements IndependenceTest {
    private final CovarianceMatrix covMatrix;
    private final DoubleMatrix2D _covMatrix;
    private List<Node> variables;
    private double alpha;
    private double fisherZ;
    private IndTestFisherZGeneralizedInverse deterministicTest;
    private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private DataSet dataSet;
    private double pValue = Double.NaN;

    public IndTestFisherZ(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.covMatrix = new CovarianceMatrix(dataSet);
        this._covMatrix = this.covMatrix.getMatrix();
        List<Node> nodes = this.covMatrix.getVariables();
        this.variables = Collections.unmodifiableList(nodes);
        this.setAlpha(alpha);
        this.deterministicTest = new IndTestFisherZGeneralizedInverse(dataSet, alpha);
        this.dataSet = dataSet;
    }

    public IndTestFisherZ(DoubleMatrix2D data, List<Node> variables, double alpha) {
        ColtDataSet dataSet = ColtDataSet.makeContinuousData(variables, data);
        this.covMatrix = new CovarianceMatrix(dataSet);
        this._covMatrix = this.covMatrix.getMatrix();
        this.variables = Collections.unmodifiableList(variables);
        this.setAlpha(alpha);
        this.deterministicTest = new IndTestFisherZGeneralizedInverse(dataSet, alpha);
    }

    public IndTestFisherZ(CovarianceMatrix corrMatrix, double alpha) {
        this.covMatrix = corrMatrix;
        this._covMatrix = corrMatrix.getMatrix();
        this.variables = Collections.unmodifiableList(corrMatrix.getVariables());
        this.setAlpha(alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.variables.contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        int[] indices = new int[vars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.variables.indexOf(vars.get(i));
        }
        CovarianceMatrix newCovMatrix = this.covMatrix.getSubmatrix(indices);
        double alphaNew = this.getAlpha();
        return new IndTestFisherZ(newCovMatrix, alphaNew);
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        boolean independent;
        DoubleMatrix2D submatrix = DataUtils.subMatrix(this._covMatrix, this.covMatrix.getVariables(), x, y, z);
        double r = 0.0;
        try {
            r = StatUtils.partialCorrelation(submatrix);
            if (Double.isNaN(r) || r < -1.0 || r > 1.0) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            int[] choice;
            DepthChoiceGenerator gen = new DepthChoiceGenerator(z.size(), z.size());
            while ((choice = gen.next()) != null) {
                try {
                    ArrayList<Node> z2 = new ArrayList<Node>(z);
                    z2.removeAll(SearchGraphUtils.asList(choice, z));
                    submatrix = DataUtils.subMatrix(this.covMatrix, x, y, z2);
                    r = StatUtils.partialCorrelation(submatrix);
                }
                catch (Exception e2) {
                    continue;
                }
                if (Double.isNaN(r) || r < -1.0 || r > 1.0) continue;
            }
        }
        if (Double.isNaN(r)) {
            int[] _z = new int[z.size()];
            return true;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        if (r < -1.0) {
            r = -1.0;
        }
        this.fisherZ = Math.sqrt((double)(this.sampleSize() - z.size()) - 3.0) * 0.5 * (Math.log(1.0 + r) - Math.log(1.0 - r));
        if (Double.isNaN(this.fisherZ)) {
            throw new IllegalArgumentException("The Fisher's Z score for independence fact " + x + " _||_ " + y + " | " + z + " is undefined. r = " + r);
        }
        boolean bl = independent = this.getPValue() > this.alpha;
        if (independent) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        }
        return independent;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        return this.isIndependent(x, y, Arrays.asList(z));
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public double getPValue() {
        if (!Double.isNaN(this.pValue)) {
            return Double.NaN;
        }
        return 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, Math.abs(this.fisherZ)));
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        int[] parents = new int[z.size()];
        for (int j = 0; j < parents.length; ++j) {
            parents[j] = this.covMatrix.getVariables().indexOf(z.get(j));
        }
        int i = this.covMatrix.getVariables().indexOf(x);
        DoubleMatrix2D matrix2D = this.covMatrix.getMatrix();
        double variance = matrix2D.get(i, i);
        if (parents.length > 0) {
            DoubleMatrix2D inverse;
            DoubleMatrix2D Czz = matrix2D.viewSelection(parents, parents);
            try {
                inverse = new Algebra().inverse(Czz);
            }
            catch (Exception e) {
                return true;
            }
            DoubleMatrix1D Cyz = matrix2D.viewColumn(i);
            Cyz = Cyz.viewSelection(parents);
            DoubleMatrix1D b = new Algebra().mult(inverse, Cyz);
            variance -= new Algebra().mult(Cyz, b);
        }
        return variance < 0.01;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    public void shuffleVariables() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.variables);
        Collections.shuffle(nodes);
        this.variables = Collections.unmodifiableList(nodes);
    }

    public String toString() {
        return "Fisher's Z, alpha = " + nf.format(this.getAlpha());
    }

    private double cutoffGaussian(double alpha) {
        double upperTail = 1.0 - alpha / 2.0;
        double epsilon = 1.0E-14;
        double lowerBound = -1.0;
        double upperBound = 0.0;
        while (ProbUtils.normalCdf(upperBound) < upperTail) {
            lowerBound += 1.0;
            upperBound += 1.0;
        }
        while (upperBound >= lowerBound + epsilon) {
            double midPoint = lowerBound + (upperBound - lowerBound) / 2.0;
            if (ProbUtils.normalCdf(midPoint) <= upperTail) {
                lowerBound = midPoint;
                continue;
            }
            upperBound = midPoint;
        }
        return lowerBound;
    }

    private int sampleSize() {
        return this.covMatrix().getSampleSize();
    }

    private CovarianceMatrix covMatrix() {
        return this.covMatrix;
    }
}

