/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ShortTriangularMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class IndTestFisherZShortTriangular
implements IndependenceTest {
    private final ShortTriangularMatrix covMatrix;
    private List<Node> variables;
    private double alpha;
    private double fisherZ;
    private IndTestFisherZGeneralizedInverse deterministicTest;
    private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private DataSet dataSet;
    private double pValue = Double.NaN;

    public IndTestFisherZShortTriangular(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.covMatrix = new ShortTriangularMatrix(dataSet.getNumColumns());
        this.covMatrix.becomeCorrelationMatrix(dataSet);
        this.variables = dataSet.getVariables();
        this.setAlpha(alpha);
        this.deterministicTest = new IndTestFisherZGeneralizedInverse(dataSet, alpha);
        this.dataSet = dataSet;
    }

    public IndTestFisherZShortTriangular(DoubleMatrix2D data, List<Node> variables, double alpha) {
        ColtDataSet dataSet = ColtDataSet.makeContinuousData(variables, data);
        this.covMatrix = new ShortTriangularMatrix(dataSet.getNumColumns());
        this.covMatrix.becomeCorrelationMatrix(dataSet);
        this.variables = dataSet.getVariables();
        this.setAlpha(alpha);
        this.deterministicTest = new IndTestFisherZGeneralizedInverse(dataSet, alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        boolean independent;
        DoubleMatrix2D submatrix = this.subMatrix(x, y, z);
        double r = 0.0;
        try {
            r = StatUtils.partialCorrelation(submatrix);
            if (Double.isNaN(r) || r < -1.0 || r > 1.0) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            int[] choice;
            DepthChoiceGenerator gen = new DepthChoiceGenerator(z.size(), z.size());
            while ((choice = gen.next()) != null) {
                try {
                    ArrayList<Node> z2 = new ArrayList<Node>(z);
                    z2.removeAll(SearchGraphUtils.asList(choice, z));
                    submatrix = this.subMatrix(x, y, z2);
                    r = StatUtils.partialCorrelation(submatrix);
                }
                catch (Exception e2) {
                    continue;
                }
                if (Double.isNaN(r) || r < -1.0 || r > 1.0) continue;
            }
        }
        if (Double.isNaN(r)) {
            int[] _z = new int[z.size()];
            return true;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        if (r < -1.0) {
            r = -1.0;
        }
        this.fisherZ = Math.sqrt((double)(this.sampleSize() - z.size()) - 3.0) * 0.5 * (Math.log(1.0 + r) - Math.log(1.0 - r));
        if (Double.isNaN(this.fisherZ)) {
            throw new IllegalArgumentException("The Fisher's Z score for independence fact " + x + " _||_ " + y + " | " + z + " is undefined. r = " + r);
        }
        boolean bl = independent = this.getPValue() > this.alpha;
        if (independent) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        } else {
            TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(x, y, z, this.getPValue()));
        }
        return independent;
    }

    private DoubleMatrix2D subMatrix(Node x, Node y, List<Node> z) {
        int dim = z.size() + 2;
        int[] indices = new int[dim];
        indices[0] = this.variables.indexOf(x);
        indices[1] = this.variables.indexOf(y);
        for (int k = 0; k < z.size(); ++k) {
            indices[k + 2] = this.variables.indexOf(z.get(k));
        }
        DenseDoubleMatrix2D submatrix = new DenseDoubleMatrix2D(dim, dim);
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                int i1 = indices[i];
                int i2 = indices[j];
                submatrix.set(i, j, this.covMatrix.getDouble(i1, i2));
            }
        }
        return submatrix;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        return this.isIndependent(x, y, Arrays.asList(z));
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public double getPValue() {
        if (!Double.isNaN(this.pValue)) {
            return Double.NaN;
        }
        return 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, Math.abs(this.fisherZ)));
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    public void shuffleVariables() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.variables);
        Collections.shuffle(nodes);
        this.variables = Collections.unmodifiableList(nodes);
    }

    public String toString() {
        return "Fisher's Z, alpha = " + nf.format(this.getAlpha());
    }

    private double cutoffGaussian(double alpha) {
        double upperTail = 1.0 - alpha / 2.0;
        double epsilon = 1.0E-14;
        double lowerBound = -1.0;
        double upperBound = 0.0;
        while (ProbUtils.normalCdf(upperBound) < upperTail) {
            lowerBound += 1.0;
            upperBound += 1.0;
        }
        while (upperBound >= lowerBound + epsilon) {
            double midPoint = lowerBound + (upperBound - lowerBound) / 2.0;
            if (ProbUtils.normalCdf(midPoint) <= upperTail) {
                lowerBound = midPoint;
                continue;
            }
            upperBound = midPoint;
        }
        return lowerBound;
    }

    private int sampleSize() {
        return this.dataSet.getNumRows();
    }
}

