/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IndTestLogisticRegression
implements IndependenceTest {
    private DataSet dataSet;
    private double alpha;

    public IndTestLogisticRegression(DataSet dataSet, double alpha) {
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            DiscreteVariable discreteVariable;
            Node variable = dataSet.getVariable(j);
            if (variable instanceof ContinuousVariable || (discreteVariable = (DiscreteVariable)variable).getNumCategories() == 2) continue;
            throw new IllegalArgumentException("Only continuous or binary variables permitted.");
        }
        this.dataSet = dataSet;
        this.alpha = alpha;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        DiscreteVariable binaryTarget = x instanceof DiscreteVariable && ((DiscreteVariable)x).getNumCategories() == 2 ? (DiscreteVariable)x : (y instanceof DiscreteVariable && ((DiscreteVariable)y).getNumCategories() == 2 ? (DiscreteVariable)y : null);
        if (binaryTarget == x) {
            return this.isIndependentLogisticRegression(x, y, z);
        }
        if (binaryTarget == y) {
            return this.isIndependentLogisticRegression(y, x, z);
        }
        return this.isIndependentRegression(x, y, z);
    }

    private boolean isIndependentLogisticRegression(Node x, Node y, List<Node> z) {
        boolean indep;
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Node> regressors = new ArrayList<Node>();
        regressors.add(this.dataSet.getVariable(y.getName()));
        for (Node zVar : z) {
            regressors.add(this.dataSet.getVariable(zVar.getName()));
        }
        RegressionDataset regression = new RegressionDataset(this.dataSet);
        RegressionResult result = null;
        try {
            result = regression.regress(x, regressors);
        }
        catch (Exception e) {
            return false;
        }
        double p = result.getP()[1];
        boolean bl = indep = p > this.alpha;
        if (indep) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, p));
        }
        return indep;
    }

    private boolean isIndependentRegression(Node x, Node y, List<Node> z) {
        boolean indep;
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Node> regressors = new ArrayList<Node>();
        regressors.add(this.dataSet.getVariable(y.getName()));
        for (Node zVar : z) {
            regressors.add(this.dataSet.getVariable(zVar.getName()));
        }
        RegressionDataset regression = new RegressionDataset(this.dataSet);
        RegressionResult result = null;
        try {
            result = regression.regress(x, regressors);
        }
        catch (Exception e) {
            return false;
        }
        double p = result.getP()[1];
        boolean bl = indep = p > this.alpha;
        if (indep) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, p));
        } else {
            TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(x, y, z, p));
        }
        return indep;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public double getPValue() {
        return 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return 0.0;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public DataSet getData() {
        return null;
    }
}

