/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.IndexedMatrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.ProbUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class IndTestTimeSeries
implements IndependenceTest {
    private final List<Node> vars;
    private final DoubleMatrix2D data;
    private final int numTimeSteps;
    private final int numVars;
    private double alpha;
    private int numReps;
    private int numLags;
    private transient double[][] sigmaU;
    private transient double[][] omega;
    private transient IndexedMatrix indexedCorr;
    private boolean stationary;
    private double chiSquare;

    public IndTestTimeSeries(DoubleMatrix2D data, List<Node> vars) {
        if (data == null) {
            throw new NullPointerException("Data must not be null.");
        }
        if (vars == null) {
            throw new NullPointerException("Variables must not be a null list.");
        }
        for (int i = 0; i < vars.size(); ++i) {
            if (vars.get(i) != null) continue;
            throw new NullPointerException("Variable at index " + i + " must not be null.");
        }
        this.data = data;
        this.numTimeSteps = this.data.rows();
        this.numVars = this.data.columns();
        this.vars = Collections.unmodifiableList(vars);
        this.setNumLags(1);
        this.setAlpha(0.05);
    }

    public IndependenceTest indTestSubset(List vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int[] indices = this.createIndexArray(z, x, y);
        return this.isIndependent(indices);
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    public boolean isIndependent(int[] indices) {
        double chiSquare;
        this.setIndices(indices);
        if (indices.length > 6) {
            return false;
        }
        double temp = Math.pow(this.tau(), 2.0);
        double numerator = (double)this.getNumReps() * temp;
        double[][] gradTau = this.gradTau();
        double[][] gradTauPrime = MatrixUtils.transpose(gradTau);
        double[][] prod1 = MatrixUtils.product(gradTauPrime, this.omega());
        double[][] prod2 = MatrixUtils.product(prod1, gradTau);
        assert (MatrixUtils.hasDimensions(prod2, 1, 1));
        double denominator = prod2[0][0];
        System.out.println("ratio w/o T = " + temp / denominator);
        this.chiSquare = chiSquare = numerator / denominator;
        double pValue = 1.0 - ProbUtils.chisqCdf(chiSquare, 1.0);
        return pValue > this.alpha;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable : variables) {
            variableNames.add(variable.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x1) {
        throw new UnsupportedOperationException("This independence test does not test whether Z determines X for list Z of variable and variable X.");
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<Node> getVariables() {
        return this.vars;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be in [0.0, 1.0]: " + alpha);
        }
        this.alpha = alpha;
    }

    public int getNumReps() {
        return this.numReps;
    }

    public int getNumLags() {
        return this.numLags;
    }

    public void setNumLags(int numLags) {
        if (numLags < 1 || numLags > this.getNumTimeSteps() - 1) {
            throw new IllegalArgumentException("numLags must be in [1, numTimePoints - 1]: " + numLags);
        }
        this.numLags = numLags;
        this.numReps = this.getNumTimeSteps() - numLags;
        this.reset();
    }

    public void setDataView(int numReps, int numLags) {
        if (numLags < 1) {
            throw new IllegalArgumentException("numLags must be > 0.");
        }
        if (numLags + numReps > this.getNumTimeSteps()) {
            throw new IllegalArgumentException("NumLags + numReps must be <= numTimeSteps.");
        }
        this.numLags = numLags;
        this.numReps = numReps;
        this.reset();
    }

    public int getNumTimeSteps() {
        return this.numTimeSteps;
    }

    public boolean isStationary() {
        return this.stationary;
    }

    public void setStationary(boolean stationary) {
        this.stationary = stationary;
    }

    @Override
    public double getPValue() {
        return Double.NaN;
    }

    private void reset() {
        this.sigmaU = null;
        this.omega = null;
        this.indexedCorr = null;
    }

    private IndexedMatrix indexedCorr() {
        if (this.indexedCorr == null) {
            this.indexedCorr = new IndexedMatrix(this.sigmaU());
        }
        return this.indexedCorr;
    }

    private void setIndices(int[] indices) {
        this.indexedCorr().setIndices(indices);
    }

    private int[] getIndices() {
        return this.indexedCorr().getIndices();
    }

    private int[] createIndexArray(List<Node> z, Node x, Node y) {
        int[] indices = new int[z.size() + 2];
        indices[0] = this.getVariables().indexOf(x);
        indices[1] = this.getVariables().indexOf(y);
        for (int i = 0; i < z.size(); ++i) {
            indices[i + 2] = this.getVariables().indexOf(z.get(i));
        }
        for (int index : indices) {
            if (index >= 0) continue;
            throw new IllegalArgumentException("Some variable was no in the constructed list of vars.");
        }
        return indices;
    }

    private double[][] yPrime(int tIndex) {
        int transformedIndex = this.getNumTimeSteps() - this.getNumReps() + tIndex - 1;
        return this.data.viewPart(transformedIndex, 0, 1, this.data.columns()).toArray();
    }

    private double[][] xPrime(int t) {
        double[][] x = new double[1][this.getNumLags() * this.numVars];
        for (int i = 0; i < this.getNumLags(); ++i) {
            double[][] yPrime = this.yPrime(t - i - 1);
            System.arraycopy(yPrime[0], 0, x[0], i * this.numVars, this.numVars);
        }
        return x;
    }

    private double[][] piPrime() {
        double[][] ma = MatrixUtils.zeros(this.numVars, this.numVars * this.numLags);
        for (int t = 1; t <= this.getNumReps(); ++t) {
            double[][] summand = MatrixUtils.product(this.y(t), this.xPrime(t));
            ma = MatrixUtils.sum(ma, summand);
        }
        double[][] mb = MatrixUtils.zeros(this.numVars * this.numLags, this.numVars * this.numLags);
        for (int t = 1; t <= this.getNumReps(); ++t) {
            double[][] summand = MatrixUtils.product(this.x(t), this.xPrime(t));
            mb = MatrixUtils.sum(mb, summand);
        }
        double[][] mbinv = MatrixUtils.inverse(mb);
        double[][] prod = MatrixUtils.product(ma, mbinv);
        assert (MatrixUtils.hasDimensions(prod, this.numVars, this.numVars * this.numLags));
        return prod;
    }

    private double[][] y(int t) {
        return MatrixUtils.transpose(this.yPrime(t));
    }

    private double[][] x(int t) {
        return MatrixUtils.transpose(this.xPrime(t));
    }

    private double[][] u(double[][] piPrime, int t) {
        return MatrixUtils.subtract(this.y(t), MatrixUtils.product(piPrime, this.x(t)));
    }

    private double[][] sigmaU() {
        if (this.sigmaU == null) {
            return this.isStationary() ? this.sigmaUStationary() : this.sigmaUNonStationary();
        }
        return this.sigmaU;
    }

    private double[][] sigmaUStationary() {
        double[][] piPrime = this.piPrime();
        double[][] sum = MatrixUtils.zeros(this.numVars, this.numVars);
        for (int t = 1; t <= this.getNumReps(); ++t) {
            double[][] u = this.u(piPrime, t);
            double[][] uPrime = MatrixUtils.transpose(u);
            double[][] product = MatrixUtils.product(u, uPrime);
            sum = MatrixUtils.sum(sum, product);
        }
        return MatrixUtils.scalarProduct(1.0 / (double)this.getNumReps(), sum);
    }

    private double[][] dkPlus() {
        double[][] dk = MatrixUtils.vechToVecLeft(this.numVars);
        double[][] dkPrime = MatrixUtils.transpose(dk);
        double[][] ma = MatrixUtils.product(dkPrime, dk);
        double[][] mainv = MatrixUtils.inverse(ma);
        return MatrixUtils.product(mainv, dkPrime);
    }

    private double[][] omega() {
        if (this.omega == null) {
            double[][] dkPlus = this.dkPlus();
            double[][] dkPlusPrime = MatrixUtils.transpose(dkPlus);
            double[][] prod1 = MatrixUtils.directProduct(this.sigmaU(), this.sigmaU());
            double[][] prod2 = MatrixUtils.scalarProduct(2.0, dkPlus);
            double[][] prod3 = MatrixUtils.product(prod2, prod1);
            this.omega = MatrixUtils.product(prod3, dkPlusPrime);
        }
        return this.omega;
    }

    private double[][] sigmaUNonStationary() {
        double[][] piPrime = this.piPrime();
        double[][] sum = MatrixUtils.zeros(this.numVars, this.numVars);
        for (int t = 1; t <= this.getNumReps(); ++t) {
            double[][] u = this.u(piPrime, t);
            double[][] uPrime = MatrixUtils.transpose(u);
            double[][] product = MatrixUtils.product(u, uPrime);
            sum = MatrixUtils.sum(sum, product);
        }
        return MatrixUtils.scalarProduct(1.0 / (double)this.getNumReps(), sum);
    }

    double chiSquareCutoff() {
        double d = 0.0;
        block0: for (int mantissa = 0; mantissa >= -15; --mantissa) {
            double increment = Math.pow(10.0, mantissa);
            while (d < 1000.0) {
                if (!(ProbUtils.chisqCdf(d += increment, 1.0) > 1.0 - this.getAlpha())) continue;
                d -= increment;
                continue block0;
            }
        }
        return d;
    }

    private double tau() {
        int numCondVars = this.getIndices().length - 2;
        switch (numCondVars) {
            case 0: {
                return this.tau0();
            }
            case 1: {
                return this.tau1();
            }
            case 2: {
                return this.tau2();
            }
            case 3: {
                return this.tau3();
            }
            case 4: {
                return this.tau4();
            }
        }
        throw new IllegalStateException("Only taus for up to four conditioning variables were hardcoded: " + numCondVars);
    }

    private double tau0() {
        return this.s(1, 2);
    }

    private double tau1() {
        return -this.s(1, 3) * this.s(2, 3) + this.s(1, 2) * this.s(3, 3);
    }

    private double tau2() {
        return -this.s(1, 4) * this.s(2, 4) * this.s(3, 3) + this.s(1, 4) * this.s(2, 3) * this.s(3, 4) + this.s(1, 3) * this.s(2, 4) * this.s(3, 4) - this.s(1, 2) * this.s(3, 4) * this.s(3, 4) - this.s(1, 3) * this.s(2, 3) * this.s(4, 4) + this.s(1, 2) * this.s(3, 3) * this.s(4, 4);
    }

    private double tau3() {
        return this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(3, 4) - this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(3, 5) - this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(3, 5) + this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(3, 5) - this.s(1, 5) * this.s(2, 5) * this.s(3, 3) * this.s(4, 4) + this.s(1, 5) * this.s(2, 3) * this.s(3, 5) * this.s(4, 4) + this.s(1, 3) * this.s(2, 5) * this.s(3, 5) * this.s(4, 4) - this.s(1, 2) * this.s(3, 5) * this.s(3, 5) * this.s(4, 4) + this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(4, 5) + this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(4, 5) - this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(4, 5) - this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(4, 5) - this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(4, 5) - this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(4, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) + this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 4) * this.s(2, 4) * this.s(3, 3) * this.s(5, 5) + this.s(1, 4) * this.s(2, 3) * this.s(3, 4) * this.s(5, 5) + this.s(1, 3) * this.s(2, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 2) * this.s(3, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 3) * this.s(2, 3) * this.s(4, 4) * this.s(5, 5) + this.s(1, 2) * this.s(3, 3) * this.s(4, 4) * this.s(5, 5);
    }

    private double tau4() {
        return this.s(1, 6) * this.s(2, 6) * this.s(3, 5) * this.s(3, 5) * this.s(4, 4) - this.s(1, 6) * this.s(2, 5) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) - this.s(1, 5) * this.s(2, 6) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) + this.s(1, 5) * this.s(2, 5) * this.s(3, 6) * this.s(3, 6) * this.s(4, 4) - 2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) + this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) + this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) + this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) - this.s(1, 5) * this.s(2, 4) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) - this.s(1, 4) * this.s(2, 5) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) + this.s(1, 6) * this.s(2, 6) * this.s(3, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 6) * this.s(2, 3) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) - this.s(1, 3) * this.s(2, 6) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) + this.s(1, 2) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) - this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) - this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) * this.s(4, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) - this.s(1, 6) * this.s(2, 5) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) - this.s(1, 5) * this.s(2, 6) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) + this.s(1, 6) * this.s(2, 3) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) + this.s(1, 3) * this.s(2, 6) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 5) * this.s(3, 3) * this.s(4, 6) * this.s(4, 6) - this.s(1, 5) * this.s(2, 3) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) - this.s(1, 3) * this.s(2, 5) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) + this.s(1, 2) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) + this.s(1, 6) * this.s(2, 6) * this.s(3, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 6) * this.s(2, 4) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) - this.s(1, 4) * this.s(2, 6) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) + this.s(1, 4) * this.s(2, 4) * this.s(3, 6) * this.s(3, 6) * this.s(5, 5) - this.s(1, 6) * this.s(2, 6) * this.s(3, 3) * this.s(4, 4) * this.s(5, 5) + this.s(1, 6) * this.s(2, 3) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) + this.s(1, 3) * this.s(2, 6) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) - this.s(1, 2) * this.s(3, 6) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) + this.s(1, 6) * this.s(2, 4) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) + this.s(1, 4) * this.s(2, 6) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) - this.s(1, 6) * this.s(2, 3) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) - this.s(1, 3) * this.s(2, 6) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) - this.s(1, 4) * this.s(2, 3) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) - this.s(1, 3) * this.s(2, 4) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) + this.s(1, 3) * this.s(2, 3) * this.s(4, 6) * this.s(4, 6) * this.s(5, 5) - this.s(1, 2) * this.s(3, 3) * this.s(4, 6) * this.s(4, 6) * this.s(5, 5) - this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) - this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) + this.s(1, 6) * this.s(2, 4) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) + this.s(1, 4) * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) - 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) * this.s(5, 6) + this.s(1, 6) * this.s(2, 5) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) + this.s(1, 5) * this.s(2, 6) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) - this.s(1, 6) * this.s(2, 3) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) - this.s(1, 3) * this.s(2, 6) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) - this.s(1, 5) * this.s(2, 3) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) - this.s(1, 3) * this.s(2, 5) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) - this.s(1, 6) * this.s(2, 4) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6) - this.s(1, 4) * this.s(2, 6) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6) + this.s(1, 6) * this.s(2, 3) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6) + this.s(1, 3) * this.s(2, 6) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) - this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) - 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(4, 6) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) * this.s(5, 6) + this.s(1, 4) * this.s(2, 4) * this.s(3, 3) * this.s(5, 6) * this.s(5, 6) - this.s(1, 4) * this.s(2, 3) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) - this.s(1, 3) * this.s(2, 4) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) + this.s(1, 2) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 3) * this.s(4, 4) * this.s(5, 6) * this.s(5, 6) - this.s(1, 2) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) * this.s(5, 6) + this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(3, 4) * this.s(6, 6) - this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) + this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(3, 5) * this.s(6, 6) - this.s(1, 5) * this.s(2, 5) * this.s(3, 3) * this.s(4, 4) * this.s(6, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) - this.s(1, 2) * this.s(3, 5) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6) - this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6) - this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) + this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(4, 5) * this.s(6, 6) - this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(4, 5) * this.s(6, 6) - this.s(1, 4) * this.s(2, 4) * this.s(3, 3) * this.s(5, 5) * this.s(6, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6) - this.s(1, 2) * this.s(3, 4) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 3) * this.s(4, 4) * this.s(5, 5) * this.s(6, 6) + this.s(1, 2) * this.s(3, 3) * this.s(4, 4) * this.s(5, 5) * this.s(6, 6);
    }

    private double[][] gradTau() {
        int numCondVars = this.getIndices().length - 2;
        switch (numCondVars) {
            case 0: {
                return this.convertGradTau(this.gradTau0());
            }
            case 1: {
                return this.convertGradTau(this.gradTau1());
            }
            case 2: {
                return this.convertGradTau(this.gradTau2());
            }
            case 3: {
                return this.convertGradTau(this.gradTau3());
            }
            case 4: {
                return this.convertGradTau(this.gradTau4());
            }
        }
        throw new IllegalStateException("Only gradients for up to four conditioning variables were hardcoded: " + numCondVars);
    }

    private double[][] convertGradTau(double[] basicGradTau) {
        double[][] m = MatrixUtils.invVech(basicGradTau);
        double[][] m2 = new double[this.numVars][this.numVars];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                m2[this.getIndices()[i]][this.getIndices()[j]] = m[i][j];
            }
        }
        return MatrixUtils.vech(m2);
    }

    private double[] gradTau0() {
        return new double[]{0.0, 1.0, 0.0};
    }

    private double[] gradTau1() {
        return new double[]{0.0, this.s(3, 3), -this.s(2, 3), 0.0, -this.s(1, 3), this.s(1, 2)};
    }

    private double[] gradTau2() {
        return new double[]{0.0, -this.s(3, 4) * this.s(3, 4) + this.s(3, 3) * this.s(4, 4), this.s(2, 4) * this.s(3, 4) - this.s(2, 3) * this.s(4, 4), -this.s(2, 4) * this.s(3, 3) + this.s(2, 3) * this.s(3, 4), 0.0, this.s(1, 4) * this.s(3, 4) - this.s(1, 3) * this.s(4, 4), -this.s(1, 4) * this.s(3, 3) + this.s(1, 3) * this.s(3, 4), -this.s(1, 4) * this.s(2, 4) + this.s(1, 2) * this.s(4, 4), this.s(1, 4) * this.s(2, 3) + this.s(1, 3) * this.s(2, 4) - 2.0 * this.s(1, 2) * this.s(3, 4), -this.s(1, 3) * this.s(2, 3) + this.s(1, 2) * this.s(3, 3)};
    }

    private double[] gradTau3() {
        return new double[]{0.0, -this.s(3, 5) * this.s(3, 5) * this.s(4, 4) + 2.0 * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) - this.s(3, 3) * this.s(4, 5) * this.s(4, 5) - this.s(3, 4) * this.s(3, 4) * this.s(5, 5) + this.s(3, 3) * this.s(4, 4) * this.s(5, 5), this.s(2, 5) * this.s(3, 5) * this.s(4, 4) - this.s(2, 5) * this.s(3, 4) * this.s(4, 5) - this.s(2, 4) * this.s(3, 5) * this.s(4, 5) + this.s(2, 3) * this.s(4, 5) * this.s(4, 5) + this.s(2, 4) * this.s(3, 4) * this.s(5, 5) - this.s(2, 3) * this.s(4, 4) * this.s(5, 5), -this.s(2, 5) * this.s(3, 4) * this.s(3, 5) + this.s(2, 4) * this.s(3, 5) * this.s(3, 5) + this.s(2, 5) * this.s(3, 3) * this.s(4, 5) - this.s(2, 3) * this.s(3, 5) * this.s(4, 5) - this.s(2, 4) * this.s(3, 3) * this.s(5, 5) + this.s(2, 3) * this.s(3, 4) * this.s(5, 5), this.s(2, 5) * this.s(3, 4) * this.s(3, 4) - this.s(2, 4) * this.s(3, 4) * this.s(3, 5) - this.s(2, 5) * this.s(3, 3) * this.s(4, 4) + this.s(2, 3) * this.s(3, 5) * this.s(4, 4) + this.s(2, 4) * this.s(3, 3) * this.s(4, 5) - this.s(2, 3) * this.s(3, 4) * this.s(4, 5), 0.0, this.s(1, 5) * this.s(3, 5) * this.s(4, 4) - this.s(1, 5) * this.s(3, 4) * this.s(4, 5) - this.s(1, 4) * this.s(3, 5) * this.s(4, 5) + this.s(1, 3) * this.s(4, 5) * this.s(4, 5) + this.s(1, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 3) * this.s(4, 4) * this.s(5, 5), -this.s(1, 5) * this.s(3, 4) * this.s(3, 5) + this.s(1, 4) * this.s(3, 5) * this.s(3, 5) + this.s(1, 5) * this.s(3, 3) * this.s(4, 5) - this.s(1, 3) * this.s(3, 5) * this.s(4, 5) - this.s(1, 4) * this.s(3, 3) * this.s(5, 5) + this.s(1, 3) * this.s(3, 4) * this.s(5, 5), this.s(1, 5) * this.s(3, 4) * this.s(3, 4) - this.s(1, 4) * this.s(3, 4) * this.s(3, 5) - this.s(1, 5) * this.s(3, 3) * this.s(4, 4) + this.s(1, 3) * this.s(3, 5) * this.s(4, 4) + this.s(1, 4) * this.s(3, 3) * this.s(4, 5) - this.s(1, 3) * this.s(3, 4) * this.s(4, 5), -this.s(1, 5) * this.s(2, 5) * this.s(4, 4) + this.s(1, 5) * this.s(2, 4) * this.s(4, 5) + this.s(1, 4) * this.s(2, 5) * this.s(4, 5) - this.s(1, 2) * this.s(4, 5) * this.s(4, 5) - this.s(1, 4) * this.s(2, 4) * this.s(5, 5) + this.s(1, 2) * this.s(4, 4) * this.s(5, 5), 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 4) - this.s(1, 5) * this.s(2, 4) * this.s(3, 5) - this.s(1, 4) * this.s(2, 5) * this.s(3, 5) - this.s(1, 5) * this.s(2, 3) * this.s(4, 5) - this.s(1, 3) * this.s(2, 5) * this.s(4, 5) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 5) + this.s(1, 4) * this.s(2, 3) * this.s(5, 5) + this.s(1, 3) * this.s(2, 4) * this.s(5, 5) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(5, 5), -this.s(1, 5) * this.s(2, 4) * this.s(3, 4) - this.s(1, 4) * this.s(2, 5) * this.s(3, 4) + 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 5) + this.s(1, 5) * this.s(2, 3) * this.s(4, 4) + this.s(1, 3) * this.s(2, 5) * this.s(4, 4) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 4) - this.s(1, 4) * this.s(2, 3) * this.s(4, 5) - this.s(1, 3) * this.s(2, 4) * this.s(4, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(4, 5), -this.s(1, 5) * this.s(2, 5) * this.s(3, 3) + this.s(1, 5) * this.s(2, 3) * this.s(3, 5) + this.s(1, 3) * this.s(2, 5) * this.s(3, 5) - this.s(1, 2) * this.s(3, 5) * this.s(3, 5) - this.s(1, 3) * this.s(2, 3) * this.s(5, 5) + this.s(1, 2) * this.s(3, 3) * this.s(5, 5), this.s(1, 5) * this.s(2, 4) * this.s(3, 3) + this.s(1, 4) * this.s(2, 5) * this.s(3, 3) - this.s(1, 5) * this.s(2, 3) * this.s(3, 4) - this.s(1, 3) * this.s(2, 5) * this.s(3, 4) - this.s(1, 4) * this.s(2, 3) * this.s(3, 5) - this.s(1, 3) * this.s(2, 4) * this.s(3, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) + 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 5) - 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 5), -this.s(1, 4) * this.s(2, 4) * this.s(3, 3) + this.s(1, 4) * this.s(2, 3) * this.s(3, 4) + this.s(1, 3) * this.s(2, 4) * this.s(3, 4) - this.s(1, 2) * this.s(3, 4) * this.s(3, 4) - this.s(1, 3) * this.s(2, 3) * this.s(4, 4) + this.s(1, 2) * this.s(3, 3) * this.s(4, 4)};
    }

    private double[] gradTau4() {
        return new double[]{0.0, this.s(3, 6) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) - 2.0 * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) + this.s(3, 5) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) - this.s(3, 6) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) + 2.0 * this.s(3, 4) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) - this.s(3, 3) * this.s(4, 6) * this.s(4, 6) * this.s(5, 5) + 2.0 * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) - 2.0 * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) - 2.0 * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) + 2.0 * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) * this.s(5, 6) + this.s(3, 4) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) - this.s(3, 3) * this.s(4, 4) * this.s(5, 6) * this.s(5, 6) - this.s(3, 5) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) + 2.0 * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) - this.s(3, 3) * this.s(4, 5) * this.s(4, 5) * this.s(6, 6) - this.s(3, 4) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6) + this.s(3, 3) * this.s(4, 4) * this.s(5, 5) * this.s(6, 6), -this.s(2, 6) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) + this.s(2, 6) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) + this.s(2, 5) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) - this.s(2, 5) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) + this.s(2, 6) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) - this.s(2, 6) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) - this.s(2, 4) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) + this.s(2, 3) * this.s(4, 6) * this.s(4, 6) * this.s(5, 5) - this.s(2, 6) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) - this.s(2, 5) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) + this.s(2, 6) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6) + this.s(2, 4) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) + this.s(2, 5) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) + this.s(2, 4) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) - 2.0 * this.s(2, 3) * this.s(4, 5) * this.s(4, 6) * this.s(5, 6) - this.s(2, 4) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) + this.s(2, 3) * this.s(4, 4) * this.s(5, 6) * this.s(5, 6) + this.s(2, 5) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) - this.s(2, 5) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6) - this.s(2, 4) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) + this.s(2, 3) * this.s(4, 5) * this.s(4, 5) * this.s(6, 6) + this.s(2, 4) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6) - this.s(2, 3) * this.s(4, 4) * this.s(5, 5) * this.s(6, 6), this.s(2, 6) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) - this.s(2, 5) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) - this.s(2, 6) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) + this.s(2, 5) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) - this.s(2, 6) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) + this.s(2, 4) * this.s(3, 6) * this.s(3, 6) * this.s(5, 5) + this.s(2, 6) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) - this.s(2, 3) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) + this.s(2, 6) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) + this.s(2, 5) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) - 2.0 * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) * this.s(5, 6) - this.s(2, 6) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6) + this.s(2, 3) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) - this.s(2, 5) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) + this.s(2, 3) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) + this.s(2, 4) * this.s(3, 3) * this.s(5, 6) * this.s(5, 6) - this.s(2, 3) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) - this.s(2, 5) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) + this.s(2, 4) * this.s(3, 5) * this.s(3, 5) * this.s(6, 6) + this.s(2, 5) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6) - this.s(2, 3) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) - this.s(2, 4) * this.s(3, 3) * this.s(5, 5) * this.s(6, 6) + this.s(2, 3) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6), -this.s(2, 6) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) + this.s(2, 5) * this.s(3, 6) * this.s(3, 6) * this.s(4, 4) + this.s(2, 6) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) - this.s(2, 4) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) + this.s(2, 6) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) * this.s(4, 6) + this.s(2, 4) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) - this.s(2, 6) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) + this.s(2, 3) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) + this.s(2, 5) * this.s(3, 3) * this.s(4, 6) * this.s(4, 6) - this.s(2, 3) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) - this.s(2, 6) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) + this.s(2, 4) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) + this.s(2, 6) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) - this.s(2, 3) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) - this.s(2, 4) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) + this.s(2, 3) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) + this.s(2, 5) * this.s(3, 4) * this.s(3, 4) * this.s(6, 6) - this.s(2, 4) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) - this.s(2, 5) * this.s(3, 3) * this.s(4, 4) * this.s(6, 6) + this.s(2, 3) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) + this.s(2, 4) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6) - this.s(2, 3) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6), this.s(2, 6) * this.s(3, 5) * this.s(3, 5) * this.s(4, 4) - this.s(2, 5) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) - 2.0 * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) + this.s(2, 5) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) + this.s(2, 4) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) + this.s(2, 6) * this.s(3, 3) * this.s(4, 5) * this.s(4, 5) - this.s(2, 3) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) + this.s(2, 5) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) - this.s(2, 4) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) - this.s(2, 5) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) + this.s(2, 3) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) + this.s(2, 6) * this.s(3, 4) * this.s(3, 4) * this.s(5, 5) - this.s(2, 4) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) - this.s(2, 6) * this.s(3, 3) * this.s(4, 4) * this.s(5, 5) + this.s(2, 3) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) + this.s(2, 4) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) - this.s(2, 3) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) - this.s(2, 5) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) + this.s(2, 4) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) + this.s(2, 5) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) - this.s(2, 3) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) - this.s(2, 4) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6) + this.s(2, 3) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6), 0.0, -this.s(1, 6) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) + this.s(1, 6) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) + this.s(1, 5) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) - this.s(1, 5) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) + this.s(1, 6) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) - this.s(1, 6) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) - this.s(1, 4) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) + this.s(1, 3) * this.s(4, 6) * this.s(4, 6) * this.s(5, 5) - this.s(1, 6) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) - this.s(1, 5) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) + this.s(1, 6) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6) + this.s(1, 4) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) + this.s(1, 5) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) + this.s(1, 4) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) - 2.0 * this.s(1, 3) * this.s(4, 5) * this.s(4, 6) * this.s(5, 6) - this.s(1, 4) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) + this.s(1, 3) * this.s(4, 4) * this.s(5, 6) * this.s(5, 6) + this.s(1, 5) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) - this.s(1, 5) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6) - this.s(1, 4) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) + this.s(1, 3) * this.s(4, 5) * this.s(4, 5) * this.s(6, 6) + this.s(1, 4) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6) - this.s(1, 3) * this.s(4, 4) * this.s(5, 5) * this.s(6, 6), this.s(1, 6) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) - this.s(1, 5) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) - this.s(1, 6) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) + this.s(1, 5) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) - this.s(1, 6) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) + this.s(1, 4) * this.s(3, 6) * this.s(3, 6) * this.s(5, 5) + this.s(1, 6) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) - this.s(1, 3) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) + this.s(1, 6) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) + this.s(1, 5) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) - 2.0 * this.s(1, 4) * this.s(3, 5) * this.s(3, 6) * this.s(5, 6) - this.s(1, 6) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6) + this.s(1, 3) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) - this.s(1, 5) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) + this.s(1, 3) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) + this.s(1, 4) * this.s(3, 3) * this.s(5, 6) * this.s(5, 6) - this.s(1, 3) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) - this.s(1, 5) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) + this.s(1, 4) * this.s(3, 5) * this.s(3, 5) * this.s(6, 6) + this.s(1, 5) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6) - this.s(1, 3) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) - this.s(1, 4) * this.s(3, 3) * this.s(5, 5) * this.s(6, 6) + this.s(1, 3) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6), -this.s(1, 6) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) + this.s(1, 5) * this.s(3, 6) * this.s(3, 6) * this.s(4, 4) + this.s(1, 6) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) - this.s(1, 4) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) + this.s(1, 6) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 5) * this.s(3, 4) * this.s(3, 6) * this.s(4, 6) + this.s(1, 4) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) - this.s(1, 6) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) + this.s(1, 3) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) + this.s(1, 5) * this.s(3, 3) * this.s(4, 6) * this.s(4, 6) - this.s(1, 3) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) - this.s(1, 6) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) + this.s(1, 4) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) + this.s(1, 6) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) - this.s(1, 3) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) - this.s(1, 4) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) + this.s(1, 3) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) + this.s(1, 5) * this.s(3, 4) * this.s(3, 4) * this.s(6, 6) - this.s(1, 4) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) - this.s(1, 5) * this.s(3, 3) * this.s(4, 4) * this.s(6, 6) + this.s(1, 3) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) + this.s(1, 4) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6) - this.s(1, 3) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6), this.s(1, 6) * this.s(3, 5) * this.s(3, 5) * this.s(4, 4) - this.s(1, 5) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) - 2.0 * this.s(1, 6) * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) + this.s(1, 5) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) + this.s(1, 4) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) + this.s(1, 6) * this.s(3, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 3) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) + this.s(1, 5) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) - this.s(1, 4) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) - this.s(1, 5) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) + this.s(1, 3) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) + this.s(1, 6) * this.s(3, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 4) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) - this.s(1, 6) * this.s(3, 3) * this.s(4, 4) * this.s(5, 5) + this.s(1, 3) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) + this.s(1, 4) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) - this.s(1, 3) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) - this.s(1, 5) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) + this.s(1, 4) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) + this.s(1, 5) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6) - this.s(1, 3) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) - this.s(1, 4) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6) + this.s(1, 3) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6), this.s(1, 6) * this.s(2, 6) * this.s(4, 5) * this.s(4, 5) - this.s(1, 6) * this.s(2, 5) * this.s(4, 5) * this.s(4, 6) - this.s(1, 5) * this.s(2, 6) * this.s(4, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 5) * this.s(4, 6) * this.s(4, 6) - this.s(1, 6) * this.s(2, 6) * this.s(4, 4) * this.s(5, 5) + this.s(1, 6) * this.s(2, 4) * this.s(4, 6) * this.s(5, 5) + this.s(1, 4) * this.s(2, 6) * this.s(4, 6) * this.s(5, 5) - this.s(1, 2) * this.s(4, 6) * this.s(4, 6) * this.s(5, 5) + this.s(1, 6) * this.s(2, 5) * this.s(4, 4) * this.s(5, 6) + this.s(1, 5) * this.s(2, 6) * this.s(4, 4) * this.s(5, 6) - this.s(1, 6) * this.s(2, 4) * this.s(4, 5) * this.s(5, 6) - this.s(1, 4) * this.s(2, 6) * this.s(4, 5) * this.s(5, 6) - this.s(1, 5) * this.s(2, 4) * this.s(4, 6) * this.s(5, 6) - this.s(1, 4) * this.s(2, 5) * this.s(4, 6) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(4, 5) * this.s(4, 6) * this.s(5, 6) + this.s(1, 4) * this.s(2, 4) * this.s(5, 6) * this.s(5, 6) - this.s(1, 2) * this.s(4, 4) * this.s(5, 6) * this.s(5, 6) - this.s(1, 5) * this.s(2, 5) * this.s(4, 4) * this.s(6, 6) + this.s(1, 5) * this.s(2, 4) * this.s(4, 5) * this.s(6, 6) + this.s(1, 4) * this.s(2, 5) * this.s(4, 5) * this.s(6, 6) - this.s(1, 2) * this.s(4, 5) * this.s(4, 5) * this.s(6, 6) - this.s(1, 4) * this.s(2, 4) * this.s(5, 5) * this.s(6, 6) + this.s(1, 2) * this.s(4, 4) * this.s(5, 5) * this.s(6, 6), -2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 5) * this.s(4, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 6) * this.s(4, 5) + this.s(1, 5) * this.s(2, 6) * this.s(3, 6) * this.s(4, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 6) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 6) * this.s(4, 6) + 2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 4) * this.s(5, 5) - this.s(1, 6) * this.s(2, 4) * this.s(3, 6) * this.s(5, 5) - this.s(1, 4) * this.s(2, 6) * this.s(3, 6) * this.s(5, 5) - this.s(1, 6) * this.s(2, 3) * this.s(4, 6) * this.s(5, 5) - this.s(1, 3) * this.s(2, 6) * this.s(4, 6) * this.s(5, 5) + 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(4, 6) * this.s(5, 5) - 2.0 * this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(5, 6) - 2.0 * this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(5, 6) + this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(5, 6) + this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(5, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 6) * this.s(5, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 6) * this.s(5, 6) + this.s(1, 6) * this.s(2, 3) * this.s(4, 5) * this.s(5, 6) + this.s(1, 3) * this.s(2, 6) * this.s(4, 5) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(4, 5) * this.s(5, 6) + this.s(1, 5) * this.s(2, 3) * this.s(4, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 5) * this.s(4, 6) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 6) * this.s(5, 6) - this.s(1, 4) * this.s(2, 3) * this.s(5, 6) * this.s(5, 6) - this.s(1, 3) * this.s(2, 4) * this.s(5, 6) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(5, 6) * this.s(5, 6) + 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(6, 6) - this.s(1, 5) * this.s(2, 4) * this.s(3, 5) * this.s(6, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 5) * this.s(6, 6) - this.s(1, 5) * this.s(2, 3) * this.s(4, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 5) * this.s(4, 5) * this.s(6, 6) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 5) * this.s(6, 6) + this.s(1, 4) * this.s(2, 3) * this.s(5, 5) * this.s(6, 6) + this.s(1, 3) * this.s(2, 4) * this.s(5, 5) * this.s(6, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(5, 5) * this.s(6, 6), 2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 5) * this.s(4, 4) - this.s(1, 6) * this.s(2, 5) * this.s(3, 6) * this.s(4, 4) - this.s(1, 5) * this.s(2, 6) * this.s(3, 6) * this.s(4, 4) - 2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 4) * this.s(4, 5) + this.s(1, 6) * this.s(2, 4) * this.s(3, 6) * this.s(4, 5) + this.s(1, 4) * this.s(2, 6) * this.s(3, 6) * this.s(4, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(4, 6) + this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(4, 6) - 2.0 * this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 6) * this.s(4, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 6) * this.s(4, 6) + this.s(1, 6) * this.s(2, 3) * this.s(4, 5) * this.s(4, 6) + this.s(1, 3) * this.s(2, 6) * this.s(4, 5) * this.s(4, 6) - 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(4, 5) * this.s(4, 6) - this.s(1, 5) * this.s(2, 3) * this.s(4, 6) * this.s(4, 6) - this.s(1, 3) * this.s(2, 5) * this.s(4, 6) * this.s(4, 6) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 6) * this.s(4, 6) + this.s(1, 6) * this.s(2, 4) * this.s(3, 4) * this.s(5, 6) + this.s(1, 4) * this.s(2, 6) * this.s(3, 4) * this.s(5, 6) - 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 6) * this.s(5, 6) - this.s(1, 6) * this.s(2, 3) * this.s(4, 4) * this.s(5, 6) - this.s(1, 3) * this.s(2, 6) * this.s(4, 4) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(4, 4) * this.s(5, 6) + this.s(1, 4) * this.s(2, 3) * this.s(4, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 4) * this.s(4, 6) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(4, 6) * this.s(5, 6) - this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(6, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(6, 6) + 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(6, 6) + this.s(1, 5) * this.s(2, 3) * this.s(4, 4) * this.s(6, 6) + this.s(1, 3) * this.s(2, 5) * this.s(4, 4) * this.s(6, 6) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 4) * this.s(6, 6) - this.s(1, 4) * this.s(2, 3) * this.s(4, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 4) * this.s(4, 5) * this.s(6, 6) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(4, 5) * this.s(6, 6), -this.s(1, 6) * this.s(2, 5) * this.s(3, 5) * this.s(4, 4) - this.s(1, 5) * this.s(2, 6) * this.s(3, 5) * this.s(4, 4) + 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 6) * this.s(4, 4) + this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(4, 5) + this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(4, 5) + this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(4, 5) + this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(4, 5) - 2.0 * this.s(1, 5) * this.s(2, 4) * this.s(3, 6) * this.s(4, 5) - 2.0 * this.s(1, 4) * this.s(2, 5) * this.s(3, 6) * this.s(4, 5) - this.s(1, 6) * this.s(2, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 3) * this.s(2, 6) * this.s(4, 5) * this.s(4, 5) + 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(4, 5) * this.s(4, 5) - 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(4, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 5) * this.s(4, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 3) * this.s(4, 5) * this.s(4, 6) + this.s(1, 3) * this.s(2, 5) * this.s(4, 5) * this.s(4, 6) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 5) * this.s(4, 6) - this.s(1, 6) * this.s(2, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 4) * this.s(2, 6) * this.s(3, 4) * this.s(5, 5) + 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 6) * this.s(5, 5) + this.s(1, 6) * this.s(2, 3) * this.s(4, 4) * this.s(5, 5) + this.s(1, 3) * this.s(2, 6) * this.s(4, 4) * this.s(5, 5) - 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(4, 4) * this.s(5, 5) - this.s(1, 4) * this.s(2, 3) * this.s(4, 6) * this.s(5, 5) - this.s(1, 3) * this.s(2, 4) * this.s(4, 6) * this.s(5, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(4, 6) * this.s(5, 5) + this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(5, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(5, 6) - 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(5, 6) - this.s(1, 5) * this.s(2, 3) * this.s(4, 4) * this.s(5, 6) - this.s(1, 3) * this.s(2, 5) * this.s(4, 4) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(4, 4) * this.s(5, 6) + this.s(1, 4) * this.s(2, 3) * this.s(4, 5) * this.s(5, 6) + this.s(1, 3) * this.s(2, 4) * this.s(4, 5) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(4, 5) * this.s(5, 6), this.s(1, 6) * this.s(2, 6) * this.s(3, 5) * this.s(3, 5) - this.s(1, 6) * this.s(2, 5) * this.s(3, 5) * this.s(3, 6) - this.s(1, 5) * this.s(2, 6) * this.s(3, 5) * this.s(3, 6) + this.s(1, 5) * this.s(2, 5) * this.s(3, 6) * this.s(3, 6) - this.s(1, 6) * this.s(2, 6) * this.s(3, 3) * this.s(5, 5) + this.s(1, 6) * this.s(2, 3) * this.s(3, 6) * this.s(5, 5) + this.s(1, 3) * this.s(2, 6) * this.s(3, 6) * this.s(5, 5) - this.s(1, 2) * this.s(3, 6) * this.s(3, 6) * this.s(5, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 3) * this.s(5, 6) + this.s(1, 5) * this.s(2, 6) * this.s(3, 3) * this.s(5, 6) - this.s(1, 6) * this.s(2, 3) * this.s(3, 5) * this.s(5, 6) - this.s(1, 3) * this.s(2, 6) * this.s(3, 5) * this.s(5, 6) - this.s(1, 5) * this.s(2, 3) * this.s(3, 6) * this.s(5, 6) - this.s(1, 3) * this.s(2, 5) * this.s(3, 6) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 3) * this.s(5, 6) * this.s(5, 6) - this.s(1, 2) * this.s(3, 3) * this.s(5, 6) * this.s(5, 6) - this.s(1, 5) * this.s(2, 5) * this.s(3, 3) * this.s(6, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 5) * this.s(6, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 5) * this.s(6, 6) - this.s(1, 2) * this.s(3, 5) * this.s(3, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 3) * this.s(5, 5) * this.s(6, 6) + this.s(1, 2) * this.s(3, 3) * this.s(5, 5) * this.s(6, 6), -2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) + this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) + this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(3, 6) + this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) + this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(3, 6) - this.s(1, 5) * this.s(2, 4) * this.s(3, 6) * this.s(3, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 6) * this.s(3, 6) + 2.0 * this.s(1, 6) * this.s(2, 6) * this.s(3, 3) * this.s(4, 5) - 2.0 * this.s(1, 6) * this.s(2, 3) * this.s(3, 6) * this.s(4, 5) - 2.0 * this.s(1, 3) * this.s(2, 6) * this.s(3, 6) * this.s(4, 5) + 2.0 * this.s(1, 2) * this.s(3, 6) * this.s(3, 6) * this.s(4, 5) - this.s(1, 6) * this.s(2, 5) * this.s(3, 3) * this.s(4, 6) - this.s(1, 5) * this.s(2, 6) * this.s(3, 3) * this.s(4, 6) + this.s(1, 6) * this.s(2, 3) * this.s(3, 5) * this.s(4, 6) + this.s(1, 3) * this.s(2, 6) * this.s(3, 5) * this.s(4, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 6) * this.s(4, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 6) * this.s(4, 6) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 6) * this.s(4, 6) - this.s(1, 6) * this.s(2, 4) * this.s(3, 3) * this.s(5, 6) - this.s(1, 4) * this.s(2, 6) * this.s(3, 3) * this.s(5, 6) + this.s(1, 6) * this.s(2, 3) * this.s(3, 4) * this.s(5, 6) + this.s(1, 3) * this.s(2, 6) * this.s(3, 4) * this.s(5, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 6) * this.s(5, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 6) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 6) * this.s(5, 6) - 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 6) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 6) * this.s(5, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(6, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(6, 6) - this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(6, 6) - this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(6, 6) - this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(6, 6) - this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(6, 6) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(6, 6) + 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(6, 6) - 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(6, 6), this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(3, 5) + this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) - this.s(1, 6) * this.s(2, 4) * this.s(3, 5) * this.s(3, 5) - this.s(1, 4) * this.s(2, 6) * this.s(3, 5) * this.s(3, 5) - 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) + this.s(1, 5) * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 5) * this.s(3, 6) - this.s(1, 6) * this.s(2, 5) * this.s(3, 3) * this.s(4, 5) - this.s(1, 5) * this.s(2, 6) * this.s(3, 3) * this.s(4, 5) + this.s(1, 6) * this.s(2, 3) * this.s(3, 5) * this.s(4, 5) + this.s(1, 3) * this.s(2, 6) * this.s(3, 5) * this.s(4, 5) + this.s(1, 5) * this.s(2, 3) * this.s(3, 6) * this.s(4, 5) + this.s(1, 3) * this.s(2, 5) * this.s(3, 6) * this.s(4, 5) - 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 6) * this.s(4, 5) + 2.0 * this.s(1, 5) * this.s(2, 5) * this.s(3, 3) * this.s(4, 6) - 2.0 * this.s(1, 5) * this.s(2, 3) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 3) * this.s(2, 5) * this.s(3, 5) * this.s(4, 6) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 5) * this.s(4, 6) + this.s(1, 6) * this.s(2, 4) * this.s(3, 3) * this.s(5, 5) + this.s(1, 4) * this.s(2, 6) * this.s(3, 3) * this.s(5, 5) - this.s(1, 6) * this.s(2, 3) * this.s(3, 4) * this.s(5, 5) - this.s(1, 3) * this.s(2, 6) * this.s(3, 4) * this.s(5, 5) - this.s(1, 4) * this.s(2, 3) * this.s(3, 6) * this.s(5, 5) - this.s(1, 3) * this.s(2, 4) * this.s(3, 6) * this.s(5, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 6) * this.s(5, 5) + 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 6) * this.s(5, 5) - 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 6) * this.s(5, 5) - this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(5, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(5, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(5, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(5, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(5, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(5, 6) - 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(5, 6), this.s(1, 6) * this.s(2, 6) * this.s(3, 4) * this.s(3, 4) - this.s(1, 6) * this.s(2, 4) * this.s(3, 4) * this.s(3, 6) - this.s(1, 4) * this.s(2, 6) * this.s(3, 4) * this.s(3, 6) + this.s(1, 4) * this.s(2, 4) * this.s(3, 6) * this.s(3, 6) - this.s(1, 6) * this.s(2, 6) * this.s(3, 3) * this.s(4, 4) + this.s(1, 6) * this.s(2, 3) * this.s(3, 6) * this.s(4, 4) + this.s(1, 3) * this.s(2, 6) * this.s(3, 6) * this.s(4, 4) - this.s(1, 2) * this.s(3, 6) * this.s(3, 6) * this.s(4, 4) + this.s(1, 6) * this.s(2, 4) * this.s(3, 3) * this.s(4, 6) + this.s(1, 4) * this.s(2, 6) * this.s(3, 3) * this.s(4, 6) - this.s(1, 6) * this.s(2, 3) * this.s(3, 4) * this.s(4, 6) - this.s(1, 3) * this.s(2, 6) * this.s(3, 4) * this.s(4, 6) - this.s(1, 4) * this.s(2, 3) * this.s(3, 6) * this.s(4, 6) - this.s(1, 3) * this.s(2, 4) * this.s(3, 6) * this.s(4, 6) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 6) * this.s(4, 6) + this.s(1, 3) * this.s(2, 3) * this.s(4, 6) * this.s(4, 6) - this.s(1, 2) * this.s(3, 3) * this.s(4, 6) * this.s(4, 6) - this.s(1, 4) * this.s(2, 4) * this.s(3, 3) * this.s(6, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 4) * this.s(6, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 4) * this.s(6, 6) - this.s(1, 2) * this.s(3, 4) * this.s(3, 4) * this.s(6, 6) - this.s(1, 3) * this.s(2, 3) * this.s(4, 4) * this.s(6, 6) + this.s(1, 2) * this.s(3, 3) * this.s(4, 4) * this.s(6, 6), -this.s(1, 6) * this.s(2, 5) * this.s(3, 4) * this.s(3, 4) - this.s(1, 5) * this.s(2, 6) * this.s(3, 4) * this.s(3, 4) + this.s(1, 6) * this.s(2, 4) * this.s(3, 4) * this.s(3, 5) + this.s(1, 4) * this.s(2, 6) * this.s(3, 4) * this.s(3, 5) + this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(3, 6) + this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(3, 6) - 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(3, 6) + this.s(1, 6) * this.s(2, 5) * this.s(3, 3) * this.s(4, 4) + this.s(1, 5) * this.s(2, 6) * this.s(3, 3) * this.s(4, 4) - this.s(1, 6) * this.s(2, 3) * this.s(3, 5) * this.s(4, 4) - this.s(1, 3) * this.s(2, 6) * this.s(3, 5) * this.s(4, 4) - this.s(1, 5) * this.s(2, 3) * this.s(3, 6) * this.s(4, 4) - this.s(1, 3) * this.s(2, 5) * this.s(3, 6) * this.s(4, 4) + 2.0 * this.s(1, 2) * this.s(3, 5) * this.s(3, 6) * this.s(4, 4) - this.s(1, 6) * this.s(2, 4) * this.s(3, 3) * this.s(4, 5) - this.s(1, 4) * this.s(2, 6) * this.s(3, 3) * this.s(4, 5) + this.s(1, 6) * this.s(2, 3) * this.s(3, 4) * this.s(4, 5) + this.s(1, 3) * this.s(2, 6) * this.s(3, 4) * this.s(4, 5) + this.s(1, 4) * this.s(2, 3) * this.s(3, 6) * this.s(4, 5) + this.s(1, 3) * this.s(2, 4) * this.s(3, 6) * this.s(4, 5) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 6) * this.s(4, 5) - this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(4, 6) - this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(4, 6) + this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(4, 6) + this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(4, 6) + this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(4, 6) + this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(4, 6) - 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(4, 6) + 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(4, 6) + 2.0 * this.s(1, 4) * this.s(2, 4) * this.s(3, 3) * this.s(5, 6) - 2.0 * this.s(1, 4) * this.s(2, 3) * this.s(3, 4) * this.s(5, 6) - 2.0 * this.s(1, 3) * this.s(2, 4) * this.s(3, 4) * this.s(5, 6) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 4) * this.s(5, 6) + 2.0 * this.s(1, 3) * this.s(2, 3) * this.s(4, 4) * this.s(5, 6) - 2.0 * this.s(1, 2) * this.s(3, 3) * this.s(4, 4) * this.s(5, 6), this.s(1, 5) * this.s(2, 5) * this.s(3, 4) * this.s(3, 4) - this.s(1, 5) * this.s(2, 4) * this.s(3, 4) * this.s(3, 5) - this.s(1, 4) * this.s(2, 5) * this.s(3, 4) * this.s(3, 5) + this.s(1, 4) * this.s(2, 4) * this.s(3, 5) * this.s(3, 5) - this.s(1, 5) * this.s(2, 5) * this.s(3, 3) * this.s(4, 4) + this.s(1, 5) * this.s(2, 3) * this.s(3, 5) * this.s(4, 4) + this.s(1, 3) * this.s(2, 5) * this.s(3, 5) * this.s(4, 4) - this.s(1, 2) * this.s(3, 5) * this.s(3, 5) * this.s(4, 4) + this.s(1, 5) * this.s(2, 4) * this.s(3, 3) * this.s(4, 5) + this.s(1, 4) * this.s(2, 5) * this.s(3, 3) * this.s(4, 5) - this.s(1, 5) * this.s(2, 3) * this.s(3, 4) * this.s(4, 5) - this.s(1, 3) * this.s(2, 5) * this.s(3, 4) * this.s(4, 5) - this.s(1, 4) * this.s(2, 3) * this.s(3, 5) * this.s(4, 5) - this.s(1, 3) * this.s(2, 4) * this.s(3, 5) * this.s(4, 5) + 2.0 * this.s(1, 2) * this.s(3, 4) * this.s(3, 5) * this.s(4, 5) + this.s(1, 3) * this.s(2, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 2) * this.s(3, 3) * this.s(4, 5) * this.s(4, 5) - this.s(1, 4) * this.s(2, 4) * this.s(3, 3) * this.s(5, 5) + this.s(1, 4) * this.s(2, 3) * this.s(3, 4) * this.s(5, 5) + this.s(1, 3) * this.s(2, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 2) * this.s(3, 4) * this.s(3, 4) * this.s(5, 5) - this.s(1, 3) * this.s(2, 3) * this.s(4, 4) * this.s(5, 5) + this.s(1, 2) * this.s(3, 3) * this.s(4, 4) * this.s(5, 5)};
    }

    private double s(int i, int j) {
        return this.indexedCorr().getValue(i - 1, j - 1);
    }

    public double getChiSquare() {
        return this.chiSquare;
    }

    public String toString() {
        return "Time Series";
    }

    @Override
    public DataSet getData() {
        return null;
    }
}

