/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import cern.jet.random.Normal;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.cluster.FastIca;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.Hungarian;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.QL;
import no.uib.cipr.matrix.Vector;

public class Lingam_old {
    private double alpha = 0.05;
    private boolean pruningDone = true;
    private boolean verbose = false;
    private boolean upperTriangleKept = true;
    private TetradLogger logger = TetradLogger.getInstance();

    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha is in range [0, 1]: " + alpha);
        }
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public GraphWithParameters lingam(DataSet dataSet) {
        DoubleMatrix2D data = dataSet.getDoubleData();
        List<Node> variables = dataSet.getVariables();
        Data result = this.algorithmA(new Data(data, variables));
        GraphWithParameters withParameters = this.makeDagWithParms2(result);
        this.logger.log("graph", "\nReturning this graph: " + withParameters.getGraph());
        return withParameters;
    }

    public boolean isPruningDone() {
        return this.pruningDone;
    }

    public void setPruningDone(boolean pruningDone) {
        this.pruningDone = pruningDone;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isUpperTriangleKept() {
        return this.upperTriangleKept;
    }

    public void setUpperTriangleKept(boolean upperTriangleKept) {
        this.upperTriangleKept = upperTriangleKept;
    }

    public String toString() {
        return "Lingam(alpha=" + this.getAlpha() + ")";
    }

    private Data algorithmA(Data data) {
        Data BHat = this.calculateBHat(data);
        Data BTilde = this.algorithmC(BHat);
        if (this.isPruningDone()) {
            int nSamples = 15;
            this.pruneEdgesBySampling(BTilde, data, this.getAlpha(), nSamples);
        }
        return BTilde;
    }

    private int[] getCausalOrder(Data BTilde, Data data) {
        int j;
        List<Node> originalVariables = data.getVariables();
        List<Node> swappedVariables = BTilde.getVariables();
        int dims = data.getData().columns();
        int[] k = new int[dims];
        for (j = 0; j < k.length; ++j) {
            k[j] = k.length - this.findColumn(j, swappedVariables, originalVariables) - 1;
        }
        for (j = 0; j < k.length; ++j) {
            System.out.print(k[j] + "\t");
        }
        return k;
    }

    private Data calculateBHat(Data data) {
        DoubleMatrix2D A = this.getMixingMatrix(data.getData());
        DoubleMatrix2D W = MatrixUtils.inverse(A);
        DoubleMatrix2D wTilde = this.permuteZerolessDiagonal(W);
        DoubleMatrix2D wTildePrime = MatrixUtils.normalizeDiagonal(wTilde);
        int n = W.rows();
        DoubleMatrix2D BHat = DoubleFactory2D.dense.identity(n);
        BHat.assign(wTildePrime, PlusMult.plusMult(-1.0));
        DoubleMatrix2D BhatT = BHat.viewDice();
        return new Data(BhatT, data.getVariables());
    }

    private Data algorithmC(Data bHat) {
        int i;
        DoubleMatrix2D _bHat = bHat.getData();
        int m = _bHat.rows();
        LinkedList<Entry> entries = this.getEntries(_bHat);
        Collections.sort(entries);
        if (this.isUpperTriangleKept()) {
            _bHat = _bHat.copy();
        }
        int numUpperTriangle = m * (m + 1) / 2;
        int numTotal = m * m;
        for (i = 0; i < numUpperTriangle; ++i) {
            Entry entry = entries.get(i);
            _bHat.set(entry.row, entry.column, 0.0);
        }
        for (i = numUpperTriangle; i < numTotal; ++i) {
            List<Integer> permutation = this.algorithmB(_bHat);
            if (permutation != null) {
                return this.permute(permutation, bHat);
            }
            Entry entry = entries.get(i);
            _bHat.set(entry.row, entry.column, 0.0);
        }
        throw new IllegalArgumentException("No permutation was found.");
    }

    private DoubleMatrix2D permuteZerolessDiagonal(DoubleMatrix2D mat) {
        DenseDoubleMatrix2D temp = new DenseDoubleMatrix2D(mat.rows(), mat.columns());
        ((DoubleMatrix2D)temp).assign(mat);
        ((DoubleMatrix2D)temp).assign(Functions.inv);
        ((DoubleMatrix2D)temp).assign(Functions.abs);
        int[][] assignment = Hungarian.hgAlgorithm(MatrixUtils.convert(temp), "min");
        return this.assignmentToMatrix(mat, assignment);
    }

    private DoubleMatrix2D assignmentToMatrix(DoubleMatrix2D mat, int[][] assignment) {
        DenseDoubleMatrix2D swappedMat = new DenseDoubleMatrix2D(mat.rows(), mat.columns());
        for (int i = 0; i < mat.rows(); ++i) {
            int newRowIndex = assignment[i][1];
            swappedMat.viewRow(newRowIndex).assign(mat.viewRow(i));
        }
        return swappedMat;
    }

    private DoubleMatrix2D getMixingMatrix(DoubleMatrix2D data0) {
        FastIca fastIca = new FastIca(data0, data0.columns());
        fastIca.setVerbose(false);
        fastIca.setTolerance(1.0E-26);
        FastIca.IcaResult result = fastIca.findComponents();
        return result.getA().viewDice();
    }

    public List<Integer> algorithmB(DoubleMatrix2D mat) {
        ArrayList<Integer> removedIndices = new ArrayList<Integer>();
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        while (removedIndices.size() < mat.rows()) {
            int allZerosRow = -1;
            for (int i = 0; i < mat.rows(); ++i) {
                if (removedIndices.contains(i) || !this.zeroesInNewColumns(mat.viewRow(i), removedIndices)) continue;
                allZerosRow = i;
                break;
            }
            if (allZerosRow == -1) {
                return null;
            }
            removedIndices.add(allZerosRow);
            permutation.add(allZerosRow);
        }
        return permutation;
    }

    private LinkedList<Entry> getEntries(DoubleMatrix2D mat) {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        for (int i = 0; i < mat.rows(); ++i) {
            for (int j = 0; j < mat.columns(); ++j) {
                Entry entry = new Entry(i, j, mat.get(i, j));
                entries.add(entry);
            }
        }
        return entries;
    }

    private Data permute(List<Integer> permutation, Data dataSet) {
        List<Node> variables = dataSet.getVariables();
        ArrayList<Node> nodes = new ArrayList<Node>(variables.size());
        for (int i1 = 0; i1 < variables.size(); ++i1) {
            nodes.add(variables.get(permutation.get(i1)));
        }
        int[] _permutation = new int[permutation.size()];
        for (int i = 0; i < permutation.size(); ++i) {
            _permutation[i] = permutation.get(i);
        }
        DoubleMatrix2D resMatrix = dataSet.getData().viewSelection(_permutation, _permutation);
        return new Data(resMatrix, nodes);
    }

    private boolean zeroesInNewColumns(DoubleMatrix1D vec, List<Integer> removedIndices) {
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i) == 0.0 || removedIndices.contains(i)) continue;
            return false;
        }
        return true;
    }

    private GraphWithParameters makeDagWithParms(Data ltDataSet) {
        DoubleMatrix2D ltMat = ltDataSet.getData();
        List<Node> variables = ltDataSet.getVariables();
        Dag dag = new Dag(variables);
        GraphWithParameters dwp = new GraphWithParameters(dag);
        for (int i = 0; i < ltMat.rows(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (ltMat.get(i, j) == 0.0) continue;
                Edge edge = new Edge(variables.get(i), variables.get(j), Endpoint.TAIL, Endpoint.ARROW);
                dwp.getGraph().addEdge(edge);
                dwp.getWeightHash().put(edge, ltMat.get(i, j));
            }
        }
        return dwp;
    }

    private GraphWithParameters makeDagWithParms2(Data BFinal) {
        DoubleMatrix2D data = BFinal.getData();
        List<Node> variables = BFinal.getVariables();
        Dag dag = new Dag(variables);
        GraphWithParameters dwp = new GraphWithParameters(dag);
        for (int j = 0; j < data.columns(); ++j) {
            for (int i = 0; i < data.rows(); ++i) {
                if (data.get(i, j) == 0.0) continue;
                Edge edge = new Edge(variables.get(i), variables.get(j), Endpoint.TAIL, Endpoint.ARROW);
                dwp.getGraph().addEdge(edge);
                dwp.getWeightHash().put(edge, data.get(i, j));
            }
        }
        return dwp;
    }

    private void pruneEdgesBySampling(Data BTilde, Data data, double alpha, int numSamples) {
        int i;
        Data[] bHats = new Data[numSamples];
        for (int i2 = 0; i2 < numSamples; ++i2) {
            Data sample = this.getBootstrapSample(data, data.getData().rows() / 2);
            bHats[i2] = this.calculateBHat(sample);
        }
        DenseDoubleMatrix2D meanMat = new DenseDoubleMatrix2D(BTilde.getData().rows(), BTilde.getData().columns());
        for (int i3 = 0; i3 < BTilde.getData().rows(); ++i3) {
            for (int j = 0; j < BTilde.getData().columns(); ++j) {
                double sum = 0.0;
                for (int z = 0; z < numSamples; ++z) {
                    sum += bHats[z].getData().get(i3, j);
                }
                meanMat.set(i3, j, sum / (double)(numSamples - 1));
            }
        }
        if (this.isVerbose()) {
            System.out.println("meanMat = " + meanMat);
        }
        DenseDoubleMatrix2D sdMat = new DenseDoubleMatrix2D(BTilde.getData().rows(), BTilde.getData().columns());
        for (i = 0; i < BTilde.getData().rows(); ++i) {
            for (int j = 0; j < BTilde.getData().columns(); ++j) {
                double sumOfSquares = 0.0;
                for (int z = 0; z < numSamples; ++z) {
                    double diff = bHats[z].getData().get(i, j) - meanMat.get(i, j);
                    sumOfSquares += diff * diff;
                }
                double variance = sumOfSquares / (double)(numSamples - 1);
                sdMat.set(i, j, Math.sqrt(variance));
            }
        }
        if (this.isVerbose()) {
            System.out.println("sdMat = " + sdMat);
        }
        for (i = 0; i < BTilde.getData().rows(); ++i) {
            for (int j = 0; j < BTilde.getData().columns(); ++j) {
                double score = new Normal(meanMat.get(i, j), sdMat.get(i, j), null).cdf(0.0);
                boolean rejected = score < alpha / 2.0 || score > 1.0 - alpha / 2.0;
                List<Node> swappedVariables = BTilde.getVariables();
                List<Node> originalVariables = data.getVariables();
                int xi = this.findColumn(i, swappedVariables, originalVariables);
                int xj = this.findColumn(j, swappedVariables, originalVariables);
                if (rejected) continue;
                BTilde.getData().set(xi, xj, 0.0);
            }
        }
    }

    public DoubleMatrix2D pruneEdgesByResampling(DoubleMatrix2D data, int[] k) {
        DenseMatrix X = new DenseMatrix(data.viewDice().toArray());
        int npieces = 10;
        int cols = X.numColumns();
        int rows = X.numRows();
        int piecesize = (int)Math.floor(cols / npieces);
        ArrayList<DenseMatrix> bpieces = new ArrayList<DenseMatrix>();
        ArrayList<DenseVector> diststdpieces = new ArrayList<DenseVector>();
        ArrayList<DenseVector> cpieces = new ArrayList<DenseVector>();
        for (int p = 0; p < npieces; ++p) {
            DenseMatrix sqrt;
            int i;
            int p0 = p * piecesize;
            int p1 = (p + 1) * piecesize - 1;
            int[] range = this.range(p0, p1);
            Matrix Xp = Matrices.getSubMatrix(X, k, range);
            double[] Xpm = new double[rows];
            for (i = 0; i < rows; ++i) {
                double sum = 0.0;
                for (int j = 0; j < Xp.numColumns(); ++j) {
                    sum += Xp.get(i, j);
                }
                Xpm[i] = sum / (double)Xp.numColumns();
            }
            for (i = 0; i < rows; ++i) {
                for (int j = 0; j < Xp.numColumns(); ++j) {
                    Xp.set(i, j, Xp.get(i, j) - Xpm[i]);
                }
            }
            DenseMatrix XpT = new DenseMatrix(Xp.numColumns(), rows);
            DenseMatrix cov = new DenseMatrix(rows, rows);
            Matrix Xpt = Xp.transpose(XpT);
            cov = new DenseMatrix(Xp.mult(Xpt, cov));
            for (int i2 = 0; i2 < cov.numRows(); ++i2) {
                for (int j = 0; j < cov.numColumns(); ++j) {
                    cov.set(i2, j, cov.get(i2, j) / (double)Xp.numColumns());
                }
            }
            try {
                sqrt = this.sqrt(cov);
            }
            catch (NotConvergedException e) {
                throw new RuntimeException(e);
            }
            DenseMatrix I = Matrices.identity(rows);
            DenseMatrix AI = I.copy();
            DenseMatrix invSqrt = new DenseMatrix(sqrt.solve(I, AI));
            QL ql = new QL(rows, rows);
            ql.factor(invSqrt);
            LowerTriangDenseMatrix L = ql.getL();
            Vector newestdisturbancestd = new DenseVector(rows);
            for (int t = 0; t < rows; ++t) {
                newestdisturbancestd.set(t, 1.0 / Math.abs(L.get(t, t)));
            }
            for (int s = 0; s < rows; ++s) {
                for (int t = 0; t <= s; ++t) {
                    L.set(s, t, L.get(s, t) / L.get(s, s));
                }
            }
            Matrix bnewest = Matrices.identity(rows);
            bnewest = bnewest.add(-1.0, L);
            Vector cnewest = new DenseVector(rows);
            cnewest = L.mult(new DenseVector(Xpm), cnewest);
            int[] ik = this.iperm(k);
            bnewest = Matrices.getSubMatrix(bnewest, ik, ik);
            newestdisturbancestd = Matrices.getSubVector(newestdisturbancestd, ik);
            cnewest = Matrices.getSubVector(cnewest, ik);
            bpieces.add((DenseMatrix)bnewest);
            diststdpieces.add((DenseVector)newestdisturbancestd);
            cpieces.add((DenseVector)cnewest);
        }
        double prunefactor = 4.0;
        DenseMatrix means = new DenseMatrix(rows, rows);
        DenseMatrix stds = new DenseMatrix(rows, rows);
        DenseMatrix BFinal = new DenseMatrix(rows, rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < rows; ++j) {
                double sum = 0.0;
                for (int y = 0; y < npieces; ++y) {
                    sum += ((Matrix)bpieces.get(y)).get(i, j);
                }
                double themean = sum / (double)npieces;
                double sumVar = 0.0;
                for (int y = 0; y < npieces; ++y) {
                    sumVar += Math.pow(((Matrix)bpieces.get(y)).get(i, j) - themean, 2.0);
                }
                double thestd = Math.sqrt(sumVar / (double)npieces);
                means.set(i, j, themean);
                stds.set(i, j, thestd);
                if (Math.abs(themean) < prunefactor * thestd) {
                    BFinal.set(i, j, 0.0);
                    continue;
                }
                BFinal.set(i, j, themean);
            }
        }
        this.printMatrix(BFinal);
        return new DenseDoubleMatrix2D(Matrices.getArray(BFinal));
    }

    private void printVector(Vector vector) {
        System.out.println();
        for (int i = 0; i < vector.size(); ++i) {
            System.out.print(vector.get(i) + "\t");
        }
        System.out.println();
    }

    private void printMatrix(Matrix matrix) {
        System.out.println();
        for (int i = 0; i < matrix.numRows(); ++i) {
            for (int j = 0; j < matrix.numColumns(); ++j) {
                System.out.print(matrix.get(i, j) + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public int[] iperm(int[] k) {
        int[] ik = new int[k.length];
        for (int i = 0; i < k.length; ++i) {
            for (int j = 0; j < k.length; ++j) {
                if (k[i] != j) continue;
                ik[j] = i;
            }
        }
        return ik;
    }

    private DenseMatrix sqrt(DenseMatrix m) throws NotConvergedException {
        EVD eig = new EVD(m.numRows());
        eig.factor(m);
        double[] r = eig.getRealEigenvalues();
        DenseMatrix v = eig.getLeftEigenvectors();
        DenseMatrix d = new DenseMatrix(m.numRows(), m.numRows());
        for (int i = 0; i < d.numRows(); ++i) {
            d.set(i, i, Math.sqrt(r[i]));
        }
        DenseMatrix vd = new DenseMatrix(m.numRows(), m.numRows());
        v.mult(d, vd);
        DenseMatrix vT = new DenseMatrix(m.numRows(), m.numRows());
        v.transpose(vT);
        DenseMatrix prod = new DenseMatrix(m.numRows(), m.numRows());
        vd.mult(vT, prod);
        return prod;
    }

    private int[] all(int i1) {
        int[] series = new int[i1];
        for (int j = 0; j < series.length; ++j) {
            series[j] = j;
        }
        return series;
    }

    private int[] range(int i1, int i2) {
        if (i2 < i1) {
            throw new IllegalArgumentException("i2 must be >=  i2 " + i1 + ", " + i2);
        }
        int[] series = new int[i2 - i1 + 1];
        for (int j = i1; j <= i2; ++j) {
            series[j - i1] = j;
        }
        return series;
    }

    private void pruneEdgesByRegression(Data BTilde, Data data, double alpha) {
        Dag graph = new Dag(this.makeDagWithParms(BTilde).getGraph());
        ArrayList<Node> variables = new ArrayList<Node>();
        for (Node node : BTilde.getVariables()) {
            variables.add(graph.getNode(node.getName()));
        }
        ColtDataSet _data = ColtDataSet.makeContinuousData(variables, data.getData());
        RegressionDataset regression = new RegressionDataset(_data);
        for (Node y : graph.getNodes()) {
            List<Node> parents = graph.getParents(y);
            if (parents.isEmpty()) continue;
            RegressionResult result = regression.regress(y, parents);
            for (int i = 0; i < parents.size(); ++i) {
                double p = result.getP()[i];
                int from = variables.indexOf(parents.get(i));
                int to = variables.indexOf(y);
                if (!(p > alpha)) continue;
                BTilde.getData().set(from, to, 0.0);
            }
        }
    }

    private void pruneEdgesByResampling2_old(Data BTilde, Data data, double alpha) {
        int numSamples = 100;
        int bootstrapSize = data.getData().rows();
        List<Node> originalVariables = data.getVariables();
        List<Node> swappedVariables = BTilde.getVariables();
        int dims = data.getData().columns();
        int[] k = new int[dims];
        for (int j = 0; j < k.length; ++j) {
            k[j] = this.findColumn(j, swappedVariables, originalVariables);
        }
        int[] ik = new int[dims];
        for (int j = 0; j < k.length; ++j) {
            ik[j] = this.findColumn(j, originalVariables, swappedVariables);
        }
        int[] allRows = new int[bootstrapSize];
        for (int i = 0; i < allRows.length; ++i) {
            allRows[i] = i;
        }
        DoubleMatrix2D[] Bpieces = new DoubleMatrix2D[numSamples];
        DoubleMatrix1D[] diststdpieces = new DoubleMatrix1D[numSamples];
        DoubleMatrix1D[] cpieces = new DoubleMatrix1D[numSamples];
        for (int s = 0; s < numSamples; ++s) {
            Data bootstrap = this.getBootstrapSample(data, bootstrapSize);
            DoubleMatrix2D Xp = bootstrap.getData().viewSelection(allRows, k).copy();
            DenseDoubleMatrix1D Xpm = new DenseDoubleMatrix1D(dims);
            for (int j = 0; j < dims; ++j) {
                DoubleArrayList column = new DoubleArrayList();
                for (int i = 0; i < bootstrapSize; ++i) {
                    column.add(Xp.get(i, j));
                }
                double mean = Descriptive.mean(column);
                double std = Descriptive.standardDeviation(Descriptive.variance(bootstrapSize, Descriptive.sum(column), Descriptive.sumOfSquares(column)));
                Xpm.set(j, mean);
                for (int i = 0; i < Xp.rows(); ++i) {
                    Xp.set(i, j, Xp.get(i, j) - mean);
                }
            }
            DoubleMatrix2D C = new Algebra().mult(Xp.viewDice(), Xp);
            C.assign(Mult.mult(1.0 / (double)bootstrapSize));
            CholeskyDecomposition cholesky = new CholeskyDecomposition(C);
            DoubleMatrix2D L = cholesky.getL();
            DoubleMatrix1D diag = DoubleFactory2D.dense.diagonal(L);
            DoubleMatrix2D D = DoubleFactory2D.dense.diagonal(diag);
            DoubleMatrix1D newestDisturbancesstd = diag.copy();
            DoubleMatrix2D identity = DoubleFactory2D.dense.identity(dims);
            DoubleMatrix2D DLInv = new Algebra().mult(D, new Algebra().inverse(L));
            DoubleMatrix2D Bnewest = identity.assign(DLInv, PlusMult.plusMult(-1.0));
            DoubleMatrix1D cnewest = new Algebra().mult(L, (DoubleMatrix1D)Xpm);
            Bpieces[s] = Bnewest;
            diststdpieces[s] = newestDisturbancesstd;
            cpieces[s] = cnewest;
        }
        for (int i = 0; i < dims; ++i) {
            for (int j = 0; j < dims; ++j) {
                DoubleArrayList sampleData = new DoubleArrayList();
                for (int s = 0; s < numSamples; ++s) {
                    sampleData.add(Bpieces[s].get(i, j));
                }
                double themean = Descriptive.mean(sampleData);
                double thestd = Descriptive.standardDeviation(Descriptive.variance(numSamples, Descriptive.sum(sampleData), Descriptive.sumOfSquares(sampleData)));
                double pruneFactor = 10.0;
                int xi = this.findColumn(i, swappedVariables, originalVariables);
                int xj = this.findColumn(j, swappedVariables, originalVariables);
                if (!(Math.abs(themean) < pruneFactor * thestd)) continue;
                BTilde.getData().set(xi, xj, 0.0);
            }
        }
    }

    private int findColumn(int index, List<Node> variables, List<Node> originalVariables) {
        String originalName = originalVariables.get(index).getName();
        for (int i = 0; i < variables.size(); ++i) {
            String newName = variables.get(i).getName();
            if (!newName.equals(originalName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Column not found.");
    }

    private Data getBootstrapSample(Data dataSet, int sampleSize) {
        DoubleMatrix2D data = dataSet.getData();
        int actualSampleSize = dataSet.data.rows();
        int[] rows = new int[sampleSize];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = RandomUtil.getInstance().nextInt(actualSampleSize);
        }
        int[] cols = new int[dataSet.getData().columns()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        DoubleMatrix2D newData = data.viewSelection(rows, cols).copy();
        return new Data(newData, dataSet.variables);
    }

    private static class Data {
        private DoubleMatrix2D data;
        private List<Node> variables;

        public Data(DoubleMatrix2D array, List<Node> variables) {
            this.data = array;
            this.variables = variables;
        }

        public DoubleMatrix2D getData() {
            return this.data;
        }

        public List<Node> getVariables() {
            return this.variables;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("\n").append(this.variables);
            buf.append("\n").append(this.data);
            return buf.toString();
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        private int row;
        private int column;
        private double value;

        public Entry(int row, int col, double val) {
            this.row = row;
            this.column = col;
            this.value = val;
        }

        @Override
        public int compareTo(Entry entry) {
            double thisVal = Math.abs(this.value);
            double entryVal = Math.abs(entry.value);
            return new Double(thisVal).compareTo(entryVal);
        }

        public String toString() {
            return "[" + this.row + "," + this.column + "]:" + this.value + " ";
        }
    }
}

