/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MeekRules
implements ImpliedOrientation {
    private Knowledge knowledge;
    private boolean aggressivelyPreventCycles = false;
    private Map<Edge, Edge> changedEdges = new HashMap<Edge, Edge>();

    @Override
    public void orientImplied(Graph graph) {
        TetradLogger.getInstance().log("impliedOrientations", "Starting Orientation Step D.");
        this.orientUsingMeekRulesLocally(this.knowledge, graph);
        TetradLogger.getInstance().log("impliedOrientations", "Finishing Orientation Step D.");
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private void orientUsingMeekRulesLocally(Knowledge knowledge, Graph graph) {
        boolean changed;
        while (changed = this.meekR2(graph, knowledge) || this.meekR1Locally(graph, knowledge) || this.meekR3(graph, knowledge) || this.meekR4(graph, knowledge)) {
        }
    }

    private boolean meekR1Locally(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Edge after;
                Edge before;
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.isUndirectedFromTo(a, c)) {
                    if (!MeekRules.isUnshieldedNoncollider(b, a, c, graph) || !MeekRules.isArrowpointAllowed(a, c, knowledge) || this.createsCycle(a, c, graph)) continue;
                    before = graph.getEdge(a, c);
                    graph.setEndpoint(a, c, Endpoint.ARROW);
                    after = graph.getEdge(a, c);
                    this.changedEdges.put(after, before);
                    TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + b + "-->" + a + "---" + c + ")", graph.getEdge(a, c)));
                    changed = true;
                    continue;
                }
                if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.isUndirectedFromTo(a, b) || !MeekRules.isUnshieldedNoncollider(b, a, c, graph) || !MeekRules.isArrowpointAllowed(a, b, knowledge) || this.createsCycle(a, b, graph)) continue;
                before = graph.getEdge(a, c);
                graph.setEndpoint(a, b, Endpoint.ARROW);
                after = graph.getEdge(a, c);
                this.changedEdges.put(after, before);
                TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R1 (" + c + "-->" + a + "---" + b + ")", graph.getEdge(a, b)));
                changed = true;
            }
        }
        return changed;
    }

    private boolean meekR2(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Edge after;
                Edge before;
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.isDirectedFromTo(b, a) && graph.isDirectedFromTo(a, c) && graph.isUndirectedFromTo(b, c)) {
                    if (!MeekRules.isArrowpointAllowed(b, c, knowledge) || this.createsCycle(b, c, graph)) continue;
                    before = graph.getEdge(b, c);
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    after = graph.getEdge(b, c);
                    this.changedEdges.put(after, before);
                    TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    continue;
                }
                if (!graph.isDirectedFromTo(c, a) || !graph.isDirectedFromTo(a, b) || !graph.isUndirectedFromTo(c, b) || !MeekRules.isArrowpointAllowed(c, b, knowledge) || this.createsCycle(c, b, graph)) continue;
                before = graph.getEdge(c, b);
                graph.setEndpoint(c, b, Endpoint.ARROW);
                after = graph.getEdge(c, b);
                this.changedEdges.put(after, before);
                TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
            }
        }
        return changed;
    }

    private boolean meekR3(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.isUndirectedFromTo(a, c) || !graph.isUndirectedFromTo(a, d) || !MeekRules.isUnshieldedNoncollider(c, a, d, graph) || !graph.isDirectedFromTo(c, b) || !graph.isDirectedFromTo(d, b) || !MeekRules.isArrowpointAllowed(a, b, knowledge) || this.createsCycle(a, b, graph)) continue;
                    Edge before = graph.getEdge(a, b);
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    Edge after = graph.getEdge(a, b);
                    this.changedEdges.put(after, before);
                    TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    private boolean meekR4(Graph graph, Knowledge knowledge) {
        if (knowledge == null) {
            return false;
        }
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isAdjacentTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Edge after;
                    Edge before;
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (!graph.isUndirectedFromTo(a, b) || !graph.isUndirectedFromTo(a, c) || !MeekRules.isUnshieldedNoncollider(c, a, b, graph)) continue;
                    if (graph.isDirectedFromTo(b, d) && graph.isDirectedFromTo(d, c)) {
                        if (!MeekRules.isArrowpointAllowed(a, c, knowledge) || this.createsCycle(a, c, graph)) continue;
                        before = graph.getEdge(a, c);
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        after = graph.getEdge(a, c);
                        this.changedEdges.put(after, before);
                        TetradLogger.getInstance().log("impliedOientations", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, c)));
                        changed = true;
                        continue block1;
                    }
                    if (!graph.isDirectedFromTo(c, d) || !graph.isDirectedFromTo(d, b) || !MeekRules.isArrowpointAllowed(a, b, knowledge) || this.createsCycle(a, b, graph)) continue;
                    before = graph.getEdge(a, b);
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    after = graph.getEdge(a, b);
                    this.changedEdges.put(after, before);
                    TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    private static boolean isUnshieldedNoncollider(Node a, Node b, Node c, Graph graph) {
        if (graph.isAmbiguousTriple(a, b, c)) {
            return false;
        }
        if (!graph.isAdjacentTo(a, b)) {
            return false;
        }
        if (!graph.isAdjacentTo(c, b)) {
            return false;
        }
        if (graph.isAdjacentTo(a, c)) {
            return false;
        }
        return graph.getEndpoint(a, b) != Endpoint.ARROW || graph.getEndpoint(c, b) != Endpoint.ARROW;
    }

    private static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(to.toString(), from.toString()) && !knowledge.edgeForbidden(from.toString(), to.toString());
    }

    private boolean createsCycle(Node x, Node y, Graph graph) {
        if (this.aggressivelyPreventCycles) {
            return graph.isAncestorOf(y, x);
        }
        return false;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public Map<Edge, Edge> getChangedEdges() {
        return this.changedEdges;
    }
}

