/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.LinkedList;
import java.util.List;

public class MeekRulesOld
implements ImpliedOrientation {
    private Knowledge knowledge = new Knowledge();

    @Override
    public void orientImplied(Graph graph) {
        this.orientUsingMeekRules(this.knowledge, graph);
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private void orientUsingMeekRules(Knowledge knowledge, Graph graph) {
        boolean changed;
        TetradLogger.getInstance().log("info", "Starting Orientation Step D.");
        while (changed = this.meekR1(graph, knowledge) || this.meekR2(graph, knowledge) || this.meekR3(graph, knowledge) || this.meekR4(graph, knowledge)) {
        }
        TetradLogger.getInstance().log("info", "Finishing Orientation Step D.");
    }

    private boolean meekR1(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Node a : nodes) {
                int[] combination;
                List<Node> adjacentNodes = graph.getAdjacentNodes(a);
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node b = adjacentNodes.get(combination[0]);
                    if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                    if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.isUndirectedFromTo(a, c)) {
                        if (!SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, c)));
                        changed = true;
                        continue;
                    }
                    if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.isUndirectedFromTo(a, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, b)));
                    changed = true;
                }
            }
        }
        return changed;
    }

    private boolean meekR2(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.isDirectedFromTo(b, a) && graph.isDirectedFromTo(a, c) && graph.isUndirectedFromTo(b, c)) {
                    if (!SearchGraphUtils.isArrowpointAllowed(b, c, knowledge)) continue;
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    continue;
                }
                if (!graph.isDirectedFromTo(c, a) || !graph.isDirectedFromTo(a, b) || !graph.isUndirectedFromTo(c, b) || !SearchGraphUtils.isArrowpointAllowed(c, b, knowledge)) continue;
                graph.setEndpoint(c, b, Endpoint.ARROW);
                TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
            }
        }
        return changed;
    }

    private boolean meekR3(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.isUndirectedFromTo(a, c) || !graph.isUndirectedFromTo(a, d) || !graph.isDirectedFromTo(c, b) || !graph.isDirectedFromTo(d, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    private boolean meekR4(Graph graph, Knowledge knowledge) {
        if (knowledge == null) {
            return false;
        }
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isAdjacentTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (!graph.isUndirectedFromTo(a, b) || !graph.isUndirectedFromTo(a, c)) continue;
                    if (graph.isDirectedFromTo(b, c) && graph.isDirectedFromTo(d, c)) {
                        if (!SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, c)));
                        changed = true;
                        continue block1;
                    }
                    if (!graph.isDirectedFromTo(c, d) || !graph.isDirectedFromTo(d, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }
}

