/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.LinkedList;
import java.util.List;

public class MeekRulesPattern
implements ImpliedOrientation {
    private Knowledge knowledge;
    private boolean aggressivelyPreventCycles = false;
    private TetradLogger logger = TetradLogger.getInstance();

    @Override
    public void orientImplied(Graph graph) {
        this.orientUsingMeekRulesLocally(this.knowledge, graph);
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public void orientUsingMeekRulesLocally(Knowledge knowledge, Graph graph) {
        boolean changed;
        this.logger.log("info", "Starting Orientation Step D.");
        while (changed = this.meekR2(graph, knowledge) || this.meekR1Locally(graph, knowledge) || this.meekR3(graph, knowledge) || this.meekR4(graph, knowledge)) {
        }
        this.logger.log("info", "Finishing Orientation Step D.");
    }

    public boolean meekR1Locally(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.isUndirectedFromTo(a, c)) {
                    if (!MeekRulesPattern.isUnshieldedNoncollider(b, a, c, graph) || !MeekRulesPattern.isArrowpointAllowed(a, c, knowledge) || this.createsCycle(a, c, graph)) continue;
                    graph.setEndpoint(a, c, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + b + "-->" + a + "---" + c + ")", graph.getEdge(a, c)));
                    changed = true;
                    this.meekR2(graph, knowledge);
                    continue;
                }
                if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.isUndirectedFromTo(a, b) || !MeekRulesPattern.isUnshieldedNoncollider(b, a, c, graph) || !MeekRulesPattern.isArrowpointAllowed(a, b, knowledge) || this.createsCycle(a, b, graph)) continue;
                graph.setEndpoint(a, b, Endpoint.ARROW);
                this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + c + "-->" + a + "---" + b + ")", graph.getEdge(a, b)));
                changed = true;
                this.meekR2(graph, knowledge);
            }
        }
        return changed;
    }

    public boolean meekR2(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.isDirectedFromTo(b, a) && graph.isDirectedFromTo(a, c) && graph.isUndirectedFromTo(b, c)) {
                    if (!MeekRulesPattern.isArrowpointAllowed(b, c, knowledge) || this.createsCycle(b, c, graph)) continue;
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    this.meekR2(graph, knowledge);
                    continue;
                }
                if (!graph.isDirectedFromTo(c, a) || !graph.isDirectedFromTo(a, b) || !graph.isUndirectedFromTo(c, b) || !MeekRulesPattern.isArrowpointAllowed(c, b, knowledge) || this.createsCycle(c, b, graph)) continue;
                graph.setEndpoint(c, b, Endpoint.ARROW);
                this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
                this.meekR2(graph, knowledge);
            }
        }
        return changed;
    }

    public boolean meekR3(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.isUndirectedFromTo(a, c) || !graph.isUndirectedFromTo(a, d) || !MeekRulesPattern.isUnshieldedNoncollider(c, a, d, graph) || !graph.isDirectedFromTo(c, b) || !graph.isDirectedFromTo(d, b) || !MeekRulesPattern.isArrowpointAllowed(a, b, knowledge) || this.createsCycle(a, b, graph)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    this.meekR2(graph, knowledge);
                    continue block1;
                }
            }
        }
        return changed;
    }

    public boolean meekR4(Graph graph, Knowledge knowledge) {
        if (knowledge == null) {
            return false;
        }
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isAdjacentTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (!graph.isUndirectedFromTo(a, b) || !graph.isUndirectedFromTo(a, c) || !MeekRulesPattern.isUnshieldedNoncollider(c, a, b, graph)) continue;
                    if (graph.isDirectedFromTo(b, d) && graph.isDirectedFromTo(d, c)) {
                        if (!MeekRulesPattern.isArrowpointAllowed(a, c, knowledge) || this.createsCycle(a, c, graph)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, c)));
                        changed = true;
                        this.meekR2(graph, knowledge);
                        continue block1;
                    }
                    if (!graph.isDirectedFromTo(c, d) || !graph.isDirectedFromTo(d, b) || !MeekRulesPattern.isArrowpointAllowed(a, b, knowledge) || this.createsCycle(a, b, graph)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, b)));
                    changed = true;
                    this.meekR2(graph, knowledge);
                    continue block1;
                }
            }
        }
        return changed;
    }

    private static boolean isUnshieldedNoncollider(Node a, Node b, Node c, Graph graph) {
        if (graph.isAmbiguousTriple(a, b, c)) {
            return false;
        }
        if (!graph.isAdjacentTo(a, b)) {
            return false;
        }
        if (!graph.isAdjacentTo(c, b)) {
            return false;
        }
        if (graph.isAdjacentTo(a, c)) {
            return false;
        }
        return graph.getEndpoint(a, b) != Endpoint.ARROW || graph.getEndpoint(c, b) != Endpoint.ARROW;
    }

    private static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(to.toString(), from.toString()) && !knowledge.edgeForbidden(from.toString(), to.toString());
    }

    private boolean createsCycle(Node x, Node y, Graph graph) {
        return graph.isAncestorOf(y, x);
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }
}

