/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class MimAdjacencySearch {
    private Graph graph;
    private IndependenceTest ind;
    private Knowledge knowledge;
    private List<Node> latents;
    private int depth = Integer.MAX_VALUE;

    public MimAdjacencySearch(Graph graph, IndependenceTest ind, Knowledge knowledge, List<Node> latents) {
        this.graph = graph;
        this.ind = ind;
        this.knowledge = knowledge;
        this.latents = latents;
    }

    public SepsetMap adjSearch() {
        SepsetMap sepset = new SepsetMap();
        for (int n = 0; this.adjStep(this.graph, this.ind, this.knowledge, sepset, n) && this.getDepth() > n; ++n) {
        }
        return sepset;
    }

    private Object[] forbidFilter(Set<String> set1, String x, Knowledge bk) {
        Iterator<String> it = set1.iterator();
        LinkedList<String> arr = new LinkedList<String>();
        while (it.hasNext()) {
            String z = it.next();
            if (bk.edgeForbidden(z, x)) continue;
            arr.add(z);
        }
        return arr.toArray();
    }

    private boolean adjStep(Graph graph, IndependenceTest ind, Knowledge knowledge, SepsetMap sepset, int n) {
        Iterator<Node> it = this.latents.iterator();
        boolean result = false;
        LinkedList<Node> visited = new LinkedList<Node>();
        while (it.hasNext()) {
            Node nodeX = it.next();
            HashSet<Node> set = new HashSet<Node>();
            for (Node node : graph.getAdjacentNodes(nodeX)) {
                if (!this.latents.contains(node)) continue;
                set.add(node);
            }
            for (Node aVisited : visited) {
                set.remove(aVisited);
            }
            visited.add(nodeX);
            block3: for (Node nodeY : new HashSet(set)) {
                int[] subset;
                HashSet<String> set1 = new HashSet<String>();
                for (Node node : graph.getAdjacentNodes(nodeX)) {
                    if (!this.latents.contains(node)) continue;
                    set1.add(((Object)node).toString());
                }
                HashSet<String> set2 = new HashSet<String>();
                for (Node node : graph.getAdjacentNodes(nodeY)) {
                    if (!this.latents.contains(node)) continue;
                    set2.add(((Object)node).toString());
                }
                set1.addAll(set2);
                set1.remove(((Object)nodeY).toString());
                set1.remove(((Object)nodeX).toString());
                Object[] seta = this.forbidFilter(set1, nodeX.getName(), knowledge);
                if (seta.length < n) continue;
                result = true;
                ChoiceGenerator cg = new ChoiceGenerator(seta.length, n);
                while ((subset = cg.next()) != null) {
                    List condSet = MimAdjacencySearch.asList(subset, seta);
                    if (!ind.isIndependent(nodeX, nodeY, condSet) || !knowledge.noEdgeRequired(nodeX.getName(), nodeY.getName())) continue;
                    set.remove(nodeY);
                    graph.removeEdge(nodeX, nodeY);
                    sepset.set(nodeX, nodeY, new LinkedList<Node>(condSet));
                    continue block3;
                }
            }
        }
        return result;
    }

    private static List asList(int[] i, Object[] o) {
        Object[] temp = new Object[i.length];
        for (int a = 0; a < i.length; ++a) {
            temp[a] = o[i[a]];
        }
        return Arrays.asList(temp);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

