/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas2;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Pc2
implements GraphSearch {
    private IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepsets;
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private boolean aggressivelyPreventCycles = false;
    private TetradLogger logger = TetradLogger.getInstance();
    private Set<Triple> unshieldedColliders;
    private Set<Triple> unshieldedNoncolliders;
    private int numIndependenceTests;
    private Graph trueGraph;
    private int numFalseDependenceJudgements;
    private int numDependenceJudgements;
    private Graph startingGraph;
    private Map<Node, List<Node>> envelopes;

    public Pc2(Graph startingGraph, IndependenceTest independenceTest, Map<Node, List<Node>> envelopes) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.startingGraph = startingGraph;
        this.envelopes = envelopes;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0.");
        }
        if (depth > 1000) {
            throw new IllegalArgumentException("Depth must be <= 1000.");
        }
        this.depth = depth;
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    public Graph search(List<Node> nodes) {
        this.logger.log("info", "Starting PC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        long startTime = System.currentTimeMillis();
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        if (this.startingGraph != null) {
            this.graph = new EdgeListGraph(this.startingGraph);
        } else {
            this.graph = new EdgeListGraph(nodes);
            this.graph.fullyConnect(Endpoint.TAIL);
        }
        Fas2 fas = new Fas2(this.graph, this.getIndependenceTest(), this.envelopes);
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setTrueGraph(this.trueGraph);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        this.enumerateTriples();
        SearchGraphUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        SearchGraphUtils.orientCollidersUsingSepsets(this.sepsets, this.knowledge, this.graph);
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        rules.setKnowledge(this.knowledge);
        rules.orientImplied(this.graph);
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        this.elapsedTime = System.currentTimeMillis() - startTime;
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.log("info", "Finishing PC Algorithm.");
        this.logger.flush();
        return this.graph;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Set<Triple> getUnshieldedColliders() {
        return this.unshieldedColliders;
    }

    public Set<Triple> getUnshieldedNoncolliders() {
        return this.unshieldedNoncolliders;
    }

    private void enumerateTriples() {
        this.unshieldedColliders = new HashSet<Triple>();
        this.unshieldedNoncolliders = new HashSet<Triple>();
        for (Node y : this.graph.getNodes()) {
            int[] choice;
            List<Node> adj = this.graph.getAdjacentNodes(y);
            if (adj.size() < 2) continue;
            ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
            while ((choice = gen.next()) != null) {
                Node z;
                Node x = adj.get(choice[0]);
                List<Node> nodes = this.sepsets.get(x, z = adj.get(choice[1]));
                if (nodes == null) continue;
                if (nodes.contains(y)) {
                    this.getUnshieldedNoncolliders().add(new Triple(x, y, z));
                    continue;
                }
                this.getUnshieldedColliders().add(new Triple(x, y, z));
            }
        }
    }

    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public int getNumFalseDependenceJudgements() {
        return this.numFalseDependenceJudgements;
    }

    public int getNumDependenceJudgements() {
        return this.numDependenceJudgements;
    }

    public List<Node> getNodes() {
        return this.graph.getNodes();
    }

    public List<Triple> getColliders(Node node) {
        return null;
    }

    public List<Triple> getNoncolliders(Node node) {
        return null;
    }

    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    public List<Triple> getUnderlineTriples(Node node) {
        return null;
    }

    public List<Triple> getDottedUnderlineTriples(Node node) {
        return null;
    }
}

