/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRulesPattern;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PcPattern
implements GraphSearch {
    private IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepset;
    private int depth = Integer.MAX_VALUE;
    private Graph graph;
    private long elapsedTime;
    private boolean aggressivelyPreventCycles = false;
    private int numIndependenceTests = 0;
    private TetradLogger logger = TetradLogger.getInstance();
    private Set<Triple> unshieldedColliders;
    private Set<Triple> unshieldedNoncolliders;

    public PcPattern(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public SepsetMap getSepset() {
        return this.sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public Graph getPartialGraph() {
        return new EdgeListGraph(this.graph);
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Graph search(List<Node> nodes) {
        this.logger.log("info", "Starting PC PATTERN algorithm");
        this.logger.log("info", "Independence test = " + this.independenceTest + ".");
        long startTime = System.currentTimeMillis();
        this.numIndependenceTests = 0;
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.TAIL);
        Fas fas = new Fas(this.graph, this.getIndependenceTest());
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        this.graph = fas.search();
        this.sepset = fas.getSepsets();
        this.numIndependenceTests = fas.getNumIndependenceTests();
        this.enumerateTriples();
        SearchGraphUtils.pcOrientbk(this.getKnowledge(), this.graph, nodes);
        this.orientCollidersUsingSepsetsPattern(this.sepset, this.getKnowledge(), this.graph);
        this.handleDirectableCycles(this.graph);
        MeekRulesPattern rules = new MeekRulesPattern();
        rules.orientImplied(this.graph);
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        this.elapsedTime = System.currentTimeMillis() - startTime;
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.log("info", "Finishing PC PATTERN Algorithm.");
        this.logger.flush();
        return this.graph;
    }

    private void enumerateTriples() {
        this.unshieldedColliders = new HashSet<Triple>();
        this.unshieldedNoncolliders = new HashSet<Triple>();
        for (Node y : this.graph.getNodes()) {
            int[] choice;
            List<Node> adj = this.graph.getAdjacentNodes(y);
            if (adj.size() < 2) continue;
            ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
            while ((choice = gen.next()) != null) {
                Node z;
                Node x = adj.get(choice[0]);
                List<Node> nodes = this.sepset.get(x, z = adj.get(choice[1]));
                if (nodes == null) continue;
                if (nodes.contains(y)) {
                    this.getUnshieldedNoncolliders().add(new Triple(x, y, z));
                    continue;
                }
                this.getUnshieldedColliders().add(new Triple(x, y, z));
            }
        }
    }

    public Set<Triple> getUnshieldedColliders() {
        return this.unshieldedColliders;
    }

    public Set<Triple> getUnshieldedNoncolliders() {
        return this.unshieldedNoncolliders;
    }

    public void orientCollidersUsingSepsetsPattern(SepsetMap set, Knowledge knowledge, Graph graph) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1])) || (sepset = set.get(b, c)) == null || sepset.contains(a) || !PcPattern.isArrowpointAllowedPattern(b, a, knowledge, graph) || !PcPattern.isArrowpointAllowedPattern(c, a, knowledge, graph) || this.createsCycle(b, a, graph) || this.createsCycle(c, a, graph)) continue;
                graph.setEndpoint(b, a, Endpoint.ARROW);
                graph.setEndpoint(c, a, Endpoint.ARROW);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(b, a, c, sepset));
                new MeekRulesPattern().meekR2(graph, knowledge);
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private static boolean isArrowpointAllowedPattern(Node from, Node to, Knowledge knowledge, Graph graph) {
        Edge edge = graph.getEdge(from, to);
        if (knowledge == null) {
            return true;
        }
        if (graph.getEndpoint(from, to) == Endpoint.ARROW || graph.getEndpoint(to, from) == Endpoint.ARROW) {
            return false;
        }
        return !knowledge.edgeRequired(((Object)to).toString(), ((Object)from).toString()) && !knowledge.edgeForbidden(((Object)from).toString(), ((Object)to).toString());
    }

    public void handleDirectableCycles(Graph graph) {
        TetradLogger.getInstance().log("info", "Starting Handling of Directable Cycles:");
        for (Node node : graph.getNodes()) {
            this.directablePathFromTo(graph, node, node);
        }
        TetradLogger.getInstance().log("info", "Finishing Handling of Directable Cycles:");
    }

    public void directablePathFromTo(Graph graph, Node node1, Node node2) {
        this.directablePathVisit(graph, node1, node2, new LinkedList<Node>());
    }

    private void directablePathVisit(Graph graph, Node node1, Node node2, LinkedList<Node> path) {
        path.addLast(node1);
        for (Edge edge : new LinkedList<Edge>(graph.getEdges(node1))) {
            Node a2;
            Node a1;
            Node child = Edges.traverse(node1, edge);
            if (child == null || path.size() >= 2 && (a1 = path.get(path.size() - 2)) != child & graph.isDefCollider(a1, a2 = path.get(path.size() - 1), child)) continue;
            if (child == node2 && path.size() >= 4) {
                if (graph.isDefCollider(path.getLast(), child, path.get(1)) || this.containsChord(path, graph)) continue;
                this.orientSomeCollider(path, graph);
                continue;
            }
            if (path.contains(child)) continue;
            this.directablePathVisit(graph, child, node2, path);
        }
        path.removeLast();
    }

    private boolean containsChord(LinkedList<Node> path, Graph graph) {
        for (int i = 0; i < path.size() / 2 + 1; ++i) {
            for (int j = 2; j < path.size() - 1; ++j) {
                Node node2;
                int _j = (i + j) % path.size();
                Node node1 = path.get(i);
                if (!graph.isAdjacentTo(node1, node2 = path.get(_j))) continue;
                return true;
            }
        }
        return false;
    }

    private void orientSomeCollider(LinkedList<Node> path, Graph graph) {
        LinkedList<Node> _path = new LinkedList<Node>(path);
        _path.add(_path.get(0));
        double storedP = Double.POSITIVE_INFINITY;
        int storedI = -1;
        for (int i = 1; i < _path.size() - 1; ++i) {
            Node node1 = _path.get(i - 1);
            Node node2 = _path.get(i);
            Node node3 = _path.get(i + 1);
            if (graph.getEdge(node1, node2) == null) {
                throw new NullPointerException();
            }
            if (graph.getEdge(node3, node2) == null) {
                throw new NullPointerException();
            }
            if (graph.getEndpoint(node2, node1) == Endpoint.ARROW || graph.getEndpoint(node2, node3) == Endpoint.ARROW) continue;
            this.independenceTest.isIndependent(node1, node3, Arrays.asList(node2));
            double p = this.independenceTest.getPValue();
            if (!(p < storedP)) continue;
            storedP = p;
            storedI = i;
        }
        if (storedI == -1) {
            return;
        }
        Node node1 = _path.get(storedI - 1);
        Node node2 = _path.get(storedI);
        Node node3 = _path.get(storedI + 1);
        if (this.createsCycle(node1, node2, graph) || this.createsCycle(node3, node2, graph)) {
            return;
        }
        graph.setEndpoint(node1, node2, Endpoint.ARROW);
        graph.setEndpoint(node3, node2, Endpoint.ARROW);
        TetradLogger.getInstance().log("details", "Orienting " + node1 + "->" + node2 + "<-" + node3 + " along path " + this.pathString(path, graph));
    }

    private String pathString(LinkedList<Node> path, Graph graph) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < path.size() - 1; ++i) {
            buf.append(path.get(i));
            Edge edge = graph.getEdge(path.get(i), path.get(i + 1));
            Endpoint leftEnd = edge.getProximalEndpoint(path.get(i));
            buf.append(leftEnd == Endpoint.ARROW ? "<" : "-");
            buf.append("-");
            Endpoint rightEnd = edge.getProximalEndpoint(path.get(i + 1));
            buf.append(rightEnd == Endpoint.ARROW ? ">" : "-");
        }
        buf.append(path.getLast());
        Edge edge = graph.getEdge(path.getLast(), path.getFirst());
        if (edge != null) {
            Endpoint leftEnd = edge.getProximalEndpoint(path.getLast());
            buf.append(leftEnd == Endpoint.ARROW ? "<" : "-");
            buf.append("-");
            Endpoint rightEnd = edge.getProximalEndpoint(path.getFirst());
            buf.append(rightEnd == Endpoint.ARROW ? ">" : "-");
            buf.append(path.getFirst());
        }
        return buf.toString();
    }

    private boolean createsCycle(Node x, Node y, Graph graph) {
        return graph.isAncestorOf(y, x);
    }
}

