/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbSearch;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.search.Pc;
import java.util.List;

public class Pcmb
implements MbSearch {
    private IndependenceTest test;
    private int depth;

    public Pcmb(IndependenceTest test, int depth) {
        this.test = test;
        this.depth = depth;
    }

    @Override
    public List<Node> findMb(String targetName) {
        Node target = this.getVariableForName(targetName);
        Pc search = new Pc(this.test);
        search.setDepth(this.depth);
        Graph graph = search.search();
        MbUtils.trimToMbNodes(graph, target, false);
        List<Node> mbVariables = graph.getNodes();
        mbVariables.remove(target);
        return mbVariables;
    }

    @Override
    public String getAlgorithmName() {
        return "PCMB";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetVariableName) {
        Node target = null;
        for (Node V : this.test.getVariables()) {
            if (!V.getName().equals(targetVariableName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetVariableName);
        }
        return target;
    }
}

