/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.search.ContinuousTetradTest;
import edu.cmu.tetrad.search.DiscreteTetradTest;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.sem.MimBuildEstimator;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Purify {
    private boolean outputMessage;
    private CorrelationMatrix correlationMatrix;
    private DataSet dataSet;
    private Clusters clusters;
    private int constraintSearchVariation = 1;
    private List forbiddenList;
    private int numVars;
    private TetradTest tetradTest;
    private TetradLogger logger = TetradLogger.getInstance();
    private final int PURE = 0;
    private final int IMPURE = 1;
    private final int UNDEFINED = 2;
    double[][] Cyy;
    double[][] Cyz;
    double[][] Czz;
    double[][] bestCyy;
    double[][] bestCyz;
    double[][] bestCzz;
    double[][] covErrors;
    double[][] oldCovErrors;
    double[][] sampleCovErrors;
    double[][] betas;
    double[][] oldBetas;
    double[][] betasLat;
    double[] varErrorLatent;
    double[][] omega;
    double[] omegaI;
    double[][][] parentsResidualsCovar;
    double[] iResidualsCovar;
    double[][][] selectedInverseOmega;
    double[][][] auxInverseOmega;
    int[][] spouses;
    int[] nSpouses;
    int[][] parents;
    int[][] parentsLat;
    double[][][] parentsCov;
    double[][] parentsChildCov;
    double[][][] parentsLatCov;
    double[][] parentsChildLatCov;
    double[][][] pseudoParentsCov;
    double[][] pseudoParentsChildCov;
    boolean[][] parentsL;
    int numObserved;
    int numLatent;
    int[] clusterId;
    Hashtable observableNames;
    Hashtable latentNames;
    SemGraph purePartitionGraph;
    Graph basicGraph;
    CovarianceMatrix covarianceMatrix;
    boolean[][] correlatedErrors;
    boolean[][] latentParent;
    boolean[][] observedParent;
    List latentNodes;
    List measuredNodes;
    SemIm currentSemIm;
    boolean modifiedGraph;
    boolean extraDebugPrint = false;

    public Purify(CorrelationMatrix correlationMatrix, double sig, TestType testType, Clusters clusters) {
        if (DataUtils.containsMissingValue(correlationMatrix.getMatrix())) {
            throw new IllegalArgumentException("Please remove or impute missing data first.");
        }
        this.correlationMatrix = correlationMatrix;
        this.initAlgorithm(sig, testType, clusters);
        if (testType == TestType.TETRAD_BOLLEN) {
            throw new RuntimeException("Covariance/correlation matrix is not enough to run Bollen's tetrad test.");
        }
    }

    public Purify(DataSet dataSet, double sig, TestType testType, Clusters clusters) {
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing data first.");
        }
        if (dataSet.isContinuous()) {
            this.correlationMatrix = new CorrelationMatrix(dataSet);
            this.dataSet = dataSet;
            this.initAlgorithm(sig, TestType.TETRAD_BOLLEN, clusters);
        } else {
            this.dataSet = dataSet;
            this.initAlgorithm(sig, testType, clusters);
        }
    }

    public Purify(TetradTest tetradTest, Clusters knowledge) {
        this.tetradTest = tetradTest;
        this.initAlgorithm(-1.0, TestType.NONE, knowledge);
    }

    public void setForbiddenList(List forbiddenList) {
        this.forbiddenList = forbiddenList;
    }

    private void initAlgorithm(double sig, TestType testType, Clusters clusters) {
        this.clusters = clusters;
        this.forbiddenList = null;
        if (this.tetradTest == null) {
            if (this.correlationMatrix != null) {
                TestType type = testType;
                this.tetradTest = testType == TestType.TETRAD_BOLLEN ? new ContinuousTetradTest(this.dataSet, type, sig) : new ContinuousTetradTest(this.correlationMatrix, type, sig);
            } else {
                this.tetradTest = new DiscreteTetradTest(this.dataSet, sig);
            }
        }
        this.numVars = this.tetradTest.getVarNames().length;
        this.outputMessage = true;
    }

    public void setConstraintSearchVariation(int type) {
        this.constraintSearchVariation = type;
    }

    public void setOutputMessage(boolean outputMessage) {
        this.outputMessage = outputMessage;
    }

    public Graph search() {
        Graph graph = this.getResultGraph();
        this.logger.log("graph", "\nReturning this graph: " + graph);
        return graph;
    }

    private Graph getResultGraph() {
        this.printlnMessage("\n**************Starting Purify search!!!*************\n");
        if (this.tetradTest instanceof DiscreteTetradTest) {
            List pureClusters = this.constraintSearchVariation == 0 ? this.tetradBasedPurify(this.getClusters()) : this.tetradBasedPurify2(this.getClusters());
            return this.convertSearchGraph(pureClusters);
        }
        TestType type = ((ContinuousTetradTest)this.tetradTest).getTestType();
        if (type == TestType.TETRAD_BASED) {
            List pureClusters = this.tetradBasedPurify(this.getClusters());
            return this.convertSearchGraph(pureClusters);
        }
        if (type == TestType.TETRAD_BASED2) {
            List pureClusters = this.tetradBasedPurify2(this.getClusters());
            return this.convertSearchGraph(pureClusters);
        }
        if (type == TestType.GAUSSIAN_SCORE || type == TestType.GAUSSIAN_SCORE_MARKS) {
            SemGraph semGraph = this.scoreBasedPurify(this.getClusters());
            return this.convertSearchGraph(semGraph);
        }
        if (type == TestType.GAUSSIAN_SCORE_ITERATE) {
            SemGraph semGraphI = this.scoreBasedPurifyIterate(this.getClusters());
            return this.convertSearchGraph(semGraphI);
        }
        if (type == TestType.GAUSSIAN_PVALUE) {
            SemGraph semGraph2 = this.pvalueBasedPurify(this.getClusters());
            return this.convertSearchGraph(semGraph2);
        }
        if (type == TestType.NONE) {
            SemGraph semGraph3 = this.dummyPurification(this.getClusters());
            return this.convertSearchGraph(semGraph3);
        }
        List pureClusters = this.constraintSearchVariation == 0 ? this.tetradBasedPurify(this.getClusters()) : this.tetradBasedPurify2(this.getClusters());
        return this.convertSearchGraph(pureClusters);
    }

    private List getClusters() {
        ArrayList<int[]> clusters = new ArrayList<int[]>();
        String[] varNames = this.tetradTest.getVarNames();
        for (int i = 0; i < this.clusters.getNumClusters(); ++i) {
            List<String> clusterS = this.clusters.getCluster(i);
            int[] cluster = new int[clusterS.size()];
            Iterator<String> it = clusterS.iterator();
            int count = 0;
            block1: while (it.hasNext()) {
                String nextName = it.next();
                for (int j = 0; j < varNames.length; ++j) {
                    if (!varNames[j].equals(nextName)) continue;
                    cluster[count++] = j;
                    continue block1;
                }
            }
            clusters.add(cluster);
        }
        return clusters;
    }

    private Graph convertSearchGraph(List<int[]> clusters) {
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (clusters == null) {
            nodes.add(new GraphNode("No_model."));
            return new EdgeListGraph(nodes);
        }
        boolean someEmpty = false;
        for (int[] cluster : clusters) {
            if (cluster.length != 0) continue;
            someEmpty = true;
        }
        if (someEmpty) {
            nodes.add(new GraphNode("No_model."));
            return new EdgeListGraph(nodes);
        }
        HashSet<GraphNode> latentsSet = new HashSet<GraphNode>();
        for (i = 0; i < clusters.size(); ++i) {
            GraphNode latent = new GraphNode("_L" + (i + 1));
            latent.setNodeType(NodeType.LATENT);
            nodes.add(latent);
            latentsSet.add(latent);
        }
        for (i = 0; i < clusters.size(); ++i) {
            int[] indicators = clusters.get(i);
            for (int j = 0; j < indicators.length; ++j) {
                String indicatorName = this.tetradTest.getVarNames()[indicators[j]];
                GraphNode indicator = new GraphNode(indicatorName);
                nodes.add(indicator);
            }
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        int acc = clusters.size();
        for (int i2 = 0; i2 < clusters.size(); ++i2) {
            int j;
            int[] indicators = clusters.get(i2);
            for (j = 0; j < indicators.length; ++j) {
                graph.setEndpoint((Node)nodes.get(i2), (Node)nodes.get(acc), Endpoint.ARROW);
                graph.setEndpoint((Node)nodes.get(acc), (Node)nodes.get(i2), Endpoint.TAIL);
                ++acc;
            }
            for (j = i2 + 1; j < clusters.size(); ++j) {
                graph.setEndpoint((Node)nodes.get(i2), (Node)nodes.get(j), Endpoint.ARROW);
                graph.setEndpoint((Node)nodes.get(j), (Node)nodes.get(i2), Endpoint.TAIL);
            }
        }
        if (graph != null && this.correlationMatrix != null) {
            MimBuildEstimator estimator = new MimBuildEstimator(this.correlationMatrix, new SemPm(graph), 10, 5);
            estimator.estimate();
            System.out.println("chisq = " + estimator.getEstimatedSem().getChiSquare());
            System.out.println("pvalue = " + estimator.getEstimatedSem().getPValue());
        }
        return graph;
    }

    private Graph convertSearchGraph(SemGraph input) {
        if (input == null) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(new GraphNode("No_model."));
            return new EdgeListGraph(nodes);
        }
        ArrayList<Node> inputIndicators = new ArrayList<Node>();
        ArrayList<Node> inputLatents = new ArrayList<Node>();
        for (Node next : input.getNodes()) {
            if (next.getNodeType() == NodeType.MEASURED) {
                inputIndicators.add(next);
                continue;
            }
            if (next.getNodeType() != NodeType.LATENT) continue;
            inputLatents.add(next);
        }
        ArrayList<Node> allNodes = new ArrayList<Node>(inputIndicators);
        allNodes.addAll(inputLatents);
        EdgeListGraph output = new EdgeListGraph(allNodes);
        for (Node node1 : input.getNodes()) {
            for (Node node2 : input.getNodes()) {
                Edge edge = input.getEdge(node1, node2);
                if (edge == null) continue;
                if (node1.getNodeType() == NodeType.ERROR && node2.getNodeType() == NodeType.ERROR) {
                    Iterator<Node> ci = input.getChildren(node1).iterator();
                    Node indicator1 = ci.next();
                    ci = input.getChildren(node2).iterator();
                    Node indicator2 = ci.next();
                    if (indicator1.getNodeType() == NodeType.LATENT) continue;
                    output.setEndpoint(indicator1, indicator2, Endpoint.ARROW);
                    output.setEndpoint(indicator2, indicator1, Endpoint.ARROW);
                    continue;
                }
                if (node1.getNodeType() == NodeType.LATENT && node2.getNodeType() == NodeType.LATENT || node1.getNodeType() == NodeType.ERROR || node2.getNodeType() == NodeType.ERROR) continue;
                output.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.ARROW);
                output.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.TAIL);
            }
        }
        for (int i = 0; i < inputLatents.size() - 1; ++i) {
            for (int j = i + 1; j < inputLatents.size(); ++j) {
                output.setEndpoint((Node)inputLatents.get(i), (Node)inputLatents.get(j), Endpoint.TAIL);
                output.setEndpoint((Node)inputLatents.get(j), (Node)inputLatents.get(i), Endpoint.TAIL);
            }
        }
        return output;
    }

    private void printClustering(List clustering) {
        for (int[] c : clustering) {
            this.printCluster(c);
        }
    }

    private void printCluster(int[] c) {
        int i;
        String[] sorted = new String[c.length];
        for (i = 0; i < c.length; ++i) {
            sorted[i] = this.tetradTest.getVarNames()[c[i]];
        }
        for (i = 0; i < sorted.length - 1; ++i) {
            String min = sorted[i];
            int min_idx = i;
            for (int j = i + 1; j < sorted.length; ++j) {
                if (sorted[j].compareTo(min) >= 0) continue;
                min = sorted[j];
                min_idx = j;
            }
            String temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
        for (i = 0; i < sorted.length; ++i) {
            this.printMessage(sorted[i] + " ");
        }
        this.printlnMessage();
    }

    private void printMessage(String message) {
        if (this.outputMessage) {
            System.out.print(message);
        }
    }

    private void printlnMessage(String message) {
        if (this.outputMessage) {
            System.out.println(message);
        }
    }

    private void printlnMessage() {
        if (this.outputMessage) {
            System.out.println();
        }
    }

    private int sizeCluster(List cluster) {
        int total = 0;
        for (int[] next : cluster) {
            total += next.length;
        }
        return total;
    }

    private List tetradBasedPurify(List partition) {
        boolean[] eliminated = new boolean[this.numVars];
        for (int i = 0; i < this.numVars; ++i) {
            eliminated[i] = false;
        }
        this.printlnMessage("TETRAD-BASED PURIFY:");
        this.printlnMessage("Finding Unidimensional Measurement Models");
        this.printlnMessage();
        this.printlnMessage("Initially Specified Measurement Model");
        this.printlnMessage();
        this.printClustering(partition);
        this.printlnMessage();
        this.printlnMessage("INTRA-CONSTRUCT PHASE.");
        this.printlnMessage("----------------------");
        this.printlnMessage();
        int count = 0;
        Iterator it = partition.iterator();
        while (it.hasNext()) {
            this.intraConstructPhase2((int[])it.next(), eliminated, "T" + ++count);
        }
        this.printlnMessage();
        this.printlnMessage("CROSS-CONSTRUCT PHASE.");
        this.printlnMessage("----------------------");
        this.printlnMessage();
        this.crossConstructPhase2(partition, eliminated);
        this.printlnMessage();
        this.printlnMessage("------------------------------------------------------");
        this.printlnMessage("Output Measurement Model");
        List output = this.buildSolution(partition, eliminated);
        this.printClustering(output);
        return output;
    }

    private void intraConstructPhase(int[] cluster, boolean[] eliminated, String clusterName) {
        int i;
        int clusterSize = cluster.length;
        double[][][][][] pvalues = new double[clusterSize][clusterSize][clusterSize][clusterSize][3];
        int numNotEliminated = this.numNotEliminated(cluster, eliminated);
        ArrayList<Double> allPValues = new ArrayList<Double>();
        int numImpurities = 0;
        Set[] failures = new Set[clusterSize];
        for (i = 0; i < clusterSize; ++i) {
            failures[i] = new HashSet();
        }
        for (i = 0; i < clusterSize - 3; ++i) {
            if (eliminated[cluster[i]]) continue;
            for (int j = i + 1; j < clusterSize - 2; ++j) {
                if (eliminated[cluster[j]]) continue;
                for (int k = j + 1; k < clusterSize - 1; ++k) {
                    if (eliminated[cluster[k]]) continue;
                    for (int l = k + 1; l < clusterSize; ++l) {
                        if (eliminated[cluster[l]]) continue;
                        double p1 = this.tetradTest.tetradPValue(cluster[i], cluster[j], cluster[k], cluster[l]);
                        double p2 = this.tetradTest.tetradPValue(cluster[i], cluster[j], cluster[l], cluster[k]);
                        double p3 = this.tetradTest.tetradPValue(cluster[i], cluster[k], cluster[l], cluster[j]);
                        allPValues.add(p1);
                        allPValues.add(p2);
                        allPValues.add(p3);
                        pvalues[i][j][k][l][0] = p1;
                        pvalues[i][j][k][l][1] = p2;
                        pvalues[i][j][k][l][2] = p3;
                    }
                }
            }
        }
        if (allPValues.size() == 0) {
            return;
        }
        Collections.sort(allPValues);
        System.out.println("numNotEliminated = " + numNotEliminated);
        System.out.println("allPValues = " + allPValues.size());
        int c = 0;
        while ((Double)allPValues.get(c) < this.tetradTest.getSignificance() * ((double)c + 1.0) / (double)allPValues.size()) {
            ++c;
        }
        double cutoff = (Double)allPValues.get(c);
        System.out.println("c = " + c + " cutoff = " + allPValues.get(c));
        for (int i2 = 0; i2 < clusterSize - 3; ++i2) {
            if (eliminated[cluster[i2]]) continue;
            for (int j = i2 + 1; j < clusterSize - 2; ++j) {
                if (eliminated[cluster[j]]) continue;
                for (int k = j + 1; k < clusterSize - 1; ++k) {
                    if (eliminated[cluster[k]]) continue;
                    for (int l = k + 1; l < clusterSize; ++l) {
                        if (eliminated[cluster[l]]) continue;
                        for (int t = 0; t < 3; ++t) {
                            if (!(pvalues[i2][j][k][l][t] < cutoff)) continue;
                            int[] newFailure = new int[]{i2, j, k, l};
                            failures[i2].add(newFailure);
                            failures[j].add(newFailure);
                            failures[k].add(newFailure);
                            failures[l].add(newFailure);
                            ++numImpurities;
                        }
                    }
                }
            }
        }
        if (numImpurities > 0) {
            this.printlnMessage(clusterName + " -- Original Status: " + numImpurities + " of " + allPValues.size() + " tetrads fail the FDR test.");
        } else {
            this.printlnMessage(clusterName + " -- Original Status: Needs NO pruning.");
        }
        while (numImpurities > 0) {
            int i3;
            int max = Integer.MIN_VALUE;
            int max_index = -1;
            for (i3 = 0; i3 < clusterSize; ++i3) {
                if (eliminated[cluster[i3]] || failures[i3].size() <= max) continue;
                max = failures[i3].size();
                max_index = i3;
            }
            eliminated[cluster[max_index]] = true;
            numImpurities -= failures[max_index].size();
            --numNotEliminated;
            for (i3 = 0; i3 < clusterSize; ++i3) {
                if (eliminated[cluster[i3]]) continue;
                HashSet<int[]> toRemove = new HashSet<int[]>();
                block14: for (int[] impurity : failures[i3]) {
                    for (int j = 0; j < 4; ++j) {
                        if (impurity[j] != max_index) continue;
                        toRemove.add(impurity);
                        continue block14;
                    }
                }
                failures[i3].removeAll(toRemove);
            }
            if (numNotEliminated < 3) {
                return;
            }
            this.printlnMessage("Dropped " + this.tetradTest.getVarNames()[cluster[max_index]] + "  Without it, " + numImpurities + " of " + allPValues.size() + " fail the FDR test.");
        }
    }

    private void intraConstructPhase2(int[] _cluster, boolean[] eliminated, String clusterName) {
        ArrayList<Integer> cluster = new ArrayList<Integer>();
        for (int i : _cluster) {
            cluster.add(i);
        }
        int numNotEliminated = this.numNotEliminated2(cluster, eliminated);
        int numImpurities = 0;
        List<Double> allPValues = this.listPValues(cluster, eliminated, Double.MAX_VALUE);
        if (allPValues.size() == 0) {
            return;
        }
        Collections.sort(allPValues);
        System.out.println(allPValues);
        System.out.println("numNotEliminated = " + numNotEliminated);
        System.out.println("allPValues = " + allPValues.size());
        double cutoff = 1.0;
        for (int c = 0; c < allPValues.size(); ++c) {
            if (!(allPValues.get(c) >= this.tetradTest.getSignificance() * ((double)c + 1.0) / (double)allPValues.size())) continue;
            cutoff = allPValues.get(c);
            break;
        }
        if (numImpurities > 0) {
            this.printlnMessage(clusterName + " -- Original Status: " + numImpurities + " of " + allPValues.size() + " tetrads fail the FDR test.");
        } else {
            this.printlnMessage(clusterName + " -- Original Status: Needs NO pruning.");
        }
        while (numImpurities > 0) {
            int min = Integer.MAX_VALUE;
            int minIndex = -1;
            Iterator i$ = cluster.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (eliminated[i]) continue;
                eliminated[i] = true;
                List<Double> pValues = this.listPValues(cluster, eliminated, cutoff);
                if (pValues.size() <= min) continue;
                min = pValues.size();
                minIndex = i;
            }
            if (minIndex == -1) continue;
            eliminated[minIndex] = true;
            numImpurities = min;
            System.out.println("Dropped " + this.tetradTest.getVarNames()[(Integer)cluster.get(minIndex)]);
        }
    }

    private List<Double> listPValues(List<Integer> cluster, boolean[] eliminated, double cutoff) {
        int[] choice;
        if (cluster.size() < 4) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> pValues = new ArrayList<Double>();
        ChoiceGenerator gen = new ChoiceGenerator(cluster.size(), 4);
        while ((choice = gen.next()) != null) {
            int i = choice[0];
            int j = choice[1];
            int k = choice[2];
            int l = choice[2];
            int ci = cluster.get(i);
            int cj = cluster.get(j);
            int ck = cluster.get(k);
            int cl = cluster.get(l);
            if (eliminated[ci] || eliminated[cj] || eliminated[ck] || eliminated[cl]) continue;
            double p1 = this.tetradTest.tetradPValue(ci, cj, ck, cl);
            double p2 = this.tetradTest.tetradPValue(ci, cj, cl, ck);
            double p3 = this.tetradTest.tetradPValue(ci, ck, cl, cj);
            if (p1 < cutoff) {
                pValues.add(p1);
            }
            if (p2 < cutoff) {
                pValues.add(p2);
            }
            if (!(p3 < cutoff)) continue;
            pValues.add(p3);
        }
        return pValues;
    }

    private void crossConstructPhase(List<int[]> partition, boolean[] eliminated) {
        int l;
        int k;
        int j;
        int i;
        int p2;
        int p1;
        int l2;
        int k2;
        int j2;
        int i2;
        int[] cluster2;
        int p22;
        int[] cluster1;
        int p12;
        int numImpurities = 0;
        ArrayList<Double> allPValues = new ArrayList<Double>();
        Set[][] failures = new Set[partition.size()][];
        for (int i3 = 0; i3 < partition.size(); ++i3) {
            int[] cluster = partition.get(i3);
            failures[i3] = new Set[cluster.length];
            for (int j3 = 0; j3 < cluster.length; ++j3) {
                failures[i3][j3] = new HashSet();
            }
        }
        for (p12 = 0; p12 < partition.size(); ++p12) {
            cluster1 = partition.get(p12);
            for (p22 = p12 + 1; p22 < partition.size(); ++p22) {
                cluster2 = partition.get(p22);
                for (i2 = 0; i2 < cluster1.length - 2; ++i2) {
                    if (eliminated[cluster1[i2]]) continue;
                    for (j2 = i2 + 1; j2 < cluster1.length - 1; ++j2) {
                        if (eliminated[cluster1[j2]]) continue;
                        for (k2 = j2 + 1; k2 < cluster1.length; ++k2) {
                            if (eliminated[cluster1[k2]]) continue;
                            for (l2 = 0; l2 < cluster2.length; ++l2) {
                                if (eliminated[cluster2[l2]]) continue;
                                allPValues.add(this.tetradTest.tetradPValue(cluster1[i2], cluster1[j2], cluster1[k2], cluster2[l2]));
                                allPValues.add(this.tetradTest.tetradPValue(cluster1[i2], cluster1[j2], cluster2[l2], cluster1[k2]));
                                allPValues.add(this.tetradTest.tetradPValue(cluster1[i2], cluster1[k2], cluster2[l2], cluster1[j2]));
                            }
                        }
                    }
                }
            }
        }
        if (allPValues.isEmpty()) {
            return;
        }
        for (p12 = 0; p12 < partition.size() - 1; ++p12) {
            cluster1 = partition.get(p12);
            for (p22 = p12 + 1; p22 < partition.size(); ++p22) {
                cluster2 = partition.get(p22);
                for (i2 = 0; i2 < cluster1.length - 1; ++i2) {
                    if (eliminated[cluster1[i2]]) continue;
                    for (j2 = i2 + 1; j2 < cluster1.length; ++j2) {
                        if (eliminated[cluster1[j2]]) continue;
                        for (k2 = 0; k2 < cluster2.length - 1; ++k2) {
                            if (eliminated[cluster2[k2]]) continue;
                            for (l2 = k2 + 1; l2 < cluster2.length; ++l2) {
                                if (eliminated[cluster2[l2]]) continue;
                                allPValues.add(this.tetradTest.tetradPValue(cluster1[i2], cluster1[j2], cluster2[k2], cluster2[l2]));
                            }
                        }
                    }
                }
            }
        }
        Collections.sort(allPValues);
        int c = 0;
        while ((Double)allPValues.get(c) < this.tetradTest.getSignificance() * ((double)c + 1.0) / (double)allPValues.size()) {
            ++c;
        }
        double cutoff = (Double)allPValues.get(c);
        System.out.println("c = " + c + " cutoff = " + allPValues.get(c));
        double[] localPValues = new double[3];
        for (p1 = 0; p1 < partition.size(); ++p1) {
            int[] cluster12 = partition.get(p1);
            for (p2 = p1 + 1; p2 < partition.size(); ++p2) {
                int[] cluster22 = partition.get(p2);
                for (i = 0; i < cluster12.length - 2; ++i) {
                    if (eliminated[cluster12[i]]) continue;
                    for (j = i + 1; j < cluster12.length - 1; ++j) {
                        if (eliminated[cluster12[j]]) continue;
                        for (k = j + 1; k < cluster12.length; ++k) {
                            if (eliminated[cluster12[k]]) continue;
                            for (l = 0; l < cluster22.length; ++l) {
                                if (eliminated[cluster22[l]]) continue;
                                localPValues[0] = this.tetradTest.tetradPValue(cluster12[i], cluster12[j], cluster12[k], cluster22[l]);
                                localPValues[1] = this.tetradTest.tetradPValue(cluster12[i], cluster12[j], cluster22[l], cluster12[k]);
                                localPValues[2] = this.tetradTest.tetradPValue(cluster12[i], cluster12[k], cluster22[l], cluster12[j]);
                                for (int t = 0; t < 3; ++t) {
                                    if (!(localPValues[t] < cutoff)) continue;
                                    int[] newFailure = new int[]{cluster12[i], cluster12[j], cluster12[k], cluster22[l]};
                                    failures[p1][i].add(newFailure);
                                    failures[p1][j].add(newFailure);
                                    failures[p1][k].add(newFailure);
                                    failures[p2][l].add(newFailure);
                                    ++numImpurities;
                                }
                            }
                        }
                    }
                }
            }
        }
        for (p1 = 0; p1 < partition.size() - 1; ++p1) {
            int[] cluster13 = partition.get(p1);
            for (p2 = p1 + 1; p2 < partition.size(); ++p2) {
                int[] cluster23 = partition.get(p2);
                for (i = 0; i < cluster13.length - 1; ++i) {
                    if (eliminated[cluster13[i]]) continue;
                    for (j = i + 1; j < cluster13.length; ++j) {
                        if (eliminated[cluster13[j]]) continue;
                        for (k = 0; k < cluster23.length - 1; ++k) {
                            if (eliminated[cluster23[k]]) continue;
                            for (l = k + 1; l < cluster23.length; ++l) {
                                if (eliminated[cluster23[l]] || !(this.tetradTest.tetradPValue(cluster13[i], cluster23[k], cluster13[j], cluster23[l]) < cutoff)) continue;
                                int[] newFailure = new int[]{cluster13[i], cluster13[j], cluster23[k], cluster23[l]};
                                failures[p1][i].add(newFailure);
                                failures[p1][j].add(newFailure);
                                failures[p2][k].add(newFailure);
                                failures[p2][l].add(newFailure);
                                ++numImpurities;
                            }
                        }
                    }
                }
            }
        }
        if (numImpurities > 0) {
            this.printlnMessage("Iteration 1   " + numImpurities + " of " + allPValues.size() + " tetrads fail the FDR test.");
        } else {
            this.printlnMessage("Needs NO pruning.");
        }
        while (numImpurities > 0) {
            int i4;
            int p;
            int max = Integer.MIN_VALUE;
            int max_index_p = -1;
            int max_index_i = -1;
            for (p = 0; p < partition.size(); ++p) {
                int[] cluster = partition.get(p);
                for (i4 = 0; i4 < cluster.length; ++i4) {
                    if (eliminated[cluster[i4]] || failures[p][i4].size() <= max) continue;
                    max = failures[p][i4].size();
                    max_index_p = p;
                    max_index_i = i4;
                }
            }
            eliminated[partition.get((int)max_index_p)[max_index_i]] = true;
            numImpurities -= failures[max_index_p][max_index_i].size();
            for (p = 0; p < partition.size(); ++p) {
                int[] cluster = partition.get(p);
                for (i4 = 0; i4 < cluster.length; ++i4) {
                    if (eliminated[cluster[i4]]) continue;
                    HashSet<int[]> toRemove = new HashSet<int[]>();
                    block33: for (int[] impurity : failures[p][i4]) {
                        for (int j4 = 0; j4 < 4; ++j4) {
                            if (impurity[j4] != partition.get(max_index_p)[max_index_i]) continue;
                            toRemove.add(impurity);
                            continue block33;
                        }
                    }
                    failures[p][i4].removeAll(toRemove);
                }
            }
            int[] cluster = partition.get(max_index_p);
            String var = this.tetradTest.getVarNames()[cluster[max_index_i]];
            this.printlnMessage("Dropped " + var + "  Without it, " + numImpurities + " of " + allPValues.size() + " tetrads fail the FDR test.");
        }
    }

    private void crossConstructPhase2(List<int[]> partition, boolean[] eliminated) {
        List<Double> allPValues = this.countCrossConstructPValues(partition, eliminated, Double.MAX_VALUE);
        if (allPValues.isEmpty()) {
            return;
        }
        Collections.sort(allPValues);
        double cutoff = 1.0;
        for (int c = 0; c < allPValues.size(); ++c) {
            if (!(allPValues.get(c) >= this.tetradTest.getSignificance() * ((double)c + 1.0) / (double)allPValues.size())) continue;
            cutoff = allPValues.get(c);
            break;
        }
        System.out.println("cutoff = " + cutoff);
        int numImpurities = this.countCrossConstructPValues(partition, eliminated, cutoff).size();
        if (numImpurities > 0) {
            this.printlnMessage("Iteration 1   " + numImpurities + " of " + allPValues.size() + " tetrads fail the FDR test.");
        } else {
            this.printlnMessage("Needs NO pruning.");
        }
        while (numImpurities > 0) {
            int min = Integer.MAX_VALUE;
            int minIndex = -1;
            ArrayList minCluster = null;
            for (int p = 0; p < partition.size(); ++p) {
                int[] cluster = partition.get(p);
                for (int i = 0; i < cluster.length; ++i) {
                    if (eliminated[cluster[i]]) continue;
                    eliminated[i] = true;
                    ArrayList<Integer> _cluster = new ArrayList<Integer>();
                    for (int j : cluster) {
                        _cluster.add(j);
                    }
                    List<Double> pValues = this.listPValues(_cluster, eliminated, cutoff);
                    if (pValues.size() <= min) continue;
                    min = pValues.size();
                    minIndex = i;
                    minCluster = new ArrayList(minCluster);
                    numImpurities = min;
                }
            }
            if (minIndex == -1) continue;
            eliminated[minIndex] = true;
            numImpurities = min;
            System.out.println("Dropped " + this.tetradTest.getVarNames()[(Integer)minCluster.get(minIndex)]);
        }
    }

    private List<Double> countCrossConstructPValues(List<int[]> partition, boolean[] eliminated, double cutoff) {
        ArrayList<Double> allPValues = new ArrayList<Double>();
        for (int p1 = 0; p1 < partition.size(); ++p1) {
            for (int p2 = p1 + 1; p2 < partition.size(); ++p2) {
                ArrayList<Integer> crossCluster;
                int[] choice2;
                int[] choice1;
                ChoiceGenerator gen2;
                ChoiceGenerator gen1;
                int[] cluster1 = partition.get(p1);
                int[] cluster2 = partition.get(p2);
                if (cluster1.length >= 3 && cluster2.length >= 1) {
                    gen1 = new ChoiceGenerator(cluster1.length, 3);
                    gen2 = new ChoiceGenerator(cluster2.length, 1);
                    while ((choice1 = gen1.next()) != null) {
                        while ((choice2 = gen2.next()) != null) {
                            crossCluster = new ArrayList<Integer>();
                            for (int i : choice1) {
                                crossCluster.add(cluster1[i]);
                            }
                            for (int i : choice2) {
                                crossCluster.add(cluster2[i]);
                            }
                            allPValues.addAll(this.listPValues(crossCluster, eliminated, cutoff));
                        }
                    }
                }
                if (cluster1.length < 2 || cluster2.length < 2) continue;
                gen1 = new ChoiceGenerator(cluster1.length, 2);
                gen2 = new ChoiceGenerator(cluster2.length, 2);
                while ((choice1 = gen1.next()) != null) {
                    while ((choice2 = gen2.next()) != null) {
                        crossCluster = new ArrayList();
                        for (int i : choice1) {
                            crossCluster.add(cluster1[i]);
                        }
                        for (int i : choice2) {
                            crossCluster.add(cluster2[i]);
                        }
                        allPValues.addAll(this.listPValues(crossCluster, eliminated, cutoff));
                    }
                }
            }
        }
        return allPValues;
    }

    private int numNotEliminated(int[] cluster, boolean[] eliminated) {
        int n1 = 0;
        for (int i = 0; i < cluster.length; ++i) {
            if (eliminated[cluster[i]]) continue;
            ++n1;
        }
        return n1;
    }

    private int numNotEliminated2(List<Integer> cluster, boolean[] eliminated) {
        int n1 = 0;
        for (int i : cluster) {
            if (eliminated[i]) continue;
            ++n1;
        }
        return n1;
    }

    private List buildSolution(List partition, boolean[] eliminated) {
        ArrayList<int[]> solution = new ArrayList<int[]>();
        for (int[] next : partition) {
            int[] draftArea = new int[next.length];
            int draftCount = 0;
            for (int i = 0; i < next.length; ++i) {
                if (eliminated[next[i]]) continue;
                draftArea[draftCount++] = next[i];
            }
            int[] realCluster = new int[draftCount];
            System.arraycopy(draftArea, 0, realCluster, 0, draftCount);
            solution.add(realCluster);
        }
        return solution;
    }

    private List tetradBasedPurify2(List partition) {
        boolean[][] impurities = this.tetradBasedMarkImpurities(partition);
        List solution = this.findInducedPureGraph(partition, impurities);
        if (solution != null) {
            this.printlnMessage(">> SIZE: " + this.sizeCluster(solution));
            this.printlnMessage(">> New solution found!");
        }
        return solution;
    }

    private boolean[][] tetradBasedMarkImpurities(List clustering) {
        int j;
        int i;
        this.printlnMessage("   (searching for impurities....)");
        int[][] relations = new int[this.numVars][this.numVars];
        for (i = 0; i < this.numVars; ++i) {
            for (int j2 = 0; j2 < this.numVars; ++j2) {
                relations[i][j2] = i == j2 ? 0 : 2;
            }
        }
        for (i = 0; i < clustering.size(); ++i) {
            int[] cluster1 = (int[])clustering.get(i);
            if (cluster1.length < 3) continue;
            for (j = 0; j < cluster1.length - 1; ++j) {
                for (int k = j + 1; k < cluster1.length; ++k) {
                    if (relations[cluster1[j]][cluster1[k]] != 2) continue;
                    boolean found = false;
                    for (int q = 0; q < cluster1.length && !found; ++q) {
                        if (j == q || k == q) continue;
                        for (int l = 0; l < clustering.size() && !found; ++l) {
                            int[] cluster2 = (int[])clustering.get(l);
                            for (int w = 0; w < cluster2.length && !found; ++w) {
                                if (l == i && (j == w || k == w || q == w) || !this.tetradTest.tetradScore3(cluster1[j], cluster1[k], cluster1[q], cluster2[w])) continue;
                                found = true;
                                relations[cluster1[k]][cluster1[j]] = 0;
                                relations[cluster1[j]][cluster1[k]] = 0;
                                relations[cluster1[q]][cluster1[j]] = 0;
                                relations[cluster1[j]][cluster1[q]] = 0;
                                relations[cluster1[q]][cluster1[k]] = 0;
                                relations[cluster1[k]][cluster1[q]] = 0;
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < clustering.size(); ++i) {
            int[] cluster1 = (int[])clustering.get(i);
            for (j = 0; j < clustering.size(); ++j) {
                if (i == j) continue;
                int[] cluster2 = (int[])clustering.get(j);
                for (int v1 = 0; v1 < cluster1.length; ++v1) {
                    for (int v2 = 0; v2 < cluster2.length; ++v2) {
                        if (relations[cluster1[v1]][cluster2[v2]] != 2) continue;
                        boolean found1 = false;
                        if (cluster1.length < 3) {
                            found1 = true;
                        }
                        for (int v3 = 0; v3 < cluster1.length && !found1; ++v3) {
                            if (v3 == v1 || relations[cluster1[v1]][cluster1[v3]] == 1 || relations[cluster2[v2]][cluster1[v3]] == 1) continue;
                            for (int v4 = 0; v4 < cluster1.length && !found1; ++v4) {
                                if (v4 == v1 || v4 == v3 || relations[cluster1[v1]][cluster1[v4]] == 1 || relations[cluster2[v2]][cluster1[v4]] == 1 || relations[cluster1[v3]][cluster1[v4]] == 1 || !this.tetradTest.tetradScore3(cluster1[v1], cluster2[v2], cluster1[v3], cluster1[v4])) continue;
                                found1 = true;
                            }
                        }
                        if (!found1) continue;
                        boolean found2 = false;
                        if (cluster2.length < 3) {
                            found2 = true;
                            relations[cluster2[v2]][cluster1[v1]] = 0;
                            relations[cluster1[v1]][cluster2[v2]] = 0;
                            continue;
                        }
                        for (int v3 = 0; v3 < cluster2.length && !found2; ++v3) {
                            if (v3 == v2 || relations[cluster1[v1]][cluster2[v3]] == 1 || relations[cluster2[v2]][cluster2[v3]] == 1) continue;
                            for (int v4 = 0; v4 < cluster2.length && !found2; ++v4) {
                                if (v4 == v2 || v4 == v3 || relations[cluster1[v1]][cluster2[v4]] == 1 || relations[cluster2[v2]][cluster2[v4]] == 1 || relations[cluster2[v3]][cluster2[v4]] == 1 || !this.tetradTest.tetradScore3(cluster1[v1], cluster2[v2], cluster2[v3], cluster2[v4])) continue;
                                found2 = true;
                                relations[cluster2[v2]][cluster1[v1]] = 0;
                                relations[cluster1[v1]][cluster2[v2]] = 0;
                            }
                        }
                    }
                }
            }
        }
        boolean[][] impurities = new boolean[this.numVars][this.numVars];
        for (int i2 = 0; i2 < this.numVars; ++i2) {
            for (j = 0; j < this.numVars; ++j) {
                impurities[i2][j] = relations[i2][j] == 2;
            }
        }
        return impurities;
    }

    private SemGraph dummyPurification(List partition) {
        this.structuralEmInitialization(partition);
        SemGraph bestGraph = this.purePartitionGraph;
        return bestGraph;
    }

    private SemGraph scoreBasedPurify(List partition) {
        int j;
        int i;
        this.structuralEmInitialization(partition);
        SemGraph bestGraph = this.purePartitionGraph;
        System.out.println(">>>> Structural EM: initial round");
        for (i = 0; i < this.correlatedErrors.length; ++i) {
            for (j = 0; j < this.correlatedErrors.length; ++j) {
                this.correlatedErrors[i][j] = false;
            }
        }
        for (i = 0; i < this.numObserved; ++i) {
            for (j = 0; j < this.numLatent; ++j) {
                Node latentNode = this.purePartitionGraph.getNode(this.latentNodes.get(j).toString());
                Node measuredNode = this.purePartitionGraph.getNode(this.measuredNodes.get(i).toString());
                this.latentParent[i][j] = this.purePartitionGraph.isParentOf(latentNode, measuredNode);
            }
            for (j = i; j < this.numObserved; ++j) {
                this.observedParent[j][i] = false;
                this.observedParent[i][j] = false;
            }
        }
        do {
            this.modifiedGraph = false;
            double score = this.gaussianEM(bestGraph, null);
            this.printlnMessage("Initial score" + score);
            this.impurityScoreSearch(score);
            if (!this.modifiedGraph) continue;
            this.printlnMessage(">>>> Structural EM: starting a new round");
            bestGraph = this.updatedGraph();
        } while (this.modifiedGraph);
        boolean[][] impurities = new boolean[this.numObserved][this.numObserved];
        for (int i2 = 0; i2 < this.numObserved; ++i2) {
            List<Node> parents = bestGraph.getParents(bestGraph.getNode(this.measuredNodes.get(i2).toString()));
            if (parents.size() > 1) {
                boolean latent_found = false;
                for (Node parent : parents) {
                    if (parent.getNodeType() != NodeType.LATENT) continue;
                    if (latent_found) {
                        impurities[i2][i2] = true;
                        break;
                    }
                    latent_found = true;
                }
            } else {
                impurities[i2][i2] = false;
            }
            for (int j2 = i2 + 1; j2 < this.numObserved; ++j2) {
                impurities[i2][j2] = this.correlatedErrors[i2][j2] || this.observedParent[i2][j2] || this.observedParent[j2][i2];
                impurities[j2][i2] = impurities[i2][j2];
            }
        }
        if (((ContinuousTetradTest)this.tetradTest).getTestType() == TestType.GAUSSIAN_SCORE) {
            bestGraph = this.removeMarkedImpurities(bestGraph, impurities);
        }
        return bestGraph;
    }

    /*
     * WARNING - void declaration
     */
    private SemGraph scoreBasedPurifyIterate(List partition) {
        boolean changed;
        int iter = 0;
        do {
            int n;
            int i;
            changed = false;
            this.printlnMessage("####Iterated score-based purification: round" + ++iter);
            this.scoreBasedPurify(partition);
            if (this.numObserved == 0) {
                return null;
            }
            int[] numImpurities = new int[this.numObserved];
            for (i = 0; i < this.numObserved; ++i) {
                numImpurities[i] = 0;
            }
            for (i = 0; i < this.numObserved; ++i) {
                for (int j = i + 1; j < this.numObserved; ++j) {
                    if (!this.correlatedErrors[i][j] && !this.observedParent[i][j] && !this.observedParent[j][i]) continue;
                    int n2 = i;
                    numImpurities[n2] = numImpurities[n2] + 1;
                    int n3 = j;
                    numImpurities[n3] = numImpurities[n3] + 1;
                    changed = true;
                }
            }
            if (!changed) continue;
            int max = numImpurities[0];
            ArrayList<Integer> choices = new ArrayList<Integer>();
            choices.add(0);
            for (int i2 = 1; i2 < this.numObserved; ++i2) {
                if (numImpurities[i2] > max) {
                    choices.clear();
                    choices.add(i2);
                    max = numImpurities[i2];
                    continue;
                }
                if (numImpurities[i2] != max) continue;
                choices.add(i2);
            }
            int choice = (Integer)choices.get(0);
            int[] chosenCluster = (int[])partition.get(this.clusterId[choice]);
            Iterator it = choices.iterator();
            while (it.hasNext()) {
                n = (Integer)it.next();
                int[] nextCluster = (int[])partition.get(this.clusterId[n]);
                if ((nextCluster.length <= chosenCluster.length || chosenCluster.length < 3) && (nextCluster.length >= chosenCluster.length || nextCluster.length >= 3)) continue;
                choice = n;
                chosenCluster = nextCluster;
            }
            this.printlnMessage("!! Removing " + this.measuredNodes.get(choice).toString());
            ArrayList<int[]> newPartition = new ArrayList<int[]>();
            n = 0;
            for (int[] next : partition) {
                if (choice >= n + next.length) {
                    newPartition.add(next);
                } else {
                    int[] newCluster = new int[next.length - 1];
                    for (int i3 = 0; i3 < next.length; ++i3) {
                        if (i3 < choice - n) {
                            newCluster[i3] = next[i3];
                            continue;
                        }
                        if (i3 <= choice - n) continue;
                        newCluster[i3 - 1] = next[i3];
                    }
                    newPartition.add(newCluster);
                    choice = this.numObserved;
                }
                n += next.length;
            }
            partition = newPartition;
        } while (changed);
        EdgeListGraph bestGraph = new EdgeListGraph();
        ArrayList<GraphNode> latentNodes = new ArrayList<GraphNode>();
        for (int p = 0; p < partition.size(); ++p) {
            void var10_20;
            int[] next = (int[])partition.get(p);
            GraphNode newLatent = new GraphNode("_L" + p);
            newLatent.setNodeType(NodeType.LATENT);
            bestGraph.addNode(newLatent);
            for (Node node : latentNodes) {
                bestGraph.addDirectedEdge(node, newLatent);
            }
            latentNodes.add(newLatent);
            boolean bl = false;
            while (var10_20 < next.length) {
                GraphNode newNode = new GraphNode(this.tetradTest.getVarNames()[next[var10_20]]);
                bestGraph.addNode(newNode);
                bestGraph.addDirectedEdge(newLatent, newNode);
                ++var10_20;
            }
        }
        return new SemGraph(bestGraph);
    }

    private void structuralEmInitialization(List partition) {
        this.observableNames = new Hashtable();
        this.latentNames = new Hashtable();
        this.numObserved = 0;
        this.numLatent = 0;
        this.latentNodes = new ArrayList();
        this.measuredNodes = new ArrayList();
        this.basicGraph = new EdgeListGraph();
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = (int[])partition.get(p);
            GraphNode newLatent = new GraphNode("_L" + p);
            newLatent.setNodeType(NodeType.LATENT);
            this.basicGraph.addNode(newLatent);
            for (Node previousLatent : this.latentNodes) {
                this.basicGraph.addDirectedEdge(previousLatent, newLatent);
            }
            this.latentNodes.add(newLatent);
            this.latentNames.put(((Object)newLatent).toString(), this.numLatent);
            ++this.numLatent;
            for (int i = 0; i < next.length; ++i) {
                GraphNode newNode = new GraphNode(this.tetradTest.getVarNames()[next[i]]);
                this.basicGraph.addNode(newNode);
                this.basicGraph.addDirectedEdge(newLatent, newNode);
                this.observableNames.put(((Object)newNode).toString(), this.numObserved);
                this.measuredNodes.add(newNode);
                ++this.numObserved;
            }
        }
        if (this.numLatent + this.numObserved < 1) {
            throw new IllegalArgumentException("Input clusters must contain at least one variable.");
        }
        this.clusterId = new int[this.numObserved];
        int count = 0;
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = (int[])partition.get(p);
            for (int i = 0; i < next.length; ++i) {
                this.clusterId[count++] = p;
            }
        }
        this.purePartitionGraph = new SemGraph(this.basicGraph);
        if (((ContinuousTetradTest)this.tetradTest).getTestType() == TestType.NONE) {
            return;
        }
        this.correlatedErrors = new boolean[this.numObserved][this.numObserved];
        this.latentParent = new boolean[this.numObserved][this.numLatent];
        this.observedParent = new boolean[this.numObserved][this.numObserved];
        this.Cyy = new double[this.numObserved][this.numObserved];
        this.bestCyy = new double[this.numObserved][this.numObserved];
        this.bestCyz = new double[this.numObserved][this.numLatent];
        this.bestCzz = new double[this.numLatent][this.numLatent];
        this.covarianceMatrix = ((ContinuousTetradTest)this.tetradTest).getCovMatrix();
        String[] varNames = this.covarianceMatrix.getVariableNames().toArray(new String[0]);
        double[][] cov = this.covarianceMatrix.getMatrix().toArray();
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov.length; ++j) {
                if (this.observableNames.get(varNames[i]) == null || this.observableNames.get(varNames[j]) == null) continue;
                this.Cyy[((Integer)this.observableNames.get((Object)varNames[i])).intValue()][((Integer)this.observableNames.get((Object)varNames[j])).intValue()] = cov[i][j];
            }
        }
        this.parents = new int[this.numObserved][];
        this.spouses = new int[this.numObserved][];
        this.nSpouses = new int[this.numObserved];
        this.parentsLat = new int[this.numLatent][];
        this.parentsL = new boolean[this.numObserved][];
        this.parentsCov = new double[this.numObserved][][];
        this.parentsChildCov = new double[this.numObserved][];
        this.parentsLatCov = new double[this.numLatent][][];
        this.parentsChildLatCov = new double[this.numLatent][];
        this.pseudoParentsCov = new double[this.numObserved][][];
        this.pseudoParentsChildCov = new double[this.numObserved][];
        this.covErrors = new double[this.numObserved][this.numObserved];
        this.oldCovErrors = new double[this.numObserved][this.numObserved];
        this.sampleCovErrors = new double[this.numObserved][this.numObserved];
        this.varErrorLatent = new double[this.numLatent];
        this.omega = new double[this.numLatent + this.numObserved - 1][this.numLatent + this.numObserved - 1];
        this.omegaI = new double[this.numLatent + this.numObserved - 1];
        this.selectedInverseOmega = new double[this.numObserved][][];
        this.auxInverseOmega = new double[this.numObserved][][];
        this.parentsResidualsCovar = new double[this.numObserved][][];
        this.iResidualsCovar = new double[this.numObserved + this.numLatent - 1];
        this.betas = new double[this.numObserved][this.numObserved + this.numLatent];
        this.oldBetas = new double[this.numObserved][this.numObserved + this.numLatent];
        this.betasLat = new double[this.numLatent][this.numLatent];
    }

    private double gaussianEM(SemGraph semdag, SemIm initialSemIm) {
        int q;
        int p;
        double newScore = -1.7976931348623157E308;
        double bestScore = -1.7976931348623157E308;
        SemPm semPm = new SemPm(semdag);
        for (p = 0; p < this.numObserved; ++p) {
            for (q = 0; q < this.numObserved; ++q) {
                this.bestCyy[p][q] = this.Cyy[p][q];
            }
            if (this.Cyz == null) continue;
            for (q = 0; q < this.numLatent; ++q) {
                this.bestCyz[p][q] = this.Cyz[p][q];
            }
        }
        if (this.Czz != null) {
            for (p = 0; p < this.numLatent; ++p) {
                for (q = 0; q < this.numLatent; ++q) {
                    this.bestCzz[p][q] = this.Czz[p][q];
                }
            }
        }
        semdag.setShowErrorTerms(true);
        this.initializeGaussianEM(semdag);
        for (int i = 0; i < 3; ++i) {
            int q2;
            int p2;
            double score;
            SemIm semIm;
            System.out.println("--Trial " + i);
            if (i == 0 && initialSemIm != null) {
                semIm = initialSemIm;
            } else {
                semIm = new SemIm(semPm);
                semIm.setCovMatrix(this.covarianceMatrix);
            }
            do {
                score = newScore;
                this.gaussianExpectation(semIm);
            } while ((newScore = this.gaussianMaximization(semIm)) != -1.7976931348623157E308 && Math.abs(score - newScore) > 0.001);
            System.out.println(newScore);
            if (!(newScore > bestScore) || Double.isInfinite(newScore)) continue;
            bestScore = newScore;
            for (p2 = 0; p2 < this.numObserved; ++p2) {
                for (q2 = 0; q2 < this.numObserved; ++q2) {
                    this.bestCyy[p2][q2] = this.Cyy[p2][q2];
                }
                for (q2 = 0; q2 < this.numLatent; ++q2) {
                    this.bestCyz[p2][q2] = this.Cyz[p2][q2];
                }
            }
            for (p2 = 0; p2 < this.numLatent; ++p2) {
                for (q2 = 0; q2 < this.numLatent; ++q2) {
                    this.bestCzz[p2][q2] = this.Czz[p2][q2];
                }
            }
        }
        for (p = 0; p < this.numObserved; ++p) {
            int q3;
            for (q3 = 0; q3 < this.numObserved; ++q3) {
                this.Cyy[p][q3] = this.bestCyy[p][q3];
            }
            for (q3 = 0; q3 < this.numLatent; ++q3) {
                this.Cyz[p][q3] = this.bestCyz[p][q3];
            }
        }
        for (p = 0; p < this.numLatent; ++p) {
            for (int q4 = 0; q4 < this.numLatent; ++q4) {
                this.Czz[p][q4] = this.bestCzz[p][q4];
            }
        }
        if (Double.isInfinite(bestScore)) {
            System.out.println("* * Warning: Heywood case in this step");
            return -1.7976931348623157E308;
        }
        return bestScore;
    }

    private void initializeGaussianEM(SemGraph semMag) {
        for (int i = 0; i < this.numLatent; ++i) {
            Node node = (Node)this.latentNodes.get(i);
            if (semMag.getParents(node).size() <= 0) continue;
            this.parentsLat[i] = new int[semMag.getParents(node).size() - 1];
            int count = 0;
            for (Node parent : semMag.getParents(node)) {
                if (parent.getNodeType() != NodeType.LATENT) continue;
                this.parentsLat[i][count++] = (Integer)this.latentNames.get(parent.getName());
            }
            this.parentsLatCov[i] = new double[this.parentsLat[i].length][this.parentsLat[i].length];
            this.parentsChildLatCov[i] = new double[this.parentsLat[i].length];
        }
        boolean[][] correlatedErrors = new boolean[this.numObserved][this.numObserved];
        for (int i = 0; i < this.numObserved; ++i) {
            for (int j = 0; j < this.numObserved; ++j) {
                correlatedErrors[i][j] = false;
            }
        }
        for (Edge nextEdge : semMag.getEdges()) {
            if (nextEdge.getEndpoint1() != Endpoint.ARROW || nextEdge.getEndpoint2() != Endpoint.ARROW) continue;
            Iterator<Node> it1 = semMag.getChildren(nextEdge.getNode1()).iterator();
            Node measure1 = it1.next();
            Iterator<Node> it2 = semMag.getChildren(nextEdge.getNode2()).iterator();
            Node measure2 = it2.next();
            correlatedErrors[((Integer)this.observableNames.get((Object)measure1.getName())).intValue()][((Integer)this.observableNames.get((Object)measure2.getName())).intValue()] = true;
            correlatedErrors[((Integer)this.observableNames.get((Object)measure2.getName())).intValue()][((Integer)this.observableNames.get((Object)measure1.getName())).intValue()] = true;
        }
        for (int i = 0; i < this.numObserved; ++i) {
            Node node = (Node)this.measuredNodes.get(i);
            this.parents[i] = new int[semMag.getParents(node).size() - 1];
            this.parentsL[i] = new boolean[semMag.getParents(node).size() - 1];
            int count = 0;
            for (Node parent : semMag.getParents(node)) {
                if (parent.getNodeType() == NodeType.LATENT) {
                    this.parents[i][count] = (Integer)this.latentNames.get(parent.getName());
                    this.parentsL[i][count++] = true;
                    continue;
                }
                if (parent.getNodeType() != NodeType.MEASURED) continue;
                this.parents[i][count] = (Integer)this.observableNames.get(parent.getName());
                this.parentsL[i][count++] = false;
            }
            int numCovar = 0;
            for (int j = 0; j < correlatedErrors.length; ++j) {
                if (i == j || !correlatedErrors[i][j]) continue;
                ++numCovar;
            }
            if (numCovar > 0) {
                this.spouses[i] = new int[numCovar];
                int countS = 0;
                for (int j = 0; j < this.numObserved; ++j) {
                    if (i == j || !correlatedErrors[i][j]) continue;
                    this.spouses[i][countS++] = j;
                }
                this.nSpouses[i] = countS;
            } else {
                this.spouses[i] = null;
                this.nSpouses[i] = 0;
            }
            this.parentsCov[i] = new double[this.parents[i].length][this.parents[i].length];
            this.parentsChildCov[i] = new double[this.parents[i].length];
            this.pseudoParentsCov[i] = new double[this.parents[i].length + this.nSpouses[i]][this.parents[i].length + this.nSpouses[i]];
            this.pseudoParentsChildCov[i] = new double[this.parents[i].length + this.nSpouses[i]];
            this.parentsResidualsCovar[i] = new double[this.parents[i].length][this.numLatent + this.numObserved - 1];
            this.selectedInverseOmega[i] = new double[this.nSpouses[i]][this.numLatent + this.numObserved - 1];
            this.auxInverseOmega[i] = new double[this.nSpouses[i]][this.numLatent + this.numObserved - 1];
        }
    }

    private void gaussianExpectation(SemIm semIm) {
        int j;
        int i;
        double[][] beta = new double[this.numLatent][this.numLatent];
        double[][] fi = new double[this.numLatent][this.numLatent];
        double[][] lambdaI = new double[this.numObserved][this.numObserved];
        double[][] lambdaL = new double[this.numObserved][this.numLatent];
        double[][] tau = new double[this.numObserved][this.numObserved];
        for (i = 0; i < this.numLatent; ++i) {
            for (j = 0; j < this.numLatent; ++j) {
                beta[i][j] = 0.0;
                fi[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numObserved; ++i) {
            for (j = 0; j < this.numLatent; ++j) {
                lambdaL[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numObserved; ++i) {
            for (j = 0; j < this.numObserved; ++j) {
                tau[i][j] = 0.0;
                lambdaI[i][j] = 0.0;
            }
        }
        List<Parameter> parameters = semIm.getFreeParameters();
        double[] paramValues = semIm.getFreeParamValues();
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            Parameter parameter = parameters.get(i2);
            if (parameter.getType() == ParamType.COEF) {
                int position2;
                int position1;
                Node from = parameter.getNodeA();
                Node to = parameter.getNodeB();
                if (to.getNodeType() == NodeType.MEASURED && from.getNodeType() == NodeType.LATENT) {
                    position1 = (Integer)this.latentNames.get(from.getName());
                    position2 = (Integer)this.observableNames.get(to.getName());
                    lambdaL[position2][position1] = paramValues[i2];
                    continue;
                }
                if (to.getNodeType() == NodeType.MEASURED && from.getNodeType() == NodeType.MEASURED) {
                    position1 = (Integer)this.observableNames.get(from.getName());
                    position2 = (Integer)this.observableNames.get(to.getName());
                    lambdaI[position2][position1] = paramValues[i2];
                    continue;
                }
                if (to.getNodeType() != NodeType.LATENT) continue;
                position1 = (Integer)this.latentNames.get(from.getName());
                position2 = (Integer)this.latentNames.get(to.getName());
                beta[position2][position1] = paramValues[i2];
                continue;
            }
            if (parameter.getType() == ParamType.VAR) {
                Node exo = parameter.getNodeA();
                if (exo.getNodeType() == NodeType.ERROR) {
                    Iterator<Node> ci = semIm.getSemPm().getGraph().getChildren(exo).iterator();
                    exo = ci.next();
                }
                if (exo.getNodeType() == NodeType.LATENT) {
                    fi[((Integer)this.latentNames.get((Object)exo.getName())).intValue()][((Integer)this.latentNames.get((Object)exo.getName())).intValue()] = paramValues[i2];
                    continue;
                }
                tau[((Integer)this.observableNames.get((Object)exo.getName())).intValue()][((Integer)this.observableNames.get((Object)exo.getName())).intValue()] = paramValues[i2];
                continue;
            }
            if (parameter.getType() != ParamType.COVAR) continue;
            Node exo1 = parameter.getNodeA();
            Node exo2 = parameter.getNodeB();
            exo1 = semIm.getSemPm().getGraph().getVarNode(exo1);
            exo2 = semIm.getSemPm().getGraph().getVarNode(exo2);
            double d = paramValues[i2];
            tau[((Integer)this.observableNames.get((Object)exo2.getName())).intValue()][((Integer)this.observableNames.get((Object)exo1.getName())).intValue()] = d;
            tau[((Integer)this.observableNames.get((Object)exo1.getName())).intValue()][((Integer)this.observableNames.get((Object)exo2.getName())).intValue()] = d;
        }
        double[][] identity = new double[this.numLatent][this.numLatent];
        for (int i3 = 0; i3 < this.numLatent; ++i3) {
            for (int j2 = 0; j2 < this.numLatent; ++j2) {
                identity[i3][j2] = i3 == j2 ? 1.0 : 0.0;
            }
        }
        double[][] identityI = new double[this.numObserved][this.numObserved];
        for (int i4 = 0; i4 < this.numObserved; ++i4) {
            for (int j3 = 0; j3 < this.numObserved; ++j3) {
                identityI[i4][j3] = i4 == j3 ? 1.0 : 0.0;
            }
        }
        double[][] iMinusB = MatrixUtils.inverse(MatrixUtils.subtract(identity, beta));
        double[][] latentImpliedCovar = MatrixUtils.product(iMinusB, MatrixUtils.product(fi, MatrixUtils.transpose(iMinusB)));
        double[][] iMinusI = MatrixUtils.inverse(MatrixUtils.subtract(identityI, lambdaI));
        double[][] indImpliedCovar = MatrixUtils.product(MatrixUtils.product(iMinusI, MatrixUtils.sum(MatrixUtils.product(MatrixUtils.product(lambdaL, latentImpliedCovar), MatrixUtils.transpose(lambdaL)), tau)), MatrixUtils.transpose(iMinusI));
        double[][] loadingLatentCovar = MatrixUtils.product(iMinusI, MatrixUtils.product(lambdaL, latentImpliedCovar));
        double[][] smallDelta = MatrixUtils.product(MatrixUtils.inverse(indImpliedCovar), loadingLatentCovar);
        double[][] bigDelta = MatrixUtils.subtract(latentImpliedCovar, MatrixUtils.product(MatrixUtils.transpose(loadingLatentCovar), smallDelta));
        this.Cyz = MatrixUtils.product(this.Cyy, smallDelta);
        this.Czz = MatrixUtils.sum(MatrixUtils.product(MatrixUtils.transpose(smallDelta), this.Cyz), bigDelta);
    }

    private double impurityScoreSearch(double initialScore) {
        double score;
        double nextScore = initialScore;
        boolean[] changed = new boolean[]{false};
        do {
            score = nextScore;
            nextScore = this.addImpuritySearch(score, changed);
            if (!changed[0]) continue;
            changed[0] = false;
            nextScore = this.deleteImpuritySearch(nextScore, changed);
        } while (changed[0]);
        return score;
    }

    private double addImpuritySearch(double initialScore, boolean[] changed) {
        double score;
        double nextScore = initialScore;
        int choiceType = -1;
        do {
            score = nextScore;
            int bestChoice1 = -1;
            int bestChoice2 = -1;
            for (int i = 0; i < this.numObserved; ++i) {
                for (int j = i + 1; j < this.numObserved; ++j) {
                    if (this.forbiddenImpurity(this.measuredNodes.get(i).toString(), this.measuredNodes.get(j).toString()) || this.correlatedErrors[i][j] || this.observedParent[i][j] || this.observedParent[j][i]) continue;
                    this.correlatedErrors[j][i] = true;
                    this.correlatedErrors[i][j] = true;
                    double newScore = this.scoreCandidate();
                    if (newScore > nextScore) {
                        nextScore = newScore;
                        bestChoice1 = i;
                        bestChoice2 = j;
                        choiceType = 2;
                    }
                    this.correlatedErrors[j][i] = false;
                    this.correlatedErrors[i][j] = false;
                }
            }
            if (bestChoice1 == -1) continue;
            this.modifiedGraph = true;
            switch (choiceType) {
                case 0: {
                    this.latentParent[bestChoice1][bestChoice2] = true;
                    System.out.println("****************************Added impurity: " + this.latentNodes.get(bestChoice2).toString() + " --> " + this.measuredNodes.get(bestChoice1).toString() + " " + nextScore);
                    break;
                }
                case 1: {
                    this.observedParent[bestChoice1][bestChoice2] = true;
                    System.out.println("****************************Added impurity: " + this.measuredNodes.get(bestChoice2).toString() + " --> " + this.measuredNodes.get(bestChoice1).toString() + " " + nextScore);
                    break;
                }
                case 2: {
                    System.out.println("****************************Added impurity: " + this.measuredNodes.get(bestChoice1).toString() + " <--> " + this.measuredNodes.get(bestChoice2).toString() + " " + nextScore);
                    this.correlatedErrors[bestChoice2][bestChoice1] = true;
                    this.correlatedErrors[bestChoice1][bestChoice2] = true;
                }
            }
            changed[0] = true;
        } while (score < nextScore);
        this.printlnMessage("End of addition round");
        return score;
    }

    private double deleteImpuritySearch(double initialScore, boolean[] changed) {
        double score;
        double nextScore = initialScore;
        int choiceType = -1;
        do {
            score = nextScore;
            int bestChoice1 = -1;
            int bestChoice2 = -1;
            for (int i = 0; i < this.numObserved - 1; ++i) {
                for (int j = i + 1; j < this.numObserved; ++j) {
                    if (this.observedParent[i][j] || this.observedParent[j][i]) {
                        boolean directionIJ = this.observedParent[i][j];
                        this.observedParent[j][i] = false;
                        this.observedParent[i][j] = false;
                        double newScore = this.scoreCandidate();
                        if (newScore > nextScore) {
                            nextScore = newScore;
                            bestChoice1 = i;
                            bestChoice2 = j;
                            choiceType = 0;
                        }
                        if (directionIJ) {
                            this.observedParent[i][j] = true;
                        } else {
                            this.observedParent[j][i] = true;
                        }
                    }
                    if (!this.correlatedErrors[i][j]) continue;
                    this.correlatedErrors[j][i] = false;
                    this.correlatedErrors[i][j] = false;
                    double newScore = this.scoreCandidate();
                    if (newScore > nextScore) {
                        nextScore = newScore;
                        bestChoice1 = i;
                        bestChoice2 = j;
                        choiceType = 1;
                    }
                    this.correlatedErrors[j][i] = true;
                    this.correlatedErrors[i][j] = true;
                }
            }
            if (bestChoice1 == -1) continue;
            this.modifiedGraph = true;
            switch (choiceType) {
                case 0: {
                    if (this.observedParent[bestChoice1][bestChoice2]) {
                        System.out.println("****************************Removed impurity: " + this.measuredNodes.get(bestChoice2).toString() + " --> " + this.measuredNodes.get(bestChoice1).toString() + " " + nextScore);
                    } else {
                        System.out.println("****************************Removed impurity: " + this.measuredNodes.get(bestChoice1).toString() + " --> " + this.measuredNodes.get(bestChoice2).toString() + " " + nextScore);
                    }
                    this.observedParent[bestChoice2][bestChoice1] = false;
                    this.observedParent[bestChoice1][bestChoice2] = false;
                    break;
                }
                case 1: {
                    System.out.println("****************************Removed impurity: " + this.measuredNodes.get(bestChoice1).toString() + " <--> " + this.measuredNodes.get(bestChoice2).toString() + " " + nextScore);
                    this.correlatedErrors[bestChoice2][bestChoice1] = false;
                    this.correlatedErrors[bestChoice1][bestChoice2] = false;
                }
            }
            changed[0] = true;
        } while (score < nextScore);
        this.printlnMessage("End of deletion round");
        return score;
    }

    private boolean forbiddenImpurity(String name1, String name2) {
        if (this.forbiddenList == null) {
            return false;
        }
        for (Set nextPair : this.forbiddenList) {
            if (!nextPair.contains(name1) || !nextPair.contains(name2)) continue;
            return true;
        }
        return false;
    }

    private double scoreCandidate() {
        SemGraph graph = this.updatedGraph();
        graph.setShowErrorTerms(true);
        this.initializeGaussianEM(graph);
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm, this.covarianceMatrix);
        this.gaussianMaximization(semIm);
        return -semIm.getTruncLL() - 0.5 * (double)semIm.getNumFreeParams() * Math.log(this.covarianceMatrix.getSampleSize());
    }

    private SemGraph updatedGraph() {
        SemGraph output = new SemGraph(this.basicGraph);
        output.setShowErrorTerms(true);
        for (int i = 0; i < output.getNodes().size() - 1; ++i) {
            Node node2;
            int j;
            Node node1 = output.getNodes().get(i);
            if (node1.getNodeType() != NodeType.MEASURED) continue;
            for (j = 0; j < output.getNodes().size(); ++j) {
                int pos2;
                int pos1;
                node2 = output.getNodes().get(j);
                if (node2.getNodeType() != NodeType.LATENT || !this.latentParent[pos1 = ((Integer)this.observableNames.get(((Object)output.getNodes().get(i)).toString())).intValue()][pos2 = ((Integer)this.latentNames.get(((Object)output.getNodes().get(j)).toString())).intValue()] || output.getEdge(node1, node2) != null) continue;
                output.addDirectedEdge(node2, node1);
            }
            for (j = i + 1; j < output.getNodes().size(); ++j) {
                int pos2;
                node2 = output.getNodes().get(j);
                if (node2.getNodeType() != NodeType.MEASURED) continue;
                Node errnode1 = output.getErrorNode(output.getNodes().get(i));
                Node errnode2 = output.getErrorNode(output.getNodes().get(j));
                int pos1 = (Integer)this.observableNames.get(((Object)output.getNodes().get(i)).toString());
                if (this.correlatedErrors[pos1][pos2 = ((Integer)this.observableNames.get(((Object)output.getNodes().get(j)).toString())).intValue()] && output.getEdge(errnode1, errnode2) == null) {
                    output.addBidirectedEdge(errnode1, errnode2);
                }
                if (this.observedParent[pos1][pos2] && output.getEdge(node1, node2) == null) {
                    output.addDirectedEdge(node2, node1);
                    continue;
                }
                if (!this.observedParent[pos2][pos1] || output.getEdge(node1, node2) != null) continue;
                output.addDirectedEdge(node1, node2);
            }
        }
        return output;
    }

    private double gaussianMaximization(SemIm semIm) {
        int i;
        double change;
        int i2;
        int j;
        int i3;
        for (i3 = 0; i3 < this.numObserved; ++i3) {
            for (j = 0; j < this.numObserved + this.numLatent; ++j) {
                this.betas[i3][j] = 0.0;
            }
        }
        for (i3 = 0; i3 < this.numLatent; ++i3) {
            for (j = 0; j < this.numLatent; ++j) {
                this.betasLat[i3][j] = 0.0;
            }
        }
        for (i3 = 0; i3 < this.numObserved; ++i3) {
            for (j = 0; j < this.numObserved; ++j) {
                this.covErrors[i3][j] = 0.0;
            }
        }
        for (Parameter nextP : semIm.getFreeParameters()) {
            Node exo;
            if (nextP.getType() == ParamType.COEF) {
                int index2;
                int index1;
                Node node1 = nextP.getNodeA();
                Node node2 = nextP.getNodeB();
                if (node1.getNodeType() == NodeType.LATENT && node2.getNodeType() == NodeType.LATENT) continue;
                Node latent = null;
                Node observed = null;
                if (node1.getNodeType() == NodeType.LATENT) {
                    latent = node1;
                    observed = node2;
                } else if (node2.getNodeType() == NodeType.LATENT) {
                    latent = node2;
                    observed = node1;
                }
                if (latent != null) {
                    index1 = (Integer)this.latentNames.get(latent.getName());
                    index2 = (Integer)this.observableNames.get(observed.getName());
                    this.betas[index2][index1] = semIm.getParamValue(nextP);
                    continue;
                }
                index1 = (Integer)this.observableNames.get(node1.getName());
                index2 = (Integer)this.observableNames.get(node2.getName());
                if (semIm.getSemPm().getGraph().isParentOf(node1, node2)) {
                    this.betas[index2][this.numLatent + index1] = semIm.getParamValue(nextP);
                    continue;
                }
                this.betas[index1][this.numLatent + index2] = semIm.getParamValue(nextP);
                continue;
            }
            if (nextP.getType() == ParamType.COVAR) {
                Node exo1 = nextP.getNodeA();
                Node exo2 = nextP.getNodeB();
                exo1 = semIm.getSemPm().getGraph().getVarNode(exo1);
                exo2 = semIm.getSemPm().getGraph().getVarNode(exo2);
                int index1 = (Integer)this.observableNames.get(exo1.getName());
                int index2 = (Integer)this.observableNames.get(exo2.getName());
                double d = semIm.getParamValue(nextP);
                this.covErrors[index2][index1] = d;
                this.covErrors[index1][index2] = d;
                continue;
            }
            if (nextP.getType() != ParamType.VAR || (exo = nextP.getNodeA()).getNodeType() == NodeType.LATENT || (exo = semIm.getSemPm().getGraph().getVarNode(exo)).getNodeType() != NodeType.MEASURED) continue;
            int index = (Integer)this.observableNames.get(exo.getName());
            this.covErrors[index][index] = semIm.getParamValue(nextP);
        }
        this.varErrorLatent[0] = this.Czz[0][0];
        for (i2 = 1; i2 < this.numLatent; ++i2) {
            for (int j2 = 0; j2 < this.parentsLat[i2].length; ++j2) {
                this.parentsChildLatCov[i2][j2] = this.Czz[i2][this.parentsLat[i2][j2]];
                for (int k = j2; k < this.parentsLat[i2].length; ++k) {
                    this.parentsLatCov[i2][j2][k] = this.Czz[this.parentsLat[i2][j2]][this.parentsLat[i2][k]];
                    this.parentsLatCov[i2][k][j2] = this.parentsLatCov[i2][j2][k];
                }
            }
            double[] betaL = MatrixUtils.product(MatrixUtils.inverse(this.parentsLatCov[i2]), this.parentsChildLatCov[i2]);
            this.varErrorLatent[i2] = this.Czz[i2][i2] - MatrixUtils.innerProduct(this.parentsChildLatCov[i2], betaL);
            for (int j3 = 0; j3 < this.parentsLat[i2].length; ++j3) {
                this.betasLat[i2][this.parentsLat[i2][j3]] = betaL[j3];
            }
        }
        for (i2 = 0; i2 < this.numObserved; ++i2) {
            for (int j4 = 0; j4 < this.parents[i2].length; ++j4) {
                this.parentsChildCov[i2][j4] = this.parentsL[i2][j4] ? this.Cyz[i2][this.parents[i2][j4]] : this.Cyy[i2][this.parents[i2][j4]];
                for (int k = j4; k < this.parents[i2].length; ++k) {
                    this.parentsCov[i2][j4][k] = this.parentsL[i2][j4] && this.parentsL[i2][k] ? this.Czz[this.parents[i2][j4]][this.parents[i2][k]] : (!this.parentsL[i2][j4] && this.parentsL[i2][k] ? this.Cyz[this.parents[i2][j4]][this.parents[i2][k]] : (this.parentsL[i2][j4] && !this.parentsL[i2][k] ? this.Cyz[this.parents[i2][k]][this.parents[i2][j4]] : this.Cyy[this.parents[i2][j4]][this.parents[i2][k]]));
                    this.parentsCov[i2][k][j4] = this.parentsCov[i2][j4][k];
                }
            }
        }
        int iter = 0;
        do {
            for (i = 0; i < this.covErrors.length; ++i) {
                for (int j5 = 0; j5 < this.covErrors.length; ++j5) {
                    this.oldCovErrors[i][j5] = this.covErrors[i][j5];
                }
            }
            for (i = 0; i < this.numObserved; ++i) {
                for (int j6 = 0; j6 < this.betas[i].length; ++j6) {
                    this.oldBetas[i][j6] = this.betas[i][j6];
                }
            }
            for (i = 0; i < this.numObserved; ++i) {
                int j7;
                int k;
                int ii;
                int j8;
                int ii2;
                for (ii2 = 0; ii2 < this.omega.length; ++ii2) {
                    for (int j9 = 0; j9 < this.omega.length; ++j9) {
                        this.omega[ii2][j9] = 0.0;
                    }
                }
                for (ii2 = 0; ii2 < this.numLatent; ++ii2) {
                    this.omegaI[ii2] = 0.0;
                    this.omega[ii2][ii2] = this.varErrorLatent[ii2];
                }
                for (ii2 = 0; ii2 < this.numObserved; ++ii2) {
                    if (ii2 > i) {
                        this.omegaI[this.numLatent + ii2 - 1] = this.covErrors[i][ii2];
                        this.omega[this.numLatent + ii2 - 1][this.numLatent + ii2 - 1] = this.covErrors[ii2][ii2];
                        continue;
                    }
                    if (ii2 >= i) continue;
                    this.omegaI[this.numLatent + ii2] = this.covErrors[i][ii2];
                    this.omega[this.numLatent + ii2][this.numLatent + ii2] = this.covErrors[ii2][ii2];
                }
                for (ii2 = 0; ii2 < this.numObserved; ++ii2) {
                    int index_ii;
                    if (ii2 > i) {
                        index_ii = this.numLatent + ii2 - 1;
                    } else {
                        if (ii2 >= i) continue;
                        index_ii = this.numLatent + ii2;
                    }
                    for (int j10 = 0; j10 < this.nSpouses[ii2]; ++j10) {
                        if (this.spouses[ii2][j10] > i) {
                            this.omega[index_ii][this.numLatent + this.spouses[ii2][j10] - 1] = this.covErrors[ii2][this.spouses[ii2][j10]];
                            continue;
                        }
                        if (this.spouses[ii2][j10] >= i) continue;
                        this.omega[index_ii][this.numLatent + this.spouses[ii2][j10]] = this.covErrors[ii2][this.spouses[ii2][j10]];
                    }
                }
                for (ii2 = 0; ii2 < this.numObserved; ++ii2) {
                    if (ii2 == i) continue;
                    for (int j11 = ii2; j11 < this.numObserved; ++j11) {
                        int p;
                        if (j11 == i) continue;
                        this.sampleCovErrors[ii2][j11] = this.Cyy[ii2][j11];
                        for (p = 0; p < this.parents[ii2].length; ++p) {
                            if (this.parentsL[ii2][p]) {
                                double[] dArray = this.sampleCovErrors[ii2];
                                int n = j11;
                                dArray[n] = dArray[n] - this.betas[ii2][this.parents[ii2][p]] * this.Cyz[j11][this.parents[ii2][p]];
                                continue;
                            }
                            double[] dArray = this.sampleCovErrors[ii2];
                            int n = j11;
                            dArray[n] = dArray[n] - this.betas[ii2][this.numLatent + this.parents[ii2][p]] * this.Cyy[j11][this.parents[ii2][p]];
                        }
                        for (p = 0; p < this.parents[j11].length; ++p) {
                            if (this.parentsL[j11][p]) {
                                double[] dArray = this.sampleCovErrors[ii2];
                                int n = j11;
                                dArray[n] = dArray[n] - this.betas[j11][this.parents[j11][p]] * this.Cyz[ii2][this.parents[j11][p]];
                                continue;
                            }
                            double[] dArray = this.sampleCovErrors[ii2];
                            int n = j11;
                            dArray[n] = dArray[n] - this.betas[j11][this.numLatent + this.parents[j11][p]] * this.Cyy[ii2][this.parents[j11][p]];
                        }
                        for (int p1 = 0; p1 < this.parents[ii2].length; ++p1) {
                            for (int p2 = 0; p2 < this.parents[j11].length; ++p2) {
                                if (this.parentsL[ii2][p1] && this.parentsL[j11][p2]) {
                                    double[] dArray = this.sampleCovErrors[ii2];
                                    int n = j11;
                                    dArray[n] = dArray[n] + this.betas[ii2][this.parents[ii2][p1]] * this.betas[j11][this.parents[j11][p2]] * this.Czz[this.parents[ii2][p1]][this.parents[j11][p2]];
                                    continue;
                                }
                                if (this.parentsL[ii2][p1] && !this.parentsL[j11][p2]) {
                                    double[] dArray = this.sampleCovErrors[ii2];
                                    int n = j11;
                                    dArray[n] = dArray[n] + this.betas[ii2][this.parents[ii2][p1]] * this.betas[j11][this.numLatent + this.parents[j11][p2]] * this.Cyz[this.parents[j11][p2]][this.parents[ii2][p1]];
                                    continue;
                                }
                                if (!this.parentsL[ii2][p1] && this.parentsL[j11][p2]) {
                                    double[] dArray = this.sampleCovErrors[ii2];
                                    int n = j11;
                                    dArray[n] = dArray[n] + this.betas[ii2][this.numLatent + this.parents[ii2][p1]] * this.betas[j11][this.parents[j11][p2]] * this.Cyz[this.parents[ii2][p1]][this.parents[j11][p2]];
                                    continue;
                                }
                                double[] dArray = this.sampleCovErrors[ii2];
                                int n = j11;
                                dArray[n] = dArray[n] + this.betas[ii2][this.numLatent + this.parents[ii2][p1]] * this.betas[j11][this.numLatent + this.parents[j11][p2]] * this.Cyy[this.parents[ii2][p1]][this.parents[j11][p2]];
                            }
                        }
                        this.sampleCovErrors[j11][ii2] = this.sampleCovErrors[ii2][j11];
                    }
                }
                for (ii2 = 0; ii2 < this.parents[i].length; ++ii2) {
                    int j12;
                    this.parentsResidualsCovar[i][ii2][0] = this.parentsL[i][ii2] ? this.Czz[this.parents[i][ii2]][0] : this.Cyz[this.parents[i][ii2]][0];
                    for (j12 = 1; j12 < this.numLatent; ++j12) {
                        int p;
                        if (this.parentsL[i][ii2]) {
                            this.parentsResidualsCovar[i][ii2][j12] = this.Czz[this.parents[i][ii2]][j12];
                            for (p = 0; p < this.parentsLat[j12].length; ++p) {
                                double[] dArray = this.parentsResidualsCovar[i][ii2];
                                int n = j12;
                                dArray[n] = dArray[n] - this.betasLat[j12][this.parentsLat[j12][p]] * this.Czz[this.parents[i][ii2]][this.parentsLat[j12][p]];
                            }
                            continue;
                        }
                        this.parentsResidualsCovar[i][ii2][j12] = this.Cyz[this.parents[i][ii2]][j12];
                        for (p = 0; p < this.parentsLat[j12].length; ++p) {
                            double[] dArray = this.parentsResidualsCovar[i][ii2];
                            int n = j12;
                            dArray[n] = dArray[n] - this.betasLat[j12][this.parentsLat[j12][p]] * this.Cyz[this.parents[i][ii2]][this.parentsLat[j12][p]];
                        }
                    }
                    for (j12 = 0; j12 < this.numObserved; ++j12) {
                        int p;
                        int index_j;
                        if (j12 < i) {
                            index_j = this.numLatent + j12;
                        } else {
                            if (j12 <= i) continue;
                            index_j = this.numLatent + j12 - 1;
                        }
                        if (this.parentsL[i][ii2]) {
                            this.parentsResidualsCovar[i][ii2][index_j] = this.Cyz[j12][this.parents[i][ii2]];
                            for (p = 0; p < this.parents[j12].length; ++p) {
                                if (this.parentsL[j12][p]) {
                                    double[] dArray = this.parentsResidualsCovar[i][ii2];
                                    int n = index_j;
                                    dArray[n] = dArray[n] - this.betas[j12][this.parents[j12][p]] * this.Czz[this.parents[i][ii2]][this.parents[j12][p]];
                                    continue;
                                }
                                double[] dArray = this.parentsResidualsCovar[i][ii2];
                                int n = index_j;
                                dArray[n] = dArray[n] - this.betas[j12][this.numLatent + this.parents[j12][p]] * this.Cyz[this.parents[j12][p]][this.parents[i][ii2]];
                            }
                            continue;
                        }
                        this.parentsResidualsCovar[i][ii2][index_j] = this.Cyy[j12][this.parents[i][ii2]];
                        for (p = 0; p < this.parents[j12].length; ++p) {
                            if (this.parentsL[j12][p]) {
                                double[] dArray = this.parentsResidualsCovar[i][ii2];
                                int n = index_j;
                                dArray[n] = dArray[n] - this.betas[j12][this.parents[j12][p]] * this.Cyz[this.parents[i][ii2]][this.parents[j12][p]];
                                continue;
                            }
                            double[] dArray = this.parentsResidualsCovar[i][ii2];
                            int n = index_j;
                            dArray[n] = dArray[n] - this.betas[j12][this.numLatent + this.parents[j12][p]] * this.Cyy[this.parents[j12][p]][this.parents[i][ii2]];
                        }
                    }
                }
                this.iResidualsCovar[0] = this.Cyz[i][0];
                for (j8 = 1; j8 < this.numLatent; ++j8) {
                    this.iResidualsCovar[j8] = this.Cyz[i][j8];
                    for (int p = 0; p < this.parentsLat[j8].length; ++p) {
                        int n = j8;
                        this.iResidualsCovar[n] = this.iResidualsCovar[n] - this.betasLat[j8][this.parentsLat[j8][p]] * this.Cyz[i][this.parentsLat[j8][p]];
                    }
                }
                for (j8 = 0; j8 < this.numObserved; ++j8) {
                    int index_j;
                    if (j8 < i) {
                        index_j = this.numLatent + j8;
                    } else {
                        if (j8 <= i) continue;
                        index_j = this.numLatent + j8 - 1;
                    }
                    this.iResidualsCovar[index_j] = this.Cyy[i][j8];
                    for (int p = 0; p < this.parents[j8].length; ++p) {
                        if (this.parentsL[j8][p]) {
                            int n = index_j;
                            this.iResidualsCovar[n] = this.iResidualsCovar[n] - this.betas[j8][this.parents[j8][p]] * this.Cyz[i][this.parents[j8][p]];
                            continue;
                        }
                        int n = index_j;
                        this.iResidualsCovar[n] = this.iResidualsCovar[n] - this.betas[j8][this.numLatent + this.parents[j8][p]] * this.Cyy[i][this.parents[j8][p]];
                    }
                }
                double[][] inverseOmega = MatrixUtils.inverse(this.omega);
                for (ii = 0; ii < this.nSpouses[i]; ++ii) {
                    int sp_index = this.spouses[i][ii] > i ? this.numLatent + this.spouses[i][ii] - 1 : this.numLatent + this.spouses[i][ii];
                    for (int j13 = 0; j13 < this.numLatent + this.numObserved - 1; ++j13) {
                        this.selectedInverseOmega[i][ii][j13] = inverseOmega[sp_index][j13];
                    }
                }
                for (ii = 0; ii < this.nSpouses[i]; ++ii) {
                    int j14;
                    for (j14 = 0; j14 < this.numLatent; ++j14) {
                        this.auxInverseOmega[i][ii][j14] = this.selectedInverseOmega[i][ii][j14] * this.varErrorLatent[j14];
                    }
                    for (j14 = 0; j14 < this.numObserved; ++j14) {
                        int index_j;
                        if (j14 > i) {
                            index_j = this.numLatent + j14 - 1;
                        } else {
                            if (j14 >= i) continue;
                            index_j = this.numLatent + j14;
                        }
                        this.auxInverseOmega[i][ii][index_j] = 0.0;
                        for (int k2 = 0; k2 < this.numObserved; ++k2) {
                            int index_k;
                            if (k2 > i) {
                                index_k = this.numLatent + k2 - 1;
                            } else {
                                if (k2 >= i) continue;
                                index_k = this.numLatent + k2;
                            }
                            double[] dArray = this.auxInverseOmega[i][ii];
                            int n = index_j;
                            dArray[n] = dArray[n] + this.selectedInverseOmega[i][ii][index_k] * this.sampleCovErrors[k2][j14];
                        }
                    }
                }
                for (ii = 0; ii < this.parents[i].length; ++ii) {
                    for (int j15 = ii; j15 < this.parents[i].length; ++j15) {
                        double d = this.parentsCov[i][ii][j15];
                        this.pseudoParentsCov[i][j15][ii] = d;
                        this.pseudoParentsCov[i][ii][j15] = d;
                    }
                }
                for (ii = 0; ii < this.parents[i].length; ++ii) {
                    for (int j16 = 0; j16 < this.nSpouses[i]; ++j16) {
                        this.pseudoParentsCov[i][ii][this.parents[i].length + j16] = 0.0;
                        for (k = 0; k < this.numLatent + this.numObserved - 1; ++k) {
                            double[] dArray = this.pseudoParentsCov[i][ii];
                            int n = this.parents[i].length + j16;
                            dArray[n] = dArray[n] + this.parentsResidualsCovar[i][ii][k] * this.selectedInverseOmega[i][j16][k];
                        }
                        this.pseudoParentsCov[i][this.parents[i].length + j16][ii] = this.pseudoParentsCov[i][ii][this.parents[i].length + j16];
                    }
                }
                block56: for (ii = 0; ii < this.nSpouses[i]; ++ii) {
                    for (int j17 = ii; j17 < this.nSpouses[i]; ++j17) {
                        this.pseudoParentsCov[i][this.parents[i].length + ii][this.parents[i].length + j17] = 0.0;
                        for (k = 0; k < this.numLatent + this.numObserved - 1; ++k) {
                            double[] dArray = this.pseudoParentsCov[i][this.parents[i].length + ii];
                            int n = this.parents[i].length + j17;
                            dArray[n] = dArray[n] + this.auxInverseOmega[i][ii][k] * this.selectedInverseOmega[i][j17][k];
                        }
                        this.pseudoParentsCov[i][this.parents[i].length + j17][this.parents[i].length + ii] = this.pseudoParentsCov[i][this.parents[i].length + ii][this.parents[i].length + j17];
                        if (this.pseudoParentsCov[i][this.parents[i].length + j17][this.parents[i].length + ii] != 0.0) continue;
                        System.out.println("Zero here... Iter = " + iter);
                        iter = 1000;
                        continue block56;
                    }
                }
                for (ii = 0; ii < this.parents[i].length; ++ii) {
                    this.pseudoParentsChildCov[i][ii] = this.parentsChildCov[i][ii];
                }
                for (int j18 = 0; j18 < this.nSpouses[i]; ++j18) {
                    this.pseudoParentsChildCov[i][this.parents[i].length + j18] = 0.0;
                    for (int k3 = 0; k3 < this.numLatent + this.numObserved - 1; ++k3) {
                        double[] dArray = this.pseudoParentsChildCov[i];
                        int n = this.parents[i].length + j18;
                        dArray[n] = dArray[n] + this.selectedInverseOmega[i][j18][k3] * this.iResidualsCovar[k3];
                    }
                }
                double[] params = MatrixUtils.product(MatrixUtils.inverse(this.pseudoParentsCov[i]), this.pseudoParentsChildCov[i]);
                for (j7 = 0; j7 < this.parents[i].length; ++j7) {
                    if (this.parentsL[i][j7]) {
                        this.betas[i][this.parents[i][j7]] = params[j7];
                        continue;
                    }
                    this.betas[i][this.numLatent + this.parents[i][j7]] = params[j7];
                }
                for (j7 = 0; j7 < this.nSpouses[i]; ++j7) {
                    double d = params[this.parents[i].length + j7];
                    this.covErrors[this.spouses[i][j7]][i] = d;
                    this.covErrors[i][this.spouses[i][j7]] = d;
                    if (this.spouses[i][j7] > i) {
                        this.omegaI[this.numLatent + this.spouses[i][j7] - 1] = params[this.parents[i].length + j7];
                        continue;
                    }
                    this.omegaI[this.numLatent + this.spouses[i][j7]] = params[this.parents[i].length + j7];
                }
                double conditionalVar = this.Cyy[i][i] - MatrixUtils.innerProduct(this.pseudoParentsChildCov[i], params);
                this.covErrors[i][i] = conditionalVar + MatrixUtils.innerProduct(MatrixUtils.product(this.omegaI, inverseOmega), this.omegaI);
            }
            change = 0.0;
            for (i = 0; i < this.covErrors.length; ++i) {
                for (int j19 = i; j19 < this.covErrors.length; ++j19) {
                    change += Math.abs(this.oldCovErrors[i][j19] - this.covErrors[i][j19]);
                }
            }
            for (i = 0; i < this.numObserved; ++i) {
                for (int j20 = 0; j20 < this.betas[i].length; ++j20) {
                    change += Math.abs(this.oldBetas[i][j20] - this.betas[i][j20]);
                }
            }
        } while (++iter < 200 && change > 0.01);
        try {
            for (i = 0; i < this.numObserved; ++i) {
                int j21;
                Node node = semIm.getSemPm().getGraph().getNode(this.measuredNodes.get(i).toString());
                Node nodeErrorTerm = semIm.getSemPm().getGraph().getExogenous(node);
                for (j21 = 0; j21 < this.parents[i].length; ++j21) {
                    Node parent = this.parentsL[i][j21] ? semIm.getSemPm().getGraph().getNode(this.latentNodes.get(this.parents[i][j21]).toString()) : semIm.getSemPm().getGraph().getNode(this.measuredNodes.get(this.parents[i][j21]).toString());
                    if (this.parentsL[i][j21]) {
                        semIm.setParamValue(parent, node, this.betas[i][this.parents[i][j21]]);
                        continue;
                    }
                    semIm.setParamValue(parent, node, this.betas[i][this.numLatent + this.parents[i][j21]]);
                }
                for (j21 = 0; j21 < this.nSpouses[i]; ++j21) {
                    if (this.spouses[i][j21] <= i) continue;
                    Node spouse = semIm.getSemPm().getGraph().getNode(this.measuredNodes.get(this.spouses[i][j21]).toString());
                    Node spouseErrorTerm = semIm.getSemPm().getGraph().getExogenous(spouse);
                    semIm.setParamValue(nodeErrorTerm, spouseErrorTerm, this.covErrors[i][this.spouses[i][j21]]);
                }
            }
            for (i = 0; i < this.numLatent; ++i) {
                Node node = semIm.getSemPm().getGraph().getNode(this.latentNodes.get(i).toString());
                if (semIm.getSemPm().getGraph().getParents(node).size() == 0) {
                    semIm.setParamValue(node, node, this.varErrorLatent[i]);
                    continue;
                }
                for (Node nextParent : semIm.getSemPm().getGraph().getParents(node)) {
                    if (nextParent.getNodeType() != NodeType.ERROR) continue;
                    semIm.setParamValue(nextParent, nextParent, this.varErrorLatent[i]);
                    break;
                }
                for (int j22 = 0; j22 < this.parentsLat[i].length; ++j22) {
                    Node parent = semIm.getSemPm().getGraph().getNode(this.latentNodes.get(this.parentsLat[i][j22]).toString());
                    semIm.setParamValue(parent, node, this.betasLat[i][this.parentsLat[i][j22]]);
                }
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("** Warning: " + e.toString());
            return -1.7976931348623157E308;
        }
        return -semIm.getTruncLL() - 0.5 * (double)semIm.getNumFreeParams() * Math.log(this.covarianceMatrix.getSampleSize());
    }

    private SemGraph pvalueBasedPurify(List partition) {
        this.structuralEmInitialization(partition);
        SemPm semPm0 = new SemPm(this.purePartitionGraph);
        MimBuildEstimator estimator0 = new MimBuildEstimator(this.covarianceMatrix, semPm0, 5, 5);
        estimator0.estimate();
        SemIm bestModel = estimator0.getEstimatedSem();
        double bestPValue = bestModel.getPValue();
        double bestScore = -bestModel.getChiSquare();
        this.printlnMessage("* Greedy removal by p-value - Initial pvalue = " + bestPValue);
        boolean noDelete = false;
        int round = 1;
        ArrayList currentMeasuredNodes = new ArrayList();
        currentMeasuredNodes.addAll(this.measuredNodes);
        while (bestPValue < 0.05 && !noDelete && currentMeasuredNodes.size() > 4) {
            this.printlnMessage("*** Starting round" + round++);
            noDelete = true;
            SemIm bestInRound = bestModel;
            Object nodeToDelete = null;
            for (int i = 0; i < currentMeasuredNodes.size(); ++i) {
                SemGraph newGraph = new SemGraph(bestModel.getSemPm().getGraph());
                Node next = bestModel.getSemPm().getGraph().getNode(currentMeasuredNodes.get(i).toString());
                this.printMessage("Removing node " + ((Object)next).toString());
                for (Node nextP : newGraph.getParents(next)) {
                    if (nextP.getNodeType() != NodeType.LATENT || newGraph.getChildren(nextP).size() != 1) continue;
                    newGraph.removeNode(nextP);
                    break;
                }
                newGraph.removeNode(next);
                SemPm semPm = new SemPm(newGraph);
                SemIm nextModel = new SemIm(semPm);
                nextModel.setCovMatrix(this.covarianceMatrix);
                MimBuildEstimator estimator = new MimBuildEstimator(this.covarianceMatrix, semPm, 5, 5);
                estimator.estimate();
                nextModel = estimator.getEstimatedSem();
                this.printlnMessage(" * pvalue = " + nextModel.getPValue() + " * chisq = " + nextModel.getChiSquare());
                double newScore = -nextModel.getChiSquare();
                if (!(newScore > bestScore)) continue;
                noDelete = false;
                nodeToDelete = (Node)currentMeasuredNodes.get(i);
                bestScore = newScore;
                bestPValue = nextModel.getPValue();
                bestInRound = nextModel;
                this.printlnMessage(">> best so far");
            }
            bestModel = bestInRound;
            if (nodeToDelete == null) continue;
            currentMeasuredNodes.remove(nodeToDelete);
            this.printlnMessage("Node removed: " + nodeToDelete.toString());
        }
        if (bestPValue < 0.05) {
            return null;
        }
        ArrayList<int[]> newPartition = new ArrayList<int[]>();
        for (Node next : bestModel.getSemPm().getGraph().getNodes()) {
            if (next.getNodeType() != NodeType.LATENT) continue;
            List<Node> children = bestModel.getSemPm().getGraph().getChildren(next);
            ArrayList<Node> nextSet = new ArrayList<Node>();
            for (Node nextC : children) {
                if (nextC.getNodeType() != NodeType.MEASURED) continue;
                nextSet.add(nextC);
            }
            int[] nextArray = new int[nextSet.size()];
            for (int i = 0; i < nextArray.length; ++i) {
                nextArray[i] = (Integer)this.observableNames.get(nextSet.get(i).toString());
            }
            newPartition.add(nextArray);
        }
        return bestModel.getSemPm().getGraph();
    }

    private SemGraph removeMarkedImpurities(SemGraph graph, boolean[][] impurities) {
        int i;
        int i2;
        this.printlnMessage();
        this.printlnMessage("** PURIFY: using marked impure pairs");
        ArrayList<Node> latents = new ArrayList<Node>();
        ArrayList<int[]> partition = new ArrayList<int[]>();
        for (i2 = 0; i2 < graph.getNodes().size(); ++i2) {
            Node nextLatent = graph.getNodes().get(i2);
            if (nextLatent.getNodeType() != NodeType.LATENT) continue;
            latents.add(graph.getNodes().get(i2));
            Iterator<Node> cit = graph.getChildren(nextLatent).iterator();
            ArrayList<Node> children = new ArrayList<Node>();
            while (cit.hasNext()) {
                Node cnext = cit.next();
                if (cnext.getNodeType() != NodeType.MEASURED) continue;
                children.add(cnext);
            }
            int[] newCluster = new int[children.size()];
            for (int j = 0; j < children.size(); ++j) {
                newCluster[j] = (Integer)this.observableNames.get(children.get(j).toString());
            }
            partition.add(newCluster);
        }
        for (i2 = 0; i2 < impurities.length - 1; ++i2) {
            for (int j = i2 + 1; j < impurities.length; ++j) {
                if (!impurities[i2][j]) continue;
                System.out.println(this.measuredNodes.get(i2).toString() + " x " + this.measuredNodes.get(j).toString());
            }
        }
        ArrayList<int[]> latentCliques = new ArrayList<int[]>();
        int[] firstClique = new int[latents.size()];
        for (i = 0; i < firstClique.length; ++i) {
            firstClique[i] = i;
        }
        latentCliques.add(firstClique);
        i = 0;
        if (i < latentCliques.size()) {
            int[] nextLatentList = (int[])latentCliques.get(i);
            ArrayList nextPartition = new ArrayList();
            for (int p = 0; p < nextLatentList.length; ++p) {
                nextPartition.add(partition.get(nextLatentList[p]));
            }
            List solution = this.findInducedPureGraph(nextPartition, impurities);
            if (solution != null) {
                int p;
                System.out.println("--Solution");
                for (int[] c : solution) {
                    for (int v = 0; v < c.length; ++v) {
                        System.out.print(this.measuredNodes.get(c[v]).toString() + " ");
                    }
                    System.out.println();
                }
                this.printlnMessage(">> SIZE: " + this.sizeCluster(solution));
                this.printlnMessage(">> New solution found!");
                SemGraph graph2 = new SemGraph();
                Node[] latentsArray = new Node[solution.size()];
                for (p = 0; p < solution.size(); ++p) {
                    int[] cluster = (int[])solution.get(p);
                    latentsArray[p] = new GraphNode("_L" + (p + 1));
                    latentsArray[p].setNodeType(NodeType.LATENT);
                    graph2.addNode(latentsArray[p]);
                    for (int q = 0; q < cluster.length; ++q) {
                        GraphNode newIndicator = new GraphNode(this.measuredNodes.get(cluster[q]).toString());
                        graph2.addNode(newIndicator);
                        graph2.addDirectedEdge(latentsArray[p], newIndicator);
                    }
                }
                for (p = 0; p < latentsArray.length - 1; ++p) {
                    for (int q = p + 1; q < latentsArray.length; ++q) {
                        graph2.addDirectedEdge(latentsArray[p], latentsArray[q]);
                    }
                }
                return graph2;
            }
            return null;
        }
        return null;
    }

    private void sortByImpurityPriority(int[][] elements, int[] partitionCount, boolean[] eliminated) {
        int j;
        int total;
        int[] temp = new int[3];
        block0: for (int i = 0; i < elements.length - 1; ++i) {
            if (!eliminated[elements[i][0]]) continue;
            for (int j2 = i + 1; j2 < elements.length; ++j2) {
                if (eliminated[elements[j2][0]]) continue;
                this.swapElements(elements, i, j2, temp);
                continue block0;
            }
        }
        for (total = 0; total < elements.length && !eliminated[elements[total][0]]; ++total) {
        }
        for (int i = 0; i < total - 1; ++i) {
            int max = -1;
            int max_idx = -1;
            for (j = i; j < total; ++j) {
                if (elements[j][2] <= max) continue;
                max = elements[j][2];
                max_idx = j;
            }
            this.swapElements(elements, i, max_idx, temp);
        }
        int start = 0;
        while (start < total) {
            int i;
            int size = partitionCount[elements[start][1]];
            int end = start + 1;
            for (j = start + 1; j < total && size == partitionCount[elements[j][1]]; ++j) {
                ++end;
            }
            for (i = start + 1; i < end; ++i) {
                if (partitionCount[elements[i][1]] != 1) continue;
                this.swapElements(elements, i, start, temp);
                ++start;
            }
            for (i = start + 1; i < end; ++i) {
                if (partitionCount[elements[i][1]] != 2) continue;
                this.swapElements(elements, i, start, temp);
                ++start;
            }
            for (i = start; i < end - 1; ++i) {
                int max = -1;
                int max_idx = -1;
                for (int j3 = i; j3 < end; ++j3) {
                    if (partitionCount[elements[j3][1]] <= max) continue;
                    max = partitionCount[elements[j3][1]];
                    max_idx = j3;
                }
                this.swapElements(elements, i, max_idx, temp);
            }
            start = end;
        }
    }

    private void swapElements(int[][] elements, int i, int j, int[] buffer) {
        buffer[0] = elements[i][0];
        buffer[1] = elements[i][1];
        buffer[2] = elements[i][2];
        elements[i][0] = elements[j][0];
        elements[i][1] = elements[j][1];
        elements[i][2] = elements[j][2];
        elements[j][0] = buffer[0];
        elements[j][1] = buffer[1];
        elements[j][2] = buffer[2];
    }

    private List findInducedPureGraph(List partition, boolean[][] impurities) {
        int[][] elements = new int[this.sizeCluster(partition)][3];
        int[] partitionCount = new int[partition.size()];
        int countElements = 0;
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = (int[])partition.get(p);
            partitionCount[p] = 0;
            for (int i = 0; i < next.length; ++i) {
                elements[countElements][0] = next[i];
                elements[countElements][1] = p;
                ++countElements;
                int n = p;
                partitionCount[n] = partitionCount[n] + 1;
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i][2] = 0;
            for (int j = 0; j < elements.length; ++j) {
                if (!impurities[elements[i][0]][elements[j][0]]) continue;
                int[] nArray = elements[i];
                nArray[2] = nArray[2] + 1;
            }
        }
        boolean[] eliminated = new boolean[this.numVars];
        for (int i = 0; i < elements.length; ++i) {
            eliminated[elements[i][0]] = impurities[elements[i][0]][elements[i][0]];
        }
        return this.buildSolution2(elements, eliminated, partition);
    }

    private boolean validSolution(int[][] elements, boolean[] eliminated) {
        for (int i = 0; i < elements.length; ++i) {
            if (eliminated[elements[i][0]] || elements[i][2] <= 0) continue;
            return false;
        }
        return true;
    }

    private List buildSolution2(int[][] elements, boolean[] eliminated, List partition) {
        ArrayList<int[]> solution = new ArrayList<int[]>();
        for (int[] next : partition) {
            int[] draftArea = new int[next.length];
            int draftCount = 0;
            for (int i = 0; i < next.length; ++i) {
                for (int j = 0; j < elements.length; ++j) {
                    if (elements[j][0] != next[i] || eliminated[elements[j][0]]) continue;
                    draftArea[draftCount++] = next[i];
                }
            }
            if (draftCount <= 0) continue;
            int[] realCluster = new int[draftCount];
            System.arraycopy(draftArea, 0, realCluster, 0, draftCount);
            solution.add(realCluster);
        }
        if (solution.size() > 0) {
            return solution;
        }
        return null;
    }
}

