/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMapDci;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class ResolveSepsets {
    public static SepsetMapDci ResolveSepsets(List<SepsetMapDci> sepsets, List<IndependenceTest> independenceTests, String method, SepsetMapDci resolvedIndependent, SepsetMapDci resolvedDependent) {
        SepsetMapDci resolvedSepset = new SepsetMapDci();
        HashSet<Node> allVars = new HashSet<Node>();
        for (IndependenceTest independenceTest : independenceTests) {
            allVars.addAll(independenceTest.getVariables());
        }
        for (NodePair pair : ResolveSepsets.allNodePairs(new ArrayList<Node>(allVars))) {
            ArrayList<List<List<Node>>> pairSepsets = new ArrayList<List<List<Node>>>();
            ArrayList<IndependenceTest> testsWithPair = new ArrayList<IndependenceTest>();
            for (int k = 0; k < independenceTests.size(); ++k) {
                IndependenceTest independenceTest = independenceTests.get(k);
                if (!independenceTest.getVariables().containsAll(Arrays.asList(pair.getFirst(), pair.getSecond()))) continue;
                pairSepsets.add(sepsets.get(k).getSet(pair.getFirst(), pair.getSecond()));
                testsWithPair.add(independenceTest);
            }
            if (testsWithPair.size() < 2) {
                if (testsWithPair.size() != 1 || pairSepsets.get(0) == null) continue;
                for (List sepset : (List)pairSepsets.get(0)) {
                    resolvedSepset.set(pair.getFirst(), pair.getSecond(), sepset);
                }
                continue;
            }
            ArrayList allConditioningSets = new ArrayList();
            for (List list : pairSepsets) {
                if (list == null) continue;
                allConditioningSets.addAll(list);
            }
            for (List list : allConditioningSets) {
                ArrayList<IndependenceTest> testsWithSet = new ArrayList<IndependenceTest>();
                for (IndependenceTest independenceTest : testsWithPair) {
                    if (!independenceTest.getVariables().containsAll(list) && !list.isEmpty()) continue;
                    testsWithSet.add(independenceTest);
                }
                if (testsWithSet.size() < 2) {
                    if (testsWithPair.size() != 1) continue;
                    resolvedSepset.set(pair.getFirst(), pair.getSecond(), list);
                    continue;
                }
                boolean separated = false;
                boolean inconsistent = false;
                for (int k = 0; k < testsWithSet.size(); ++k) {
                    IndependenceTest testWithSet = (IndependenceTest)testsWithSet.get(k);
                    if (k == 0) {
                        separated = testWithSet.isIndependent(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (separated == testWithSet.isIndependent(pair.getFirst(), pair.getSecond(), list)) continue;
                    inconsistent = true;
                    break;
                }
                if (inconsistent) {
                    if (method.equals("fisher")) {
                        if (ResolveSepsets.isIndependentPooledFisher(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("fisher2")) {
                        if (ResolveSepsets.isIndependentPooledFisher2(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("tippett")) {
                        if (ResolveSepsets.isIndependentPooledTippett(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("worsleyfriston")) {
                        if (ResolveSepsets.isIndependentPooledWorsleyFriston(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("stouffer")) {
                        if (ResolveSepsets.isIndependentPooledStouffer(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("mudholkergeorge")) {
                        if (ResolveSepsets.isIndependentPooledMudholkerGeorge(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("mudholkergeorge2")) {
                        if (ResolveSepsets.isIndependentPooledMudholkerGeorge2(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("averagetest")) {
                        if (ResolveSepsets.isIndependentPooledAverageTest(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("average")) {
                        if (ResolveSepsets.isIndependentPooledAverage(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("random")) {
                        if (ResolveSepsets.isIndependentPooledRandom(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("fdr")) {
                        if (ResolveSepsets.isIndependentMajorityFdr(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method.equals("majority")) {
                        if (ResolveSepsets.isIndependentMajorityIndep(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    throw new RuntimeException("Invalid Test");
                }
                resolvedSepset.set(pair.getFirst(), pair.getSecond(), list);
            }
        }
        return resolvedSepset;
    }

    public static boolean isIndependentPooled(String method, List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        if (method.equals("fisher")) {
            return ResolveSepsets.isIndependentPooledFisher(independenceTests, x, y, condSet);
        }
        if (method.equals("fisher2")) {
            return ResolveSepsets.isIndependentPooledFisher2(independenceTests, x, y, condSet);
        }
        if (method.equals("tippett")) {
            return ResolveSepsets.isIndependentPooledTippett(independenceTests, x, y, condSet);
        }
        if (method.equals("worsleyfriston")) {
            return ResolveSepsets.isIndependentPooledWorsleyFriston(independenceTests, x, y, condSet);
        }
        if (method.equals("stouffer")) {
            return ResolveSepsets.isIndependentPooledStouffer(independenceTests, x, y, condSet);
        }
        if (method.equals("mudholkergeorge")) {
            return ResolveSepsets.isIndependentPooledMudholkerGeorge(independenceTests, x, y, condSet);
        }
        if (method.equals("mudholkergeorge2")) {
            return ResolveSepsets.isIndependentPooledMudholkerGeorge2(independenceTests, x, y, condSet);
        }
        if (method.equals("averagetest")) {
            return ResolveSepsets.isIndependentPooledAverageTest(independenceTests, x, y, condSet);
        }
        if (method.equals("average")) {
            return ResolveSepsets.isIndependentPooledAverage(independenceTests, x, y, condSet);
        }
        if (method.equals("random")) {
            return ResolveSepsets.isIndependentPooledRandom(independenceTests, x, y, condSet);
        }
        if (method.equals("fdr")) {
            return ResolveSepsets.isIndependentMajorityFdr(independenceTests, x, y, condSet);
        }
        if (method.equals("majority")) {
            return ResolveSepsets.isIndependentMajorityIndep(independenceTests, x, y, condSet);
        }
        throw new RuntimeException("Invalid Test");
    }

    public static boolean isIndependentPooledFisher(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double tf = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            tf += -2.0 * Math.log(independenceTest.getPValue());
        }
        double p = 1.0 - ProbUtils.chisqCdf(tf, 2 * independenceTests.size());
        return p > alpha;
    }

    public static boolean isIndependentPooledFisher2(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        List<Double> pValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        double tf = 0.0;
        for (double p : pValues) {
            tf += -2.0 * Math.log(p);
        }
        double p = 1.0 - ProbUtils.chisqCdf(tf, 2 * pValues.size());
        return p > alpha;
    }

    public static boolean isIndependentPooledTippett(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double p = -1.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            if (p == -1.0) {
                p = independenceTest.getPValue();
                continue;
            }
            double newp = independenceTest.getPValue();
            if (!(newp < p)) continue;
            p = newp;
        }
        return p > 1.0 - Math.pow(1.0 - alpha, 1.0 / (double)independenceTests.size());
    }

    public static boolean isIndependentPooledWilkinson(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet, int r) {
        double alpha = independenceTests.get(0).getAlpha();
        double[] p = new double[independenceTests.size()];
        int k = 0;
        for (IndependenceTest independenceTest : independenceTests) {
            p[k] = independenceTest.getPValue();
            ++k;
        }
        Arrays.sort(p);
        return p[r] > 1.0 - Math.pow(1.0 - Math.pow(alpha, 1.0 / (double)r), (double)r / (double)independenceTests.size());
    }

    public static boolean isIndependentPooledWorsleyFriston(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double p = -1.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            if (p == -1.0) {
                p = independenceTest.getPValue();
                continue;
            }
            double newp = independenceTest.getPValue();
            if (!(newp > p)) continue;
            p = newp;
        }
        return p > Math.pow(alpha, 1.0 / (double)independenceTests.size());
    }

    public static boolean isIndependentPooledStouffer(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double ts = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            ts += ProbUtils.normalQuantile(independenceTest.getPValue()) / Math.sqrt(independenceTests.size());
        }
        double p = 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, Math.abs(ts)));
        return p > alpha;
    }

    public static boolean isIndependentPooledMudholkerGeorge(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double c = Math.sqrt((double)(3 * (5 * independenceTests.size() + 4)) / ((double)independenceTests.size() * Math.pow(Math.PI, 2.0) * (double)(5 * independenceTests.size() + 2)));
        double tm = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            double pk = independenceTest.getPValue();
            tm += -c * Math.log(pk / (1.0 - pk));
        }
        double p = 2.0 * (1.0 - ProbUtils.tCdf(Math.abs(tm), 5 * independenceTests.size() + 4));
        return p > alpha;
    }

    public static boolean isIndependentPooledMudholkerGeorge2(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        List<Double> pValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        double c = Math.sqrt((double)(3 * (5 * pValues.size() + 4)) / ((double)pValues.size() * Math.pow(Math.PI, 2.0) * (double)(5 * pValues.size() + 2)));
        double tm = 0.0;
        for (double pk : pValues) {
            tm += -c * Math.log(pk / (1.0 - pk));
        }
        double p = 2.0 * (1.0 - ProbUtils.tCdf(Math.abs(tm), 5 * pValues.size() + 4));
        return p > alpha;
    }

    public static boolean isIndependentPooledAverage(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double p = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            p += independenceTest.getPValue() / (double)independenceTests.size();
        }
        return p > alpha;
    }

    public static boolean isIndependentPooledAverageTest(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double ts = 0.0;
        int df = 0;
        for (IndependenceTest independenceTest : independenceTests) {
            if (!(independenceTest instanceof IndTestChiSquare)) {
                throw new RuntimeException("Must be ChiSquare Test");
            }
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            ts += ((IndTestChiSquare)independenceTest).getXSquare() / (double)independenceTests.size();
            df += ((IndTestChiSquare)independenceTest).getDf();
        }
        double p = 1.0 - ProbUtils.chisqCdf(ts, df /= independenceTests.size());
        return p > alpha;
    }

    public static boolean isIndependentPooledRandom(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        int r = RandomUtil.getInstance().nextInt(independenceTests.size());
        IndependenceTest independenceTest = independenceTests.get(r);
        ArrayList<Node> localCondSet = new ArrayList<Node>();
        for (Node node : condSet) {
            localCondSet.add(independenceTest.getVariable(node.getName()));
        }
        independenceTest.isIndependent(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
        double p = independenceTest.getPValue();
        return p > alpha;
    }

    public static List<NodePair> allNodePairs(List<Node> nodes) {
        ArrayList<NodePair> nodePairs = new ArrayList<NodePair>();
        for (int j = 0; j < nodes.size() - 1; ++j) {
            for (int k = j + 1; k < nodes.size(); ++k) {
                nodePairs.add(new NodePair(nodes.get(j), nodes.get(k)));
            }
        }
        return nodePairs;
    }

    private static boolean isIndependentMajorityFdr(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        boolean independent;
        int c;
        List<Double> allPValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        Collections.sort(allPValues);
        for (c = 0; c < allPValues.size() && allPValues.get(c) < independenceTests.get(0).getAlpha() * ((double)c + 1.0) / (double)allPValues.size(); ++c) {
        }
        boolean bl = independent = c < allPValues.size() / 2;
        if (independent) {
            TetradLogger.getInstance().log("independence", "***FDR judges " + SearchLogUtils.independenceFact(x, y, condSet) + " independent");
            TetradLogger.getInstance().log("independence", "c = " + c);
        } else {
            TetradLogger.getInstance().log("independence", "###FDR judges " + SearchLogUtils.independenceFact(x, y, condSet) + " dependent");
            TetradLogger.getInstance().log("independence", "c = " + c);
        }
        return independent;
    }

    private static List<Double> getAvailablePValues(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        ArrayList<Double> allPValues = new ArrayList<Double>();
        for (IndependenceTest test : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(test.getVariable(node.getName()));
            }
            try {
                test.isIndependent(test.getVariable(x.getName()), test.getVariable(y.getName()), localCondSet);
                allPValues.add(test.getPValue());
            }
            catch (Exception e) {}
        }
        return allPValues;
    }

    private static boolean isIndependentMajorityIndep(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        boolean independent;
        int c;
        List<Double> allPValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        Collections.sort(allPValues);
        for (c = 0; c < allPValues.size() && allPValues.get(c) < independenceTests.get(0).getAlpha(); ++c) {
        }
        boolean bl = independent = c < allPValues.size() / 2;
        if (independent) {
            TetradLogger.getInstance().log("independence", "***Majority = " + SearchLogUtils.independenceFact(x, y, condSet) + " independent");
            TetradLogger.getInstance().log("independence", "c = " + c);
        } else {
            TetradLogger.getInstance().log("independence", "###Majority = " + SearchLogUtils.independenceFact(x, y, condSet) + " dependent");
            TetradLogger.getInstance().log("independence", "c = " + c);
        }
        return independent;
    }
}

