/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.LacerdaSpirtesRamsey2007Search;
import edu.cmu.tetrad.search.SemLearningMethod;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import edu.cmu.tetrad.util.dist.GaussianPower;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class RunCyclicDiscovery {
    public double[][] sampleMatrix() {
        double[][] a = new double[][]{{2.0, 5.0, 10.0, 11.0, 7.0}, {3.0, 3.0, 5.0, 1.0, 2.0}, {5.0, 4.0, 8.0, 6.0, 11.0}, {6.0, 3.0, 5.0, 12.0, 10.0}, {9.0, 2.0, 4.0, 5.0, 9.0}};
        return a;
    }

    public static List<Node> makeNodeList(int nVars) {
        Vector<Node> nodes = new Vector<Node>();
        for (int i = 1; i <= nVars; ++i) {
            GraphNode node = new GraphNode("X" + i);
            nodes.add(node);
        }
        return nodes;
    }

    private static GraphWithParameters makeRandomDagWithParms(Dag dag) {
        GraphWithParameters dwp = new GraphWithParameters(dag);
        List<Edge> edges = dag.getEdges();
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.get(i);
            double w = 1.0;
            dwp.getWeightHash().put(edge, w);
        }
        return dwp;
    }

    public static void main(String[] args) {
        RunCyclicDiscovery.testCyclicDiscovery();
    }

    private static void generateCandidateModels() {
        GraphWithParameters genModel = RunCyclicDiscovery.graph4Cycle();
        System.out.println("genModel = " + genModel + "\n" + genModel.getGraphMatrix());
        boolean isShrinkingMatrix = LacerdaSpirtesRamsey2007Search.allEigenvaluesAreSmallerThanOneInModulus(genModel.getGraphMatrix().getDoubleData());
        System.out.println("for generating model, isShrinkingMatrix = " + isShrinkingMatrix);
        DoubleMatrix2D reducedForm = RunCyclicDiscovery.reducedForm(genModel);
        System.out.println("reducedForm = " + reducedForm);
        ColtDataSet matrixB = genModel.getGraphMatrix();
        int n = matrixB.getDoubleData().rows();
        DoubleMatrix2D matrixW = MatrixUtils.linearCombination(MatrixUtils.identityMatrix(n), 1.0, matrixB.getDoubleData(), -1.0);
        System.out.println("211: matrixW = " + matrixW);
        LacerdaSpirtesRamsey2007Search.findCandidateModels(genModel.getGraph().getNodes(), matrixW, null, n, false);
    }

    private static void showPowersOfB(GraphWithParameters genModel) {
        ColtDataSet matrixB = genModel.getGraphMatrix();
        Algebra algebra = new Algebra();
        for (int i = 1; i < 100; i += 10) {
            DoubleMatrix2D bpow = algebra.pow(matrixB.getDoubleData(), i);
            System.out.println("B^" + i + " = " + bpow);
        }
    }

    private static GraphWithParameters graphXyzw() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("X"));
        g.addNode(new GraphNode("Y"));
        g.addNode(new GraphNode("Z"));
        g.addNode(new GraphNode("W"));
        genModel.addEdge("X", "Z", 1.0);
        genModel.addEdge("Y", "W", 1.0);
        genModel.addEdge("Z", "W", 1.2);
        genModel.addEdge("W", "Z", 0.7);
        return genModel;
    }

    private static GraphWithParameters graph4Cycle() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("B"));
        g.addNode(new GraphNode("C"));
        g.addNode(new GraphNode("D"));
        g.addNode(new GraphNode("E"));
        genModel.addEdge("B", "C", 1.0);
        genModel.addEdge("C", "D", 0.7);
        genModel.addEdge("D", "E", 0.7);
        genModel.addEdge("E", "B", 1.0);
        return genModel;
    }

    private static GraphWithParameters graphInteractingCycles() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A"));
        g.addNode(new GraphNode("B"));
        g.addNode(new GraphNode("C"));
        g.addNode(new GraphNode("D"));
        g.addNode(new GraphNode("E"));
        genModel.addEdge("A", "B", 0.5);
        genModel.addEdge("B", "C", 1.0);
        genModel.addEdge("C", "A", 1.0);
        genModel.addEdge("A", "D", -1.1);
        genModel.addEdge("D", "E", 1.0);
        genModel.addEdge("E", "C", 0.96);
        return genModel;
    }

    private static GraphWithParameters graphWithCycleIndicators() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A1"));
        g.addNode(new GraphNode("A2"));
        g.addNode(new GraphNode("A3"));
        g.addNode(new GraphNode("A4"));
        g.addNode(new GraphNode("B1"));
        g.addNode(new GraphNode("B2"));
        g.addNode(new GraphNode("B3"));
        g.addNode(new GraphNode("B4"));
        g.addNode(new GraphNode("C1"));
        g.addNode(new GraphNode("C2"));
        g.addNode(new GraphNode("C3"));
        g.addNode(new GraphNode("C4"));
        genModel.addEdge("A1", "B1", 1.0);
        genModel.addEdge("A2", "B2", 1.0);
        genModel.addEdge("A3", "B3", 1.0);
        genModel.addEdge("A4", "B4", 1.0);
        genModel.addEdge("B1", "C1", 1.0);
        genModel.addEdge("B2", "C2", 1.0);
        genModel.addEdge("B3", "C3", 1.0);
        genModel.addEdge("B4", "C4", 1.0);
        genModel.addEdge("B1", "B2", 0.9);
        genModel.addEdge("B2", "B3", 0.9);
        genModel.addEdge("B3", "B4", 0.9);
        genModel.addEdge("B4", "B1", 0.9);
        return genModel;
    }

    private static GraphWithParameters graph2() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A"));
        g.addNode(new GraphNode("B"));
        genModel.addEdge("A", "B", 0.5);
        genModel.addEdge("B", "A", 0.8);
        return genModel;
    }

    private static GraphWithParameters graphUaiPaper() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        genModel.addEdge("X1", "X2", 1.2);
        genModel.addEdge("X2", "X3", 2.0);
        genModel.addEdge("X3", "X4", -1.0);
        genModel.addEdge("X4", "X2", -0.3);
        genModel.addEdge("X2", "X5", 3.0);
        return genModel;
    }

    private static GraphWithParameters graphIndepCycles() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("A"));
        g.addNode(new GraphNode("B"));
        g.addNode(new GraphNode("C"));
        g.addNode(new GraphNode("D"));
        g.addNode(new GraphNode("E"));
        genModel.addEdge("A", "B", 0.5);
        genModel.addEdge("B", "A", 0.5);
        genModel.addEdge("B", "C", 1.0);
        genModel.addEdge("C", "D", 0.7);
        genModel.addEdge("D", "C", 0.7);
        return genModel;
    }

    private static GraphWithParameters graph2_2Cycles() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters genModel = new GraphWithParameters(g);
        g.addNode(new GraphNode("K1"));
        g.addNode(new GraphNode("K2"));
        g.addNode(new GraphNode("L1"));
        g.addNode(new GraphNode("L2"));
        genModel.addEdge("K1", "K2", 0.9);
        genModel.addEdge("K2", "K1", 0.9);
        genModel.addEdge("L1", "L2", 0.9);
        genModel.addEdge("L2", "L1", 0.9);
        return genModel;
    }

    private static void testCyclicDiscovery() {
        int numSamples = 15000;
        GaussianPower gp2 = new GaussianPower(2.0);
        GraphWithParameters genModel = RunCyclicDiscovery.graphUaiPaper();
        DoubleMatrix1D errorCoefficients = RunCyclicDiscovery.getErrorCoeffsIdentity(genModel.getGraph().getNumNodes());
        DoubleMatrix2D inVectors = RunCyclicDiscovery.simulate_Cyclic(genModel, errorCoefficients, numSamples, gp2);
        ColtDataSet dataSet = ColtDataSet.makeContinuousData(genModel.getGraph().getNodes(), inVectors.viewDice());
        new LacerdaSpirtesRamsey2007Search().run(dataSet);
    }

    private static DoubleMatrix1D getErrorCoeffsSpirtes05Nov() {
        DenseDoubleMatrix1D errorCoefficients = new DenseDoubleMatrix1D(4);
        errorCoefficients.set(0, 0.9);
        errorCoefficients.set(1, 1.5);
        errorCoefficients.set(2, 1.3);
        errorCoefficients.set(3, 0.6);
        return errorCoefficients;
    }

    private static DoubleMatrix1D getErrorCoeffsIdentity(int n) {
        DenseDoubleMatrix1D errorCoefficients = new DenseDoubleMatrix1D(n);
        for (int i = 0; i < n; ++i) {
            errorCoefficients.set(i, 1.0);
        }
        return errorCoefficients;
    }

    public static void testNRooks() {
        DoubleMatrix2D mat = RunCyclicDiscovery.getMat17Oct();
        List<List<Integer>> assns = LacerdaSpirtesRamsey2007Search.nRookColumnAssignments(mat);
        System.out.println("assns.size() = " + assns.size());
        for (List<Integer> assn : assns) {
            System.out.println(assn);
            DoubleMatrix2D m = LacerdaSpirtesRamsey2007Search.displayNRookAssignment(assn);
            System.out.println(m);
        }
    }

    private static DoubleMatrix2D getMat17Oct() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(0, 0, 1.0);
        mat.set(0, 1, 1.0);
        mat.set(1, 1, 1.0);
        mat.set(1, 2, 1.0);
        mat.set(2, 2, 1.0);
        mat.set(2, 3, 1.0);
        mat.set(3, 3, 1.0);
        mat.set(3, 0, 1.0);
        return mat;
    }

    private static DoubleMatrix2D getMatAbcd() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(0, 1, 0.5);
        mat.set(1, 2, 0.5);
        mat.set(2, 3, 0.5);
        mat.set(3, 0, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzwM1() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(2, 0, 0.7);
        mat.set(3, 1, 1.2);
        mat.set(3, 2, 0.8);
        mat.set(2, 3, 0.4);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzCycle() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(1, 0, 0.5);
        mat.set(2, 1, 0.5);
        mat.set(1, 2, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXzyCycle() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(2, 0, 0.5);
        mat.set(2, 1, 0.5);
        mat.set(1, 2, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzwM2() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(4, 4);
        mat.set(3, 0, 0.5);
        mat.set(2, 1, 0.5);
        mat.set(3, 2, 0.5);
        mat.set(2, 3, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzComplete() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(0, 1, 0.5);
        mat.set(0, 2, 0.5);
        mat.set(1, 0, 0.5);
        mat.set(1, 2, 0.5);
        mat.set(2, 0, 0.5);
        mat.set(2, 1, 0.5);
        return mat;
    }

    private static DoubleMatrix2D getMatXyzXExogenous() {
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(3, 3);
        mat.set(0, 1, 0.5);
        mat.set(1, 2, 0.5);
        mat.set(2, 1, 0.5);
        return mat;
    }

    private static int argmin(List<Double> l, List<SemLearningMethod> methods) {
        int minIndex = 0;
        double min = l.get(0);
        int i = 0;
        for (double d : l) {
            if (d < min && !methods.get(i).getName().contains("true DAG")) {
                min = d;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    private static Dag twoNodeDag() {
        GraphNode node1 = new GraphNode("X1");
        GraphNode node2 = new GraphNode("X2");
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node1);
        nodes.add(node2);
        Dag dag = new Dag(nodes);
        Edge edge = new Edge(node1, node2, Endpoint.TAIL, Endpoint.ARROW);
        dag.addEdge(edge);
        return dag;
    }

    private static DoubleMatrix2D reducedForm(GraphWithParameters graph) {
        int n = graph.getGraph().getNumNodes();
        DoubleMatrix2D graphMatrix = graph.getGraphMatrix().getDoubleData();
        DoubleMatrix2D identityMinusGraphMatrix = MatrixUtils.linearCombination(MatrixUtils.identityMatrix(n), 1.0, graphMatrix, -1.0);
        DoubleMatrix2D mixingMatrix = MatrixUtils.inverse(identityMinusGraphMatrix);
        return mixingMatrix;
    }

    private static DoubleMatrix1D simulateReducedForm(DoubleMatrix2D reducedForm, DoubleMatrix1D errorCoefficients, Distribution distr) {
        int n = reducedForm.rows();
        DenseDoubleMatrix1D vector = new DenseDoubleMatrix1D(n);
        DenseDoubleMatrix1D samples = new DenseDoubleMatrix1D(n);
        for (int j = 0; j < n; ++j) {
            double sample = distr.nextRandom();
            double errorCoefficient = errorCoefficients.get(j);
            samples.set(j, sample * errorCoefficient);
        }
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                double coefficient = reducedForm.get(i, j);
                double sample = samples.get(j);
                sum += coefficient * sample;
            }
            vector.set(i, sum);
        }
        return vector;
    }

    public static DoubleMatrix2D simulate_Cyclic(GraphWithParameters dwp, DoubleMatrix1D errorCoefficients, int n, Distribution distribution) {
        Object errorCoeffMatrix = null;
        DoubleMatrix2D reducedForm = RunCyclicDiscovery.reducedForm(dwp);
        System.out.println("reducedForm = " + reducedForm);
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(dwp.getGraph().getNumNodes(), n);
        for (int j = 0; j < n; ++j) {
            DoubleMatrix1D vector = RunCyclicDiscovery.simulateReducedForm(reducedForm, errorCoefficients, distribution);
            vectors.viewColumn(j).assign(vector);
        }
        return vectors;
    }

    private static DoubleMatrix2D example_line(int n) {
        DoubleMatrix1D e1 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e2 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e3 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D x2 = RunCyclicDiscovery.linearCombination(x1, 1.0, e2, 0.07);
        DoubleMatrix1D x3 = RunCyclicDiscovery.linearCombination(x2, 1.0, e3, 0.05);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3};
        return RunCyclicDiscovery.combine(observedVars);
    }

    private static DoubleMatrix2D example_Y(int n) {
        DoubleMatrix1D e1 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e2 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e3 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e4 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e5 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D x2 = e2;
        DoubleMatrix1D x3 = RunCyclicDiscovery.linearCombination(RunCyclicDiscovery.linearCombination(x1, 1.0, x2, 2.0), 1.0, e3, 1.0);
        DoubleMatrix1D x4 = RunCyclicDiscovery.linearCombination(x3, 1.5, e4, 1.0);
        DoubleMatrix1D x5 = RunCyclicDiscovery.linearCombination(x1, 1.0, e5, 1.0);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3, x4, x5};
        return RunCyclicDiscovery.combine(observedVars);
    }

    private static DoubleMatrix2D example_completeDag(int n) {
        DoubleMatrix1D e1 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e2 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e3 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D e4 = RunCyclicDiscovery.generateUniform(0.0, 1.0, n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{2.0, 1.0};
        DoubleMatrix1D x2 = RunCyclicDiscovery.linearCombination(vars2, ws2);
        DoubleMatrix1D[] vars3 = new DoubleMatrix1D[]{x1, x2, e3};
        double[] ws3 = new double[]{3.0, 0.0, 1.0};
        DoubleMatrix1D x3 = RunCyclicDiscovery.linearCombination(vars3, ws3);
        DoubleMatrix1D[] vars4 = new DoubleMatrix1D[]{x1, x2, x3, e4};
        double[] ws4 = new double[]{1.0, 1.0, -1.0, 1.0};
        DoubleMatrix1D x4 = RunCyclicDiscovery.linearCombination(vars4, ws4);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3, x4};
        return RunCyclicDiscovery.combine(observedVars);
    }

    private static DoubleMatrix2D example_completeDagSG(int n) {
        DoubleMatrix1D e1 = RunCyclicDiscovery.generateSquaredGaussian(n);
        DoubleMatrix1D e2 = RunCyclicDiscovery.generateSquaredGaussian(n);
        DoubleMatrix1D e3 = RunCyclicDiscovery.generateSquaredGaussian(n);
        DoubleMatrix1D e4 = RunCyclicDiscovery.generateSquaredGaussian(n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{2.0, 1.0};
        DoubleMatrix1D x2 = RunCyclicDiscovery.linearCombination(vars2, ws2);
        DoubleMatrix1D[] vars3 = new DoubleMatrix1D[]{x1, x2, e3};
        double[] ws3 = new double[]{3.0, 0.0, 1.0};
        DoubleMatrix1D x3 = RunCyclicDiscovery.linearCombination(vars3, ws3);
        DoubleMatrix1D[] vars4 = new DoubleMatrix1D[]{x1, x2, x3, e4};
        double[] ws4 = new double[]{1.0, 1.0, -1.0, 1.0};
        DoubleMatrix1D x4 = RunCyclicDiscovery.linearCombination(vars4, ws4);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2, x3, x4};
        return RunCyclicDiscovery.combine(observedVars);
    }

    private static DoubleMatrix2D example_Straight(int n) {
        DoubleMatrix1D e1 = RunCyclicDiscovery.generateFourthGaussian(n);
        DoubleMatrix1D e2 = RunCyclicDiscovery.generateAlmostGaussian(n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{1.0, 1.0};
        DoubleMatrix1D x2 = RunCyclicDiscovery.linearCombination(vars2, ws2);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2};
        return RunCyclicDiscovery.combine(observedVars);
    }

    private static DoubleMatrix2D example_Reverse(int n) {
        DoubleMatrix1D e1 = RunCyclicDiscovery.generateAlmostGaussian(n);
        DoubleMatrix1D e2 = RunCyclicDiscovery.generateFourthGaussian(n);
        DoubleMatrix1D x1 = e1;
        DoubleMatrix1D[] vars2 = new DoubleMatrix1D[]{x1, e2};
        double[] ws2 = new double[]{1.0, 1.0};
        DoubleMatrix1D x2 = RunCyclicDiscovery.linearCombination(vars2, ws2);
        DoubleMatrix1D[] observedVars = new DoubleMatrix1D[]{x1, x2};
        return RunCyclicDiscovery.combine(observedVars);
    }

    private static DoubleMatrix2D combine(DoubleMatrix1D[] vecs) {
        DenseDoubleMatrix2D resultMatrix = new DenseDoubleMatrix2D(vecs.length, vecs[0].size());
        for (int i = 0; i < vecs.length; ++i) {
            resultMatrix.viewRow(i).assign(vecs[i]);
        }
        return resultMatrix;
    }

    private static DoubleMatrix1D linearCombination(DoubleMatrix1D a, double aw, DoubleMatrix1D b, double bw) {
        DenseDoubleMatrix1D resultMatrix = new DenseDoubleMatrix1D(a.size());
        for (int i = 0; i < a.size(); ++i) {
            resultMatrix.set(i, aw * a.get(i) + bw * b.get(i));
        }
        return resultMatrix;
    }

    private static DoubleMatrix1D linearCombination(DoubleMatrix1D[] vecs, double[] weights) {
        DenseDoubleMatrix1D resultMatrix = new DenseDoubleMatrix1D(vecs[0].size());
        for (int i = 0; i < vecs[0].size(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < vecs.length; ++j) {
                sum += vecs[j].get(i) * weights[j];
            }
            resultMatrix.set(i, sum);
        }
        return resultMatrix;
    }

    private static DoubleMatrix2D linearCombination(DoubleMatrix2D a, double aw, DoubleMatrix2D b, double bw) {
        for (int i = 0; i < a.rows(); ++i) {
        }
        DenseDoubleMatrix2D resultMatrix = new DenseDoubleMatrix2D(a.rows(), a.columns());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                resultMatrix.set(i, j, aw * a.get(i, j) + bw * b.get(i, j));
                if (i != j) continue;
            }
        }
        return resultMatrix;
    }

    private static DataSet readData(String filename) {
        DataReader p = new DataReader();
        File inFile = new File(filename);
        try {
            return p.parseTabular(inFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DoubleMatrix2D generateBimodal2DGaussian(int n) {
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(2, n);
        for (int i = 0; i < n; ++i) {
            double y;
            double x;
            if (Math.random() < 0.5) {
                x = RunCyclicDiscovery.Gaussian_invcdf(Math.random()) - 10.0;
                y = RunCyclicDiscovery.Gaussian_invcdf(Math.random());
            } else {
                x = RunCyclicDiscovery.Gaussian_invcdf(Math.random()) + 10.0;
                y = RunCyclicDiscovery.Gaussian_invcdf(Math.random());
            }
            vectors.set(0, i, x);
            vectors.set(1, i, y);
        }
        return vectors;
    }

    public static DoubleMatrix2D generate2DGaussian(int n) {
        DenseDoubleMatrix2D vectors = new DenseDoubleMatrix2D(2, n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            vectors.set(0, i, r.nextNormal(0.0, 1.0));
            vectors.set(1, i, r.nextNormal(0.0, 1.0));
        }
        return vectors;
    }

    public static DoubleMatrix1D generateAlmostGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            if (r.nextDouble() < 0.95) {
                points.set(i, r.nextNormal(0.0, 1.0));
                continue;
            }
            points.set(i, r.nextNormal(0.0, 1.0) + 2.0);
        }
        return points;
    }

    public static DoubleMatrix1D generateGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            points.set(i, r.nextNormal(0.0, 1.0));
        }
        return points;
    }

    public static DoubleMatrix1D generateSquaredGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            points.set(i, Math.pow(r.nextNormal(0.0, 1.0), 2.0));
        }
        return points;
    }

    public static DoubleMatrix1D generateFourthGaussian(int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        RandomUtil r = RandomUtil.getInstance();
        for (int i = 0; i < n; ++i) {
            points.set(i, Math.pow(r.nextNormal(0.0, 1.0), 4.0));
        }
        return points;
    }

    public static double generateUniform(double a, double b) {
        double length = b - a;
        double x = a + length * Math.random();
        return x;
    }

    public static DoubleMatrix1D generateUniform(double a, double b, int n) {
        DenseDoubleMatrix1D points = new DenseDoubleMatrix1D(n);
        double length = b - a;
        for (int i = 0; i < n; ++i) {
            double x = a + length * Math.random();
            points.set(i, x);
        }
        return points;
    }

    private static double Gaussian_invcdf(double x) {
        double[] table = new double[]{0.0, 0.0398, 0.0793, 0.1179, 0.1554, 0.1915, 0.2257, 0.258, 0.2881, 0.3159, 0.3413, 0.3643, 0.3849, 0.4032, 0.4192, 0.4332, 0.4452, 0.4554, 0.4641, 0.4713, 0.4772, 0.4821, 0.4861, 0.4893, 0.4918, 0.4938, 0.4953, 0.4965, 0.4974, 0.4981, 0.4987, 0.5};
        if (x > 0.5) {
            int index = RunCyclicDiscovery.getLastSmallerIndex(x - 0.5, table);
            double interpol = RunCyclicDiscovery.interpolate(0.5 + table[index], 0.5 + table[index + 1], (double)index * 0.1, (double)(index + 1) * 0.1, x);
            System.out.println("x = " + x + "    interpol = " + interpol);
            return interpol;
        }
        double ix = 1.0 - x;
        int index = RunCyclicDiscovery.getLastSmallerIndex(ix - 0.5, table);
        double interpol = RunCyclicDiscovery.interpolate(0.5 + table[index], 0.5 + table[index + 1], (double)index * 0.1, (double)(index + 1) * 0.1, ix);
        System.out.println("x = " + x + "    -interpol = " + -interpol);
        return -interpol;
    }

    private static double interpolate(double x1, double x2, double y1, double y2, double x) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double slope = dy / dx;
        return y1 + slope * (x - x1);
    }

    private static int getLastSmallerIndex(double d, double[] table) {
        for (int i = 0; i < table.length; ++i) {
            if (!(table[i] > d)) continue;
            return i - 1;
        }
        return -1;
    }

    public static DoubleMatrix2D convertToColt(double[][] vectors) {
        int m = Matrix.getNumOfRows(vectors);
        int n = Matrix.getNumOfColumns(vectors);
        DenseDoubleMatrix2D mat = new DenseDoubleMatrix2D(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                mat.set(i, j, vectors[i][j]);
            }
        }
        return mat;
    }

    public static double[] convert(DoubleMatrix1D vector) {
        int n = vector.size();
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = vector.get(i);
        }
        return v;
    }

    public static double[][] convert(DoubleMatrix2D inVectors) {
        if (inVectors == null) {
            return null;
        }
        int m = inVectors.rows();
        int n = inVectors.columns();
        double[][] inV = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                inV[i][j] = inVectors.get(i, j);
            }
        }
        return inV;
    }

    public static final class Invert
    implements DoubleFunction {
        @Override
        public double apply(double d) {
            return 1.0 / d;
        }
    }

    public static class DagWithParmsAndValues {
        public GraphWithParameters dwp;
        public HashMap<Node, Double> valueHash;

        public DagWithParmsAndValues(GraphWithParameters dwp) {
            this.dwp = dwp;
            this.valueHash = new HashMap();
        }
    }
}

