/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public final class ShimizuResult {
    private Graph graph;
    private HashMap<Edge, Double> weightHash;
    private Dag patternDag = null;
    private int errorsOfOmission = 0;
    private int errorsOfCommission = 0;
    private int oriEvaluated = 0;
    private int oriCorrect = 0;
    private int oriIncorrect = 0;
    private int oriUndirected = 0;
    private List<Edge> correctOrientationEdges;
    private double totalCoeffErrorSq = 0.0;

    public ShimizuResult(Graph graph) {
        this.graph = graph;
        this.weightHash = new HashMap();
    }

    public ShimizuResult(Graph graph, Dag patDag) {
        this(graph);
        this.patternDag = patDag;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public double getWeight(Edge edge) {
        return this.weightHash.get(edge);
    }

    public void setWeight(Edge edge, double v) {
        this.weightHash.put(edge, v);
    }

    public Dag getPatternDag() {
        return this.patternDag;
    }

    public String toString() {
        String str = "";
        for (Edge edge : this.getGraph().getEdges()) {
            str = str + edge.toString();
            str = str + "   " + this.getWeight(edge) + "\n";
        }
        return str;
    }

    public void evalAdjacency(Dag genDag) {
        boolean adjCorrect;
        for (Edge thisEdge : this.getGraph().getEdges()) {
            System.out.print("thisEdge = " + thisEdge);
            Edge genEdge = ShimizuResult.getCorrespondingEdge(genDag, thisEdge);
            System.out.println(", genEdge = " + genEdge);
            adjCorrect = thisEdge != null;
            if (adjCorrect) continue;
            ++this.errorsOfCommission;
        }
        for (Edge genEdge : genDag.getEdges()) {
            System.out.print("genEdge = " + genEdge);
            Edge thisEdge = ShimizuResult.getCorrespondingEdge(this.getGraph(), genEdge);
            System.out.println(", thisEdge = " + thisEdge);
            adjCorrect = thisEdge != null;
            if (adjCorrect) continue;
            ++this.errorsOfOmission;
        }
    }

    public void printAdjacencyEvaluation() {
        System.out.println("== Results of evaluating adjacency ==");
        System.out.println("errorsOfOmission = " + this.errorsOfOmission);
        System.out.println("errorsOfCommission = " + this.errorsOfCommission);
    }

    public void evalOrientations(Dag genDag) {
        this.correctOrientationEdges = new Vector<Edge>();
        for (Edge genEdge : genDag.getEdges()) {
            Edge thisEdge = ShimizuResult.getCorrespondingEdge(this.getGraph(), genEdge);
            System.out.print("genEdge = " + genEdge);
            System.out.println(", thisEdge = " + thisEdge);
            if (thisEdge == null) continue;
            ++this.oriEvaluated;
            if (thisEdge.isDirected()) {
                if (ShimizuResult.getCorrespondingDirectedEdge(this.getGraph(), genEdge) != null) {
                    ++this.oriCorrect;
                    this.correctOrientationEdges.add(thisEdge);
                    continue;
                }
                ++this.oriIncorrect;
                continue;
            }
            ++this.oriUndirected;
        }
        System.out.print("\n");
    }

    public void printOrientationEvaluation() {
        System.out.println("== Results of evaluating orientation ==");
        System.out.println("oriCorrect = " + this.oriCorrect + "  oriIncorrect = " + this.oriIncorrect + "  oriUndirected = " + this.oriUndirected);
        System.out.println("oriEvaluated = " + this.oriEvaluated);
    }

    public void evalCoeffs(ShimizuResult genDag) {
        List<Edge> edgesToEvaluate;
        if (this.getPatternDag() != null) {
            edgesToEvaluate = new Vector<Edge>();
            for (Edge patDagEdge : this.getPatternDag().getEdges()) {
                Edge genEdge;
                if (!this.oriAgrees(patDagEdge, genEdge = ShimizuResult.getCorrespondingEdge(genDag.getGraph(), patDagEdge))) continue;
                edgesToEvaluate.add(ShimizuResult.getCorrespondingEdge(this.getGraph(), patDagEdge));
            }
        } else {
            edgesToEvaluate = this.correctOrientationEdges;
        }
        for (Edge edge : edgesToEvaluate) {
            double thisCoeff = this.getWeight(edge);
            Edge genEdge = ShimizuResult.getCorrespondingEdge(genDag.getGraph(), edge);
            double genCoeff = genDag.getWeight(genEdge);
            double diff = thisCoeff - genCoeff;
            this.totalCoeffErrorSq += Math.pow(diff, 2.0);
        }
    }

    public void printCoefficientEvaluation() {
        System.out.println("== Results of evaluating coefficients ==");
        System.out.println("totalCoeffErrorSq = " + this.totalCoeffErrorSq + ", from " + this.correctOrientationEdges.size() + " edges.");
    }

    public static Edge getCorrespondingEdge(Graph graph, Edge edge) {
        String nodeName1 = edge.getNode1().getName();
        String nodeName2 = edge.getNode2().getName();
        Node node1 = graph.getNode(nodeName1);
        Node node2 = graph.getNode(nodeName2);
        Edge result = graph.getEdge(node1, node2);
        return result;
    }

    public static Edge getCorrespondingDirectedEdge(Graph graph, Edge edge) {
        String nodeName1 = edge.getNode1().getName();
        String nodeName2 = edge.getNode2().getName();
        Node node1 = graph.getNode(nodeName1);
        Node node2 = graph.getNode(nodeName2);
        Edge result = graph.getDirectedEdge(node1, node2);
        return result;
    }

    private boolean oriAgrees(Edge edge1, Edge edge2) {
        return edge1.pointsTowards(edge1.getNode2()) && edge2.pointsTowards(edge1.getNode2());
    }
}

