/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.Ccd;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.PagUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCcd
extends TestCase {
    public TestCcd(String name) {
        super(name);
    }

    public void testCcd() {
        ContinuousVariable a = new ContinuousVariable("A");
        ContinuousVariable b = new ContinuousVariable("B");
        ContinuousVariable x = new ContinuousVariable("X");
        ContinuousVariable y = new ContinuousVariable("Y");
        EdgeListGraph graph = new EdgeListGraph();
        try {
            graph.addNode(a);
            graph.addNode(b);
            graph.addNode(x);
            graph.addNode(y);
        }
        catch (Exception e) {
            TestCcd.fail("Cant add nodes");
        }
        try {
            graph.addDirectedEdge(a, x);
        }
        catch (Exception e) {
            TestCcd.fail("Cant add edge A to X");
        }
        try {
            graph.addDirectedEdge(b, y);
        }
        catch (Exception e) {
            TestCcd.fail("Cant add edge B to Y");
        }
        try {
            graph.addDirectedEdge(x, y);
        }
        catch (Exception e) {
            TestCcd.fail("Cant add edge X to Y");
        }
        try {
            graph.addDirectedEdge(y, x);
        }
        catch (Exception e) {
            TestCcd.fail("Cant add edge Y to X");
        }
        IndTestDSep test = new IndTestDSep(graph);
        List<Node> listOfVars = test.getVariables();
        System.out.println("FIRST CASE");
        System.out.println("List of vars:  ");
        for (Node listOfVar : listOfVars) {
            System.out.println(listOfVar.getName());
        }
        Ccd ccd = new Ccd(test);
        Graph outPag = ccd.search();
        System.out.println("Output PAG for 1st case:  ");
        System.out.println(outPag);
        System.out.println("\n\n");
        boolean b1 = PagUtils.graphInPagStep1(outPag, graph);
        if (!b1) {
            TestCcd.fail();
        } else {
            System.out.println("Step 1 OK");
        }
        boolean b2 = PagUtils.graphInPagStep2(outPag, graph);
        if (!b2) {
            TestCcd.fail();
        } else {
            System.out.println("Step 2 OK");
        }
        boolean b3 = PagUtils.graphInPagStep3(outPag, graph);
        if (!b3) {
            TestCcd.fail();
        } else {
            System.out.println("Step 3 OK");
        }
        boolean b4 = PagUtils.graphInPagStep4(outPag, graph);
        if (!b4) {
            TestCcd.fail();
        } else {
            System.out.println("Step 4 OK");
        }
        boolean b5 = PagUtils.graphInPagStep5(outPag, graph);
        if (!b5) {
            TestCcd.fail();
        } else {
            System.out.println("Step 5 OK");
        }
        boolean b6 = PagUtils.graphInPagStep6(outPag, graph);
        if (!b6) {
            TestCcd.fail();
        } else {
            System.out.println("Step 6 OK");
        }
        System.out.println("\n\n");
    }

    public void testCcdC() {
        ContinuousVariable a = new ContinuousVariable("A");
        ContinuousVariable b = new ContinuousVariable("B");
        ContinuousVariable c = new ContinuousVariable("C");
        ContinuousVariable d = new ContinuousVariable("D");
        ContinuousVariable e = new ContinuousVariable("E");
        a.setNodeType(NodeType.MEASURED);
        b.setNodeType(NodeType.MEASURED);
        c.setNodeType(NodeType.MEASURED);
        d.setNodeType(NodeType.MEASURED);
        e.setNodeType(NodeType.MEASURED);
        EdgeListGraph graph = new EdgeListGraph();
        try {
            graph.addNode(a);
            graph.addNode(b);
            graph.addNode(c);
            graph.addNode(d);
            graph.addNode(e);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add nodes");
        }
        try {
            graph.addDirectedEdge(a, b);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add edge A to B");
        }
        try {
            graph.addDirectedEdge(b, c);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add edge B to C");
        }
        try {
            graph.addDirectedEdge(c, b);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add edge C to B");
        }
        try {
            graph.addDirectedEdge(c, d);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add edge C to D");
        }
        try {
            graph.addDirectedEdge(d, c);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add edge D to C");
        }
        try {
            graph.addDirectedEdge(e, d);
        }
        catch (Exception ex) {
            TestCcd.fail("Cant add edge E to D");
        }
        IndTestDSep test = new IndTestDSep(graph);
        List<Node> listOfVars = test.getVariables();
        System.out.println("SECOND CASE");
        System.out.println("List of vars:  ");
        for (Node var : listOfVars) {
            System.out.println(var.getName());
        }
        Ccd ccd = new Ccd(test);
        Graph outPag = ccd.search();
        System.out.println("Output PAG for 2nd case:  ");
        System.out.println(outPag);
        System.out.println("\n\n");
        boolean b1 = PagUtils.graphInPagStep1(outPag, graph);
        if (!b1) {
            TestCcd.fail();
        } else {
            System.out.println("Step 1 OK");
        }
        boolean b2 = PagUtils.graphInPagStep2(outPag, graph);
        if (!b2) {
            TestCcd.fail();
        } else {
            System.out.println("Step 2 OK");
        }
        boolean b3 = PagUtils.graphInPagStep3(outPag, graph);
        if (!b3) {
            TestCcd.fail();
        } else {
            System.out.println("Step 3 OK");
        }
        boolean b4 = PagUtils.graphInPagStep4(outPag, graph);
        if (!b4) {
            TestCcd.fail();
        } else {
            System.out.println("Step 4 OK");
        }
        boolean b5 = PagUtils.graphInPagStep5(outPag, graph);
        if (!b5) {
            TestCcd.fail();
        } else {
            System.out.println("Step 5 OK");
        }
        boolean b6 = PagUtils.graphInPagStep6(outPag, graph);
        if (!b6) {
            TestCcd.fail();
        } else {
            System.out.println("Step 6 OK");
        }
        System.out.println("\n\n");
    }

    public void testRandom() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        Dag dag = GraphUtils.randomDag(20, 0, 20, 3, 3, 4, false);
        Graph graph = GraphUtils.addCycles(dag, 7, 2);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(1000, false);
        Ccd ccd = new Ccd(new IndTestFisherZ(data, 0.01));
        Graph pag = ccd.search();
        System.out.println(pag);
    }

    public static Test suite() {
        return new TestSuite(TestCcd.class);
    }
}

