/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.DagInPatternIterator;
import edu.cmu.tetrad.search.DagIterator;
import edu.cmu.tetrad.search.DagIterator3;
import edu.cmu.tetrad.search.TestDagInPatternIterator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDagIterator
extends TestCase {
    public TestDagIterator(String name) {
        super(name);
    }

    public void test1() {
        Dag dag = new Dag();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        GraphNode z = new GraphNode("Z");
        GraphNode w = new GraphNode("W");
        dag.addNode(x);
        dag.addNode(y);
        dag.addNode(z);
        dag.addNode(w);
        dag.addDirectedEdge(x, y);
        dag.addDirectedEdge(y, z);
        dag.addDirectedEdge(x, z);
        dag.addDirectedEdge(z, w);
        System.out.println("DAG " + dag);
        Graph graph = GraphUtils.undirectedGraph(dag);
        for (Edge edge : graph.getEdges()) {
            graph.removeEdge(edge);
            graph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        System.out.println("Pattern " + graph);
        DagIterator iterator = new DagIterator(graph);
        int i = 0;
        while (iterator.hasNext()) {
            System.out.println("DAG # " + ++i + iterator.next());
        }
    }

    public void test2() {
        EdgeListGraph pattern = new EdgeListGraph();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        pattern.addNode(x);
        pattern.addNode(y);
        pattern.addDirectedEdge(x, y);
        DagIterator iterator = new DagIterator(pattern);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public void test3() {
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(x1);
        nodes.add(x2);
        nodes.add(x3);
        nodes.add(x4);
        int minEdges = 0;
        int maxEdges = 3;
        DagIterator3 iterator = new DagIterator3(nodes, minEdges, maxEdges);
        int i = 0;
        while (iterator.hasNext()) {
            System.out.println("" + ++i + iterator.next());
        }
    }

    public void test4() {
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(x1);
        nodes.add(x2);
        nodes.add(x3);
        nodes.add(x4);
        DagIterator3 iterator = new DagIterator3(nodes, 0, 0);
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 1);
        iterator = new DagIterator3(nodes, 1, 1);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 28);
        iterator = new DagIterator3(nodes, 2, 2);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 198);
        iterator = new DagIterator3(nodes, 3, 3);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 316);
        iterator = new DagIterator3(nodes, 0, 3);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 543);
        GraphNode x5 = new GraphNode("X5");
        nodes.add(x5);
        iterator = new DagIterator3(nodes, 0, 0);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 1);
        iterator = new DagIterator3(nodes, 1, 1);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 75);
        iterator = new DagIterator3(nodes, 2, 2);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 10610);
        iterator = new DagIterator3(nodes, 3, 3);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 10710);
        iterator = new DagIterator3(nodes, 4, 4);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 16885);
        iterator = new DagIterator3(nodes, 0, 4);
        i = 0;
        while (iterator.hasNext()) {
            ++i;
            iterator.next();
        }
        assert (i == 38281);
    }

    public void test5() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        EdgeListGraph pattern = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        pattern.addNode(x1);
        pattern.addNode(x2);
        pattern.addNode(x3);
        pattern.addNode(x4);
        pattern.addNode(x5);
        pattern.addNode(x6);
        pattern.addUndirectedEdge(x1, x2);
        pattern.addUndirectedEdge(x1, x3);
        pattern.addUndirectedEdge(x1, x4);
        pattern.addUndirectedEdge(x2, x5);
        pattern.addUndirectedEdge(x4, x5);
        pattern.addUndirectedEdge(x5, x6);
        DagInPatternIterator iterator = new DagInPatternIterator(pattern);
        ArrayList<Dag> dags = new ArrayList<Dag>();
        while (iterator.hasNext()) {
            Graph graph = iterator.next();
            try {
                Dag dag = new Dag(graph);
                dags.add(dag);
            }
            catch (IllegalArgumentException e) {}
        }
        for (int i = 0; i < dags.size(); ++i) {
            System.out.println("DAG # " + (i + 1));
            System.out.println(dags.get(i));
        }
    }

    public static Test suite() {
        return new TestSuite(TestDagInPatternIterator.class);
    }
}

