/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestTimeSeries;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndTestFisherZ
extends TestCase {
    private final String[] discreteFiles = new String[]{"test_data/embayes_l1x1x2x3MD.dat", "test_data/determinationtest.dat"};
    private IndTestTimeSeries test;

    public TestIndTestFisherZ(String name) {
        super(name);
    }

    public void testDirections() {
        EdgeListGraph graph1 = new EdgeListGraph();
        EdgeListGraph graph2 = new EdgeListGraph();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        GraphNode z = new GraphNode("Z");
        graph1.addNode(x);
        graph1.addNode(y);
        graph1.addNode(z);
        graph2.addNode(x);
        graph2.addNode(y);
        graph2.addNode(z);
        graph1.addEdge(Edges.directedEdge(x, y));
        graph1.addEdge(Edges.directedEdge(y, z));
        graph2.addEdge(Edges.directedEdge(x, y));
        graph2.addEdge(Edges.directedEdge(z, y));
        SemPm pm1 = new SemPm(graph1);
        SemPm pm2 = new SemPm(graph2);
        SemIm im1 = new SemIm(pm1);
        SemIm im2 = new SemIm(pm2);
        im1.getSemPm().getGraph().setShowErrorTerms(true);
        im2.getSemPm().getGraph().setShowErrorTerms(true);
        im2.setEdgeCoef(x, y, im1.getEdgeCoef(x, y));
        im2.setEdgeCoef(z, y, im1.getEdgeCoef(y, z));
        double varianceFactor = 5.0;
        im2.setErrCovar(x, im1.getErrVar(x) * varianceFactor);
        im2.setErrCovar(y, im1.getErrVar(y) * varianceFactor);
        im2.setErrCovar(z, im1.getErrVar(z) * varianceFactor);
        DataSet data1 = im1.simulateData(1000, false);
        DataSet data2 = im2.simulateData(1000, false);
        IndTestFisherZ test1 = new IndTestFisherZ(data1, 0.05);
        IndTestFisherZ test2 = new IndTestFisherZ(data2, 0.05);
        test1.isIndependent(data1.getVariable(x.getName()), data1.getVariable(z.getName()), new Node[0]);
        double p1 = test1.getPValue();
        test2.isIndependent(data2.getVariable(x.getName()), data2.getVariable(z.getName()), data2.getVariable(y.getName()));
        double p2 = test2.getPValue();
        System.out.println("p1 = " + p1 + " p2 = " + p2);
    }

    public static Test suite() {
        return new TestSuite(TestIndTestFisherZ.class);
    }
}

