/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.FciOld;
import edu.cmu.tetrad.search.IndTestCramerT;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IonSearch;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIonSearch
extends TestCase {
    public TestIonSearch(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        TetradLogger.getInstance().setLogging(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testExampleTrace1() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        EdgeListGraph pag1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        pag1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.CIRCLE));
        pag1.addEdge(new Edge(Y, Z, Endpoint.CIRCLE, Endpoint.CIRCLE));
        pag1.addUnderlineTriple(X, Y, Z);
        EdgeListGraph pag2 = new EdgeListGraph(Arrays.asList(X, W, Z));
        pag2.addEdge(new Edge(X, W, Endpoint.CIRCLE, Endpoint.CIRCLE));
        pag2.addEdge(new Edge(W, Z, Endpoint.CIRCLE, Endpoint.CIRCLE));
        pag2.addUnderlineTriple(X, W, Z);
        IonSearch search = new IonSearch(Arrays.asList(pag1, pag2));
        List<Graph> pags = search.search();
        HashSet<Graph> outputPags = new HashSet<Graph>();
        for (Graph graph : pags) {
            outputPags.add(graph);
        }
        EdgeListGraph O1 = new EdgeListGraph(Arrays.asList(X, Y, W, Z));
        O1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.CIRCLE));
        O1.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.CIRCLE));
        O1.addEdge(new Edge(Z, W, Endpoint.CIRCLE, Endpoint.CIRCLE));
        O1.addUnderlineTriple(Y, W, Z);
        O1.addUnderlineTriple(X, Y, W);
        EdgeListGraph O2 = new EdgeListGraph(Arrays.asList(X, W, Y, Z));
        O2.addEdge(new Edge(X, W, Endpoint.CIRCLE, Endpoint.CIRCLE));
        O2.addEdge(new Edge(Y, Z, Endpoint.CIRCLE, Endpoint.CIRCLE));
        O2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.CIRCLE));
        O2.addUnderlineTriple(X, W, Y);
        O2.addUnderlineTriple(W, Y, Z);
        HashSet<EdgeListGraph> expectedPags = new HashSet<EdgeListGraph>();
        expectedPags.add(O2);
        expectedPags.add(O1);
    }

    public void testExampleTrace2() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        G1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(Z, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(Y, W));
        G2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.ARROW));
        IonSearch search = new IonSearch(Arrays.asList(G1, G2));
        search.search();
    }

    public void testExampleTrace3() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        ContinuousVariable T = new ContinuousVariable("T");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        G1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(Y, Z, Endpoint.ARROW, Endpoint.CIRCLE));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(Y, W, T));
        G2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(W, T, Endpoint.ARROW, Endpoint.CIRCLE));
        IonSearch search = new IonSearch(Arrays.asList(G1, G2));
        search.search();
        System.out.println(search.getStats());
    }

    public void testExampleTrace3b() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        ContinuousVariable T = new ContinuousVariable("T");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        G1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(Y, Z, Endpoint.ARROW, Endpoint.CIRCLE));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(Y, W, T));
        G2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(W, T, Endpoint.ARROW, Endpoint.CIRCLE));
        IonSearch search = new IonSearch(Arrays.asList(G1, G2));
        search.setPathLengthSearch(true);
        search.search();
        System.out.println(search.getStats());
    }

    public void testExampleTrace3c() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        ContinuousVariable T = new ContinuousVariable("T");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        G1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(Y, Z, Endpoint.ARROW, Endpoint.CIRCLE));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(Y, W, T));
        G2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(W, T, Endpoint.ARROW, Endpoint.CIRCLE));
        IonSearch search = new IonSearch(Arrays.asList(G1, G2));
        search.setPathLengthSearch(true);
        search.setAdjacencySearch(false);
        search.search();
        System.out.println(search.getStats());
    }

    public void testExampleTrace3d() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        ContinuousVariable T = new ContinuousVariable("T");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        G1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(Y, Z, Endpoint.ARROW, Endpoint.CIRCLE));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(Y, W, T));
        G2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(W, T, Endpoint.ARROW, Endpoint.CIRCLE));
        IonSearch search = new IonSearch(Arrays.asList(G1, G2));
        search.setAdjacencySearch(false);
        search.search();
        System.out.println(search.getStats());
    }

    public void testError() {
        ContinuousVariable X1 = new ContinuousVariable("X1");
        ContinuousVariable X2 = new ContinuousVariable("X2");
        ContinuousVariable X3 = new ContinuousVariable("X3");
        ContinuousVariable X4 = new ContinuousVariable("X4");
        ContinuousVariable X5 = new ContinuousVariable("X5");
        EdgeListGraph pag1 = new EdgeListGraph(Arrays.asList(X3, X2, X4, X5));
        pag1.addEdge(new Edge(X4, X2, Endpoint.CIRCLE, Endpoint.ARROW));
        pag1.addEdge(new Edge(X5, X2, Endpoint.CIRCLE, Endpoint.ARROW));
        pag1.addEdge(new Edge(X3, X2, Endpoint.CIRCLE, Endpoint.ARROW));
        pag1.addEdge(new Edge(X3, X4, Endpoint.CIRCLE, Endpoint.CIRCLE));
        pag1.addEdge(new Edge(X5, X4, Endpoint.CIRCLE, Endpoint.CIRCLE));
        EdgeListGraph pag2 = new EdgeListGraph(Arrays.asList(X3, X1, X4, X5));
        pag2.addEdge(new Edge(X1, X4, Endpoint.CIRCLE, Endpoint.ARROW));
        pag2.addEdge(new Edge(X3, X4, Endpoint.CIRCLE, Endpoint.ARROW));
        pag2.addEdge(new Edge(X4, X5, Endpoint.TAIL, Endpoint.ARROW));
        IonSearch search = new IonSearch(Arrays.asList(pag1, pag2));
        System.out.println(search.search());
    }

    public void testExampleCompare() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable W = new ContinuousVariable("W");
        ContinuousVariable Z = new ContinuousVariable("Z");
        ContinuousVariable T = new ContinuousVariable("T");
        EdgeListGraph pag1 = new EdgeListGraph(Arrays.asList(X, Y, Z));
        pag1.addEdge(new Edge(X, Y, Endpoint.CIRCLE, Endpoint.ARROW));
        pag1.addEdge(new Edge(Y, Z, Endpoint.ARROW, Endpoint.CIRCLE));
        EdgeListGraph pag2 = new EdgeListGraph(Arrays.asList(Y, W, T));
        pag2.addEdge(new Edge(Y, W, Endpoint.CIRCLE, Endpoint.ARROW));
        pag2.addEdge(new Edge(W, T, Endpoint.ARROW, Endpoint.CIRCLE));
        IonSearch search = new IonSearch(Arrays.asList(pag1, pag2));
        List<Object> search1 = new ArrayList();
        search1 = search.search();
        System.out.println(search.getStats());
        search.setPathLengthSearch(true);
        List<Object> search3 = new ArrayList();
        search3 = search.search();
        System.out.println(search.getStats());
        List<Object> search2 = new ArrayList();
        search.setAdjacencySearch(false);
        search2 = search.search();
        System.out.println(search.getStats());
    }

    public void testExampleTrace4() {
        ContinuousVariable X = new ContinuousVariable("X");
        ContinuousVariable Y = new ContinuousVariable("Y");
        ContinuousVariable Z = new ContinuousVariable("Z");
        ContinuousVariable W = new ContinuousVariable("W");
        EdgeListGraph trueGraph = new EdgeListGraph(Arrays.asList(X, Y, Z, W));
        trueGraph.addEdge(new Edge(W, X, Endpoint.TAIL, Endpoint.ARROW));
        trueGraph.addEdge(new Edge(W, Z, Endpoint.TAIL, Endpoint.ARROW));
        trueGraph.addEdge(new Edge(X, Y, Endpoint.TAIL, Endpoint.ARROW));
        trueGraph.addEdge(new Edge(Z, Y, Endpoint.TAIL, Endpoint.ARROW));
        FciOld fci1 = new FciOld(new IndTestDSep(trueGraph), Arrays.asList(W, X, Y));
        Graph pag1 = fci1.search();
        FciOld fci2 = new FciOld(new IndTestDSep(trueGraph), Arrays.asList(W, Z, Y));
        Graph pag2 = fci2.search();
        ArrayList<Graph> list = new ArrayList<Graph>();
        list.add(pag1);
        list.add(pag2);
        IonSearch search = new IonSearch(list);
        search.search();
    }

    public void testExampleTraceCycle() {
        ContinuousVariable A = new ContinuousVariable("X1");
        ContinuousVariable B = new ContinuousVariable("X2");
        ContinuousVariable C = new ContinuousVariable("X3");
        ContinuousVariable D = new ContinuousVariable("X4");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(A, C, D));
        G1.addEdge(new Edge(A, C, Endpoint.CIRCLE, Endpoint.CIRCLE));
        G1.addEdge(new Edge(C, D, Endpoint.CIRCLE, Endpoint.CIRCLE));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(B, C, D));
        G2.addEdge(new Edge(B, D, Endpoint.CIRCLE, Endpoint.CIRCLE));
        G2.addEdge(new Edge(D, C, Endpoint.CIRCLE, Endpoint.CIRCLE));
        EdgeListGraph G3 = new EdgeListGraph(Arrays.asList(A, B, C));
        G3.addEdge(new Edge(A, B, Endpoint.CIRCLE, Endpoint.CIRCLE));
        G3.addEdge(new Edge(A, C, Endpoint.CIRCLE, Endpoint.CIRCLE));
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        graphs.add(G1);
        graphs.add(G2);
        graphs.add(G3);
        IonSearch search = new IonSearch(graphs);
        List<Graph> pags = search.search();
    }

    public void rtestIonSearchOnData() {
        DataSet dataSet1 = null;
        DataSet dataSet2 = null;
        try {
            DataReader reader = new DataReader();
            dataSet1 = reader.parseTabular(new File("test_data/TestIonL.txt"));
            dataSet2 = reader.parseTabular(new File("test_data/TestIonR.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestIonSearch.fail();
        }
        LinkedList<Graph> pags = new LinkedList<Graph>();
        IndTestCramerT independenceTest = new IndTestCramerT(dataSet1, 0.05);
        FciOld fci = new FciOld(independenceTest);
        pags.add(fci.search());
        independenceTest = new IndTestCramerT(dataSet2, 0.05);
        fci = new FciOld(independenceTest);
        pags.add(fci.search());
        IonSearch search = new IonSearch(pags);
        search.search();
    }

    public static Test suite() {
        return new TestSuite(TestIonSearch.class);
    }
}

