/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.Ling;
import edu.cmu.tetrad.search.Lingam;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.GaussianPower;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLing
extends TestCase {
    public TestLing(String name) {
        super(name);
    }

    public void test() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        gWP.addEdge("X1", "X2", 1.2);
        gWP.addEdge("X2", "X3", 2.0);
        gWP.addEdge("X3", "X4", -1.0);
        gWP.addEdge("X4", "X2", -0.3);
        gWP.addEdge("X2", "X5", 3.0);
        System.out.println("Input Graph");
        System.out.println(gWP);
        Ling t = new Ling(gWP, 15000);
        Ling.StoredGraphs gs = t.search();
        int zeroless = gs.getNumGraphs();
        System.out.println("There are " + zeroless + " zeroless diagonal permutations.");
        for (int i = 0; i < zeroless; ++i) {
            System.out.println("Shrinking = " + gs.isStable(i));
            System.out.println("Graph = " + gs.getGraph(i));
            System.out.println("Data = " + gs.getData(i));
        }
    }

    public void test1_6() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        gWP.addEdge("X1", "X2", -1.0);
        gWP.addEdge("X2", "X3", 0.5);
        gWP.addEdge("X3", "X1", 1.0);
        gWP.addEdge("X1", "X3", 0.5);
        System.out.println("Input Graph");
        System.out.println(gWP);
        DoubleMatrix2D b = gWP.getGraphMatrix().getDoubleData();
        boolean smaller = TestLing.allEigenvaluesAreSmallerThanOneInModulus(b);
        System.out.println("All eigenvalues smaller than one in modulus: " + smaller);
    }

    public void test1_7() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        gWP.addEdge("X1", "X2", 1.0);
        gWP.addEdge("X2", "X3", 1.0);
        gWP.addEdge("X3", "X1", 0.4999);
        gWP.addEdge("X2", "X4", 1.0);
        gWP.addEdge("X4", "X1", 0.4999);
        System.out.println("Input Graph");
        System.out.println(gWP);
        DoubleMatrix2D b = gWP.getGraphMatrix().getDoubleData();
        boolean smaller = TestLing.allEigenvaluesAreSmallerThanOneInModulus(b);
        System.out.println("All eidgenvalues smaller than one in modulus: " + smaller);
    }

    public void test1_8() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        gWP.addEdge("X2", "X1", 1.0);
        gWP.addEdge("X3", "X2", 1.0);
        gWP.addEdge("X1", "X4", 1.0);
        gWP.addEdge("X4", "X3", 0.25);
        gWP.addEdge("X4", "X2", 1.75);
        gWP.addEdge("X3", "X1", -9.9);
        System.out.println("Input Graph");
        System.out.println(gWP);
        DoubleMatrix2D b = gWP.getGraphMatrix().getDoubleData();
        boolean smaller = TestLing.allEigenvaluesAreSmallerThanOneInModulus(b);
        System.out.println("All eigenvalues smaller than one in modulus: " + smaller);
    }

    public void test1_9() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        g.addNode(new GraphNode("X6"));
        gWP.addEdge("X2", "X1", 1.0);
        gWP.addEdge("X2", "X3", 1.0);
        gWP.addEdge("X3", "X1", 1.0);
        gWP.addEdge("X4", "X5", 1.0);
        gWP.addEdge("X5", "X6", 1.0);
        gWP.addEdge("X6", "X4", 0.9);
        gWP.addEdge("X1", "X4", 1.0);
        System.out.println("Input Graph");
        System.out.println(gWP);
        DoubleMatrix2D b = gWP.getGraphMatrix().getDoubleData();
        boolean smaller = TestLing.allEigenvaluesAreSmallerThanOneInModulus(b);
        System.out.println("All eigenvalues smaller than one in modulus: " + smaller);
        for (int i = 0; i < 1000; ++i) {
            for (Edge edge : gWP.getGraph().getEdges()) {
                gWP.getWeightHash().put(edge, 6.0 * RandomUtil.getInstance().nextDouble() - 3.0);
            }
            DoubleMatrix2D b1 = gWP.getGraphMatrix().getDoubleData();
            boolean smaller1 = TestLing.allEigenvaluesAreSmallerThanOneInModulus(b1);
            System.out.println("All eidgenvalues smaller than one in modulus: " + smaller1);
        }
    }

    public void test2() {
        Dag dag = GraphUtils.randomDag(6, 0, 7, 3, 3, 4, false);
        Graph graph = GraphUtils.addCycles(dag, 3, 2);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        for (Node node : im.getSemPm().getGraph().getNodes()) {
            im.setDistribution(node, new GaussianPower(2.0));
        }
        DataSet data = im.simulateDataReducedForm(15000, false);
        System.out.println("Input Graph");
        System.out.println(graph);
        Ling t = new Ling(new GraphWithParameters(im, graph), 15000);
        Ling.StoredGraphs gs = t.search();
        int zeroless = gs.getNumGraphs();
        System.out.println("There are " + zeroless + " zeroless diagonal permutations.");
        for (int i = 0; i < zeroless; ++i) {
            System.out.println("Shrinking = " + gs.isStable(i));
            System.out.println("Graph = " + gs.getGraph(i));
        }
    }

    public void test2_1() {
        Dag dag = GraphUtils.randomDag(8, 0, 8, 3, 3, 4, false);
        Graph graph = GraphUtils.addCycles(dag, 1, 3);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        GraphWithParameters gWP = new GraphWithParameters(im, pm.getGraph());
        Ling t = new Ling(gWP, 15000);
        System.out.println(graph);
        Ling.StoredGraphs gs = t.search();
        int zeroless = gs.getNumGraphs();
        System.out.println("There are " + zeroless + " zeroless diagonal permutations.");
        for (int i = 0; i < zeroless; ++i) {
            System.out.println("Shrinking = " + gs.isStable(i));
            System.out.println("Graph = " + gs.getGraph(i));
        }
    }

    public void test3() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        gWP.addEdge("X1", "X2", 1.0);
        gWP.addEdge("X2", "X3", 2.0);
        gWP.addEdge("X3", "X4", -0.5);
        gWP.addEdge("X4", "X1", 1.0);
        System.out.println("Input Graph");
        System.out.println(gWP);
        Ling t = new Ling(gWP, 15000);
        Ling.StoredGraphs gs = t.search();
        int zeroless = gs.getNumGraphs();
        System.out.println("There are " + zeroless + " zeroless diagonal permutations.");
        for (int i = 0; i < zeroless; ++i) {
            System.out.println("Shrinking = " + gs.isStable(i));
            System.out.println("Graph = " + gs.getGraph(i));
        }
    }

    public void test4() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        g.addNode(new GraphNode("X6"));
        gWP.addEdge("X1", "X2", 0.5);
        gWP.addEdge("X3", "X4", -2.0);
        gWP.addEdge("X2", "X4", 1.4);
        gWP.addEdge("X4", "X2", -2.0);
        gWP.addEdge("X2", "X6", -1.0);
        gWP.addEdge("X4", "X5", -0.7);
        gWP.addEdge("X5", "X6", 0.8);
        gWP.addEdge("X6", "X5", 1.0);
        System.out.println("Input Graph");
        System.out.println(gWP);
        Ling t = new Ling(gWP, 15000);
        Ling.StoredGraphs gs = t.search();
        int zeroless = gs.getNumGraphs();
        System.out.println("There are " + zeroless + " zeroless diagonal permutations.");
        for (int i = 0; i < zeroless; ++i) {
            System.out.println("Shrinking = " + gs.isStable(i));
            System.out.println("Graph = " + gs.getGraph(i));
        }
    }

    public void test5() {
        EdgeListGraph g = new EdgeListGraph();
        GraphWithParameters gWP = new GraphWithParameters(g);
        g.addNode(new GraphNode("X1"));
        g.addNode(new GraphNode("X2"));
        g.addNode(new GraphNode("X3"));
        g.addNode(new GraphNode("X4"));
        g.addNode(new GraphNode("X5"));
        g.addNode(new GraphNode("X6"));
        gWP.addEdge("X1", "X2", 1.5);
        gWP.addEdge("X2", "X4", 0.4);
        gWP.addEdge("X4", "X2", -1.1);
        gWP.addEdge("X2", "X6", -1.0);
        gWP.addEdge("X5", "X6", 0.8);
        gWP.addEdge("X6", "X5", 1.0);
        System.out.println("Input Graph");
        System.out.println(gWP);
        Ling t = new Ling(gWP, 15000);
        Ling.StoredGraphs gs = t.search();
        int zeroless = gs.getNumGraphs();
        System.out.println("There are " + zeroless + " zeroless diagonal permutations.");
        for (int i = 0; i < zeroless; ++i) {
            System.out.println("Shrinking = " + gs.isStable(i));
            System.out.println("Graph = " + gs.getGraph(i));
        }
    }

    public void test6() {
        double avg = 0.0;
        int iterations = 10;
        for (int i = 0; i < iterations; ++i) {
            Dag dag = GraphUtils.randomDag(5, 0, 5, 3, 3, 4, false);
            Graph graph = GraphUtils.addCycles(dag, 1, 10);
            SemPm pm = new SemPm(graph);
            SemIm im = new SemIm(pm);
            Ling t = new Ling(new GraphWithParameters(im, graph), 15000);
            DataSet data = t.getData();
            long sTime = new Date().getTime();
            t.search();
            long eTime = new Date().getTime();
            long dif1 = eTime - sTime;
            Lingam t2 = new Lingam();
            sTime = new Date().getTime();
            t2.search(data);
            eTime = new Date().getTime();
            long dif2 = eTime - sTime;
            avg += (double)dif1 / (double)dif2;
        }
        System.out.println("Average of the difference ratio is: " + avg / (double)iterations);
    }

    public void test7() {
        try {
            DataReader reader = new DataReader();
            DataSet data = reader.parseTabular(new File("test_data/roidata.txt"));
            Ling t = new Ling(data);
            t.setThreshold(1.5);
            t.search();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean allEigenvaluesAreSmallerThanOneInModulus(DoubleMatrix2D b) {
        EigenvalueDecomposition dec = new EigenvalueDecomposition(b);
        DoubleMatrix1D realEigenvalues = dec.getRealEigenvalues();
        DoubleMatrix1D imagEigenvalues = dec.getImagEigenvalues();
        boolean allEigenvaluesSmallerThanOneInModulus = true;
        for (int i = 0; i < realEigenvalues.size(); ++i) {
            double realEigenvalue = realEigenvalues.get(i);
            double imagEigenvalue = imagEigenvalues.get(i);
            double modulus = Math.sqrt(Math.pow(realEigenvalue, 2.0) + Math.pow(imagEigenvalue, 2.0));
            if (!(modulus >= 1.0)) continue;
            allEigenvaluesSmallerThanOneInModulus = false;
        }
        return allEigenvaluesSmallerThanOneInModulus;
    }

    public static Test suite() {
        return new TestSuite(TestLing.class);
    }
}

