/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Pattern;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.PatternToDag;
import edu.cmu.tetrad.search.PcPattern;
import edu.cmu.tetrad.search.Pcd;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPcPattern
extends TestCase {
    public TestPcPattern(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        RandomUtil.getInstance().setSeed(295838249L);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testSearch1() {
        this.checkSearch("X1-->X2,X1-->X3,X2-->X4,X3-->X4", "X1---X2,X1---X3,X2-->X4,X3-->X4");
    }

    public void testSearch2() {
        this.checkSearch("A-->D,A-->B,B-->D,C-->D,D-->E", "A-->D,A---B,B-->D,C-->D,D-->E");
    }

    public void testSearch3() {
        Knowledge knowledge = new Knowledge();
        knowledge.setEdgeForbidden("B", "D", true);
        knowledge.setEdgeForbidden("D", "B", true);
        this.checkWithKnowledge("A-->B,C-->B,B-->D", "A-->B,C-->B,D", knowledge);
    }

    public void compareToPc() {
        int success = 0;
        int fail = 0;
        int totBidirected = 0;
        int numCyclic = 0;
        for (int i = 0; i < 100; ++i) {
            TetradLogger.getInstance().log("info", "# " + (i + 1));
            try {
                Dag graph = GraphUtils.randomDag(20, 0, 20, 4, 4, 4, false);
                SemPm pm = new SemPm(graph);
                SemIm im = new SemIm(pm);
                DataSet dataSet = im.simulateData(1000, false);
                IndTestFisherZ test = new IndTestFisherZ(dataSet, 0.05);
                PcPattern search = new PcPattern(test);
                Graph graph2 = search.search();
                int numBidirected = 0;
                for (Edge edge : graph2.getEdges()) {
                    if (!Edges.isBidirectedEdge(edge)) continue;
                    ++numBidirected;
                }
                totBidirected += numBidirected;
                if (graph2.existsDirectedCycle()) {
                    ++numCyclic;
                    TetradLogger.getInstance().log("info", "Cyclic pattern!");
                }
                new PatternToDag(new Pattern(graph2)).patternToDagMeekRules();
                ++success;
                continue;
            }
            catch (IllegalArgumentException e) {
                ++fail;
            }
        }
        TetradLogger.getInstance().log("info", "success = " + success + " fail = " + fail);
        TetradLogger.getInstance().log("info", "Total bidirected edges = " + totBidirected + " num cyclic = " + numCyclic);
    }

    private void checkSearch(String inputGraph, String outputGraph) {
        Graph graph = GraphConverter.convert(inputGraph);
        IndTestDSep independence = new IndTestDSep(graph);
        Pcd pc = new Pcd(independence);
        Graph resultGraph = pc.search();
        Graph trueGraph = GraphConverter.convert(outputGraph);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
        System.out.println("\nTrue graph:");
        System.out.println(trueGraph);
        TestPcPattern.assertTrue(((Object)resultGraph).equals(trueGraph));
    }

    private void checkWithKnowledge(String inputGraph, String outputGraph, Knowledge knowledge) {
        Graph graph = GraphConverter.convert(inputGraph);
        IndTestDSep independence = new IndTestDSep(graph);
        PcPattern pcSearch = new PcPattern(independence);
        pcSearch.setKnowledge(knowledge);
        Graph resultGraph = pcSearch.search();
        Graph trueGraph = GraphConverter.convert(outputGraph);
        System.out.println("\nKnowldge:");
        System.out.println(knowledge);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
        System.out.println("\nTrue graph:");
        System.out.println(trueGraph);
        TestPcPattern.assertTrue(((Object)resultGraph).equals(trueGraph));
    }

    public static Test suite() {
        return new TestSuite(TestPcPattern.class);
    }
}

