/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestVarianceTiebreaking
extends TestCase {
    public TestVarianceTiebreaking(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testSearch1() {
        Dag dag = new Dag();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        GraphNode z = new GraphNode("Z");
        dag.addNode(x);
        dag.addNode(y);
        dag.addNode(z);
        dag.addDirectedEdge(x, y);
        dag.addDirectedEdge(y, z);
        dag.addDirectedEdge(x, z);
        System.out.println(dag);
        SemPm semPm = new SemPm(dag);
        SemIm semIm = new SemIm(semPm);
        semIm.setParamValue(x, y, 1.0);
        semIm.setParamValue(y, z, -0.5);
        semIm.setParamValue(x, z, 0.5);
        System.out.println(semIm);
        DataSet data = semIm.simulateData(1000, false);
        CovarianceMatrix cov = new CovarianceMatrix(data);
        System.out.println("x");
        System.out.println(this.variance(x, cov));
        System.out.println(this.conditionalVariance(x, y, cov));
        System.out.println(this.conditionalVariance(x, z, cov));
        System.out.println("y");
        System.out.println(this.variance(y, cov));
        System.out.println(this.conditionalVariance(y, x, cov));
        System.out.println(this.conditionalVariance(y, z, cov));
        System.out.println("z");
        System.out.println(this.variance(z, cov));
        System.out.println(this.conditionalVariance(z, x, cov));
        System.out.println(this.conditionalVariance(z, y, cov));
    }

    private double variance(Node x, CovarianceMatrix cov) {
        int index = cov.getVariableNames().indexOf(x.getName());
        return cov.getMatrix().get(index, index);
    }

    private double conditionalVariance(Node x, Node y, CovarianceMatrix cov) {
        int[] indices = new int[2];
        List<String> variableNames = cov.getVariableNames();
        indices[0] = variableNames.indexOf(x.getName());
        indices[1] = variableNames.indexOf(y.getName());
        DoubleMatrix2D submatrix = cov.getMatrix().viewSelection(indices, indices);
        if (new Algebra().rank(submatrix) != submatrix.rows()) {
            throw new IllegalArgumentException("Matrix singularity detected.");
        }
        submatrix = MatrixUtils.inverseC(submatrix);
        double d = submatrix.get(0, 0);
        return (d - 1.0) / d;
    }

    private double conditionalVariance(Node x, Node y, Node z, CovarianceMatrix cov) {
        int[] indices = new int[3];
        List<String> variableNames = cov.getVariableNames();
        indices[0] = variableNames.indexOf(x.getName());
        indices[1] = variableNames.indexOf(y.getName());
        indices[2] = variableNames.indexOf(z.getName());
        DoubleMatrix2D submatrix = cov.getMatrix().viewSelection(indices, indices);
        if (new Algebra().rank(submatrix) != submatrix.rows()) {
            throw new IllegalArgumentException("Matrix singularity detected.");
        }
        submatrix = MatrixUtils.inverseC(submatrix);
        double d = submatrix.get(0, 0);
        return (d - 1.0) / d;
    }

    public static Test suite() {
        return new TestSuite(TestVarianceTiebreaking.class);
    }
}

