/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica;

import edu.cmu.tetrad.search.fastica.math.EigenValueDecompositionSymm;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.search.fastica.math.Vector;

public class PCA {
    private double[] meanValues;
    private double[][] vectorsZeroMean;
    private double[][] covarianceMatrix;
    private double[] eigenValues;
    private double[][] eigenVectors;
    private double[][] resVectors;

    public PCA(double[][] inVectors) {
        this.meanValues = PCA.calcMeanValues(inVectors);
        this.vectorsZeroMean = Vector.addVecToSet(inVectors, Vector.scale(-1.0, this.meanValues));
        this.covarianceMatrix = Matrix.scale(Matrix.square(this.vectorsZeroMean), 1.0 / (double)Matrix.getNumOfColumns(inVectors));
        EigenValueDecompositionSymm eigenDeco = new EigenValueDecompositionSymm(this.covarianceMatrix);
        this.eigenVectors = eigenDeco.getEigenVectors();
        this.eigenValues = eigenDeco.getEigenValues();
        this.resVectors = Matrix.mult(Matrix.transpose(this.eigenVectors), this.vectorsZeroMean);
    }

    public double[] getEigenValues() {
        return this.eigenValues;
    }

    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }

    public double[] getMeanValues() {
        return this.meanValues;
    }

    public double[][] getVectorsZeroMean() {
        return this.vectorsZeroMean;
    }

    public double[][] getResultingVectors() {
        return this.resVectors;
    }

    private static double[] calcMeanValues(double[][] inVectors) {
        int m = Matrix.getNumOfRows(inVectors);
        int n = Matrix.getNumOfColumns(inVectors);
        double[] meanValues = Vector.newVector(m);
        int i = 0;
        while (i < m) {
            meanValues[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                meanValues[n2] = meanValues[n2] + inVectors[i][j];
            }
            int n3 = i++;
            meanValues[n3] = meanValues[n3] / (double)n;
        }
        return meanValues;
    }
}

