/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import edu.cmu.tetrad.search.fastica.EigenValueFilter;
import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.search.fastica.math.Vector;
import edu.cmu.tetrad.search.fastica.swing.EigenValueDialog;
import javax.swing.JFrame;

public class DialogEVFilter
implements EigenValueFilter {
    private JFrame owner;
    private double[] eigenValues;
    private double[][] eigenVectors;

    public DialogEVFilter(JFrame owner) {
        this.owner = owner;
    }

    @Override
    public void passEigenValues(double[] eigenValues, double[][] eigenVectors) {
        EigenValueDialog eigenDl = new EigenValueDialog(this.owner, "Please select the eigenvalues...", eigenValues);
        if (eigenDl.open()) {
            boolean[] accept = eigenDl.getAcceptanceList();
            int l = accept.length;
            int n = 0;
            for (int i = 0; i < l; ++i) {
                if (!accept[i]) continue;
                ++n;
            }
            int m = Matrix.getNumOfRows(eigenVectors);
            this.eigenValues = Vector.newVector(n);
            this.eigenVectors = Matrix.newMatrix(m, n);
            int ii = 0;
            for (int i = 0; i < l; ++i) {
                if (!accept[i]) continue;
                this.eigenValues[ii] = eigenValues[i];
                for (int j = 0; j < m; ++j) {
                    this.eigenVectors[j][ii] = eigenVectors[j][i];
                }
                ++ii;
            }
        } else {
            this.eigenValues = eigenValues;
            this.eigenVectors = eigenVectors;
        }
    }

    @Override
    public double[] getEigenValues() {
        return this.eigenValues;
    }

    @Override
    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }
}

