/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WaveMerger {
    public static void main(String[] args) {
        try {
            AudioInputStream aistream0 = AudioSystem.getAudioInputStream(new File(args[0]));
            AudioInputStream aistream1 = AudioSystem.getAudioInputStream(new File(args[1]));
            float sampleRate = aistream0.getFormat().getSampleRate();
            AudioFormat format = new AudioFormat(sampleRate, 16, 1, false, false);
            DataInputStream distream0 = new DataInputStream(new BufferedInputStream(AudioSystem.getAudioInputStream(format, aistream0)));
            DataInputStream distream1 = new DataInputStream(new BufferedInputStream(AudioSystem.getAudioInputStream(format, aistream1)));
            int n = (int)aistream0.getFrameLength();
            byte[] data = new byte[n * 4];
            for (int j = 0; j < n; ++j) {
                short val = distream0.readShort();
                data[j * 4 + 1] = (byte)(val & 0xFF);
                data[j * 4 + 0] = (byte)(val >> 8);
                val = distream1.readShort();
                data[j * 4 + 3] = (byte)(val & 0xFF);
                data[j * 4 + 2] = (byte)(val >> 8);
            }
            format = new AudioFormat(sampleRate, 16, 2, false, false);
            AudioInputStream ostream = new AudioInputStream(new ByteArrayInputStream(data), format, n);
            AudioSystem.write(ostream, AudioFileFormat.Type.WAVE, new File(args[2]));
        }
        catch (Exception exc) {
            exc.printStackTrace(System.err);
        }
    }
}

