/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.kernel;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.search.kernel.KernelGaussian;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Arrays;
import junit.framework.TestCase;

public class TestKernelGaussian
extends TestCase {
    public TestKernelGaussian(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        TetradLogger.getInstance().setLogging(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testMedianBandwidth() {
        ContinuousVariable X = new ContinuousVariable("X");
        ColtDataSet dataset = new ColtDataSet(5, Arrays.asList(X));
        dataset.setDouble(0, 0, 1.0);
        dataset.setDouble(1, 0, 2.0);
        dataset.setDouble(2, 0, 3.0);
        dataset.setDouble(3, 0, 4.0);
        dataset.setDouble(4, 0, 5.0);
        KernelGaussian kernel = new KernelGaussian(dataset, X);
        TestKernelGaussian.assertTrue(kernel.getBandwidth() == 2.0);
    }

    public void testEval() {
        KernelGaussian kernel = new KernelGaussian(2.6851);
        System.out.println(kernel.eval(10.2381, 11.3825));
    }
}

