/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemEstimatorGibbs;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;

public class GibbsEstimatorTester {
    public static void main(String[] args) {
        SemGraph leadGraph = new SemGraph();
        GraphNode LE = new GraphNode("LE");
        GraphNode le = new GraphNode("le");
        GraphNode iq = new GraphNode("iq");
        leadGraph.addNode(LE);
        leadGraph.addNode(le);
        leadGraph.addNode(iq);
        LE.setNodeType(NodeType.LATENT);
        le.setNodeType(NodeType.MEASURED);
        iq.setNodeType(NodeType.MEASURED);
        leadGraph.addDirectedEdge(LE, le);
        leadGraph.addDirectedEdge(LE, iq);
        leadGraph.setShowErrorTerms(true);
        System.out.println(leadGraph);
        SemPm semPm = new SemPm(leadGraph);
        SemGraph leadSemGraph = semPm.getGraph();
        leadSemGraph.setShowErrorTerms(true);
        Node leError = leadSemGraph.getErrorNode(le);
        System.out.println("leError " + leError);
        Node iqError = leadSemGraph.getErrorNode(iq);
        System.out.println("Graph as retrieved from SemPm");
        System.out.println(semPm.getGraph());
        double[][] covariances = new double[][]{{2.0, -0.2}, {-0.2, 1.04}};
        double[][] sampleCovars1 = new double[][]{{1.947, -0.262}, {-0.262, 0.8619}};
        DenseDoubleMatrix2D sampleCovars = new DenseDoubleMatrix2D(sampleCovars1);
        String[] varNames = new String[]{"le", "iq"};
        SemIm semIm = new SemIm(semPm);
        Parameter varLE = semPm.getVarianceParameter(LE);
        varLE.setFixed(true);
        semIm.setParamValue(varLE, 1.0);
        Parameter varleError = semPm.getVarianceParameter(leError);
        varleError.setFixed(false);
        semIm.setParamValue(varleError, 1.0);
        Parameter variqError = semPm.getVarianceParameter(iqError);
        variqError.setFixed(false);
        semIm.setParamValue(variqError, 1.0);
        Parameter coefLEle = semPm.getCoefficientParameter(LE, le);
        coefLEle.setFixed(false);
        semIm.setParamValue(coefLEle, 1.0);
        Parameter coefLEiq = semPm.getCoefficientParameter(LE, iq);
        coefLEiq.setFixed(false);
        semIm.setParamValue(coefLEiq, -0.5);
        int sampleSize = 100;
        CovarianceMatrix covMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), sampleCovars, sampleSize);
        semIm.setCovMatrix(covMatrix);
        boolean flatPrior = true;
        double stretch = 2.0;
        int numIterations = 2000;
        long seed = -3186053L;
        SemEstimatorGibbs estimator = new SemEstimatorGibbs(semPm, semIm, covMatrix.getMatrix().toArray(), flatPrior, stretch, numIterations);
        estimator.estimate();
        System.out.println(estimator.getEstimatedSem());
    }
}

