/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.search.HitonClassifier;
import java.io.File;
import java.io.IOException;

public final class HitonClassifyTester {
    public static void main(String[] args) {
        try {
            int i;
            String filenameD1 = args[0];
            String filenameD2 = args[1];
            File fileD1 = new File(filenameD1);
            File fileD2 = new File(filenameD2);
            Object frD1 = null;
            double alpha = Double.parseDouble(args[2]);
            String targetVariableString = args[3];
            int depth = Integer.parseInt(args[4]);
            DataReader reader = new DataReader();
            DataSet dds1 = reader.parseTabular(fileD1);
            reader.setKnownVariables(dds1.getVariables());
            DataSet dds2 = reader.parseTabular(fileD2);
            HitonClassifier hitonc = new HitonClassifier(dds1, dds2, targetVariableString, alpha, depth);
            int[][] crossTabs = hitonc.crossTabulation();
            DiscreteVariable targetVariable = hitonc.getTargetVariable();
            int nvalues = targetVariable.getNumCategories();
            System.out.println("Target Variable " + targetVariableString);
            System.out.println("\t\t\tEstimated\t");
            System.out.print("Observed\t");
            for (i = 0; i < nvalues - 1; ++i) {
                System.out.print(targetVariable.getCategory(i) + "\t");
            }
            System.out.print(targetVariable.getCategory(nvalues - 1));
            System.out.println();
            for (i = 0; i < nvalues; ++i) {
                System.out.print(targetVariable.getCategory(i) + "\t\t");
                for (int j = 0; j < nvalues - 1; ++j) {
                    System.out.print(crossTabs[i][j] + "\t");
                }
                System.out.print(crossTabs[i][nvalues - 1]);
                System.out.println();
            }
            System.out.println("Percentage correctly classified:  ");
            System.out.println(hitonc.getPercentCorrect());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

