/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FciOld;
import edu.cmu.tetrad.search.IONSearchOriginal;
import edu.cmu.tetrad.search.IndTestCramerT;
import edu.cmu.tetrad.search.SepsetMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class IonTester {
    public static void main(String[] args) {
        double alpha = 0.05;
        String file1 = "test_data/TestIonL.txt";
        DataSet dataSet1 = null;
        try {
            DataReader reader = new DataReader();
            dataSet1 = reader.parseTabular(new File(file1));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String file2 = "test_data/TestIonR.txt";
        DataSet dataSet2 = null;
        try {
            DataReader reader = new DataReader();
            dataSet2 = reader.parseTabular(new File(file2));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Graph[] pag = new Graph[2];
        SepsetMap[] ss = new SepsetMap[2];
        System.out.println("For alpha = " + alpha);
        IndTestCramerT indTest1 = new IndTestCramerT(dataSet1, alpha);
        List<Node> listOfNodes1 = indTest1.getVariables();
        int numNodes1 = listOfNodes1.size();
        System.out.println("List of nodes " + numNodes1);
        Iterator<Node> i$ = listOfNodes1.iterator();
        while (i$.hasNext()) {
            Node node;
            Node var = node = i$.next();
            System.out.println(var);
        }
        Knowledge bk1 = new Knowledge();
        FciOld fci1 = new FciOld(indTest1);
        pag[0] = fci1.search();
        ss[0] = fci1.getSepsetMap();
        System.out.println("For alpha = " + alpha);
        IndTestCramerT indTest2 = new IndTestCramerT(dataSet2, alpha);
        List<Node> listOfNodes2 = indTest2.getVariables();
        int numNodes2 = listOfNodes2.size();
        System.out.println("List of nodes " + numNodes2);
        Iterator<Node> i$2 = listOfNodes2.iterator();
        while (i$2.hasNext()) {
            Node node;
            Node var = node = i$2.next();
            System.out.println(var);
        }
        Knowledge bk2 = new Knowledge();
        FciOld fci2 = new FciOld(indTest2);
        pag[1] = fci2.search();
        ss[1] = fci2.getSepsetMap();
        IONSearchOriginal ionSearch = new IONSearchOriginal(pag, ss, bk1);
        Graph gOut = ionSearch.search();
        System.out.println("Result of ION Algorithm");
        System.out.println(gOut);
        boolean[][] confirmed = ionSearch.getConfirmed();
        List<Node> nodes = gOut.getNodes();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            Node X = nodes.get(i);
            for (int j = i; j < n; ++j) {
                Node Y = nodes.get(j);
                if (!gOut.isAdjacentTo(X, Y)) continue;
                System.out.println("Edge between " + X + " and " + Y + " " + confirmed[i][j]);
            }
        }
    }
}

