/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestCramerT;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class SemIndTestPower {
    private static CorrelationMatrix corrMatrix;
    private static List variables;
    private static double alpha;

    public static void main(String[] args) {
        double[][][] allPowersT = new double[4][5][3];
        double[][][] allSensesT = new double[4][5][3];
        double[][][] allPowersF = new double[4][5][3];
        double[][][] allSensesF = new double[4][5][3];
        int numNodes = 20;
        int numLatents = 0;
        int[] edges = new int[]{20, 30, 50, 100};
        int[] samples = new int[]{10, 20, 50, 100, 1000};
        double[] sigs = new double[]{0.01, 0.05, 0.1};
        int ncases = 0;
        double sumTtestP = 0.0;
        double sumTtestS = 0.0;
        double sumFisherP = 0.0;
        double sumFisherS = 0.0;
        for (int iedges = 0; iedges < edges.length; ++iedges) {
            for (int isamp = 0; isamp < samples.length; ++isamp) {
                for (int isig = 0; isig < sigs.length; ++isig) {
                    int numEdges = edges[iedges];
                    int sampleSize = samples[isamp];
                    boolean latentDataSaved = false;
                    double alpha = sigs[isig];
                    int[][] corrConfusion = new int[][]{{0, 0}, {0, 0}};
                    int[][] fishConfusion = new int[][]{{0, 0}, {0, 0}};
                    for (int k = 0; k < 100; ++k) {
                        Dag graph = GraphUtils.randomDagC(numNodes, numLatents, numEdges);
                        SemPm semPm = new SemPm(graph);
                        SemIm sem = new SemIm(semPm);
                        DataSet contDataColumnContinuous = sem.simulateData(sampleSize, latentDataSaved);
                        sem.setDataSet(contDataColumnContinuous);
                        DoubleMatrix2D covar = sem.getSampleCovar();
                        int nvars = covar.rows();
                        String[] varNames = new String[nvars];
                        List<Node> nodes = sem.getMeasuredNodes();
                        for (int i = 0; i < nvars; ++i) {
                            varNames[i] = nodes.get(i).getName();
                        }
                        CovarianceMatrix covarMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), covar, sampleSize);
                        variables = covarMatrix.getVariables();
                        corrMatrix = new CorrelationMatrix(covarMatrix);
                        IndTestCramerT indTestCramerT = new IndTestCramerT(corrMatrix, alpha);
                        IndTestFisherZ indTestF = new IndTestFisherZ(corrMatrix, alpha);
                        IndTestDSep indTestG = new IndTestDSep(graph);
                        LinkedList<Node> cond = new LinkedList<Node>();
                        cond.add((Node)variables.get(2));
                        cond.add((Node)variables.get(3));
                        cond.add((Node)variables.get(4));
                        boolean indCorr = indTestCramerT.isIndependent((Node)variables.get(0), (Node)variables.get(1), cond);
                        boolean indGraph = indTestG.isIndependent((Node)variables.get(0), (Node)variables.get(1), cond);
                        boolean indFisher = indTestF.isIndependent((Node)variables.get(0), (Node)variables.get(1), cond);
                        if (!indGraph && !indCorr) {
                            int[] nArray = corrConfusion[0];
                            nArray[0] = nArray[0] + 1;
                        }
                        if (indGraph && indCorr) {
                            int[] nArray = corrConfusion[1];
                            nArray[1] = nArray[1] + 1;
                        }
                        if (!indGraph && indCorr) {
                            int[] nArray = corrConfusion[0];
                            nArray[1] = nArray[1] + 1;
                        }
                        if (indGraph && !indCorr) {
                            int[] nArray = corrConfusion[1];
                            nArray[0] = nArray[0] + 1;
                        }
                        if (!indGraph && !indFisher) {
                            int[] nArray = fishConfusion[0];
                            nArray[0] = nArray[0] + 1;
                        }
                        if (indGraph && indFisher) {
                            int[] nArray = fishConfusion[1];
                            nArray[1] = nArray[1] + 1;
                        }
                        if (!indGraph && indFisher) {
                            int[] nArray = fishConfusion[0];
                            nArray[1] = nArray[1] + 1;
                        }
                        if (!indGraph || indFisher) continue;
                        int[] nArray = fishConfusion[1];
                        nArray[0] = nArray[0] + 1;
                    }
                    double powerCorr = (double)corrConfusion[0][0] / (double)(corrConfusion[0][0] + corrConfusion[0][1]);
                    double sensitivityCorr = (double)corrConfusion[1][1] / (double)(corrConfusion[1][1] + corrConfusion[1][0]);
                    double powerFish = (double)fishConfusion[0][0] / (double)(fishConfusion[0][0] + fishConfusion[0][1]);
                    double sensitivityFish = (double)fishConfusion[1][1] / (double)(fishConfusion[1][1] + fishConfusion[1][0]);
                    allPowersT[iedges][isamp][isig] = powerCorr;
                    allSensesT[iedges][isamp][isig] = sensitivityCorr;
                    allPowersF[iedges][isamp][isig] = powerFish;
                    allSensesF[iedges][isamp][isig] = sensitivityFish;
                    ++ncases;
                    sumTtestP += powerCorr;
                    sumTtestS += sensitivityCorr;
                    sumFisherP += powerFish;
                    sumFisherS += sensitivityFish;
                }
            }
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        for (int iedges = 0; iedges < edges.length; ++iedges) {
            int isamp;
            System.out.println("\n\n\n****For graph with " + numNodes + "variables and " + edges[iedges] + " edges and five conditioning variables:");
            System.out.println("\nPower\n");
            System.out.println("\t\t\t\tFisher's Z\t\t\tT-Test");
            System.out.println("Alpha:\t\t\t0.01  0.05  0.10\t\t 0.01  0.05  0.10");
            for (isamp = 0; isamp < samples.length; ++isamp) {
                System.out.print(samples[isamp] + "\t\t" + nf.format(allPowersF[iedges][isamp][0]) + "  " + nf.format(allPowersF[iedges][isamp][1]) + "  " + nf.format(allPowersF[iedges][isamp][2]) + "\t");
                System.out.println("\t\t" + nf.format(allPowersT[iedges][isamp][0]) + "  " + nf.format(allPowersT[iedges][isamp][1]) + "  " + nf.format(allPowersT[iedges][isamp][2]));
            }
            System.out.println("\nSensitivity\n");
            System.out.println("\t\t\t\tFisher's Z\t\t\tT-Test");
            System.out.println("Alpha:\t\t\t0.01  0.05  0.10\t\t 0.01  0.05  0.10");
            for (isamp = 0; isamp < samples.length; ++isamp) {
                System.out.print(samples[isamp] + "\t\t" + nf.format(allSensesF[iedges][isamp][0]) + "  " + nf.format(allSensesF[iedges][isamp][1]) + "  " + nf.format(allSensesF[iedges][isamp][2]) + "\t");
                System.out.println("\t\t" + nf.format(allSensesT[iedges][isamp][0]) + "  " + nf.format(allSensesT[iedges][isamp][1]) + "  " + nf.format(allSensesT[iedges][isamp][2]));
            }
        }
        double avePowerTT = sumTtestP / (double)ncases;
        double aveSenseTT = sumTtestS / (double)ncases;
        System.out.println("\nT-Test ave power = " + nf.format(avePowerTT) + " ave sensitivity = " + nf.format(aveSenseTT));
        double avePowerFish = sumFisherP / (double)ncases;
        double aveSenseFish = sumFisherS / (double)ncases;
        System.out.println("Fishers Z ave power = " + nf.format(avePowerFish) + " ave sensitivity = " + nf.format(aveSenseFish));
    }

    public static double getAlpha() {
        return alpha;
    }

    static {
        alpha = 0.05;
    }
}

