/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Mapping
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private ISemIm semIm;
    private Parameter parameter;
    private double[][] a;
    private DoubleMatrix2D aC;
    private int i;
    private int j;

    public Mapping(ISemIm semIm, Parameter parameter, DoubleMatrix2D matrix, int i, int j) {
        if (semIm == null) {
            throw new NullPointerException("SemIm must not be null.");
        }
        if (parameter == null) {
            throw new NullPointerException("Parameter must not be null.");
        }
        if (matrix == null) {
            throw new NullPointerException("Supplied array must not be null.");
        }
        if (i < 0 || j < 0) {
            throw new IllegalArgumentException("Indices must be non-negative");
        }
        this.semIm = semIm;
        this.parameter = parameter;
        this.aC = matrix;
        this.i = i;
        this.j = j;
    }

    public static Mapping serializableInstance() {
        return new Mapping(SemIm.serializableInstance(), Parameter.serializableInstance(), new DenseDoubleMatrix2D(0, 0), 1, 1);
    }

    public void setValue(double x) {
        if (this.semIm.isParameterBoundsEnforced() && this.getParameter().getType() == ParamType.VAR && x < 0.0) {
            throw new IllegalArgumentException("Variances cannot have values <= 0.0: " + x);
        }
        this.aC.set(this.i, this.j, x);
        if (this.getParameter().getType() == ParamType.VAR || this.getParameter().getType() == ParamType.COVAR) {
            this.aC.set(this.j, this.i, x);
            this.aC.set(this.i, this.j, x);
        }
    }

    public double getValue() {
        return this.aC.getQuick(this.i, this.j);
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String toString() {
        return "<" + this.getParameter().getName() + " " + this.getParameter().getType() + "[" + this.i + "][" + this.j + "]>";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semIm == null) {
            throw new NullPointerException();
        }
        if (this.parameter == null) {
            throw new NullPointerException();
        }
    }
}

