/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.ParamConstraintType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.TetradSerializable;

public class ParamConstraint
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private double number;
    private Parameter param1;
    private Parameter param2;
    private ParamConstraintType type;
    private SemIm semIm;

    public ParamConstraint(SemIm semIm, Parameter param1, ParamConstraintType type, double number) {
        this.semIm = semIm;
        this.param1 = param1;
        this.param2 = null;
        this.type = type;
        this.number = number;
    }

    public ParamConstraint(SemIm semIm, Parameter param1, Parameter param2, ParamConstraintType type) {
        this.semIm = semIm;
        this.param1 = param1;
        this.param2 = param2;
        this.type = type;
        this.number = 0.0;
    }

    public static ParamConstraint serializableInstance() {
        return new ParamConstraint(SemIm.serializableInstance(), Parameter.serializableInstance(), ParamConstraintType.EQ, 1.0);
    }

    public ParamConstraintType getType() {
        return this.type;
    }

    public void setType(ParamConstraintType type) {
        this.type = type;
    }

    public double getNumber() {
        return this.number;
    }

    public Parameter getParam2() {
        return this.param2;
    }

    public void setParam2(Parameter param2) {
        this.param2 = param2;
    }

    public boolean isSatisfied() {
        if (this.type == ParamConstraintType.NONE) {
            return true;
        }
        if (this.param2 == null) {
            if (this.type == ParamConstraintType.EQ && this.semIm.getParamValue(this.param1) == this.number) {
                return true;
            }
            if (this.type == ParamConstraintType.GT && this.semIm.getParamValue(this.param1) > this.number) {
                return true;
            }
            if (this.type == ParamConstraintType.LT && this.semIm.getParamValue(this.param1) < this.number) {
                return true;
            }
            if (this.type == ParamConstraintType.EQ && this.semIm.getParamValue(this.param1) == this.semIm.getParamValue(this.param2)) {
                return true;
            }
            if (this.type == ParamConstraintType.LT && this.semIm.getParamValue(this.param1) < this.semIm.getParamValue(this.param2)) {
                return true;
            }
            if (this.type == ParamConstraintType.GT && this.semIm.getParamValue(this.param1) > this.semIm.getParamValue(this.param2)) {
                return true;
            }
        }
        return false;
    }

    public boolean wouldBeSatisfied(double testValue) {
        if (this.type == ParamConstraintType.NONE) {
            return true;
        }
        if (this.param2 == null) {
            if (this.type == ParamConstraintType.EQ && testValue == this.number) {
                return true;
            }
            if (this.type == ParamConstraintType.GT && testValue > this.number) {
                return true;
            }
            return this.type == ParamConstraintType.LT && testValue < this.number;
        }
        return false;
    }
}

